/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInsight.intention.EventTrackingIntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNamedElementWithCustomPresentation;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.statistics.SpellcheckerActionStatistics;
import com.intellij.spellchecker.statistics.SpellcheckerRateTracker;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import icons.SpellcheckerIcons;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameTo
extends IntentionAndQuickFixAction
implements Iconable,
EventTrackingIntentionAction {
    private final String typo;
    private final SmartPsiFileRange rangeRelativeToFile;
    private final SmartPsiElementPointer<PsiElement> pointer;
    private final SpellcheckerRateTracker tracker;
    private volatile List<String> suggestions;
    private SmartPsiElementPointer<PsiElement> namedPointer;

    public RenameTo(String typo, TextRange range, PsiElement psi, SpellcheckerRateTracker tracker) {
        PsiFile file = psi.getContainingFile();
        this.rangeRelativeToFile = SmartPointerManager.getInstance((Project)psi.getProject()).createSmartPsiFileRangePointer(file, range.shiftRight(psi.getTextRange().getStartOffset()));
        this.typo = typo;
        this.pointer = SmartPointerManager.getInstance((Project)psi.getProject()).createSmartPsiElementPointer(psi, file);
        this.tracker = tracker;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, PsiFile psiFile) {
        PsiElement element;
        if (project == null) {
            RenameTo.$$$reportNull$$$0(0);
        }
        if ((element = this.pointer.getElement()) == null) {
            return false;
        }
        Pair<PsiNamedElement, String> presentationName = RenameTo.getPresentationName(element);
        if (presentationName == null) {
            return false;
        }
        this.generateSuggestions((String)presentationName.getSecond(), element);
        this.namedPointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)presentationName.getFirst());
        return this.suggestions != null && !this.suggestions.isEmpty();
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getName() {
        String string = RenameTo.getFixName(this.suggestions);
        if (string == null) {
            RenameTo.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = RenameTo.getFixName(this.suggestions);
        if (string == null) {
            RenameTo.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, PsiFile psiFile, @Nullable Editor editor) {
        PsiElement element;
        if (project == null) {
            RenameTo.$$$reportNull$$$0(3);
        }
        PsiElement psiElement = element = this.namedPointer.getElement() == null ? null : this.namedPointer.getElement();
        if (element == null) {
            return;
        }
        if (this.suggestions.size() == 1) {
            this.runRenamer(element, this.suggestions.getFirst());
        } else {
            DataContext context = DataManager.getInstance().getDataContext((Component)editor.getContentComponent());
            DataContext contextWithSuggestions = dataId -> {
                if (PsiElementRenameHandler.NAME_SUGGESTIONS.is(dataId)) {
                    return new ArrayList<String>(this.suggestions);
                }
                if (PlatformCoreDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                    return new PsiElement[]{element};
                }
                return context.getData(dataId);
            };
            RefactoringActionHandler handler = RenameTo.getRenameHandler(contextWithSuggestions);
            handler.invoke(project, editor, psiFile, contextWithSuggestions);
        }
        if (!IntentionPreviewUtils.isIntentionPreviewActive()) {
            SpellcheckerActionStatistics.renameToPerformed(this.tracker, this.suggestions.size());
        }
    }

    public void suggestionShown(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            RenameTo.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            RenameTo.$$$reportNull$$$0(5);
        }
        if (psiFile == null) {
            RenameTo.$$$reportNull$$$0(6);
        }
        if (this.tracker.markShown()) {
            SpellcheckerActionStatistics.suggestionShown(this.tracker);
        }
    }

    @Nls
    public static String getFixName(List<String> suggestions) {
        return suggestions != null && suggestions.size() == 1 ? SpellCheckerBundle.message("rename.to.0", suggestions.getFirst()) : SpellCheckerBundle.message("rename.to", new Object[0]);
    }

    public Icon getIcon(int flags) {
        return SpellcheckerIcons.Spellcheck;
    }

    @Nullable
    private static Pair<PsiNamedElement, String> getPresentationName(PsiElement element) {
        String name;
        PsiNamedElement namedElement = (PsiNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiNamedElement.class});
        if (namedElement == null) {
            return null;
        }
        if (namedElement instanceof PsiNamedElementWithCustomPresentation) {
            PsiNamedElementWithCustomPresentation custom = (PsiNamedElementWithCustomPresentation)namedElement;
            v0 = custom.getPresentationName();
        } else {
            v0 = name = namedElement.getName();
        }
        if (name == null) {
            return null;
        }
        return new Pair((Object)namedElement, (Object)name);
    }

    private static RefactoringActionHandler getRenameHandler(DataContext dataContext) {
        RenameHandler handler = RenameHandlerRegistry.getInstance().getRenameHandler(dataContext);
        if (handler == null) {
            return RefactoringActionHandlerFactory.getInstance().createRenameHandler();
        }
        return handler;
    }

    private void generateSuggestions(String name, PsiElement element) {
        if (this.suggestions == null) {
            TextRange range = this.restoreRange(name);
            if (range == null) {
                return;
            }
            this.suggestions = SpellCheckerManager.getInstance(this.pointer.getProject()).getSuggestions(this.typo).stream().map(suggestion -> range.replace(name, suggestion)).filter(suggestion -> RenameUtil.isValidName((Project)element.getProject(), (PsiElement)element, (String)suggestion)).distinct().toList();
        }
    }

    @Nullable
    private TextRange restoreRange(String currentElementName) {
        PsiElement element = this.pointer.getElement();
        Segment rangeRelativeToFile = this.rangeRelativeToFile.getRange();
        if (element == null || rangeRelativeToFile == null) {
            return null;
        }
        int offset = element.getText().indexOf(currentElementName);
        return TextRange.create((Segment)rangeRelativeToFile).shiftLeft(element.getTextRange().getStartOffset()).shiftLeft(offset);
    }

    private void runRenamer(PsiElement element, String suggestion) {
        new RenameProcessor(this.pointer.getProject(), element, suggestion, true, true).run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/quickfixes/RenameTo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/quickfixes/RenameTo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "suggestionShown";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

