/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting;

import com.intellij.java.codeserver.core.JavaPsiModifierUtil;
import com.intellij.java.codeserver.highlighting.JavaErrorVisitor;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportHolder;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PsiUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

final class ModifierChecker {
    private static final Set<String> ourConstructorNotAllowedModifiers = Set.of("abstract", "static", "native", "final", "strictfp", "synchronized");
    @NotNull
    private final JavaErrorVisitor myVisitor;

    ModifierChecker(@NotNull JavaErrorVisitor visitor) {
        if (visitor == null) {
            ModifierChecker.$$$reportNull$$$0(0);
        }
        this.myVisitor = visitor;
    }

    /*
     * Unable to fully structure code
     */
    void checkNotAllowedModifier(@NotNull PsiKeyword keyword, @NotNull PsiModifierList modifierList) {
        block49: {
            block43: {
                block45: {
                    block47: {
                        block48: {
                            block46: {
                                block44: {
                                    if (keyword == null) {
                                        ModifierChecker.$$$reportNull$$$0(1);
                                    }
                                    if (modifierList == null) {
                                        ModifierChecker.$$$reportNull$$$0(2);
                                    }
                                    if ((modifierOwner = modifierList.getParent()) == null) {
                                        return;
                                    }
                                    modifier = keyword.getText();
                                    if (modifierOwner instanceof PsiMember) {
                                        psiMember = (PsiMember)modifierOwner;
                                        v0 = psiMember.getContainingClass();
                                    } else {
                                        v0 = modifierOwnerParent = modifierOwner.getParent();
                                    }
                                    if (modifierOwnerParent == null) {
                                        modifierOwnerParent = modifierOwner.getParent();
                                    }
                                    isAllowed = true;
                                    if (!(modifierOwner instanceof PsiClass)) break block43;
                                    aClass = (PsiClass)modifierOwner;
                                    v1 = privateOrProtected = "private".equals(modifier) != false || "protected".equals(modifier) != false;
                                    if (!aClass.isInterface()) break block44;
                                    if ("static".equals(modifier) || privateOrProtected || "packageLocal".equals(modifier)) {
                                        isAllowed = modifierOwnerParent instanceof PsiClass;
                                    }
                                    if ("public".equals(modifier)) {
                                        v2 = isAllowed = modifierOwnerParent instanceof PsiDeclarationStatement == false;
                                    }
                                    if ("sealed".equals(modifier)) {
                                        isAllowed = aClass.isAnnotationType() == false;
                                    }
                                    break block45;
                                }
                                if (!"public".equals(modifier)) break block46;
                                if (modifierOwnerParent instanceof PsiImportHolder) ** GOTO lbl-1000
                                if (modifierOwnerParent instanceof PsiClass) {
                                    psiClass = (PsiClass)modifierOwnerParent;
                                    ** if (!(modifierOwnerParent instanceof PsiSyntheticClass) && !PsiUtil.isAvailable((JavaFeature)JavaFeature.INNER_STATICS, (PsiElement)modifierOwnerParent) && psiClass.getQualifiedName() == null && modifierOwnerParent.isPhysical()) goto lbl-1000
                                }
                                ** GOTO lbl-1000
lbl-1000:
                                // 2 sources

                                {
                                    v3 = true;
                                    ** GOTO lbl37
                                }
lbl-1000:
                                // 2 sources

                                {
                                    v3 = false;
                                }
lbl37:
                                // 2 sources

                                isAllowed = v3;
                                break block47;
                            }
                            if (!"static".equals(modifier) && !privateOrProtected && !"packageLocal".equals(modifier)) break block47;
                            if (!(modifierOwnerParent instanceof PsiClass)) break block48;
                            psiClass = (PsiClass)modifierOwnerParent;
                            if ("static".equals(modifier) || PsiUtil.isAvailable((JavaFeature)JavaFeature.INNER_STATICS, (PsiElement)modifierOwnerParent) || psiClass.getQualifiedName() != null) ** GOTO lbl-1000
                        }
                        if (FileTypeUtils.isInServerPageFile((PsiElement)modifierOwnerParent) || !modifierOwnerParent.isPhysical()) lbl-1000:
                        // 2 sources

                        {
                            v4 = true;
                        } else {
                            v4 = isAllowed = false;
                        }
                    }
                    if (aClass.isEnum()) {
                        isAllowed &= "final".equals(modifier) == false && "abstract".equals(modifier) == false && "sealed".equals(modifier) == false && "value".equals(modifier) == false;
                    } else if (aClass.isRecord()) {
                        isAllowed &= "abstract".equals(modifier) == false;
                    }
                    if (aClass.getContainingClass() instanceof PsiAnonymousClass && privateOrProtected && !PsiUtil.getLanguageLevel((PsiElement)modifierOwnerParent).isAtLeast(LanguageLevel.JDK_16)) {
                        isAllowed = false;
                    }
                }
                if (("non-sealed".equals(modifier) || "sealed".equals(modifier)) && modifierOwnerParent instanceof PsiDeclarationStatement) {
                    this.myVisitor.report(JavaErrorKinds.MODIFIER_NOT_ALLOWED_LOCAL_CLASS.create(keyword, modifier));
                    return;
                }
                if ("non-sealed".equals(modifier) && !aClass.hasModifierProperty("sealed") && !(isAllowed = Arrays.stream(aClass.getSuperTypes()).map((Function<PsiClassType, PsiClass>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, resolve(), (Lcom/intellij/psi/PsiClassType;)Lcom/intellij/psi/PsiClass;)()).anyMatch((Predicate<PsiClass>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$checkNotAllowedModifier$0(com.intellij.psi.PsiClass ), (Lcom/intellij/psi/PsiClass;)Z)()))) {
                    this.myVisitor.report(JavaErrorKinds.MODIFIER_NOT_ALLOWED_NON_SEALED.create(keyword, modifier));
                    return;
                }
                break block49;
            }
            if (modifierOwner instanceof PsiMethod) {
                method = (PsiMethod)modifierOwner;
                isAllowed = method.isConstructor() == false || ModifierChecker.ourConstructorNotAllowedModifiers.contains(modifier) == false;
                containingClass = method.getContainingClass();
                if ((method.hasModifierProperty("public") || method.hasModifierProperty("protected")) && method.isConstructor() && containingClass != null && containingClass.isEnum()) {
                    isAllowed = false;
                }
                v5 = isInterface = modifierOwnerParent instanceof PsiClass != false && (psiClass = (PsiClass)modifierOwnerParent).isInterface() != false;
                if ("private".equals(modifier) && modifierOwnerParent instanceof PsiClass) {
                    psiClass = (PsiClass)modifierOwnerParent;
                    isAllowed &= isInterface == false || PsiUtil.isAvailable((JavaFeature)JavaFeature.PRIVATE_INTERFACE_METHODS, (PsiElement)modifierOwner) != false && psiClass.isAnnotationType() == false;
                } else if ("strictfp".equals(modifier)) {
                    isAllowed &= isInterface == false || PsiUtil.isAvailable((JavaFeature)JavaFeature.EXTENSION_METHODS, (PsiElement)modifierOwner) != false;
                } else if ("protected".equals(modifier) || "transient".equals(modifier) || "final".equals(modifier)) {
                    isAllowed &= isInterface == false;
                } else if ("synchronized".equals(modifier)) {
                    isAllowed &= isInterface == false && (containingClass == null || containingClass.isValueClass() == false);
                }
                if (containingClass != null && (containingClass.isInterface() || containingClass.isRecord())) {
                    isAllowed &= "native".equals(modifier) == false;
                }
                if (containingClass != null && containingClass.isAnnotationType()) {
                    isAllowed &= "static".equals(modifier) == false;
                    isAllowed &= "default".equals(modifier) == false;
                }
                if (JavaPsiRecordUtil.getRecordComponentForAccessor((PsiMethod)method) != null) {
                    isAllowed &= "static".equals(modifier) == false;
                }
            } else if (modifierOwner instanceof PsiField) {
                if ("private".equals(modifier) || "protected".equals(modifier) || "transient".equals(modifier) || "strictfp".equals(modifier)) {
                    isAllowed = modifierOwnerParent instanceof PsiClass != false && (psiClass = (PsiClass)modifierOwnerParent).isInterface() == false;
                }
            } else if (modifierOwner instanceof PsiClassInitializer) {
                isAllowed = "static".equals(modifier);
            } else if (modifierOwner instanceof PsiLocalVariable || modifierOwner instanceof PsiParameter) {
                isAllowed = "final".equals(modifier);
            } else if (modifierOwner instanceof PsiReceiverParameter || modifierOwner instanceof PsiRecordComponent) {
                isAllowed = false;
            }
        }
        if (isAllowed && !JavaPsiModifierUtil.isAllowed((String)modifier, (PsiModifierList)modifierList)) {
            isAllowed = false;
        }
        if (!isAllowed) {
            this.myVisitor.report(JavaErrorKinds.MODIFIER_NOT_ALLOWED.create(keyword, modifier));
        }
    }

    void checkIllegalModifierCombination(@NotNull PsiKeyword keyword, @NotNull PsiModifierList modifierList) {
        String modifier;
        String incompatible;
        if (keyword == null) {
            ModifierChecker.$$$reportNull$$$0(3);
        }
        if (modifierList == null) {
            ModifierChecker.$$$reportNull$$$0(4);
        }
        if ((incompatible = JavaPsiModifierUtil.getIncompatibleModifier((String)(modifier = keyword.getText()), (PsiModifierList)modifierList)) != null) {
            if (incompatible.equals(modifier)) {
                for (PsiElement child = modifierList.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (!modifier.equals(child.getText())) continue;
                    if (child != keyword) break;
                    return;
                }
                this.myVisitor.report(JavaErrorKinds.MODIFIER_REPEATED.create(keyword, modifier));
            } else {
                this.myVisitor.report(JavaErrorKinds.MODIFIER_INCOMPATIBLE.create(keyword, incompatible));
            }
        }
    }

    void reportAccessProblem(@NotNull PsiElement ref, @NotNull PsiModifierListOwner resolved, @NotNull JavaResolveResult result) {
        if (ref == null) {
            ModifierChecker.$$$reportNull$$$0(5);
        }
        if (resolved == null) {
            ModifierChecker.$$$reportNull$$$0(6);
        }
        if (result == null) {
            ModifierChecker.$$$reportNull$$$0(7);
        }
        result = ModifierChecker.withElement(result, (PsiElement)resolved);
        if (resolved.hasModifierProperty("private")) {
            this.myVisitor.report(JavaErrorKinds.ACCESS_PRIVATE.create(ref, result));
            return;
        }
        if (resolved.hasModifierProperty("protected")) {
            this.myVisitor.report(JavaErrorKinds.ACCESS_PROTECTED.create(ref, result));
            return;
        }
        PsiClass packageLocalClass = JavaPsiModifierUtil.getPackageLocalClassInTheMiddle((PsiElement)ref);
        if (packageLocalClass != null) {
            result = ModifierChecker.withElement(result, (PsiElement)packageLocalClass);
        }
        if (resolved.hasModifierProperty("packageLocal") || packageLocalClass != null) {
            this.myVisitor.report(JavaErrorKinds.ACCESS_PACKAGE_LOCAL.create(ref, result));
            return;
        }
        this.myVisitor.myModuleChecker.checkModuleAccess(resolved, ref);
        if (this.myVisitor.hasErrorResults()) {
            return;
        }
        this.myVisitor.report(JavaErrorKinds.ACCESS_GENERIC_PROBLEM.create(ref, result));
    }

    @NotNull
    private static JavaResolveResult withElement(final @NotNull JavaResolveResult original, final @NotNull PsiElement newElement) {
        if (original == null) {
            ModifierChecker.$$$reportNull$$$0(8);
        }
        if (newElement == null) {
            ModifierChecker.$$$reportNull$$$0(9);
        }
        if (newElement == original.getElement()) {
            JavaResolveResult javaResolveResult = original;
            if (javaResolveResult == null) {
                ModifierChecker.$$$reportNull$$$0(10);
            }
            return javaResolveResult;
        }
        return new JavaResolveResult(){

            public PsiElement getElement() {
                return newElement;
            }

            @NotNull
            public PsiSubstitutor getSubstitutor() {
                PsiSubstitutor psiSubstitutor = original.getSubstitutor();
                if (psiSubstitutor == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiSubstitutor;
            }

            public boolean isPackagePrefixPackageReference() {
                return original.isPackagePrefixPackageReference();
            }

            public boolean isAccessible() {
                return original.isAccessible();
            }

            public boolean isStaticsScopeCorrect() {
                return original.isStaticsScopeCorrect();
            }

            public PsiElement getCurrentFileResolveScope() {
                return original.getCurrentFileResolveScope();
            }

            public boolean isValidResult() {
                return original.isValidResult();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/java/codeserver/highlighting/ModifierChecker$1", "getSubstitutor"));
            }
        };
    }

    private static /* synthetic */ boolean lambda$checkNotAllowedModifier$0(PsiClass superClass) {
        return superClass != null && superClass.hasModifierProperty("sealed");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/codeserver/highlighting/ModifierChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/codeserver/highlighting/ModifierChecker";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkNotAllowedModifier";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkIllegalModifierCombination";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reportAccessProblem";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "withElement";
                break;
            }
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

