/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;
import org.jetbrains.plugins.gradle.codeInspection.fix.GradleWrapperVersionFix;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/gradle/codeInspection/GradleLatestMinorVersionInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "isAvailableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "intellij.gradle.java"})
public final class GradleLatestMinorVersionInspection
extends LocalInspectionTool {
    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FileUtilRt.fileNameEquals((CharSequence)file.getName(), (CharSequence)"gradle-wrapper.properties");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PsiElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitElement(PsiElement element) {
                GradleVersion gradleVersion;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (!(element instanceof Property)) {
                    return;
                }
                if (!Intrinsics.areEqual((Object)((Property)element).getKey(), (Object)"distributionUrl")) {
                    return;
                }
                Regex regex = new Regex("gradle-(.+)-bin\\.zip$");
                String string = ((Property)element).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
                if (matchResult == null || (matchResult = matchResult.getGroups().get(1)) == null) {
                    return;
                }
                MatchResult group = matchResult;
                String currentVersion = group.getValue();
                TextRange versionTextRange = new TextRange(group.getRange().getFirst(), group.getRange().getLast() + 1);
                try {
                    gradleVersion = GradleVersion.version((String)currentVersion);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return;
                }
                GradleVersion currentGradleVersion = gradleVersion;
                Intrinsics.checkNotNull((Object)currentGradleVersion);
                if (GradleJvmSupportMatrix.Companion.isGradleDeprecatedByIdea(currentGradleVersion)) {
                    return;
                }
                GradleVersion latestMinorGradleVersion = GradleJvmSupportMatrix.Companion.getLatestMinorGradleVersion(currentGradleVersion.getMajorVersion());
                if (currentGradleVersion.compareTo(latestMinorGradleVersion) >= 0) {
                    return;
                }
                this.$holder.problem(element, GradleInspectionBundle.message("inspection.message.newer.gradle.minor.version.available.descriptor", new Object[0])).range(versionTextRange).fix((LocalQuickFix)new GradleWrapperVersionFix(latestMinorGradleVersion, versionTextRange)).register();
            }
        };
    }
}

