/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.config;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.UseScopeEnlarger;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.config.GradleBuildscriptSearchScope;
import org.jetbrains.plugins.gradle.config.GradleClassFinder;
import org.jetbrains.plugins.gradle.service.GradleBuildClasspathManager;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/gradle/config/GradleUseScopeEnlarger;", "Lcom/intellij/psi/search/UseScopeEnlarger;", "<init>", "()V", "getAdditionalUseScope", "Lcom/intellij/psi/search/SearchScope;", "element", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.gradle.java"})
public final class GradleUseScopeEnlarger
extends UseScopeEnlarger {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public SearchScope getAdditionalUseScope(@NotNull PsiElement element) {
        SearchScope searchScope;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        try {
            searchScope = GradleUseScopeEnlarger.Companion.getScope(element);
        }
        catch (IndexNotReadyException e) {
            searchScope = null;
        }
        return searchScope;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J0\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/gradle/config/GradleUseScopeEnlarger$Companion;", "", "<init>", "()V", "getScope", "Lcom/intellij/psi/search/SearchScope;", "element", "Lcom/intellij/psi/PsiElement;", "isInGradleDistribution", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isInBuildSrc", "isApplicable", "module", "Lcom/intellij/openapi/module/Module;", "rootProjectPath", "", "virtualFile", "fileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "search", "", "Lcom/intellij/psi/PsiMember;", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/PsiReference;", "intellij.gradle.java"})
    public static final class Companion {
        private Companion() {
        }

        private final SearchScope getScope(PsiElement element) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)element.getContainingFile()));
            if (virtualFile == null) {
                return null;
            }
            VirtualFile virtualFile2 = virtualFile;
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            if (!this.isInBuildSrc(project2, virtualFile2) && !this.isInGradleDistribution(project2, virtualFile2)) {
                return null;
            }
            SearchScope searchScope = element.getUseScope();
            Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getUseScope(...)");
            SearchScope useScope = searchScope;
            if (useScope instanceof LocalSearchScope) {
                VirtualFile[] virtualFileArray = ((LocalSearchScope)useScope).getVirtualFiles();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getVirtualFiles(...)");
                if (Intrinsics.areEqual((Object)ArraysKt.singleOrNull((Object[])virtualFileArray), (Object)virtualFile2)) {
                    return null;
                }
            }
            Project project3 = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
            return (SearchScope)new GradleBuildscriptSearchScope(project3);
        }

        private final boolean isInGradleDistribution(Project project, VirtualFile file) {
            GradleClassFinder gradleClassFinder = (GradleClassFinder)((Object)PsiElementFinder.EP.findExtension(GradleClassFinder.class, (AreaInstance)project));
            if (gradleClassFinder == null) {
                return false;
            }
            GradleClassFinder gradleClassFinder2 = gradleClassFinder;
            List<VirtualFile> roots = gradleClassFinder2.calcClassRoots();
            for (VirtualFile root : roots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)true)) continue;
                return true;
            }
            return false;
        }

        private final boolean isInBuildSrc(Project project, VirtualFile file) {
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
            ProjectFileIndex fileIndex = projectFileIndex;
            Module module = fileIndex.getModuleForFile(file);
            if (module == null) {
                return false;
            }
            Module module2 = module;
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module2)) {
                return false;
            }
            String string = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module2);
            if (string == null) {
                return false;
            }
            String rootProjectPath = string;
            return this.isApplicable(project, module2, rootProjectPath, file, fileIndex);
        }

        private final boolean isApplicable(Project project, Module module, String rootProjectPath, VirtualFile virtualFile, ProjectFileIndex fileIndex) {
            String string = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
            if (string == null) {
                return false;
            }
            String projectPath = string;
            if (StringsKt.endsWith$default((String)projectPath, (String)"/buildSrc", (boolean)false, (int)2, null)) {
                return true;
            }
            VirtualFile sourceRoot = fileIndex.getSourceRootForFile(virtualFile);
            return GradleBuildClasspathManager.getInstance(project).getModuleClasspathEntries(rootProjectPath).contains(sourceRoot);
        }

        public final void search(@NotNull PsiMember element, @NotNull Processor<PsiReference> consumer) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            SearchScope searchScope = (SearchScope)ReadAction.compute(() -> Companion.search$lambda$0(element));
            if (searchScope == null) {
                return;
            }
            SearchScope scope = searchScope;
            ReferencesSearch.SearchParameters newParams = new ReferencesSearch.SearchParameters((PsiElement)element, scope, true);
            ReferencesSearch.search((ReferencesSearch.SearchParameters)newParams).forEach(consumer);
        }

        private static final SearchScope search$lambda$0(PsiMember $element) {
            return Companion.getScope((PsiElement)$element);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

