/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridges;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.projectModel.GradleBuildEntity;
import org.jetbrains.plugins.gradle.model.projectModel.GradleModuleEntity;
import org.jetbrains.plugins.gradle.model.projectModel.GradleModuleEntityKt;
import org.jetbrains.plugins.gradle.model.versionCatalogs.GradleVersionCatalogEntity;
import org.jetbrains.plugins.gradle.model.versionCatalogs.GradleVersionCatalogEntityKt;
import org.jetbrains.plugins.gradle.service.resolve.GradleVersionCatalogHandler;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleWsmVersionCatalogHandler;", "Lorg/jetbrains/plugins/gradle/service/resolve/GradleVersionCatalogHandler;", "<init>", "()V", "getVersionCatalogFiles", "", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "getVersionCatalogEntities", "", "Lorg/jetbrains/plugins/gradle/model/versionCatalogs/GradleVersionCatalogEntity;", "intellij.gradle.java"})
public final class GradleWsmVersionCatalogHandler
implements GradleVersionCatalogHandler {
    @Override
    @NotNull
    public Map<String, VirtualFile> getVersionCatalogFiles(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        HashMap result = new HashMap();
        for (GradleVersionCatalogEntity entity : this.getVersionCatalogEntities(module)) {
            VirtualFile virtualFile;
            if (VirtualFileUrls.getVirtualFile((VirtualFileUrl)entity.getUrl()) == null) continue;
            ((Map)result).put(entity.getName(), virtualFile);
        }
        return result;
    }

    private final List<GradleVersionCatalogEntity> getVersionCatalogEntities(Module module) {
        ModuleEntity moduleEntity = ModuleBridges.findModuleEntity((Module)module);
        if (moduleEntity == null) {
            return CollectionsKt.emptyList();
        }
        ModuleEntity moduleEntity2 = moduleEntity;
        GradleModuleEntity gradleModuleEntity = GradleModuleEntityKt.getGradleModuleEntity((ModuleEntity)moduleEntity2);
        if (gradleModuleEntity == null) {
            return CollectionsKt.emptyList();
        }
        GradleModuleEntity gradleModuleEntity2 = gradleModuleEntity;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ImmutableEntityStorage storage = WorkspaceModelKt.getWorkspaceModel((Project)project).getCurrentSnapshot();
        GradleBuildEntity gradleBuildEntity = (GradleBuildEntity)storage.resolve((SymbolicEntityId)gradleModuleEntity2.getGradleProjectId().getBuildId());
        if (gradleBuildEntity == null) {
            return CollectionsKt.emptyList();
        }
        GradleBuildEntity build = gradleBuildEntity;
        return GradleVersionCatalogEntityKt.getVersionCatalogs((GradleBuildEntity)build);
    }
}

