/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerDelegate;
import java.awt.EventQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J\u0014\u0010\u0011\u001a\u00020\t2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/util/concurrency/LegacyInvokerDelegate;", "Lcom/intellij/util/concurrency/InvokerDelegate;", "useReadAction", "Lcom/intellij/util/ThreeState;", "<init>", "(Lcom/intellij/util/ThreeState;)V", "indicators", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lcom/intellij/openapi/progress/util/ProgressIndicatorBase;", "dispose", "", "run", "", "task", "Ljava/lang/Runnable;", "promise", "indicator", "intellij.platform.ide.concurrency"})
@SourceDebugExtension(value={"SMAP\nLegacyInvokerDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyInvokerDelegate.kt\ncom/intellij/util/concurrency/LegacyInvokerDelegate\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1915#2,2:82\n*S KotlinDebug\n*F\n+ 1 LegacyInvokerDelegate.kt\ncom/intellij/util/concurrency/LegacyInvokerDelegate\n*L\n20#1:82,2\n*E\n"})
public abstract class LegacyInvokerDelegate
implements InvokerDelegate {
    @NotNull
    private final ThreeState useReadAction;
    @NotNull
    private final ConcurrentHashMap<AsyncPromise<?>, ProgressIndicatorBase> indicators;

    public LegacyInvokerDelegate(@NotNull ThreeState useReadAction) {
        Intrinsics.checkNotNullParameter((Object)useReadAction, (String)"useReadAction");
        this.useReadAction = useReadAction;
        this.indicators = new ConcurrentHashMap();
    }

    public void dispose() {
        while (!this.indicators.isEmpty()) {
            Set set = this.indicators.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AsyncPromise it = (AsyncPromise)element$iv;
                boolean bl = false;
                it.cancel();
            }
        }
    }

    @Override
    public boolean run(@NotNull Runnable task, @NotNull AsyncPromise<?> promise) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter(promise, (String)"promise");
        if (ApplicationManager.getApplication() == null) {
            task.run();
        } else if (this.useReadAction != ThreeState.YES || EventQueue.isDispatchThread()) {
            ProgressManager.getInstance().runProcess(task, (ProgressIndicator)this.indicator(promise));
        } else if (!ProgressIndicatorUtils.runInReadActionWithWriteActionPriority((Runnable)task, (ProgressIndicator)((ProgressIndicator)this.indicator(promise)))) {
            return false;
        }
        return true;
    }

    private final ProgressIndicatorBase indicator(AsyncPromise<?> promise) {
        ProgressIndicatorBase indicator = this.indicators.get(promise);
        if (indicator == null) {
            indicator = new ProgressIndicatorBase(true, false);
            ProgressIndicatorBase old = this.indicators.put(promise, indicator);
            if (old != null) {
                Invoker.LOG.error("the same task is running in parallel");
            }
            promise.onProcessed(arg_0 -> LegacyInvokerDelegate.indicator$lambda$1(arg_0 -> LegacyInvokerDelegate.indicator$lambda$0(this, promise, arg_0), arg_0));
        }
        return indicator;
    }

    private static final Unit indicator$lambda$0(LegacyInvokerDelegate this$0, AsyncPromise $promise, Object it) {
        block0: {
            ProgressIndicatorBase progressIndicatorBase = this$0.indicators.remove($promise);
            if (progressIndicatorBase == null) break block0;
            progressIndicatorBase.cancel();
        }
        return Unit.INSTANCE;
    }

    private static final void indicator$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

