/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.code;

import ai.grazie.nlp.patterns.AggregatedPattern;
import ai.grazie.nlp.patterns.Pattern;
import ai.grazie.nlp.patterns.RegexPattern;
import ai.grazie.nlp.patterns.standard.LikelyPatterns;
import ai.grazie.text.TextRange;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import one.util.streamex.StreamEx;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class CodeDetector {
    private static final String idTail = "[a-zA-Z0-9_$]{0,50}";
    private static final String id = "(?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)";
    private static final String atomicExpr = "((?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)(\\.(?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+))*|\\b[0-9]+\\w*|['\"]\\S*['\"])";
    private static final String polyadicExpr = "(- ?)?((?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)(\\.(?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+))*|\\b[0-9]+\\w*|['\"]\\S*['\"])( ?([-+*/%]|[<>!]=?|&&?|\\|\\|?) ?(-? )?((?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)(\\.(?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+))*|\\b[0-9]+\\w*|['\"]\\S*['\"]))*";
    private static final String primitiveType = "u?(byte|short|int((8|16|32|64)(_t)?)?|long)|float|double|char|boolean|void";
    private static final Pattern bareCallArgs = new RegexPattern("\\((- ?)?((?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)(\\.(?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+))*|\\b[0-9]+\\w*|['\"]\\S*['\"])( ?([-+*/%]|[<>!]=?|&&?|\\|\\|?) ?(-? )?((?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)(\\.(?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+))*|\\b[0-9]+\\w*|['\"]\\S*['\"]))*, ?((- ?)?((?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)(\\.(?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+))*|\\b[0-9]+\\w*|['\"]\\S*['\"])( ?([-+*/%]|[<>!]=?|&&?|\\|\\|?) ?(-? )?((?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)(\\.(?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+))*|\\b[0-9]+\\w*|['\"]\\S*['\"]))*(, ?)?)*\\)").exclude((Pattern)new RegexPattern("\\([\\p{L}\\d,. '\"]*\\)"));
    private static final Pattern javaVariable = new RegexPattern("([A-Z])([a-zA-Z0-9_$]{0,50}) ([a-z])(\\2) ?[;:,)=]"){

        public List<TextRange> find(CharSequence text) {
            return super.find(text).stream().filter(r -> {
                MatchResult result = this.getRegex().matchAt(text, r.getStart());
                return result != null && ((String)result.getGroupValues().get(1)).equals(((String)result.getGroupValues().get(3)).toUpperCase(Locale.ROOT));
            }).toList();
        }
    };
    private static final Pattern idChain = new RegexPattern("(?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)(\\.(?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)){2,}");
    private static final Pattern assignment = new RegexPattern("= ?['\"](.*['\"])?").expandBack(new Regex(" ?['\"]?\\w+[\"]?"));
    private static final Pattern pyFString = new RegexPattern("\\bf\"");
    private static final Pattern commonCharEscape = new RegexPattern("\\\\[ntbru]");
    private static final Regex atLineStart = new Regex(" *(\\n|$)");
    private static final Pattern keyColonValue = new RegexPattern("\\b[a-zA-Z0-9_$'\"-]+: *[a-zA-Z0-9_$'\"-]+%?($|[^%,!?;\\s\\w])").expandBack(atLineStart);
    private static final Pattern scalaTodo = new RegexPattern("= ?\\?\\?\\?");
    private static final Pattern charList = new RegexPattern("['\"].['\"](, ['\"].['\"])+");
    private static final Pattern switchCase = new RegexPattern("(- ?)?((?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)(\\.(?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+))*|\\b[0-9]+\\w*|['\"]\\S*['\"])( ?([-+*/%]|[<>!]=?|&&?|\\|\\|?) ?(-? )?((?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)(\\.(?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+))*|\\b[0-9]+\\w*|['\"]\\S*['\"]))* ?->");
    private static final Pattern emptyParens = new RegexPattern("(?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)\\(\\)( ?\\{|[=;])?");
    private static final Pattern returnExpr = new RegexPattern("return (- ?)?((?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)(\\.(?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+))*|\\b[0-9]+\\w*|['\"]\\S*['\"])( ?([-+*/%]|[<>!]=?|&&?|\\|\\|?) ?(-? )?((?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)(\\.(?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+))*|\\b[0-9]+\\w*|['\"]\\S*['\"]))*;?").expandBack(atLineStart);
    private static final Pattern modifierList = new RegexPattern("((public|private|internal|final|static|open|abstract|virtual|override|sealed|unsafe|extern|partial|@(?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)|u?(byte|short|int((8|16|32|64)(_t)?)?|long)|float|double|char|boolean|void)\\s+){2,}").expandBack(atLineStart);
    private static final Pattern codeLike = new AggregatedPattern(new Pattern[]{new AggregatedPattern(new Pattern[]{new RegexPattern("\\${5,}"), CodeDetector.cSharpGenericMethod(), bareCallArgs, assignment, pyFString, keyColonValue, scalaTodo, javaVariable, charList, switchCase, emptyParens, returnExpr, modifierList, LikelyPatterns.IsExcelFormula}).withWordBoundariesAround(), commonCharEscape});
    private static final Pattern foldableExpression = new AggregatedPattern(new Pattern[]{CodeDetector.call(), new AggregatedPattern(new Pattern[]{idChain, new RegexPattern("object ?: ?((?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)(\\.(?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+))*|\\b[0-9]+\\w*|['\"]\\S*['\"])( ?\\{)?"), new RegexPattern("\\(\\$+\\)|(new|await) \\$+")}).withWordBoundariesAround()});

    private static RegexPattern cSharpGenericMethod() {
        String typeOrValueTuple = "((?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)|\\((?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)(, *(?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+))+\\))";
        String typeParameter = "(((in|out) +)?" + typeOrValueTuple + ")";
        return new RegexPattern("(?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)<" + typeParameter + "(, *" + typeParameter + ")*>\\(");
    }

    private static Pattern call() {
        String capitalizedDataType = "[A-Z][a-zA-Z_0-9]+";
        String optionalGenerics = "(<.+>)?";
        String typeName = "(" + capitalizedDataType + optionalGenerics + "|u?(byte|short|int((8|16|32|64)(_t)?)?|long)|float|double|char|boolean|void) ";
        String parameter = typeName + id;
        String parameterChain = parameter + "(, " + parameter + ")+";
        String argumentChain = "(- ?)?((?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)(\\.(?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+))*|\\b[0-9]+\\w*|['\"]\\S*['\"])( ?([-+*/%]|[<>!]=?|&&?|\\|\\|?) ?(-? )?((?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)(\\.(?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+))*|\\b[0-9]+\\w*|['\"]\\S*['\"]))*(, ?(- ?)?((?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)(\\.(?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+))*|\\b[0-9]+\\w*|['\"]\\S*['\"])( ?([-+*/%]|[<>!]=?|&&?|\\|\\|?) ?(-? )?((?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)(\\.(?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+))*|\\b[0-9]+\\w*|['\"]\\S*['\"]))*)*";
        RegexPattern wordParenWord = new RegexPattern("\\w+\\(\\w+\\)");
        return new RegexPattern("(?:\\b[a-zA-Z_$][a-zA-Z0-9_$]{0,50}\\b|\\$+)\\((" + parameterChain + "|" + argumentChain + ")?\\)").exclude((Pattern)wordParenWord);
    }

    public static boolean looksLikeCode(CharSequence input) {
        List<ai.grazie.rules.tree.TextRange> fragments = CodeDetector.findCodeFragments(input);
        int coveredLength = fragments.stream().mapToInt(ai.grazie.rules.tree.TextRange::length).sum();
        return coveredLength > input.length() * 7 / 10;
    }

    public static List<ai.grazie.rules.tree.TextRange> findCodeFragments(CharSequence input) {
        if (CodeDetector.looksLikeCodeHeuristically(input = CodeDetector.foldExpressions(input))) {
            return List.of(new ai.grazie.rules.tree.TextRange(0, input.length()));
        }
        List result = StreamEx.of((Collection)codeLike.find(input)).map(r -> new ai.grazie.rules.tree.TextRange(r.getStart(), r.getEndExclusive())).toList();
        return ai.grazie.rules.tree.TextRange.mergeConditionally((Stream<ai.grazie.rules.tree.TextRange>)StreamEx.of((Collection)result).sortedByInt(ai.grazie.rules.tree.TextRange::start), ai.grazie.rules.tree.TextRange::touches);
    }

    private static CharSequence foldExpressions(CharSequence input) {
        List ranges;
        ExpressionFoldedSequence e;
        ExpressionFoldedSequence folded;
        ExpressionFoldedSequence expressionFoldedSequence = folded = input instanceof ExpressionFoldedSequence ? (e = (ExpressionFoldedSequence)input) : new ExpressionFoldedSequence(input, new BitSet(), 0);
        while (!(ranges = foldableExpression.find((CharSequence)folded)).isEmpty()) {
            for (TextRange range : ranges) {
                folded.exprIndices().set(range.getStart() + folded.offset, range.getEndExclusive() + folded.offset);
            }
        }
        return folded;
    }

    private static boolean looksLikeCodeHeuristically(CharSequence input) {
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) <= '\u007f') continue;
            return false;
        }
        int codeChars = 0;
        int textTokens = 0;
        boolean inToken = false;
        char prev = '\u0000';
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                if (!inToken) {
                    inToken = true;
                    ++textTokens;
                }
            } else {
                inToken = false;
                if ("{}[]<>=+-*/|&;,:\\@#^".indexOf(c) != -1 || c == '$' && prev != '$') {
                    ++codeChars;
                }
            }
            prev = c;
        }
        return codeChars > 0 && textTokens < codeChars;
    }

    private record ExpressionFoldedSequence(CharSequence original, BitSet exprIndices, int offset) implements CharSequence
    {
        @Override
        public int length() {
            return this.original.length();
        }

        @Override
        public char charAt(int index) {
            return this.exprIndices.get(index + this.offset) ? (char)'$' : this.original.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new ExpressionFoldedSequence(this.original.subSequence(start, end), this.exprIndices, this.offset + start);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.length());
            for (int i = 0; i < sb.length(); ++i) {
                sb.append(this.charAt(i));
            }
            return sb.toString();
        }
    }
}

