/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.common;

import ai.grazie.rules.tree.TextRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.text.similarity.LongestCommonSubsequence;
import org.jspecify.annotations.Nullable;

record PhraseDiff(String expected, String actual, List<Span> spans) {
    static PhraseDiff build(String expected, String actual) {
        if (expected.equals(actual)) {
            return new PhraseDiff(expected, actual, List.of());
        }
        ArrayList<Span> spans = new ArrayList<Span>();
        CharSequence common = new LongestCommonSubsequence().longestCommonSubsequence((CharSequence)expected, (CharSequence)actual);
        int matchedE = 0;
        int matchedA = 0;
        for (int i = 0; i < common.length(); ++i) {
            char c = common.charAt(i);
            int nextE = expected.indexOf(c, matchedE);
            int nextA = actual.indexOf(c, matchedA);
            if (nextE != matchedE || nextA != matchedA) {
                spans.add(new Span(new TextRange(matchedE, nextE), new TextRange(matchedA, nextA)));
            }
            matchedE = nextE + 1;
            matchedA = nextA + 1;
        }
        if (expected.length() > matchedE || actual.length() > matchedA) {
            spans.add(new Span(new TextRange(matchedE, expected.length()), new TextRange(matchedA, actual.length())));
        }
        return new PhraseDiff(expected, actual, spans);
    }

    boolean hasBigDifferences() {
        Span last = null;
        for (Span next : this.spans) {
            last = this.joinIfClose(next, last);
            if (!this.isBig(last)) continue;
            return true;
        }
        return false;
    }

    private boolean isBig(Span span) {
        if (Math.abs(span.actRange.length() - span.expRange.length()) >= 3) {
            return true;
        }
        if (span.actRange.length() + span.expRange.length() < 6) {
            return false;
        }
        return !PhraseDiff.allChars(span.actRange.substring(this.actual)).equals(PhraseDiff.allChars(span.expRange.substring(this.expected)));
    }

    private static Set<Integer> allChars(String s) {
        return s.chars().boxed().collect(Collectors.toSet());
    }

    private Span joinIfClose(Span next, @Nullable Span prev) {
        if (prev == null || prev.actRange.end() + 1 != next.actRange.start()) {
            return next;
        }
        TextRange actRange = TextRange.span(prev.actRange, next.actRange);
        TextRange expRange = TextRange.span(prev.expRange, next.expRange);
        if (actRange.length() > 0 && expRange.length() > 0 && this.actual.charAt(actRange.end() - 1) == this.expected.charAt(expRange.end() - 1)) {
            actRange = new TextRange(actRange.start(), actRange.end() - 1);
            expRange = new TextRange(expRange.start(), expRange.end() - 1);
        }
        assert (actRange.length() > 0 || expRange.length() > 0);
        return new Span(expRange, actRange);
    }

    record Span(TextRange expRange, TextRange actRange) {
        Span {
            assert (expRange.length() > 0 || actRange.length() > 0);
        }

        @Nullable Span reduce(String actual, String expected, Pattern actPattern, Pattern expPattern) {
            Matcher actMatcher = actPattern.matcher(actual);
            if (!actMatcher.find(Math.max(0, this.actRange.start() - 1))) {
                return this;
            }
            Matcher expMatcher = expPattern.matcher(expected);
            if (!expMatcher.find(Math.max(0, this.expRange.start() - 1))) {
                return this;
            }
            if (actMatcher.start() <= this.actRange.start() && expMatcher.start() <= this.expRange.start()) {
                TextRange reducedExp = new TextRange(this.expRange.clamp(expMatcher.end()), this.expRange.end());
                TextRange reducedAct = new TextRange(this.actRange.clamp(actMatcher.end()), this.actRange.end());
                return reducedAct.length() == 0 || reducedExp.length() == 0 ? null : new Span(reducedExp, reducedAct);
            }
            if (actMatcher.end() >= this.actRange.end() && expMatcher.end() >= this.expRange.end()) {
                TextRange reducedExp = new TextRange(this.expRange.start(), this.expRange.clamp(expMatcher.start()));
                TextRange reducedAct = new TextRange(this.actRange.start(), this.actRange.clamp(actMatcher.start()));
                return reducedAct.length() == 0 || reducedExp.length() == 0 ? null : new Span(reducedExp, reducedAct);
            }
            return this;
        }
    }
}

