/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.ru;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.KnownPhrases;
import ai.grazie.rules.common.MultiWordSpelling;
import ai.grazie.rules.common.ProperNames;
import ai.grazie.rules.ru.Case;
import ai.grazie.rules.ru.SemanticRules;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.TreeSupport;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;

class SpellingRules {
    private static final String DLINNA_MSG = "\u0412\u044b \u0438\u043c\u0435\u043b\u0438 \u0432 \u0432\u0438\u0434\u0443 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u00ab\u0434\u043b\u0438\u043d\u0430\u00bb?";
    private static final String VUZ_MSG = "\u0410\u0431\u0431\u0440\u0435\u0432\u0438\u0430\u0442\u0443\u0440\u0443 \u00ab\u0432\u0443\u0437\u00bb \u043f\u0440\u0438\u043d\u044f\u0442\u043e \u043f\u0438\u0441\u0430\u0442\u044c \u0441\u0442\u0440\u043e\u0447\u043d\u044b\u043c\u0438 \u0431\u0443\u043a\u0432\u0430\u043c\u0438";

    SpellingRules() {
    }

    static List<Rule> rules() {
        return List.of(new Rule.PatternRule("Spelling.LATIN_CYRILLIC_CONFUSION", "\u0421\u043c\u0435\u0448\u0435\u043d\u0438\u0435 \u043a\u0438\u0440\u0438\u043b\u043b\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u0438 \u043b\u0430\u0442\u0438\u043d\u0441\u043a\u0438\u0445 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432", "\u0411\u0443\u043a\u0432\u0430 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u0434\u0440\u0443\u0433\u043e\u043c\u0443 \u0430\u043b\u0444\u0430\u0432\u0438\u0442\u0443.", null, () -> SpellingRules.latinCyrillicConfusion(), new Example("\u0423 \u043c\u0435\u043d\u044f \u0435\u0441\u0442\u044c <b>co\u0431\u0430\u043a\u0430</b>.", "\u0423 \u043c\u0435\u043d\u044f \u0435\u0441\u0442\u044c <b>\u0441\u043e\u0431\u0430\u043a\u0430</b>.")).enableInFlatTrees(), new Rule.PatternRule("Spelling.MISPLACED_SPACE", "\u041f\u0440\u043e\u0431\u0435\u043b \u0432 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u043c \u043c\u0435\u0441\u0442\u0435", "\u041f\u0440\u043e\u0431\u0435\u043b \u043d\u0435 \u043d\u0443\u0436\u0435\u043d \u0438\u043b\u0438 \u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u043d\u0435 \u0441\u043e\u0432\u0441\u0435\u043c \u0432 \u043d\u0443\u0436\u043d\u043e\u0435 \u043c\u0435\u0441\u0442\u043e.", null, () -> CommonPatterns.misplacedSpace("\u0412\u044b \u0438\u043c\u0435\u043b\u0438 \u0432 \u0432\u0438\u0434\u0443 \u00ab%s\u00bb?", CommonPatterns.latin), new Example("<b>\u041f\u0440\u043e\u0431\u0435\u043b\u0431 \u044b\u043b</b> \u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u043d\u0435\u0432\u0435\u0440\u043d\u043e", "<b>\u041f\u0440\u043e\u0431\u0435\u043b \u0431\u044b\u043b</b> \u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u043d\u0435\u0432\u0435\u0440\u043d\u043e")).enableInFlatTrees(), new Rule.PatternRule("Spelling.MULTI_WORD", "\u041f\u0440\u0430\u0432\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u0438\u0445 \u0441\u043b\u043e\u0432", "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0437\u0430\u0433\u043b\u0430\u0432\u043d\u044b\u0445 \u0431\u0443\u043a\u0432 \u0438 \u043e\u043f\u0435\u0447\u0430\u0442\u043a\u0438 \u0432 \u0440\u0430\u0437\u043b\u0438\u0447\u043d\u044b\u0445 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u044f\u0445, \u0441\u043e\u0441\u0442\u043e\u044f\u0449\u0438\u0445 \u0438\u0437 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u0438\u0445 \u0441\u043b\u043e\u0432.", null, () -> NodePattern.or(CommonPatterns.googleProducts("\u0412\u044b \u0438\u043c\u0435\u043b\u0438 \u0432 \u0432\u0438\u0434\u0443 \u00ab%s\u00bb?"), ProperNames.fixFritzProducts.message("\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b \u00abFritz!\u00bb \u043f\u0438\u0448\u0443\u0442\u0441\u044f \u0441 \u0432\u043e\u0441\u043a\u043b\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c \u0437\u043d\u0430\u043a\u043e\u043c"), ProperNames.openAI.message("\u0412\u044b \u0438\u043c\u0435\u043b\u0438 \u0432 \u0432\u0438\u0434\u0443 \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044e \u00abOpenAI\u00bb?"), new MultiWordSpelling(KnownPhrases.forLanguage(Language.RUSSIAN)){
            final NodePattern allowExpansion = NodePattern.N.noForm("\u0430|\u0443|\u0438|\u0430\u043c|\u0430\u0445").andNot(NodePattern.PUNCT);

            @Override
            protected boolean allowExpansion(Node start, Node lastSuggestionEnd, Node expandedEnd) {
                return ((StreamEx)((StreamEx)lastSuggestionEnd.forward().skip(1L)).takeWhileInclusive(n -> n == expandedEnd)).allMatch(this.allowExpansion::matches);
            }
        }.pattern("\u0412\u044b \u0438\u043c\u0435\u043b\u0438 \u0432 \u0432\u0438\u0434\u0443 \u00ab%s\u00bb?", "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u043d\u0430\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u2013 \u00ab%s\u00bb").noForm("\u0433\\.|\u0442\u0435\u043b\u0435\u0441\u0442\u0430\u043d\u0446\u0438(\u044f|\u0438|\u044f\u043c\u0438|\u0435\u0439|\u044f\u043c|\u044f\u0445|\u044e|\u0435\u044e|\u0439)")), new Example("\u041e\u043d\u0438 \u043f\u0440\u0438\u0435\u0445\u0430\u043b\u0438 \u0438\u0437 <b>\u0421\u0430\u043d\u043a\u0442\u043f\u0435\u0442\u0435\u0440\u0431\u0443\u0440\u0433\u0430</b>.", "\u041e\u043d\u0438 \u043f\u0440\u0438\u0435\u0445\u0430\u043b\u0438 \u0438\u0437 <b>\u0421\u0430\u043d\u043a\u0442-\u041f\u0435\u0442\u0435\u0440\u0431\u0443\u0440\u0433\u0430</b>.")).enableInFlatTrees(), new Rule.PatternRule("Spelling.SIMILAR_WORD_CONFUSION", "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0435 \u043d\u0430\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043f\u043e\u0445\u043e\u0436\u0438\u0445 \u0441\u043b\u043e\u0432", "\u041d\u0430\u0445\u043e\u0434\u0438\u0442 \u043e\u043f\u0435\u0447\u0430\u0442\u043a\u0438, \u0432 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0435 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043f\u043e\u044f\u0432\u043b\u044f\u044e\u0442\u0441\u044f \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0435 \u0441\u043b\u043e\u0432\u0430, \u043d\u043e \u043d\u0435\u043f\u0440\u0438\u043c\u0435\u043d\u0438\u043c\u044b\u0435 \u0432 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430\u0445.", null, () -> NodePattern.or(SpellingRules.dlinna(), SpellingRules.telegram()), new Example("\u0414\u0440\u0443\u0433\u043e\u0439 \u0432\u043e\u043f\u0440\u043e\u0441 \u043d\u0430\u0434\u043e \u043f\u0440\u043e\u0434\u0443\u043c\u0430\u0442\u044c, \u0430 \u043a\u0430\u043a\u043e\u0432\u0430 <b>\u0434\u043b\u0438\u043d\u043d\u0430</b> \u0442\u0440\u0443\u0431\u044b?", "\u0414\u0440\u0443\u0433\u043e\u0439 \u0432\u043e\u043f\u0440\u043e\u0441 \u043d\u0430\u0434\u043e \u043f\u0440\u043e\u0434\u0443\u043c\u0430\u0442\u044c, \u0430 \u043a\u0430\u043a\u043e\u0432\u0430 <b>\u0434\u043b\u0438\u043d\u0430</b> \u0442\u0440\u0443\u0431\u044b?")).enableInFlatTrees(), new Rule.PatternRule("Spelling.RULE_SPELLING", "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0435 \u043d\u0430\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0441\u043b\u043e\u0432", "\u041f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u0435\u0442 \u0437\u0430\u043c\u0435\u043d\u044b \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u043d\u0430\u043f\u0438\u0441\u0430\u043d\u043d\u044b\u0445 \u0441\u043b\u043e\u0432 \u0432 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438 \u043e\u0442 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430.", "https://gramota.ru/poisk?query=%D0%92%D0%A3%D0%97%D0%B0&mode=spravka", () -> SpellingRules.vuz(), new Example("\u0421\u0442\u0443\u0434\u0435\u043d\u0442 \u043f\u043e\u0441\u043b\u0435 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f <b>\u0412\u0423\u0417\u0430</b> \u0430\u043a\u0442\u0438\u0432\u043d\u043e \u0438\u0449\u0435\u0442 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0443\u044e \u0440\u0430\u0431\u043e\u0442\u0443", "\u0421\u0442\u0443\u0434\u0435\u043d\u0442 \u043f\u043e\u0441\u043b\u0435 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f <b>\u0432\u0443\u0437\u0430</b> \u0430\u043a\u0442\u0438\u0432\u043d\u043e \u0438\u0449\u0435\u0442 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0443\u044e \u0440\u0430\u0431\u043e\u0442\u0443")).enableInFlatTrees());
    }

    private static NodePattern latinCyrillicConfusion() {
        return NodePattern.or(CommonPatterns.latinCyrillicConfusion("\u041b\u0430\u0442\u0438\u043d\u0441\u043a\u0430\u044f", "\u041a\u0438\u0440\u0438\u043b\u043b\u0438\u0447\u0435\u0441\u043a\u0430\u044f", " \u0431\u0443\u043a\u0432\u0430 \u00ab%s\u00bb \u0432 \u00ab%s\u00bb", "[a-z\u00eb\u00ef]", ".*ABR.*"), NodePattern.or(NodePattern.or(NodePattern.N.form("a").correct(NodeCorrector.replace("\u0430")).message("\u041b\u0430\u0442\u0438\u043d\u0441\u043a\u0430\u044f \u0431\u0443\u043a\u0432\u0430 \u00aba\u00bb \u0432 \u00ab\u0430\u00bb"), NodePattern.N.form("c").correct(NodeCorrector.replace("\u0441")).message("\u041b\u0430\u0442\u0438\u043d\u0441\u043a\u0430\u044f \u0431\u0443\u043a\u0432\u0430 \u00abc\u00bb \u0432 \u00ab\u0441\u00bb"), NodePattern.N.form("\u043do").correct(NodeCorrector.replace("\u043d\u043e")).message("\u041b\u0430\u0442\u0438\u043d\u0441\u043a\u0430\u044f \u0431\u0443\u043a\u0432\u0430 \u00abo\u00bb \u0432 \u00ab\u043d\u043e\u00bb"), NodePattern.N.formCaseSensitive("H\u043e").correct(NodeCorrector.replace("\u041d\u043e")).message("\u041b\u0430\u0442\u0438\u043d\u0441\u043a\u0430\u044f \u0431\u0443\u043a\u0432\u0430 \u00abH\u00bb \u0432 \u00ab\u041d\u043e\u00bb")).withHeadRelation("cc"), NodePattern.or(NodePattern.N.form("\u043da").correct(NodeCorrector.replace("\u043d\u0430")).message("\u041b\u0430\u0442\u0438\u043d\u0441\u043a\u0430\u044f \u0431\u0443\u043a\u0432\u0430 \u00aba\u00bb \u0432 \u00ab\u043d\u0430\u00bb"), NodePattern.N.formCaseSensitive("H\u0430").correct(NodeCorrector.replace("\u041d\u0430")).message("\u041b\u0430\u0442\u0438\u043d\u0441\u043a\u0430\u044f \u0431\u0443\u043a\u0432\u0430 \u00abH\u00bb \u0432 \u00ab\u041d\u0430\u00bb")).withHeadRelation("case")).andOr(NodePattern.N.form("..+"), CommonPatterns.highlightWithTrailingSpace()));
    }

    private static NodePattern dlinna() {
        return NodePattern.N.form("\u0434\u043b\u0438\u043d\u043d.*").and(CommonPatterns.replacementProduces("(.*)\u043d\u043d(.*)", "$1\u043d$2", "NN:Inanim:Fem:.*")).andOr(NodePattern.N.noPos(), NodePattern.N.directlyBefore(NodePattern.N.pos("NN:.*:R")).andNot(NodePattern.N.form("\u0434\u043b\u0438\u043d\u043d\u043e\u0439").directlyBefore(NodePattern.N.pos("NN:.*Fem.*:R"))), NodePattern.N.directlyAfter(NodePattern.N.pos("ADJ:Posit:.*")), NodePattern.N.withHeadRelation("nsubj"), NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.lemma("\u043c\u0435\u0440\u0430"), SemanticRules.lengthUnit))).correct(NodeCorrector.regexReplace("\u0434\u043b\u0438\u043d\u043d(.*)", "\u0434\u043b\u0438\u043d$1")).message(DLINNA_MSG);
    }

    private static NodePattern telegram() {
        return NodePattern.N.form("\u0442\u0435\u043b\u0435\u0433\u0440\u0430\u043c\u043c").directlyAfter(NodePattern.N.pos("PREP").and(node -> {
            Set<Case> cases = Case.getPrepositionCases(node);
            return cases != null && !cases.contains((Object)Case.R);
        })).correct(NodeCorrector.replace("Telegram")).message("\u0412\u044b \u0438\u043c\u0435\u043b\u0438 \u0432 \u0432\u0438\u0434\u0443 \u043c\u0435\u0441\u0441\u0435\u043d\u0434\u0436\u0435\u0440 Telegram?");
    }

    private static NodePattern vuz() {
        return NodePattern.N.form("\u0432\u0443\u0437(\u0430|\u0443|\u043e\u043c|\u0435|\u044b|\u043e\u0432|\u0430\u043c|\u0430\u043c\u0438|\u0430\u0445)?|\u0432\u0443\u0437\u043e\u0432\u0441\u043a(\u0438\u0439|\u043e\u0435|\u0430\u044f|\u0438\u0435|\u043e\u0433\u043e|\u043e\u0439|\u0438\u0445|\u043e\u043c\u0443|\u0438\u043c|\u043e\u044e|\u0438\u043c\u0438|\u043e\u043c)").noFormCaseSensitive("[\u0412\u0432]\u0443\u0437.*").andNot(CommonPatterns.upperCase.andOr(NodePattern.N.directlyAfter(CommonPatterns.upperCase), NodePattern.N.directlyBefore(CommonPatterns.upperCase.directlyBefore(CommonPatterns.upperCase)))).andOr(NodePattern.N.form("\u0432\u0443\u0437").directlyBefore(CommonPatterns.noSpaceHyphen.directlyBefore(NodePattern.N.form("\u0430|\u0443|\u043e\u043c|\u0435|\u044b|\u043e\u0432|\u0430\u043c|\u0430\u043c\u0438|\u0430\u0445"))).and((node, match) -> {
            String vuz = "\u0432\u0443\u0437";
            if (TreeSupport.hasOnlyPunctuationBefore(node.tree().text(), node.startOffset())) {
                vuz = "\u0412\u0443\u0437";
            }
            return match.withCorrector(NodeCorrector.rawReplace(node.startOffset(), node.neighbor(2).endOffset(), vuz + node.neighbor(2).lowForm()));
        }), NodePattern.or(CommonPatterns.firstWord, NodePattern.N.directlyAfter(CommonPatterns.capitalizedMiddle).directlyBefore(CommonPatterns.capitalizedMiddle)).correct(NodeCorrector.regexReplace("\u0412\u0423\u0417", "\u0432\u0443\u0437")), CommonPatterns.toLowerCase).message(VUZ_MSG);
    }
}

