/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compose.ide.plugin.resources;

import com.intellij.compose.ide.plugin.gradleTooling.rt.ComposeResourcesModel;
import com.intellij.compose.ide.plugin.resources.ComposeResources;
import com.intellij.compose.ide.plugin.resources.ComposeResourcesDataServiceKt;
import com.intellij.compose.ide.plugin.resources.ComposeResourcesDir;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataImportListener;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u0017J\u0014\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006 "}, d2={"Lcom/intellij/compose/ide/plugin/resources/ComposeResourcesManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myComposeResourcesByModulePath", "Ljava/util/concurrent/atomic/AtomicReference;", "", "", "Lcom/intellij/compose/ide/plugin/resources/ComposeResources;", "composeResources", "", "Lcom/intellij/compose/ide/plugin/resources/ComposeResourcesDir;", "getComposeResources", "()Ljava/util/List;", "composeResourcesByModulePath", "getComposeResourcesByModulePath", "()Ljava/util/Map;", "refresh", "", "findComposeResourcesDirFor", "path", "Ljava/nio/file/Path;", "composeResourcesModels", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/compose/ide/plugin/gradleTooling/rt/ComposeResourcesModel;", "getComposeResourcesModels", "()Ljava/util/Collection;", "loadComposeResources", "ComposeResourcesProjectDataImportListener", "intellij.compose.ide.plugin.resources"})
@SourceDebugExtension(value={"SMAP\nComposeResourcesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeResourcesManager.kt\ncom/intellij/compose/ide/plugin/resources/ComposeResourcesManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 CollectionUtils.kt\ncom/intellij/compose/ide/plugin/shared/CollectionUtilsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,73:1\n78#2:74\n99#2,5:75\n296#3,2:80\n1266#3,4:87\n5#4,3:82\n8#4,3:91\n466#5:85\n415#5:86\n*S KotlinDebug\n*F\n+ 1 ComposeResourcesManager.kt\ncom/intellij/compose/ide/plugin/resources/ComposeResourcesManager\n*L\n27#1:74\n27#1:75,5\n38#1:80,2\n55#1:87,4\n53#1:82,3\n53#1:91,3\n55#1:85\n55#1:86\n*E\n"})
public final class ComposeResourcesManager {
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicReference<Map<String, ComposeResources>> myComposeResourcesByModulePath;

    public ComposeResourcesManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myComposeResourcesByModulePath = new AtomicReference();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ComposeResourcesDir> getComposeResources() {
        void $this$flatMapTo$iv$iv;
        Map<String, ComposeResources> $this$flatMap$iv = this.getComposeResourcesByModulePath();
        boolean $i$f$flatMap = false;
        Map<String, ComposeResources> map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            Iterable list$iv$iv = ((ComposeResources)it.getValue()).getDirectoriesBySourceSetName().values();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Map<String, ComposeResources> getComposeResourcesByModulePath() {
        Map map = this.myComposeResourcesByModulePath.updateAndGet(arg_0 -> ComposeResourcesManager._get_composeResourcesByModulePath_$lambda$0(this, arg_0));
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    public final void refresh() {
        this.myComposeResourcesByModulePath.updateAndGet(arg_0 -> ComposeResourcesManager.refresh$lambda$0(this, arg_0));
    }

    @Nullable
    public final ComposeResourcesDir findComposeResourcesDirFor(@NotNull Path path) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Iterable $this$firstOrNull$iv = this.getComposeResources();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ComposeResourcesDir it = (ComposeResourcesDir)element$iv;
                boolean bl = false;
                if (!path.startsWith(it.getDirectoryPath())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final Collection<DataNode<ComposeResourcesModel>> getComposeResourcesModels() {
        Collection collection = ProjectDataManager.getInstance().getExternalProjectsData(this.project, GradleConstants.SYSTEM_ID);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getExternalProjectsData(...)");
        ExternalProjectInfo externalProjectInfo = (ExternalProjectInfo)CollectionsKt.firstOrNull((Iterable)collection);
        if (externalProjectInfo == null) {
            return CollectionsKt.emptyList();
        }
        ExternalProjectInfo externalProjectData = externalProjectInfo;
        DataNode dataNode = externalProjectData.getExternalProjectStructure();
        if (dataNode == null) {
            return CollectionsKt.emptyList();
        }
        DataNode externalProjectStructure = dataNode;
        Collection collection2 = ExternalSystemApiUtil.findAllRecursively((DataNode)externalProjectStructure, ComposeResourcesDataServiceKt.getCOMPOSE_RESOURCES_KEY());
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"findAllRecursively(...)");
        return collection2;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, ComposeResources> loadComposeResources() {
        Map map;
        Iterable $this$associateNotNull$iv = this.getComposeResourcesModels();
        boolean $i$f$associateNotNull = false;
        Map $this$associateNotNull_u24lambda_u240$iv = map = MapsKt.createMapBuilder();
        boolean bl = false;
        for (Object item$iv : $this$associateNotNull$iv) {
            Pair pair;
            DataNode node = (DataNode)item$iv;
            boolean bl2 = false;
            DataNode dataNode = node.getParent();
            Object object = dataNode != null ? dataNode.getData() : null;
            Object object2 = object instanceof ModuleData ? (ModuleData)object : null;
            if (object2 == null || (object2 = object2.getModuleName()) == null) {
                pair = null;
            } else {
                void $this$associateByTo$iv$iv$iv;
                void $this$mapValuesTo$iv$iv;
                Object moduleName = object2;
                Map $this$mapValues$iv = ((ComposeResourcesModel)node.getData()).getCustomComposeResourcesDirs();
                boolean $i$f$mapValues = false;
                Map map2 = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
                Map destination$iv$iv$iv = destination$iv$iv;
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map3 = destination$iv$iv$iv;
                    boolean bl3 = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Object k = it$iv$iv.getKey();
                    Map map4 = map3;
                    boolean bl4 = false;
                    String sourceSetName = (String)entry2.getKey();
                    Pair customDirectoryPath = (Pair)entry2.getValue();
                    String directoryPath = (String)customDirectoryPath.component1();
                    boolean isCustom = (Boolean)customDirectoryPath.component2();
                    Path path = Path.of(directoryPath, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                    ComposeResourcesDir composeResourcesDir = new ComposeResourcesDir((String)moduleName, sourceSetName, path, isCustom);
                    map4.put(k, composeResourcesDir);
                }
                Map dirs = destination$iv$iv$iv;
                pair = TuplesKt.to((Object)moduleName, (Object)new ComposeResources((String)moduleName, dirs, ((ComposeResourcesModel)node.getData()).isPublicResClass(), ((ComposeResourcesModel)node.getData()).getNameOfResClass()));
            }
            if (pair == null) continue;
            Pair pair2 = pair;
            Object key$iv = pair2.component1();
            Object value$iv = pair2.component2();
            $this$associateNotNull_u24lambda_u240$iv.put(key$iv, value$iv);
        }
        return MapsKt.build((Map)map);
    }

    private static final Map _get_composeResourcesByModulePath_$lambda$0(ComposeResourcesManager this$0, Map cached) {
        Map<String, ComposeResources> map = cached;
        if (map == null) {
            map = this$0.loadComposeResources();
        }
        return map;
    }

    private static final Map refresh$lambda$0(ComposeResourcesManager this$0, Map it) {
        return this$0.loadComposeResources();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/compose/ide/plugin/resources/ComposeResourcesManager$ComposeResourcesProjectDataImportListener;", "Lcom/intellij/openapi/externalSystem/service/project/manage/ProjectDataImportListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "onImportFinished", "", "projectPath", "", "intellij.compose.ide.plugin.resources"})
    @SourceDebugExtension(value={"SMAP\nComposeResourcesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeResourcesManager.kt\ncom/intellij/compose/ide/plugin/resources/ComposeResourcesManager$ComposeResourcesProjectDataImportListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,73:1\n30#2,2:74\n*S KotlinDebug\n*F\n+ 1 ComposeResourcesManager.kt\ncom/intellij/compose/ide/plugin/resources/ComposeResourcesManager$ComposeResourcesProjectDataImportListener\n*L\n70#1:74,2\n*E\n"})
    public static final class ComposeResourcesProjectDataImportListener
    implements ProjectDataImportListener {
        @NotNull
        private final Project project;

        public ComposeResourcesProjectDataImportListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void onImportFinished(@Nullable String projectPath) {
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<ComposeResourcesManager> serviceClass$iv = ComposeResourcesManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((ComposeResourcesManager)object).refresh();
        }
    }
}

