/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger.agent;

import com.intellij.rt.debugger.agent.CaptureAgent;
import com.intellij.rt.debugger.agent.ClassTransformer;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import org.jetbrains.capture.org.objectweb.asm.ClassVisitor;
import org.jetbrains.capture.org.objectweb.asm.MethodVisitor;

public class SpilledVariablesTransformer {
    public static void init(Instrumentation instrumentation) {
        if (Boolean.getBoolean("debugger.agent.enable.coroutines")) {
            instrumentation.addTransformer(new SpillingTransformer(), true);
        }
    }

    private static class SpillingTransformer
    implements ClassFileTransformer {
        private static final String NULL_OUT_SPILLED_VARIABLE_DESC = "(Ljava/lang/Object;)Ljava/lang/Object;";

        private SpillingTransformer() {
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
            if (!"kotlin/coroutines/jvm/internal/SpillingKt".equals(className)) {
                return classfileBuffer;
            }
            try {
                ClassTransformer transformer = new ClassTransformer(className, classfileBuffer, 2, loader);
                byte[] bytes = transformer.accept(new ClassVisitor(589824, transformer.writer){

                    @Override
                    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                        MethodVisitor superMethodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
                        if (name.equals("nullOutSpilledVariable")) {
                            if (!descriptor.equals(SpillingTransformer.NULL_OUT_SPILLED_VARIABLE_DESC)) {
                                System.err.println("SpilledVariablesTransformer: unexpected descriptor of SpillingKt#nullOutSpilledVariable " + descriptor);
                                return superMethodVisitor;
                            }
                            return new MethodVisitor(this.api, superMethodVisitor){

                                @Override
                                public void visitCode() {
                                    super.visitCode();
                                    this.mv.visitVarInsn(25, 0);
                                    this.mv.visitInsn(176);
                                }
                            };
                        }
                        return superMethodVisitor;
                    }
                }, 0, false);
                CaptureAgent.storeClassForDebug(className, bytes);
                return bytes;
            }
            catch (Exception e) {
                System.out.println("SpillingTransformer: failed to instrument " + className);
                e.printStackTrace();
                return null;
            }
        }
    }
}

