/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rhizomedb.rql;

import com.jetbrains.rhizomedb.rql.Column;
import com.jetbrains.rhizomedb.rql.ColumnSelection;
import com.jetbrains.rhizomedb.rql.Expression;
import com.jetbrains.rhizomedb.rql.FromSource;
import com.jetbrains.rhizomedb.rql.GroupBy;
import com.jetbrains.rhizomedb.rql.InExpression;
import com.jetbrains.rhizomedb.rql.Lexer;
import com.jetbrains.rhizomedb.rql.Limit;
import com.jetbrains.rhizomedb.rql.OrderBy;
import com.jetbrains.rhizomedb.rql.OrderTerm;
import com.jetbrains.rhizomedb.rql.Query;
import com.jetbrains.rhizomedb.rql.RqlError;
import com.jetbrains.rhizomedb.rql.Token;
import com.jetbrains.rhizomedb.rql.TokenType;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0001\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0016H\u0002J\b\u0010 \u001a\u00020\u0016H\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\u0012H\u0002J\b\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020(H\u0002J\b\u0010,\u001a\u00020\tH\u0002J\u001c\u0010-\u001a\u00020\t2\u0006\u0010.\u001a\u00020(2\n\b\u0002\u0010/\u001a\u0004\u0018\u00010\u0003H\u0002J\u001a\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u00032\b\b\u0002\u00103\u001a\u00020\tH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/jetbrains/rhizomedb/rql/Parser;", "", "source", "", "<init>", "(Ljava/lang/String;)V", "lexer", "Lcom/jetbrains/rhizomedb/rql/Lexer;", "current", "Lcom/jetbrains/rhizomedb/rql/Token;", "parse", "Lcom/jetbrains/rhizomedb/rql/Query;", "query", "columnSelection", "Lcom/jetbrains/rhizomedb/rql/ColumnSelection;", "column", "Lcom/jetbrains/rhizomedb/rql/Column;", "from", "", "Lcom/jetbrains/rhizomedb/rql/FromSource;", "fromSource", "where", "Lcom/jetbrains/rhizomedb/rql/Expression;", "groupBy", "Lcom/jetbrains/rhizomedb/rql/GroupBy;", "orderBy", "Lcom/jetbrains/rhizomedb/rql/OrderBy;", "limit", "Lcom/jetbrains/rhizomedb/rql/Limit;", "orderTerm", "Lcom/jetbrains/rhizomedb/rql/OrderTerm;", "expression", "primary", "listing", "inExpression", "Lcom/jetbrains/rhizomedb/rql/InExpression;", "parsePrecedence", "minPrecedence", "", "peek", "Lcom/jetbrains/rhizomedb/rql/TokenType;", "match", "", "tokenType", "advance", "expect", "expected", "message", "parseError", "", "msg", "token", "fleet.rhizomedb"})
public final class Parser {
    @NotNull
    private final Lexer lexer;
    @NotNull
    private Token current;

    public Parser(@NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.lexer = new Lexer(source);
        this.current = this.lexer.scanToken();
    }

    @NotNull
    public final Query parse() {
        Query query = this.query();
        Parser.expect$default(this, TokenType.EOF, null, 2, null);
        return query;
    }

    private final Query query() {
        return new Query(this.columnSelection(), this.from(), this.where(), this.groupBy(), this.orderBy(), this.limit());
    }

    private final ColumnSelection columnSelection() {
        ColumnSelection columnSelection;
        this.expect(TokenType.SELECT, "Expected SELECT");
        if (WhenMappings.$EnumSwitchMapping$0[this.peek().ordinal()] == 1) {
            this.advance();
            columnSelection = ColumnSelection.Wildcard.INSTANCE;
        } else {
            Object[] objectArray = new Column[]{this.column()};
            List columns = CollectionsKt.mutableListOf((Object[])objectArray);
            while (this.match(TokenType.COMMA)) {
                columns.add(this.column());
            }
            columnSelection = new ColumnSelection.Columns(columns);
        }
        return columnSelection;
    }

    private final Column column() {
        Expression e = this.expression();
        String alias = this.match(TokenType.AS) ? this.expect(TokenType.IDENTIFIER, "Alias should be an identifier").getLexeme() : null;
        return new Column(e, alias);
    }

    private final List<FromSource> from() {
        if (this.match(TokenType.FROM)) {
            Object[] objectArray = new FromSource[]{this.fromSource()};
            List sources = CollectionsKt.mutableListOf((Object[])objectArray);
            while (this.match(TokenType.COMMA)) {
                sources.add(this.fromSource());
            }
            return sources;
        }
        return CollectionsKt.emptyList();
    }

    private final FromSource fromSource() {
        Token first = this.expect(TokenType.IDENTIFIER, "Expected identifier");
        FromSource result2 = new FromSource.Table(first);
        while (this.match(TokenType.JOIN)) {
            Token next = this.expect(TokenType.IDENTIFIER, "Expected identifier after JOIN");
            this.expect(TokenType.ON, "Expected ON after JOIN");
            Expression on = this.expression();
            result2 = new FromSource.Join(result2, next, on);
        }
        return result2;
    }

    private final Expression where() {
        if (this.match(TokenType.WHERE)) {
            return this.expression();
        }
        return null;
    }

    private final GroupBy groupBy() {
        if (this.match(TokenType.GROUP)) {
            this.expect(TokenType.BY, "Expected GROUP BY");
            List<Expression> expressions = this.listing();
            Expression having = this.match(TokenType.HAVING) ? this.expression() : null;
            return new GroupBy(expressions, having);
        }
        return null;
    }

    private final OrderBy orderBy() {
        if (this.match(TokenType.ORDER)) {
            this.expect(TokenType.BY, "Expected ORDER BY");
            Object[] objectArray = new OrderTerm[]{this.orderTerm()};
            List terms = CollectionsKt.mutableListOf((Object[])objectArray);
            while (this.match(TokenType.COMMA)) {
                terms.add(this.orderTerm());
            }
            return new OrderBy(terms);
        }
        return null;
    }

    private final Limit limit() {
        if (this.match(TokenType.LIMIT)) {
            Expression limit = this.expression();
            Expression offset = this.match(TokenType.OFFSET) ? this.expression() : null;
            return new Limit(limit, offset);
        }
        return null;
    }

    private final OrderTerm orderTerm() {
        Expression e = this.expression();
        boolean ascending = this.match(TokenType.ASC) || !this.match(TokenType.DESC);
        return new OrderTerm(e, ascending);
    }

    private final Expression expression() {
        return this.parsePrecedence(0);
    }

    private final Expression primary() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.peek().ordinal()]) {
            case 2, 3, 4, 5, 6, 7, 8 -> new Expression.Literal(this.advance());
            case 9 -> new Expression.Variable(this.advance());
            default -> {
                Parser.parseError$default(this, "Unexpected token '" + this.current.getLexeme() + "'", null, 2, null);
                throw new KotlinNothingValueException();
            }
        };
    }

    private final List<Expression> listing() {
        if (this.peek() == TokenType.RPAREN) {
            return CollectionsKt.emptyList();
        }
        Object[] objectArray = new Expression[]{this.expression()};
        List params = CollectionsKt.mutableListOf((Object[])objectArray);
        while (this.match(TokenType.COMMA)) {
            params.add(this.expression());
        }
        return params;
    }

    private final InExpression inExpression() {
        if (this.peek() == TokenType.SELECT) {
            return new InExpression.Select(this.query());
        }
        this.expect(TokenType.LPAREN, "Expecting ( after IN clause");
        if (this.peek() == TokenType.SELECT) {
            Query q = this.query();
            this.expect(TokenType.RPAREN, "Expecting ) after query");
            return new InExpression.Select(q);
        }
        List<Expression> items = this.listing();
        this.expect(TokenType.RPAREN, "Expecting )");
        return new InExpression.Tuple(items);
    }

    private final Expression parsePrecedence(int minPrecedence) {
        Expression expression;
        Integer prefixPrecedence;
        switch (WhenMappings.$EnumSwitchMapping$0[this.peek().ordinal()]) {
            case 10: 
            case 11: 
            case 12: {
                Integer n = 8;
                break;
            }
            default: {
                Integer n = prefixPrecedence = null;
            }
        }
        if (prefixPrecedence != null) {
            Token operator = this.advance();
            Expression operand = this.parsePrecedence(prefixPrecedence);
            expression = new Expression.UnaryOp(operator, operand);
        } else if (this.match(TokenType.LPAREN)) {
            Expression inner = this.parsePrecedence(0);
            this.expect(TokenType.RPAREN, "Expected )");
            expression = inner;
        } else {
            expression = this.primary();
        }
        Expression left = expression;
        block17: while (true) {
            Object right;
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[this.peek().ordinal()]) {
                case 13: {
                    n = 1;
                    break;
                }
                case 14: {
                    n = 2;
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    n = 4;
                    break;
                }
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    n = 5;
                    break;
                }
                case 10: 
                case 11: {
                    n = 6;
                    break;
                }
                case 1: 
                case 23: 
                case 24: {
                    n = 7;
                    break;
                }
                case 25: {
                    n = 9;
                    break;
                }
                default: {
                    break block17;
                }
            }
            int infixPrecedence = n;
            if (infixPrecedence <= minPrecedence) break;
            Token operator = this.advance();
            switch (WhenMappings.$EnumSwitchMapping$0[operator.getType().ordinal()]) {
                case 18: {
                    right = this.inExpression();
                    left = new Expression.InOp(left, (InExpression)right);
                    continue block17;
                }
                case 17: {
                    Token pattern = this.expect(TokenType.STRING, "Expected string after LIKE");
                    Expression.Literal right2 = new Expression.Literal(pattern);
                    left = new Expression.BinaryOp(left, operator, right2);
                    continue block17;
                }
                case 25: {
                    List<Expression> parameters = this.listing();
                    this.expect(TokenType.RPAREN, "Expected )");
                    left = new Expression.FunctionCall(left, parameters);
                    continue block17;
                }
            }
            right = this.parsePrecedence(infixPrecedence);
            left = new Expression.BinaryOp(left, operator, (Expression)right);
        }
        return left;
    }

    private final TokenType peek() {
        return this.current.getType();
    }

    private final boolean match(TokenType tokenType) {
        if (this.peek() == tokenType) {
            this.advance();
            return true;
        }
        return false;
    }

    private final Token advance() {
        Token token = this.current;
        this.current = this.lexer.scanToken();
        return token;
    }

    private final Token expect(TokenType expected, String message) {
        if (this.peek() != expected) {
            Object object = message;
            if (object == null) {
                object = "Unexpected token '" + this.current.getLexeme() + "'";
            }
            Parser.parseError$default(this, (String)object, null, 2, null);
            throw new KotlinNothingValueException();
        }
        return this.advance();
    }

    static /* synthetic */ Token expect$default(Parser parser, TokenType tokenType, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return parser.expect(tokenType, string);
    }

    private final Void parseError(String msg, Token token) {
        throw new RqlError(token.getStartOffset(), token.getEndOffset(), "Parse error: " + msg);
    }

    static /* synthetic */ Void parseError$default(Parser parser, String string, Token token, int n, Object object) {
        if ((n & 2) != 0) {
            token = parser.current;
        }
        return parser.parseError(string, token);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TokenType.values().length];
            try {
                nArray[TokenType.STAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.INTEGER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.FLOAT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.DOUBLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.STRING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.TRUE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.FALSE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.NULL.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.IDENTIFIER.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.PLUS.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.MINUS.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.NOT.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.OR.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.AND.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.EQUAL.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.NOT_EQUAL.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.LIKE.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.IN.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.GREATER.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.GREATER_EQUAL.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.LESS.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.LESS_EQUAL.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.SLASH.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.PERCENT.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.LPAREN.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

