/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit5.report;

import com.intellij.junit5.report.ExecutionState;
import com.intellij.junit5.report.LocationInfo;
import com.intellij.junit5.report.SuiteReporter;
import com.intellij.junit5.report.TeamCityTestReporter;
import com.intellij.rt.execution.junit.ComparisonFailureData;
import com.intellij.rt.execution.junit.MapSerializerUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestIdentifier;

public abstract class AbstractTestReporter
implements TeamCityTestReporter {
    protected final TestIdentifier identifier;
    protected final ExecutionState state;

    protected AbstractTestReporter(TestIdentifier identifier, ExecutionState state) {
        this.identifier = identifier;
        this.state = state;
    }

    @Override
    public List<String> output(ReportEntry entry) {
        Map<String, String> attrs = this.attributes(ReportedField.ID, ReportedField.NAME, ReportedField.NODE_ID, ReportedField.PARENT_NODE_ID);
        StringBuilder builder = new StringBuilder();
        builder.append("timestamp = ").append(entry.getTimestamp());
        entry.getKeyValuePairs().forEach((key, value) -> builder.append(", ").append((String)key).append(" = ").append((String)value));
        builder.append("\n");
        attrs.put("out", builder.toString());
        return Collections.singletonList(MapSerializerUtil.asString((String)"testStdOut", attrs));
    }

    protected String id() {
        return this.identifier.getUniqueId() + this.state.suffix();
    }

    protected Optional<SuiteReporter> getParent() {
        return this.state.plan().getParent(this.identifier).map(i -> new SuiteReporter((TestIdentifier)i, this.state)).map(r -> r.isSkipped() ? r.getParent() : Optional.of(r)).orElse(Optional.empty());
    }

    protected Map<String, String> attributes(ReportedField ... fields) {
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>(fields.length * 2);
        LocationInfo location = this.locationInfo();
        for (ReportedField field : fields) {
            String value = null;
            switch (field.ordinal()) {
                case 0: 
                case 2: {
                    value = this.id();
                    break;
                }
                case 1: {
                    value = this.name();
                    break;
                }
                case 3: {
                    value = this.getParent().map(AbstractTestReporter::id).orElse("0");
                    break;
                }
                case 4: {
                    value = location.locationHint();
                    break;
                }
                case 5: {
                    value = location.metainfo();
                }
            }
            if (value == null) continue;
            attrs.put(field.getId(), value);
        }
        return attrs;
    }

    protected String name() {
        return this.identifier.getDisplayName();
    }

    private LocationInfo locationInfo() {
        if (this.state.plan() == null) {
            return LocationInfo.EMPTY;
        }
        TestIdentifier parent = this.state.plan().getParent(this.identifier).orElse(null);
        return LocationInfo.compute(this.identifier, parent);
    }

    protected static String getTrace(Throwable ex) {
        if (ComparisonFailureData.isAssertionError(ex.getClass())) {
            return "";
        }
        StringWriter writer = new StringWriter();
        ex.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    protected static enum ReportedField {
        ID("id"),
        NAME("name"),
        NODE_ID("nodeId"),
        PARENT_NODE_ID("parentNodeId"),
        HINT("locationHint"),
        METAINFO("metainfo");

        private final String myId;

        private ReportedField(String id) {
            this.myId = id;
        }

        public String getId() {
            return this.myId;
        }
    }
}

