/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.intentions;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationBundle;
import com.intellij.refactoring.typeMigration.TypeMigrationVariableTypeFixProvider;
import com.intellij.refactoring.typeMigration.rules.LongAdderConversionRule;
import com.intellij.util.IncorrectOperationException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class ConvertAtomicToLongAdderIntention
extends BaseElementAtCaretIntentionAction {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiVariable variable;
        if (project == null) {
            ConvertAtomicToLongAdderIntention.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ConvertAtomicToLongAdderIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            ConvertAtomicToLongAdderIntention.$$$reportNull$$$0(2);
        }
        if ((variable = ConvertAtomicToLongAdderIntention.getVariable(element)) != null) {
            PsiType longAdder = JavaPsiFacade.getElementFactory((Project)project).createTypeFromText("java.util.concurrent.atomic.LongAdder", element);
            TypeMigrationVariableTypeFixProvider.runTypeMigrationOnVariable(variable, longAdder, null, false, false);
        }
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            ConvertAtomicToLongAdderIntention.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            ConvertAtomicToLongAdderIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            ConvertAtomicToLongAdderIntention.$$$reportNull$$$0(5);
        }
        if (!element.isValid() || !PsiUtil.isLanguageLevel8OrHigher((PsiElement)element)) {
            return false;
        }
        PsiVariable variable = ConvertAtomicToLongAdderIntention.getVariable(element);
        return variable != null;
    }

    private static PsiVariable getVariable(PsiElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiLocalVariable) && !(parent instanceof PsiField)) {
            return null;
        }
        PsiVariable var = (PsiVariable)element.getParent();
        PsiType type = var.getType();
        if (!type.isValid()) {
            return null;
        }
        PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)type);
        if (aClass == null || !AtomicLong.class.getName().equals(aClass.getQualifiedName()) && !AtomicInteger.class.getName().equals(aClass.getQualifiedName())) {
            return null;
        }
        PsiExpression initializer = var.getInitializer();
        if (initializer != null) {
            if (initializer instanceof PsiNewExpression) {
                return LongAdderConversionRule.getParametersCount((PsiCallExpression)initializer) == -1 ? null : var;
            }
            return null;
        }
        return var;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            ConvertAtomicToLongAdderIntention.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = TypeMigrationBundle.message("convert.to.longadder.family.name", new Object[0]);
        if (string == null) {
            ConvertAtomicToLongAdderIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/intentions/ConvertAtomicToLongAdderIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/intentions/ConvertAtomicToLongAdderIntention";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

