/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;
import com.intellij.refactoring.typeMigration.usageInfo.TypeMigrationUsageInfo;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OptionalConversionRule
extends TypeConversionRule {
    private static final Map<String, String> GET_METHODS = Map.of("java.util.Optional", "orElse(null)", "java.util.OptionalInt", "getAsInt()", "java.util.OptionalLong", "getAsLong()", "java.util.OptionalDouble", "getAsDouble()");

    @Nullable
    public TypeConversionDescriptorBase findConversion(PsiType from, PsiType to, PsiMember member, PsiExpression context, TypeMigrationLabeler labeler) {
        PsiReferenceExpression ref;
        PsiExpression binOp2;
        PsiAssignmentExpression assignment;
        PsiReferenceExpression qualifierRef;
        PsiReferenceExpression ref2;
        PsiExpression qualifier;
        PsiElement element;
        PsiType optionalElementType = OptionalUtil.getOptionalElementType((PsiType)to);
        if (optionalElementType == null) {
            return null;
        }
        if (!from.equals(optionalElementType)) {
            return null;
        }
        PsiClass optionalClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)to);
        if (optionalClass == null) {
            return null;
        }
        String qualifiedName = optionalClass.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        PsiElement parent = context.getParent();
        TypeMigrationUsageInfo root = labeler.getCurrentRoot();
        PsiElement psiElement = element = root == null ? null : root.getElement();
        if (element != null && context instanceof PsiReferenceExpression && (qualifier = (ref2 = (PsiReferenceExpression)context).getQualifierExpression()) instanceof PsiReferenceExpression && (qualifierRef = (PsiReferenceExpression)qualifier).isReferenceTo(element)) {
            return new TypeConversionDescriptor("$val$", "$val$.get()", qualifier);
        }
        if (element != null && context instanceof PsiReferenceExpression && (ref2 = (PsiReferenceExpression)context).isReferenceTo(element)) {
            PsiBinaryExpression binOp2;
            IElementType tokenType;
            if (parent instanceof PsiBinaryExpression && ((tokenType = (binOp2 = (PsiBinaryExpression)parent).getOperationTokenType()).equals(JavaTokenType.EQEQ) || tokenType.equals(JavaTokenType.NE))) {
                PsiExpression lOp = binOp2.getLOperand();
                PsiExpression rOp = binOp2.getROperand();
                if (rOp != null) {
                    if (ExpressionUtils.isNullLiteral((PsiExpression)rOp)) {
                        return new TypeConversionDescriptor("$val$" + binOp2.getOperationSign().getText() + rOp.getText(), tokenType.equals(JavaTokenType.EQEQ) ? "$val$.isEmpty()" : "$val$.isPresent()", (PsiExpression)binOp2);
                    }
                    if (ExpressionUtils.isNullLiteral((PsiExpression)lOp)) {
                        return new TypeConversionDescriptor(lOp.getText() + binOp2.getOperationSign().getText() + "$val$", tokenType.equals(JavaTokenType.EQEQ) ? "$val$.isEmpty()" : "$val$.isPresent()", (PsiExpression)binOp2);
                    }
                }
            }
            return new TypeConversionDescriptor("$val$", "$val$." + GET_METHODS.get(qualifiedName), context);
        }
        if (parent instanceof PsiAssignmentExpression && (assignment = (PsiAssignmentExpression)parent).getRExpression() == context && element != null && (binOp2 = assignment.getLExpression()) instanceof PsiReferenceExpression && (ref = (PsiReferenceExpression)binOp2).isReferenceTo(element) && assignment.getOperationTokenType().equals(JavaTokenType.PLUSEQ) && TypeUtils.isJavaLangString((PsiType)optionalElementType)) {
            String varName = new VariableNameGenerator((PsiElement)context, VariableKind.PARAMETER).byName(new String[]{ref.getText()}).byType(optionalElementType).generate(true);
            return new TypeConversionDescriptor("$val$+=$operand$", "$val$=$val$.map(" + varName + "->" + varName + "+$operand$)", (PsiExpression)assignment);
        }
        if (context instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment2 = (PsiAssignmentExpression)context;
            String compoundOp = assignment2.getOperationSign().getText();
            String op = compoundOp.substring(0, compoundOp.length() - 1);
            if (!op.isEmpty()) {
                return new TypeConversionDescriptor("$val$" + compoundOp + "$operand$", "$val$=" + qualifiedName + ".of($val$." + GET_METHODS.get(qualifiedName) + op + "$operand$)", context);
            }
        } else if (context instanceof PsiUnaryExpression) {
            PsiUnaryExpression unary = (PsiUnaryExpression)context;
            if (context instanceof PsiPrefixExpression || ExpressionUtils.isVoidContext((PsiExpression)unary)) {
                String op;
                IElementType tokenType = unary.getOperationTokenType();
                String string = tokenType.equals(JavaTokenType.PLUSPLUS) ? "+" : (op = tokenType.equals(JavaTokenType.MINUSMINUS) ? "-" : null);
                if (op != null) {
                    Object orig = "$val$";
                    orig = context instanceof PsiPrefixExpression ? op + op + (String)orig : (String)orig + op + op;
                    return new TypeConversionDescriptor((String)orig, "$val$=" + qualifiedName + ".of($val$." + GET_METHODS.get(qualifiedName) + op + "1)", context);
                }
            }
        }
        if (ExpressionUtils.isVoidContext((PsiExpression)context)) {
            return new TypeConversionDescriptor("$val$", "$val$", context);
        }
        return OptionalConversionRule.wrap(context, qualifiedName);
    }

    @NotNull
    private static TypeConversionDescriptor wrap(PsiExpression context, String qualifiedName) {
        if (ExpressionUtils.isNullLiteral((PsiExpression)context)) {
            return new TypeConversionDescriptor("$val$", qualifiedName + ".empty()", context);
        }
        if (NullabilityUtil.getExpressionNullability((PsiExpression)context, (boolean)true) == Nullability.NOT_NULL) {
            return new TypeConversionDescriptor("$val$", qualifiedName + ".of($val$)", context);
        }
        return new TypeConversionDescriptor("$val$", qualifiedName + ".ofNullable($val$)", context);
    }

    public boolean shouldConvertNullInitializer(PsiType from, PsiType to, PsiExpression context) {
        return from.equals(OptionalUtil.getOptionalElementType((PsiType)to));
    }
}

