/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class FunctionalInterfaceTypeConversionDescriptor
extends TypeConversionDescriptor {
    @NotNull
    private final String myMethodName;
    @NotNull
    private final String myTargetMethodName;
    @NotNull
    private final String myTargetClassQName;

    FunctionalInterfaceTypeConversionDescriptor(@NotNull String methodName, @NotNull String targetMethodName, @NotNull String targetClassQName) {
        if (methodName == null) {
            FunctionalInterfaceTypeConversionDescriptor.$$$reportNull$$$0(0);
        }
        if (targetMethodName == null) {
            FunctionalInterfaceTypeConversionDescriptor.$$$reportNull$$$0(1);
        }
        if (targetClassQName == null) {
            FunctionalInterfaceTypeConversionDescriptor.$$$reportNull$$$0(2);
        }
        super(null, null);
        this.myMethodName = methodName;
        this.myTargetMethodName = targetMethodName;
        this.myTargetClassQName = targetClassQName;
    }

    @Override
    public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) {
        if (evaluator == null) {
            FunctionalInterfaceTypeConversionDescriptor.$$$reportNull$$$0(3);
        }
        if (expression.getParent() instanceof PsiMethodReferenceExpression) {
            expression = (PsiExpression)expression.getParent();
        }
        if (expression instanceof PsiMethodReferenceExpression) {
            expression = this.setupAsMethodReference(expression);
        } else if (expression instanceof PsiReferenceExpression) {
            this.setupAsReference();
        } else {
            this.setupAsMethodCall();
        }
        PsiExpression converted = super.replace(expression, evaluator);
        PsiElement parent = converted.getParent();
        if (parent instanceof PsiParenthesizedExpression && !ParenthesesUtils.areParenthesesNeeded((PsiParenthesizedExpression)((PsiParenthesizedExpression)parent), (boolean)true)) {
            return (PsiExpression)parent.replace((PsiElement)converted);
        }
        return converted;
    }

    private void setupAsReference() {
        this.setStringToReplace("$ref$");
        this.setReplaceByString("$ref$::" + this.myTargetMethodName);
    }

    private PsiExpression setupAsMethodReference(PsiExpression methodReferenceExpression) {
        PsiClass resolvedClass;
        PsiTypeElement typeElement;
        PsiElement parent = methodReferenceExpression.getParent();
        if (parent instanceof PsiTypeCastExpression && (typeElement = ((PsiTypeCastExpression)parent).getCastType()) != null && (resolvedClass = PsiTypesUtil.getPsiClass((PsiType)typeElement.getType())) != null && this.myTargetClassQName.equals(resolvedClass.getQualifiedName())) {
            methodReferenceExpression = (PsiExpression)parent.replace((PsiElement)methodReferenceExpression);
        }
        this.setStringToReplace("$qualifier$::" + this.myMethodName);
        this.setReplaceByString("$qualifier$");
        return methodReferenceExpression;
    }

    private void setupAsMethodCall() {
        this.setStringToReplace("$qualifier$." + this.myMethodName + "($param$)");
        this.setReplaceByString("$qualifier$." + this.myTargetMethodName + "($param$)");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetMethodName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClassQName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/typeMigration/rules/guava/FunctionalInterfaceTypeConversionDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "replace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

