/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit6;

import com.intellij.junit5.JUnit5TestRunnerHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.engine.CancellationToken;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.LauncherExecutionRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherExecutionRequestBuilder;

final class JUnit6TestRunnerHelper
extends JUnit5TestRunnerHelper {
    private static final int DEFAULT_SHUTDOWN_TIMEOUT = 600;
    private final CancellationToken myCancellationToken = CancellationToken.create();
    private final ReentrantLock myLock = new ReentrantLock();

    JUnit6TestRunnerHelper() {
        int shutdownTimeout = JUnit6TestRunnerHelper.getIntProperty("idea.test.graceful.shutdown.timeout.seconds", 600);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.myCancellationToken.cancel();
                if (shutdownTimeout >= 0) {
                    this.myLock.tryLock(shutdownTimeout, TimeUnit.SECONDS);
                } else {
                    this.myLock.lockInterruptibly();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }, "junit6-shutdown-hook"));
    }

    protected boolean loadMethodByReflection(MethodSelector selector) {
        try {
            Class<?> aClass = Class.forName(selector.getClassName());
            return ReflectionSupport.findMethod(aClass, (String)selector.getMethodName(), (Class[])selector.getParameterTypes()).isPresent();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Launcher launcher, LauncherDiscoveryRequest request, TestExecutionListener[] listeners) {
        this.myLock.lock();
        try {
            LauncherExecutionRequest executionRequest = LauncherExecutionRequestBuilder.request((LauncherDiscoveryRequest)request).cancellationToken(this.myCancellationToken).listeners(listeners).build();
            launcher.execute(executionRequest);
        }
        finally {
            this.myLock.unlock();
        }
    }

    private static int getIntProperty(String propertyName, int defaultValue) {
        String property = System.getProperty(propertyName);
        if (property == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

