/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.wasm;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibDiagnosticContext;
import org.jetbrains.kotlin.ir.backend.js.wasm.ExportKind;
import org.jetbrains.kotlin.ir.backend.js.wasm.WasmKlibExportingDeclaration;
import org.jetbrains.kotlin.ir.backend.js.wasm.declarations.WasmKlibExportsChecker;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.library.SerializedIrFile;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JX\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b20\b\u0002\u0010\r\u001a*\u0012\u0004\u0012\u00020\u000f\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000e0\u000e0\u000ej\u0002`\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/wasm/WasmKlibCheckers;", "", "<init>", "()V", "makeChecker", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "diagnosticReporter", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "cleanFiles", "", "Lorg/jetbrains/kotlin/library/SerializedIrFile;", "exportedNames", "", "Lorg/jetbrains/kotlin/ir/backend/js/wasm/ExportKind;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "", "Lorg/jetbrains/kotlin/ir/backend/js/wasm/ExportNamesMap;", "ir.serialization.js"})
public final class WasmKlibCheckers {
    @NotNull
    public static final WasmKlibCheckers INSTANCE = new WasmKlibCheckers();

    private WasmKlibCheckers() {
    }

    @NotNull
    public final IrVisitorVoid makeChecker(@NotNull IrDiagnosticReporter diagnosticReporter, @NotNull CompilerConfiguration configuration, @NotNull List<SerializedIrFile> cleanFiles, @NotNull Map<ExportKind, ? extends Map<IrFile, ? extends Map<IrDeclarationWithName, String>>> exportedNames) {
        Intrinsics.checkNotNullParameter((Object)diagnosticReporter, (String)"diagnosticReporter");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(cleanFiles, (String)"cleanFiles");
        Intrinsics.checkNotNullParameter(exportedNames, (String)"exportedNames");
        return new IrVisitorVoid(configuration, cleanFiles, exportedNames, diagnosticReporter){
            private final JsKlibDiagnosticContext diagnosticContext;
            final /* synthetic */ List<SerializedIrFile> $cleanFiles;
            final /* synthetic */ Map<ExportKind, Map<IrFile, Map<IrDeclarationWithName, String>>> $exportedNames;
            final /* synthetic */ IrDiagnosticReporter $diagnosticReporter;
            {
                this.$cleanFiles = $cleanFiles;
                this.$exportedNames = $exportedNames;
                this.$diagnosticReporter = $diagnosticReporter;
                this.diagnosticContext = new JsKlibDiagnosticContext($configuration);
            }

            public void visitModuleFragment(IrModuleFragment declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                List<WasmKlibExportingDeclaration> exportedDeclarations = WasmKlibExportingDeclaration.Companion.collectDeclarations(this.$cleanFiles, declaration.getFiles(), this.$exportedNames);
                WasmKlibExportsChecker.INSTANCE.check(exportedDeclarations, this.diagnosticContext, this.$diagnosticReporter);
            }
        };
    }

    public static /* synthetic */ IrVisitorVoid makeChecker$default(WasmKlibCheckers wasmKlibCheckers, IrDiagnosticReporter irDiagnosticReporter, CompilerConfiguration compilerConfiguration, List list, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        return wasmKlibCheckers.makeChecker(irDiagnosticReporter, compilerConfiguration, list, map);
    }
}

