/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.declarations;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.CompilerVersionOfApiDeprecation;
import org.jetbrains.kotlin.DeprecatedForRemovalCompilerApi;
import org.jetbrains.kotlin.constant.EvaluatedConstTracker;
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.descriptors.MultiFieldValueClassRepresentation;
import org.jetbrains.kotlin.descriptors.ValueClassRepresentation;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.MetadataSource;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NameUtils;

@Metadata(mv={2, 4, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\n\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\u001a\u0018\u0010\r\u001a\u00020\u0001*\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f\u001a5\u0010\u0000\u001a\u0002H,\"\b\b\u0000\u0010,*\u00020\u0002*\u0002H,2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0007b\u000e\b.\u0012\n\b/\u0012\u0006\b\n0081\u00a2\u0006\u0002\u0010-\"\u0015\u0010\u0006\u001a\u00020\u0005*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\"\u0015\u0010\t\u001a\u00020\u0005*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\b\"\u0015\u0010\u0010\u001a\u00020\u0011*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\"\u0015\u0010\u0015\u001a\u00020\u0011*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014\"\u0015\u0010\u0017\u001a\u00020\u0011*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014\"\u0015\u0010\u0019\u001a\u00020\u0011*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014\"\u0015\u0010\u001b\u001a\u00020\u001c*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\"\u0015\u0010\u001f\u001a\u00020\u0005*\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!\"\u0015\u0010\"\u001a\u00020\u0005*\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010!\"\u001d\u0010#\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\"\u001d\u0010(\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010)*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u00062"}, d2={"copyAttributes", "", "Lorg/jetbrains/kotlin/ir/IrElement;", "other", "includeAll", "", "isSingleFieldValueClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Z", "isMultiFieldValueClass", "addMember", "member", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "addAll", "members", "", "path", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getPath", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;)Ljava/lang/String;", "name", "getName", "nameWithPackage", "getNameWithPackage", "packagePartClassName", "getPackagePartClassName", "evaluatedConstTrackerKey", "Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker$Key;", "getEvaluatedConstTrackerKey", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;)Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker$Key;", "isStaticMethodOfClass", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "isPropertyAccessor", "multiFieldValueClassRepresentation", "Lorg/jetbrains/kotlin/descriptors/MultiFieldValueClassRepresentation;", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "getMultiFieldValueClassRepresentation", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/descriptors/MultiFieldValueClassRepresentation;", "inlineClassRepresentation", "Lorg/jetbrains/kotlin/descriptors/InlineClassRepresentation;", "getInlineClassRepresentation", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/descriptors/InlineClassRepresentation;", "D", "(Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/IrElement;)Lorg/jetbrains/kotlin/ir/IrElement;", "Lorg/jetbrains/kotlin/DeprecatedForRemovalCompilerApi;", "deprecatedSince", "Lorg/jetbrains/kotlin/CompilerVersionOfApiDeprecation;", "_2_1_20", "ir.tree"})
public final class IrDeclarationsKt {
    public static final void copyAttributes(@NotNull IrElement $this$copyAttributes, @NotNull IrElement other, boolean includeAll) {
        Intrinsics.checkNotNullParameter((Object)$this$copyAttributes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ((IrElementBase)$this$copyAttributes).copyAttributesFrom$ir_tree((IrElementBase)other, includeAll);
        $this$copyAttributes.setAttributeOwnerId(other.getAttributeOwnerId());
    }

    public static /* synthetic */ void copyAttributes$default(IrElement irElement, IrElement irElement2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        IrDeclarationsKt.copyAttributes(irElement, irElement2, bl);
    }

    public static final boolean isSingleFieldValueClass(@NotNull IrClass $this$isSingleFieldValueClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isSingleFieldValueClass, (String)"<this>");
        return $this$isSingleFieldValueClass.getValueClassRepresentation() instanceof InlineClassRepresentation;
    }

    public static final boolean isMultiFieldValueClass(@NotNull IrClass $this$isMultiFieldValueClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isMultiFieldValueClass, (String)"<this>");
        return $this$isMultiFieldValueClass.getValueClassRepresentation() instanceof MultiFieldValueClassRepresentation;
    }

    public static final void addMember(@NotNull IrClass $this$addMember, @NotNull IrDeclaration member) {
        Intrinsics.checkNotNullParameter((Object)$this$addMember, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        $this$addMember.getDeclarations().add(member);
    }

    public static final void addAll(@NotNull IrClass $this$addAll, @NotNull List<? extends IrDeclaration> members) {
        Intrinsics.checkNotNullParameter((Object)$this$addAll, (String)"<this>");
        Intrinsics.checkNotNullParameter(members, (String)"members");
        $this$addAll.getDeclarations().addAll((Collection<IrDeclaration>)members);
    }

    @NotNull
    public static final String getPath(@NotNull IrFile $this$path) {
        Intrinsics.checkNotNullParameter((Object)$this$path, (String)"<this>");
        return $this$path.getFileEntry().getName();
    }

    @NotNull
    public static final String getName(@NotNull IrFile $this$name) {
        Intrinsics.checkNotNullParameter((Object)$this$name, (String)"<this>");
        String string = new File(IrDeclarationsKt.getPath($this$name)).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public static final String getNameWithPackage(@NotNull IrFile $this$nameWithPackage) {
        Intrinsics.checkNotNullParameter((Object)$this$nameWithPackage, (String)"<this>");
        FqName fqName = $this$nameWithPackage.getPackageFqName();
        Name name = Name.identifier((String)IrDeclarationsKt.getName($this$nameWithPackage));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        return fqName.child(name).asString();
    }

    @NotNull
    public static final String getPackagePartClassName(@NotNull IrFile $this$packagePartClassName) {
        Intrinsics.checkNotNullParameter((Object)$this$packagePartClassName, (String)"<this>");
        return NameUtils.getPackagePartClassNamePrefix((String)FilesKt.getNameWithoutExtension((File)new File(IrDeclarationsKt.getPath($this$packagePartClassName)))) + "Kt";
    }

    @NotNull
    public static final EvaluatedConstTracker.Key getEvaluatedConstTrackerKey(@NotNull IrFile $this$evaluatedConstTrackerKey) {
        Intrinsics.checkNotNullParameter((Object)$this$evaluatedConstTrackerKey, (String)"<this>");
        MetadataSource metadataSource = $this$evaluatedConstTrackerKey.getMetadata();
        MetadataSource.File file = metadataSource instanceof MetadataSource.File ? (MetadataSource.File)metadataSource : null;
        if (file == null || (file = file.asEvaluatedConstTrackerKey()) == null) {
            file = (EvaluatedConstTracker.Key)new EvaluatedConstTracker.Key.StringBased($this$evaluatedConstTrackerKey.getFileEntry().getName());
        }
        return file;
    }

    public static final boolean isStaticMethodOfClass(@NotNull IrFunction $this$isStaticMethodOfClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isStaticMethodOfClass, (String)"<this>");
        return $this$isStaticMethodOfClass instanceof IrSimpleFunction && ((IrSimpleFunction)$this$isStaticMethodOfClass).getParent() instanceof IrClass && $this$isStaticMethodOfClass.getDispatchReceiverParameter() == null;
    }

    public static final boolean isPropertyAccessor(@NotNull IrFunction $this$isPropertyAccessor) {
        Intrinsics.checkNotNullParameter((Object)$this$isPropertyAccessor, (String)"<this>");
        return $this$isPropertyAccessor instanceof IrSimpleFunction && ((IrSimpleFunction)$this$isPropertyAccessor).getCorrespondingPropertySymbol() != null;
    }

    @Nullable
    public static final MultiFieldValueClassRepresentation<IrSimpleType> getMultiFieldValueClassRepresentation(@NotNull IrClass $this$multiFieldValueClassRepresentation) {
        Intrinsics.checkNotNullParameter((Object)$this$multiFieldValueClassRepresentation, (String)"<this>");
        ValueClassRepresentation<IrSimpleType> valueClassRepresentation = $this$multiFieldValueClassRepresentation.getValueClassRepresentation();
        return valueClassRepresentation instanceof MultiFieldValueClassRepresentation ? (MultiFieldValueClassRepresentation)valueClassRepresentation : null;
    }

    @Nullable
    public static final InlineClassRepresentation<IrSimpleType> getInlineClassRepresentation(@NotNull IrClass $this$inlineClassRepresentation) {
        Intrinsics.checkNotNullParameter((Object)$this$inlineClassRepresentation, (String)"<this>");
        ValueClassRepresentation<IrSimpleType> valueClassRepresentation = $this$inlineClassRepresentation.getValueClassRepresentation();
        return valueClassRepresentation instanceof InlineClassRepresentation ? (InlineClassRepresentation)valueClassRepresentation : null;
    }

    @DeprecatedForRemovalCompilerApi(deprecatedSince=CompilerVersionOfApiDeprecation._2_1_20)
    @NotNull
    public static final <D extends IrElement> D copyAttributes(@NotNull D $this$copyAttributes, @Nullable IrElement other) {
        D d;
        Intrinsics.checkNotNullParameter($this$copyAttributes, (String)"<this>");
        D $this$copyAttributes_u24lambda_u240 = d = $this$copyAttributes;
        boolean bl = false;
        if (other != null) {
            IrDeclarationsKt.copyAttributes($this$copyAttributes_u24lambda_u240, other, false);
        }
        return d;
    }
}

