/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mcpserver.clients;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.mcpserver.StdioRunnerUtilKt;
import com.intellij.mcpserver.clients.McpClient;
import com.intellij.mcpserver.clients.McpClient$McpServers$;
import com.intellij.mcpserver.clients.McpClientInfo;
import com.intellij.mcpserver.clients.configs.ExistingConfig;
import com.intellij.mcpserver.clients.configs.ExistingConfig$;
import com.intellij.mcpserver.clients.configs.STDIOServerConfig;
import com.intellij.mcpserver.clients.configs.ServerConfig;
import com.intellij.mcpserver.impl.McpServerService;
import com.intellij.mcpserver.impl.util.network.McpServerConnectionAddressProvider;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.ClassDiscriminatorMode;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonIgnoreUnknownKeys;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonNames;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.json.JvmStreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 @2\u00020\u0001:\u0003?@AB\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\f\u001a\u00020\rH\u0096\u0080\u0004J\u000f\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\rH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\n\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u0014J\b\u0010\u001c\u001a\u00020\u001aH\u0002J\u0016\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eH\u0014J\u000f\u0010 \u001a\u0004\u0018\u00010\u0014H\u0004\u00a2\u0006\u0002\u0010\u0015J\u000f\u0010!\u001a\u0004\u0018\u00010\u0014H\u0004\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010\"\u001a\u00020\u0014J\u0018\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u001aH\u0004J\b\u0010)\u001a\u00020\rH\u0005J\b\u0010*\u001a\u00020+H\u0002J\u0018\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020+2\u0006\u0010(\u001a\u00020\u001aH\u0014J\u0010\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020+H\u0002J\u0010\u00108\u001a\u00020\u00142\u0006\u00109\u001a\u00020\rH\u0002J\u0010\u0010:\u001a\u00020\u00142\u0006\u0010;\u001a\u00020\rH\u0002J\u0012\u0010<\u001a\u0004\u0018\u00010=2\u0006\u00109\u001a\u00020\rH\u0002J\f\u0010>\u001a\u00020\r*\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0016\u00100\u001a\u0004\u0018\u0001018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0014\u00104\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0010R\u0014\u00106\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0010\u00a8\u0006B"}, d2={"Lcom/intellij/mcpserver/clients/McpClient;", "", "mcpClientInfo", "Lcom/intellij/mcpserver/clients/McpClientInfo;", "configPath", "Ljava/nio/file/Path;", "<init>", "(Lcom/intellij/mcpserver/clients/McpClientInfo;Ljava/nio/file/Path;)V", "getMcpClientInfo", "()Lcom/intellij/mcpserver/clients/McpClientInfo;", "getConfigPath", "()Ljava/nio/file/Path;", "toString", "", "sseUrl", "getSseUrl", "()Ljava/lang/String;", "streamableHttpUrl", "getStreamableHttpUrl", "isConfigured", "", "()Ljava/lang/Boolean;", "mcpServersKey", "configure", "", "getConfig", "Lcom/intellij/mcpserver/clients/configs/ServerConfig;", "getSSEConfig", "getStdioConfig", "readMcpServers", "", "Lcom/intellij/mcpserver/clients/configs/ExistingConfig;", "isStdIOConfigured", "isSSEConfigured", "isPortCorrect", "isPortMatching", "serverConfig", "targetPort", "", "updateServerConfig", "serverEntry", "jetBrainsServerKey", "readExistingConfig", "Lkotlinx/serialization/json/JsonObject;", "buildUpdatedConfig", "existingConfig", "writeConfigToFile", "config", "connectionAddressProvider", "Lcom/intellij/mcpserver/impl/util/network/McpServerConnectionAddressProvider;", "getConnectionAddressProvider", "()Lcom/intellij/mcpserver/impl/util/network/McpServerConnectionAddressProvider;", "defaultSseUrl", "getDefaultSseUrl", "defaultStreamUrl", "getDefaultStreamUrl", "matchesCurrentServerUrl", "url", "hostMatchesCurrent", "host", "parseServerUrl", "Lcom/intellij/mcpserver/clients/McpClient$ParsedServerUrl;", "normalizeHostForComparison", "ParsedServerUrl", "Companion", "McpServers", "intellij.mcpserver"})
@SourceDebugExtension(value={"SMAP\nMcpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpClient.kt\ncom/intellij/mcpserver/clients/McpClient\n+ 2 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 6 Json.kt\nkotlinx/serialization/json/JsonKt\n*L\n1#1,298:1\n80#2:299\n80#2:310\n42#2:332\n193#3,3:300\n193#3,2:303\n195#3:306\n193#3,3:307\n221#3,2:322\n221#3,2:329\n1#4:305\n29#5,3:311\n29#5,3:314\n29#5,3:317\n29#5,2:320\n31#5:326\n29#5,2:327\n31#5:331\n324#6:324\n324#6:325\n*S KotlinDebug\n*F\n+ 1 McpClient.kt\ncom/intellij/mcpserver/clients/McpClient\n*L\n74#1:299\n132#1:310\n165#1:332\n81#1:300,3\n91#1:303,2\n91#1:306\n100#1:307,3\n147#1:322,2\n157#1:329,2\n133#1:311,3\n135#1:314,3\n143#1:317,3\n146#1:320,2\n146#1:326\n156#1:327,2\n156#1:331\n150#1:324\n152#1:325\n*E\n"})
public abstract class McpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final McpClientInfo mcpClientInfo;
    @NotNull
    private final Path configPath;
    @NotNull
    private static final Set<String> STREAM_PATHS;
    @Nullable
    private static volatile Boolean writeLegacyOverride;
    @NotNull
    public static final String LEGACY_KEY = "jetbrains";
    @NotNull
    private static final Set<String> LEGACY_SERVER_KEYS;
    @NotNull
    private static final Lazy<String> PRODUCT_SPECIFIC_SERVER_KEY$delegate;
    @Nullable
    private static volatile String productSpecificServerKeyOverride;
    @NotNull
    private static final Lazy<Json> json$delegate;

    public McpClient(@NlsContexts.BorderTitle @NotNull McpClientInfo mcpClientInfo, @NotNull Path configPath) {
        Intrinsics.checkNotNullParameter((Object)mcpClientInfo, (String)"mcpClientInfo");
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        this.mcpClientInfo = mcpClientInfo;
        this.configPath = configPath;
    }

    @NotNull
    public final McpClientInfo getMcpClientInfo() {
        return this.mcpClientInfo;
    }

    @NotNull
    public final Path getConfigPath() {
        return this.configPath;
    }

    @NotNull
    public String toString() {
        return this.mcpClientInfo.getDisplayName();
    }

    @NotNull
    protected final String getSseUrl() {
        Object object = this.getConnectionAddressProvider();
        if (object == null || (object = ((McpServerConnectionAddressProvider)object).getServerSseUrl()) == null) {
            object = this.getDefaultSseUrl();
        }
        return object;
    }

    @NotNull
    protected String getStreamableHttpUrl() {
        Object object = this.getConnectionAddressProvider();
        if (object == null || (object = ((McpServerConnectionAddressProvider)object).getServerStreamUrl()) == null) {
            object = this.getDefaultStreamUrl();
        }
        return object;
    }

    @Nullable
    public Boolean isConfigured() {
        return true;
    }

    @NotNull
    public String mcpServersKey() {
        return "mcpServers";
    }

    public void configure() {
        this.updateServerConfig(this.getConfig());
    }

    @NotNull
    public final ServerConfig getConfig() {
        ServerConfig serverConfig = this.getSSEConfig();
        if (serverConfig == null) {
            serverConfig = this.getStdioConfig();
        }
        return serverConfig;
    }

    @Nullable
    protected ServerConfig getSSEConfig() {
        return null;
    }

    private final ServerConfig getStdioConfig() {
        GeneralCommandLine cmd = StdioRunnerUtilKt.createStdioMcpServerCommandLine$default(McpServerService.Companion.getInstance().getPort(), null, null, 4, null);
        return new STDIOServerConfig(cmd.getExePath(), cmd.getParametersList().getParameters(), cmd.getEnvironment());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected Map<String, ExistingConfig> readMcpServers() {
        Object object;
        Object object2 = this;
        try {
            void stream$iv;
            void $this$decodeFromStream$iv;
            McpClient $this$readMcpServers_u24lambda_u240 = object2;
            boolean bl = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists($this$readMcpServers_u24lambda_u240.configPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return null;
            }
            Json json = Companion.getJson();
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream($this$readMcpServers_u24lambda_u240.configPath, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            InputStream inputStream2 = inputStream;
            boolean $i$f$decodeFromStream = false;
            $this$decodeFromStream$iv.getSerializersModule();
            object = Result.constructor-impl(((McpServers)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)McpServers.Companion.serializer()), (InputStream)stream$iv)).getMcpServers());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (Map)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    protected final Boolean isStdIOConfigured() {
        boolean bl;
        boolean bl2;
        Map<String, ExistingConfig> mcpServers;
        Map<String, ExistingConfig> map = mcpServers = this.readMcpServers();
        if (map == null) return null;
        boolean bl3 = map.isEmpty();
        if (bl3) {
            return null;
        }
        Map<String, ExistingConfig> $this$any$iv = mcpServers;
        boolean $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            bl2 = false;
            return bl2;
        }
        Iterator<Map.Entry<String, ExistingConfig>> iterator = $this$any$iv.entrySet().iterator();
        do {
            Map.Entry<String, ExistingConfig> element$iv;
            if (!iterator.hasNext()) {
                bl2 = false;
                return bl2;
            }
            Map.Entry<String, ExistingConfig> entry = element$iv = iterator.next();
            boolean bl4 = false;
            ExistingConfig serverConfig = entry.getValue();
            String string = serverConfig.getCommand();
            boolean bl5 = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"java", (boolean)false, (int)2, null) : false;
            if (bl5) {
                Map<String, String> map2 = serverConfig.getEnv();
                boolean bl6 = map2 != null ? map2.containsKey("IJ_MCP_SERVER_PORT") : false;
                if (bl6) {
                    boolean bl7;
                    List<String> list = serverConfig.getArgs();
                    if (list != null) {
                        Method method = ReflectJvmMapping.getJavaMethod((KFunction)((KFunction)isStdIOConfigured.1.1.INSTANCE));
                        Intrinsics.checkNotNull((Object)method);
                        bl7 = list.contains(method.getDeclaringClass().getName());
                    } else {
                        bl7 = false;
                    }
                    if (bl7) {
                        bl = true;
                        continue;
                    }
                }
            }
            bl = false;
        } while (!bl);
        bl2 = true;
        return bl2;
    }

    @Nullable
    protected final Boolean isSSEConfigured() {
        boolean bl;
        block6: {
            Map<String, ExistingConfig> mcpServers;
            Map<String, ExistingConfig> map = mcpServers = this.readMcpServers();
            if (map != null ? map.isEmpty() : true) {
                return null;
            }
            Map<String, ExistingConfig> $this$any$iv = mcpServers;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<String, ExistingConfig>> iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    boolean bl2;
                    Map.Entry<String, ExistingConfig> element$iv;
                    Map.Entry<String, ExistingConfig> entry = element$iv = iterator.next();
                    boolean bl3 = false;
                    ExistingConfig serverConfig = entry.getValue();
                    if (serverConfig.getUrl() != null) {
                        String it;
                        boolean bl4 = false;
                        bl2 = this.matchesCurrentServerUrl(it);
                    } else {
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isPortCorrect() {
        boolean bl;
        block5: {
            Map<String, ExistingConfig> servers;
            if (!McpServerService.Companion.getInstance().isRunning()) {
                return true;
            }
            int currentPort = McpServerService.Companion.getInstance().getPort();
            Map<String, ExistingConfig> map = this.readMcpServers();
            if (map == null) {
                return true;
            }
            Map<String, ExistingConfig> $this$any$iv = servers = map;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<String, ExistingConfig>> iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, ExistingConfig> element$iv;
                    Map.Entry<String, ExistingConfig> entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    ExistingConfig serverConfig = entry.getValue();
                    if (!this.isPortMatching(serverConfig, currentPort)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isPortMatching(ExistingConfig serverConfig, int targetPort) {
        String string = serverConfig.getUrl();
        if (string != null) {
            String url = string;
            boolean bl = false;
            ParsedServerUrl parsedServerUrl = this.parseServerUrl(url);
            if (parsedServerUrl == null) {
                return false;
            }
            ParsedServerUrl parsed = parsedServerUrl;
            if (STREAM_PATHS.contains(parsed.getPath()) && this.hostMatchesCurrent(parsed.getHost())) {
                return parsed.getPort() == targetPort;
            }
            return false;
        }
        String string2 = serverConfig.getCommand();
        boolean bl = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"java", (boolean)false, (int)2, null) : false;
        if (bl) {
            Map<String, String> map = serverConfig.getEnv();
            boolean bl2 = map != null ? map.containsKey("IJ_MCP_SERVER_PORT") : false;
            if (bl2) {
                boolean bl3;
                List<String> list = serverConfig.getArgs();
                if (list != null) {
                    Method method = ReflectJvmMapping.getJavaMethod((KFunction)((KFunction)isPortMatching.2.INSTANCE));
                    Intrinsics.checkNotNull((Object)method);
                    bl3 = list.contains(method.getDeclaringClass().getName());
                } else {
                    bl3 = false;
                }
                if (bl3) {
                    Integer configuredPort;
                    String string3 = serverConfig.getEnv().get("IJ_MCP_SERVER_PORT");
                    Integer n = configuredPort = string3 != null ? StringsKt.toIntOrNull((String)string3) : null;
                    int n2 = targetPort;
                    return n != null && n == n2;
                }
            }
        }
        return true;
    }

    protected final void updateServerConfig(@NotNull ServerConfig serverEntry) {
        Intrinsics.checkNotNullParameter((Object)serverEntry, (String)"serverEntry");
        JsonObject existingConfig = this.readExistingConfig();
        JsonObject updatedConfig = this.buildUpdatedConfig(existingConfig, serverEntry);
        this.writeConfigToFile(updatedConfig);
    }

    @Deprecated(message="Use product-specific terminology")
    @NotNull
    protected final String jetBrainsServerKey() {
        return Companion.productSpecificServerKey();
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject readExistingConfig() {
        JsonObject jsonObject;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(this.configPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Object object;
            Object $this$readExistingConfig_u24lambda_u240;
            Object object2 = this;
            try {
                void stream$iv;
                void $this$decodeFromStream$iv;
                $this$readExistingConfig_u24lambda_u240 = object2;
                boolean bl = false;
                Json json = Companion.getJson();
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream(((McpClient)$this$readExistingConfig_u24lambda_u240).configPath, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                InputStream inputStream2 = inputStream;
                boolean $i$f$decodeFromStream = false;
                $this$decodeFromStream$iv.getSerializersModule();
                $this$readExistingConfig_u24lambda_u240 = Result.constructor-impl((Object)((JsonObject)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)JsonObject.Companion.serializer()), (InputStream)stream$iv)));
            }
            catch (Throwable bl) {
                $this$readExistingConfig_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = $this$readExistingConfig_u24lambda_u240;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) {
                object = object2;
            } else {
                JsonObjectBuilder builder$iv;
                Throwable it = throwable;
                boolean bl = false;
                boolean $i$f$buildJsonObject = false;
                JsonObjectBuilder $this$readExistingConfig_u24lambda_u241_u240 = builder$iv = new JsonObjectBuilder();
                boolean bl2 = false;
                object = builder$iv.build();
            }
            jsonObject = (JsonObject)object;
        } else {
            JsonObjectBuilder builder$iv;
            boolean $i$f$buildJsonObject = false;
            JsonObjectBuilder $this$readExistingConfig_u24lambda_u242 = builder$iv = new JsonObjectBuilder();
            boolean bl = false;
            jsonObject = builder$iv.build();
        }
        return jsonObject;
    }

    @NotNull
    protected JsonObject buildUpdatedConfig(@NotNull JsonObject existingConfig, @NotNull ServerConfig serverEntry) {
        Json $this$encodeToJsonElement$iv;
        JsonElement value;
        String key;
        Map.Entry entry;
        Map.Entry element$iv;
        JsonObjectBuilder builder$iv;
        boolean $i$f$buildJsonObject;
        Intrinsics.checkNotNullParameter((Object)existingConfig, (String)"existingConfig");
        Intrinsics.checkNotNullParameter((Object)serverEntry, (String)"serverEntry");
        JsonElement jsonElement = (JsonElement)existingConfig.get((Object)this.mcpServersKey());
        if (jsonElement == null || (jsonElement = JsonElementKt.getJsonObject((JsonElement)jsonElement)) == null) {
            $i$f$buildJsonObject = false;
            JsonObjectBuilder $this$buildUpdatedConfig_u24lambda_u240 = builder$iv = new JsonObjectBuilder();
            boolean bl = false;
            jsonElement = builder$iv.build();
        }
        JsonElement existingServers = jsonElement;
        String targetKey = this.jetBrainsServerKey();
        $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$buildUpdatedConfig_u24lambda_u241 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        Map $this$forEach$iv = (Map)existingServers;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl2 = false;
            key = (String)entry.getKey();
            value = (JsonElement)entry.getValue();
            if (Intrinsics.areEqual((Object)key, (Object)targetKey) || LEGACY_SERVER_KEYS.contains(key)) continue;
            $this$buildUpdatedConfig_u24lambda_u241.put(key, value);
        }
        $this$forEach$iv = Companion.getJson();
        ServerConfig value$iv = serverEntry;
        boolean $i$f$encodeToJsonElement = false;
        $this$encodeToJsonElement$iv.getSerializersModule();
        $this$buildUpdatedConfig_u24lambda_u241.put(targetKey, $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)ServerConfig.Companion.serializer(), (Object)value$iv));
        if (Companion.writeLegacy() && !Intrinsics.areEqual((Object)LEGACY_KEY, (Object)targetKey)) {
            $this$encodeToJsonElement$iv = Companion.getJson();
            value$iv = serverEntry;
            $i$f$encodeToJsonElement = false;
            $this$encodeToJsonElement$iv.getSerializersModule();
            $this$buildUpdatedConfig_u24lambda_u241.put(LEGACY_KEY, $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)ServerConfig.Companion.serializer(), (Object)value$iv));
        }
        JsonObject updatedServers = builder$iv.build();
        $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$buildUpdatedConfig_u24lambda_u242 = builder$iv = new JsonObjectBuilder();
        boolean bl3 = false;
        $this$forEach$iv = (Map)existingConfig;
        $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl4 = false;
            key = (String)entry.getKey();
            value = (JsonElement)entry.getValue();
            if (Intrinsics.areEqual((Object)key, (Object)this.mcpServersKey())) continue;
            $this$buildUpdatedConfig_u24lambda_u242.put(key, value);
        }
        $this$buildUpdatedConfig_u24lambda_u242.put(this.mcpServersKey(), (JsonElement)updatedServers);
        return builder$iv.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void writeConfigToFile(JsonObject config) {
        CopyOption[] copyOptionArray;
        Path path = this.configPath.getParent();
        if (path != null) {
            PathsKt.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
        }
        Path tmp = this.configPath.resolveSibling(this.configPath.getFileName() + ".tmp");
        Intrinsics.checkNotNull((Object)tmp);
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(tmp, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        CopyOption[] copyOptionArray2 = (CopyOption[])outputStream;
        Throwable throwable = null;
        try {
            void value$iv;
            void $this$encodeToStream$iv;
            OutputStream output = (OutputStream)copyOptionArray2;
            boolean bl = false;
            Json json = Companion.getJson();
            JsonObject jsonObject = config;
            OutputStream stream$iv = output;
            boolean $i$f$encodeToStream = false;
            $this$encodeToStream$iv.getSerializersModule();
            JvmStreamsKt.encodeToStream((Json)$this$encodeToStream$iv, (SerializationStrategy)((SerializationStrategy)JsonObject.Companion.serializer()), (Object)value$iv, (OutputStream)stream$iv);
            copyOptionArray = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)copyOptionArray2, (Throwable)throwable);
        }
        try {
            copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE};
            Files.move(tmp, this.configPath, copyOptionArray2);
        }
        catch (AtomicMoveNotSupportedException atomicMoveNotSupportedException) {
            copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.move(tmp, this.configPath, copyOptionArray);
        }
    }

    private final McpServerConnectionAddressProvider getConnectionAddressProvider() {
        return McpServerConnectionAddressProvider.Companion.getInstanceOrNull();
    }

    private final String getDefaultSseUrl() {
        return "http://localhost:" + McpServerService.Companion.getInstance().getPort() + "/sse";
    }

    private final String getDefaultStreamUrl() {
        return "http://localhost:" + McpServerService.Companion.getInstance().getPort() + "/stream";
    }

    private final boolean matchesCurrentServerUrl(String url) {
        ParsedServerUrl parsedServerUrl = this.parseServerUrl(url);
        if (parsedServerUrl == null) {
            return false;
        }
        ParsedServerUrl parsed = parsedServerUrl;
        return STREAM_PATHS.contains(parsed.getPath()) && this.hostMatchesCurrent(parsed.getHost());
    }

    private final boolean hostMatchesCurrent(String host) {
        Object currentHost;
        String normalized = this.normalizeHostForComparison(host);
        Object object = this.getConnectionAddressProvider();
        if (object == null || (object = ((McpServerConnectionAddressProvider)object).getCurrentHost()) == null || (object = this.normalizeHostForComparison((String)object)) == null) {
            object = "localhost";
        }
        return Intrinsics.areEqual((Object)normalized, (Object)(currentHost = object)) || Intrinsics.areEqual((Object)normalized, (Object)"localhost") || Intrinsics.areEqual((Object)normalized, (Object)"127.0.0.1");
    }

    private final ParsedServerUrl parseServerUrl(String url) {
        Object $this$parseServerUrl_u24lambda_u240;
        Object object = this;
        try {
            $this$parseServerUrl_u24lambda_u240 = object;
            boolean bl = false;
            $this$parseServerUrl_u24lambda_u240 = Result.constructor-impl((Object)new URI(url));
        }
        catch (Throwable throwable) {
            $this$parseServerUrl_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object = $this$parseServerUrl_u24lambda_u240;
        URI uRI = (URI)(Result.isFailure-impl((Object)object) ? null : object);
        if (uRI == null) {
            return null;
        }
        URI uri = uRI;
        String string = uri.getHost();
        if (string == null) {
            return null;
        }
        String host = string;
        String string2 = uri.getPath();
        if (string2 == null) {
            return null;
        }
        String path = string2;
        int port = uri.getPort() == -1 ? 80 : uri.getPort();
        return new ParsedServerUrl(host, port, path);
    }

    private final String normalizeHostForComparison(String $this$normalizeHostForComparison) {
        String string = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)((Object)StringsKt.trim((CharSequence)$this$normalizeHostForComparison)).toString(), (CharSequence)"["), (CharSequence)"]").toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    private static final String PRODUCT_SPECIFIC_SERVER_KEY_delegate$lambda$0() {
        return McpClient.Companion.computeProductSpecificServerKey();
    }

    private static final Unit json_delegate$lambda$0$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setAllowComments(true);
        $this$Json.setAllowTrailingComma(true);
        $this$Json.setPrettyPrint(true);
        $this$Json.setPrettyPrintIndent("  ");
        $this$Json.setClassDiscriminatorMode(ClassDiscriminatorMode.NONE);
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    private static final Json json_delegate$lambda$0() {
        return JsonKt.Json$default(null, McpClient::json_delegate$lambda$0$0, (int)1, null);
    }

    static {
        Object[] objectArray = new String[]{"/sse", "/stream"};
        STREAM_PATHS = SetsKt.setOf((Object[])objectArray);
        LEGACY_SERVER_KEYS = SetsKt.setOf((Object)LEGACY_KEY);
        PRODUCT_SPECIFIC_SERVER_KEY$delegate = LazyKt.lazy(McpClient::PRODUCT_SPECIFIC_SERVER_KEY_delegate$lambda$0);
        json$delegate = LazyKt.lazy(McpClient::json_delegate$lambda$0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0007\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u000e\u001a\u00020\bJ\u0006\u0010\u001e\u001a\u00020\u0006J\u0012\u0010\u001f\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0007J\b\u0010 \u001a\u00020\u0006H\u0002J)\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\b\u0010\"\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010#\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b$J\u0010\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u000f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0013\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0019\u001a\u00020\u001a8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0017\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006'"}, d2={"Lcom/intellij/mcpserver/clients/McpClient$Companion;", "", "<init>", "()V", "STREAM_PATHS", "", "", "writeLegacyOverride", "", "Ljava/lang/Boolean;", "overrideWriteLegacyForTests", "", "value", "(Ljava/lang/Boolean;)V", "writeLegacy", "LEGACY_KEY", "LEGACY_SERVER_KEYS", "getLEGACY_SERVER_KEYS", "()Ljava/util/Set;", "PRODUCT_SPECIFIC_SERVER_KEY", "getPRODUCT_SPECIFIC_SERVER_KEY", "()Ljava/lang/String;", "PRODUCT_SPECIFIC_SERVER_KEY$delegate", "Lkotlin/Lazy;", "productSpecificServerKeyOverride", "json", "Lkotlinx/serialization/json/Json;", "getJson", "()Lkotlinx/serialization/json/Json;", "json$delegate", "productSpecificServerKey", "overrideProductSpecificServerKeyForTests", "computeProductSpecificServerKey", "productName", "editionName", "runningFromSources", "computeProductSpecificServerKey$intellij_mcpserver", "sanitizeSegment", "segment", "intellij.mcpserver"})
    @SourceDebugExtension(value={"SMAP\nMcpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpClient.kt\ncom/intellij/mcpserver/clients/McpClient$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,298:1\n1#2:299\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        public final void overrideWriteLegacyForTests(@Nullable Boolean value) {
            writeLegacyOverride = value;
        }

        public final boolean writeLegacy() {
            Boolean bl = writeLegacyOverride;
            return bl != null ? bl.booleanValue() : Registry.Companion.is("mcp.server.write.legacy.key", false);
        }

        @NotNull
        public final Set<String> getLEGACY_SERVER_KEYS() {
            return LEGACY_SERVER_KEYS;
        }

        private final String getPRODUCT_SPECIFIC_SERVER_KEY() {
            Lazy lazy = PRODUCT_SPECIFIC_SERVER_KEY$delegate;
            return (String)lazy.getValue();
        }

        @NotNull
        public final Json getJson() {
            Lazy lazy = json$delegate;
            return (Json)lazy.getValue();
        }

        @NotNull
        public final String productSpecificServerKey() {
            String string = productSpecificServerKeyOverride;
            if (string == null) {
                string = this.getPRODUCT_SPECIFIC_SERVER_KEY();
            }
            return string;
        }

        @TestOnly
        public final void overrideProductSpecificServerKeyForTests(@Nullable String value) {
            productSpecificServerKeyOverride = value;
        }

        private final String computeProductSpecificServerKey() {
            ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"getInstance(...)");
            ApplicationNamesInfo namesInfo = applicationNamesInfo;
            String string = namesInfo.getProductName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductName(...)");
            return this.computeProductSpecificServerKey$intellij_mcpserver(string, namesInfo.getEditionName(), PluginManagerCore.isRunningFromSources());
        }

        /*
         * Unable to fully structure code
         */
        @VisibleForTesting
        @NotNull
        public final String computeProductSpecificServerKey$intellij_mcpserver(@NotNull String productName, @Nullable String editionName, boolean runningFromSources) {
            Intrinsics.checkNotNullParameter((Object)productName, (String)"productName");
            var5_4 = this.sanitizeSegment(productName);
            if (StringsKt.isBlank((CharSequence)var5_4)) {
                $i$a$-ifBlank-McpClient$Companion$computeProductSpecificServerKey$sanitizedProductName$1 = false;
                v0 = "jetbrains";
            } else {
                v0 = var5_4;
            }
            sanitizedProductName = (String)v0;
            if (editionName == null) ** GOTO lbl-1000
            p0 = editionName;
            $i$a$-let-McpClient$Companion$computeProductSpecificServerKey$sanitizedEdition$1 = false;
            var6_6 = this.sanitizeSegment(p0);
            if (var6_6 == null || (var7_13 = StringsKt.removeSuffix((String)var6_6, (CharSequence)"edition")) == null) ** GOTO lbl-1000
            it = var9_12 = var7_13;
            $i$a$-takeUnless-McpClient$Companion$computeProductSpecificServerKey$sanitizedEdition$2 = false;
            v1 = p0 = StringsKt.isBlank((CharSequence)it) == false ? var9_12 : null;
            if (p0 != null) {
                it = var9_12 = p0;
                $i$a$-takeUnless-McpClient$Companion$computeProductSpecificServerKey$sanitizedEdition$3 = false;
                v2 = !StringsKt.endsWith$default((String)sanitizedProductName, (String)it, (boolean)false, (int)2, null) ? var9_12 : null;
            } else lbl-1000:
            // 3 sources

            {
                v2 = v3 = null;
            }
            if (v2 == null) {
                v3 = "";
            }
            sanitizedEdition = v3;
            $this$computeProductSpecificServerKey_u24lambda_u243 = var6_7 = new StringBuilder();
            $i$a$-buildString-McpClient$Companion$computeProductSpecificServerKey$1 = false;
            $this$computeProductSpecificServerKey_u24lambda_u243.append(sanitizedProductName);
            if (((CharSequence)sanitizedEdition).length() > 0) {
                $this$computeProductSpecificServerKey_u24lambda_u243.append(sanitizedEdition);
            }
            if (runningFromSources) {
                $this$computeProductSpecificServerKey_u24lambda_u243.append("dev");
            }
            return var6_7.toString();
        }

        public static /* synthetic */ String computeProductSpecificServerKey$intellij_mcpserver$default(Companion companion, String string, String string2, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.computeProductSpecificServerKey$intellij_mcpserver(string, string2, bl);
        }

        private final String sanitizeSegment(String segment) {
            CharSequence charSequence = segment;
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            String string = charSequence.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            charSequence = string;
            Regex regex = new Regex("[^a-z0-9]+");
            String string2 = "";
            return regex.replace(charSequence, string2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @JsonIgnoreUnknownKeys
    @Serializable
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0083\b\u0018\u0000 !2\u00020\u0001:\u0002 !B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B1\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\u0015\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\u0012\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0014\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0016\u001a\u00020\tH\u00d6\u0081\u0004J\n\u0010\u0017\u001a\u00020\u0004H\u00d6\u0081\u0004J%\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0001\u00a2\u0006\u0002\b\u001fR(\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lcom/intellij/mcpserver/clients/McpClient$McpServers;", "", "mcpServers", "", "", "Lcom/intellij/mcpserver/clients/configs/ExistingConfig;", "<init>", "(Ljava/util/Map;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/Map;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getMcpServers$annotations", "()V", "getMcpServers", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_mcpserver", "$serializer", "Companion", "intellij.mcpserver"})
    private static final class McpServers {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<String, ExistingConfig> mcpServers;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public McpServers(@NotNull Map<String, ExistingConfig> mcpServers) {
            Intrinsics.checkNotNullParameter(mcpServers, (String)"mcpServers");
            this.mcpServers = mcpServers;
        }

        @NotNull
        public final Map<String, ExistingConfig> getMcpServers() {
            return this.mcpServers;
        }

        @JsonNames(names={"servers", "mcpServers"})
        public static /* synthetic */ void getMcpServers$annotations() {
        }

        @NotNull
        public final Map<String, ExistingConfig> component1() {
            return this.mcpServers;
        }

        @NotNull
        public final McpServers copy(@NotNull Map<String, ExistingConfig> mcpServers) {
            Intrinsics.checkNotNullParameter(mcpServers, (String)"mcpServers");
            return new McpServers(mcpServers);
        }

        public static /* synthetic */ McpServers copy$default(McpServers mcpServers, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = mcpServers.mcpServers;
            }
            return mcpServers.copy(map);
        }

        @NotNull
        public String toString() {
            return "McpServers(mcpServers=" + this.mcpServers + ")";
        }

        public int hashCode() {
            return ((Object)this.mcpServers).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof McpServers)) {
                return false;
            }
            McpServers mcpServers = (McpServers)other;
            return Intrinsics.areEqual(this.mcpServers, mcpServers.mcpServers);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_mcpserver(McpServers self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)lazyArray[0].getValue(), self.mcpServers);
        }

        public /* synthetic */ McpServers(int seen0, Map mcpServers, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)McpServers$$serializer.INSTANCE.getDescriptor());
            }
            this.mcpServers = mcpServers;
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)ExistingConfig$.serializer.INSTANCE))};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/mcpserver/clients/McpClient$McpServers$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/mcpserver/clients/McpClient$McpServers;", "intellij.mcpserver"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<McpServers> serializer() {
                return (KSerializer)McpServers$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0015\u001a\u00020\u0005H\u00d6\u0081\u0004J\n\u0010\u0016\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/intellij/mcpserver/clients/McpClient$ParsedServerUrl;", "", "host", "", "port", "", "path", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getHost", "()Ljava/lang/String;", "getPort", "()I", "getPath", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "intellij.mcpserver"})
    private static final class ParsedServerUrl {
        @NotNull
        private final String host;
        private final int port;
        @NotNull
        private final String path;

        public ParsedServerUrl(@NotNull String host, int port, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.host = host;
            this.port = port;
            this.path = path;
        }

        @NotNull
        public final String getHost() {
            return this.host;
        }

        public final int getPort() {
            return this.port;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final String component1() {
            return this.host;
        }

        public final int component2() {
            return this.port;
        }

        @NotNull
        public final String component3() {
            return this.path;
        }

        @NotNull
        public final ParsedServerUrl copy(@NotNull String host, int port, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new ParsedServerUrl(host, port, path);
        }

        public static /* synthetic */ ParsedServerUrl copy$default(ParsedServerUrl parsedServerUrl, String string, int n, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = parsedServerUrl.host;
            }
            if ((n2 & 2) != 0) {
                n = parsedServerUrl.port;
            }
            if ((n2 & 4) != 0) {
                string2 = parsedServerUrl.path;
            }
            return parsedServerUrl.copy(string, n, string2);
        }

        @NotNull
        public String toString() {
            return "ParsedServerUrl(host=" + this.host + ", port=" + this.port + ", path=" + this.path + ")";
        }

        public int hashCode() {
            int result = this.host.hashCode();
            result = result * 31 + Integer.hashCode(this.port);
            result = result * 31 + this.path.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParsedServerUrl)) {
                return false;
            }
            ParsedServerUrl parsedServerUrl = (ParsedServerUrl)other;
            if (!Intrinsics.areEqual((Object)this.host, (Object)parsedServerUrl.host)) {
                return false;
            }
            if (this.port != parsedServerUrl.port) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.path, (Object)parsedServerUrl.path);
        }
    }
}

