/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.DocumentUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XSourcePositionImpl
implements XSourcePosition {
    private final VirtualFile myFile;

    private XSourcePositionImpl(@NotNull VirtualFile file2) {
        if (file2 == null) {
            XSourcePositionImpl.$$$reportNull$$$0(0);
        }
        this.myFile = file2;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            XSourcePositionImpl.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    @Nullable
    public static XSourcePositionImpl createByOffset(final @Nullable VirtualFile file2, final int offset) {
        if (file2 == null) {
            return null;
        }
        return new XSourcePositionImpl(file2){
            private final NotNullLazyValue<Integer> myLine;
            {
                super(file22);
                this.myLine = NotNullLazyValue.atomicLazy(() -> {
                    Document document = FileDocumentManager.getInstance().getDocument(file2);
                    if (document == null) {
                        return -1;
                    }
                    return DocumentUtil.isValidOffset((int)offset, (Document)document) ? document.getLineNumber(offset) : -1;
                });
            }

            public int getLine() {
                return XSourcePositionImpl.getOrComputeLazyValue(this.myLine);
            }

            public int getOffset() {
                return offset;
            }
        };
    }

    @Nullable
    public static XSourcePositionImpl createByElement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile file2 = psiFile.getVirtualFile();
        if (file2 == null) {
            return null;
        }
        final SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
        return new XSourcePositionImpl(file2){
            private final NotNullLazyValue<XSourcePosition> myDelegate;
            {
                super(file2);
                this.myDelegate = NotNullLazyValue.atomicLazy(() -> {
                    PsiElement elem = pointer.getElement();
                    return 2.createByOffset(pointer.getVirtualFile(), elem != null ? elem.getTextOffset() : -1);
                });
            }

            public int getLine() {
                return XSourcePositionImpl.getOrComputeLazyValue(this.myDelegate).getLine();
            }

            public int getOffset() {
                return XSourcePositionImpl.getOrComputeLazyValue(this.myDelegate).getOffset();
            }

            @Override
            @NotNull
            public Navigatable createNavigatable(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (this.myDelegate.isComputed()) {
                    Navigatable navigatable = ((XSourcePosition)this.myDelegate.getValue()).createNavigatable(project);
                    if (navigatable == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return navigatable;
                }
                PsiElement elem = pointer.getElement();
                if (elem instanceof Navigatable) {
                    Navigatable navigatable = (Navigatable)elem;
                    if (navigatable == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return navigatable;
                }
                Navigatable navigatable = NonNavigatable.INSTANCE;
                if (navigatable == null) {
                    2.$$$reportNull$$$0(3);
                }
                return navigatable;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/xdebugger/impl/XSourcePositionImpl$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/xdebugger/impl/XSourcePositionImpl$2";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createNavigatable";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createNavigatable";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 3 -> new IllegalStateException(string);
                };
            }
        };
    }

    @Contract(value="null , _ -> null; !null, _ -> !null")
    public static XSourcePositionImpl create(@Nullable VirtualFile file2, int line) {
        return file2 == null ? null : XSourcePositionImpl.create(file2, line, 0);
    }

    @Contract(value="null , _, _ -> null; !null, _, _ -> !null")
    public static XSourcePositionImpl create(final @Nullable VirtualFile file2, final int line, final int column) {
        if (file2 == null) {
            return null;
        }
        return new XSourcePositionImpl(file2){
            private final NotNullLazyValue<Integer> myOffset;
            {
                super(file22);
                this.myOffset = NotNullLazyValue.atomicLazy(() -> {
                    int offset;
                    if (file2 instanceof LightVirtualFile || file2 instanceof HttpVirtualFile) {
                        return -1;
                    }
                    Document document = FileDocumentManager.getInstance().getDocument(file2);
                    if (document == null) {
                        return -1;
                    }
                    int l = Math.max(0, line);
                    int c = Math.max(0, column);
                    int n = offset = l < document.getLineCount() ? document.getLineStartOffset(l) + c : -1;
                    if (offset >= document.getTextLength()) {
                        offset = document.getTextLength() - 1;
                    }
                    return offset;
                });
            }

            public int getLine() {
                return line;
            }

            public int getOffset() {
                return XSourcePositionImpl.getOrComputeLazyValue(this.myOffset);
            }
        };
    }

    @NotNull
    public Navigatable createNavigatable(@NotNull Project project) {
        if (project == null) {
            XSourcePositionImpl.$$$reportNull$$$0(2);
        }
        Navigatable navigatable = XDebuggerUtilImpl.createNavigatable(project, this);
        if (navigatable == null) {
            XSourcePositionImpl.$$$reportNull$$$0(3);
        }
        return navigatable;
    }

    public String toString() {
        return "XSourcePositionImpl[" + String.valueOf(this.myFile) + ":" + this.getLine() + "(" + this.getOffset() + ")]";
    }

    @NotNull
    private static <T> T getOrComputeLazyValue(@NotNull NotNullLazyValue<T> lazyValue) {
        if (lazyValue == null) {
            XSourcePositionImpl.$$$reportNull$$$0(4);
        }
        if (lazyValue.isComputed()) {
            Object object = lazyValue.getValue();
            if (object == null) {
                XSourcePositionImpl.$$$reportNull$$$0(5);
            }
            return (T)object;
        }
        Object object = ReadAction.compute(() -> lazyValue.getValue());
        if (object == null) {
            XSourcePositionImpl.$$$reportNull$$$0(6);
        }
        return (T)object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/XSourcePositionImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lazyValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/XSourcePositionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNavigatable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrComputeLazyValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createNavigatable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrComputeLazyValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

