/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.lang.Language;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XExpressionImpl
implements XExpression {
    public static final XExpression EMPTY_EXPRESSION = XExpressionImpl.fromText("", EvaluationMode.EXPRESSION);
    public static final XExpression EMPTY_CODE_FRAGMENT = XExpressionImpl.fromText("", EvaluationMode.CODE_FRAGMENT);
    @NotNull
    private final String myExpression;
    private final Language myLanguage;
    private final String myCustomInfo;
    private final EvaluationMode myMode;

    public XExpressionImpl(@NotNull String expression, Language language, String customInfo) {
        if (expression == null) {
            XExpressionImpl.$$$reportNull$$$0(0);
        }
        this(expression, language, customInfo, EvaluationMode.EXPRESSION);
    }

    public XExpressionImpl(@NotNull String expression, Language language, String customInfo, @NotNull EvaluationMode mode) {
        if (expression == null) {
            XExpressionImpl.$$$reportNull$$$0(1);
        }
        if (mode == null) {
            XExpressionImpl.$$$reportNull$$$0(2);
        }
        this.myExpression = expression;
        this.myLanguage = language;
        this.myCustomInfo = customInfo;
        this.myMode = mode;
    }

    @NotNull
    public String getExpression() {
        String string = this.myExpression;
        if (string == null) {
            XExpressionImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    public Language getLanguage() {
        return this.myLanguage;
    }

    public String getCustomInfo() {
        return this.myCustomInfo;
    }

    @NotNull
    public EvaluationMode getMode() {
        EvaluationMode evaluationMode = this.myMode;
        if (evaluationMode == null) {
            XExpressionImpl.$$$reportNull$$$0(4);
        }
        return evaluationMode;
    }

    @Contract(value="null -> null; !null -> !null")
    public static XExpressionImpl fromText(@Nullable String text) {
        return text != null ? new XExpressionImpl(text, null, null, EvaluationMode.EXPRESSION) : null;
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static XExpressionImpl fromText(@Nullable String text, @NotNull EvaluationMode mode) {
        if (mode == null) {
            XExpressionImpl.$$$reportNull$$$0(5);
        }
        return text != null ? new XExpressionImpl(text, null, null, mode) : null;
    }

    public static XExpressionImpl changeMode(@NotNull XExpression expression, @NotNull EvaluationMode mode) {
        if (expression == null) {
            XExpressionImpl.$$$reportNull$$$0(6);
        }
        if (mode == null) {
            XExpressionImpl.$$$reportNull$$$0(7);
        }
        return new XExpressionImpl(expression.getExpression(), expression.getLanguage(), expression.getCustomInfo(), mode);
    }

    public static XExpressionImpl changeLanguage(@NotNull XExpression expression, @Nullable Language language) {
        if (expression == null) {
            XExpressionImpl.$$$reportNull$$$0(8);
        }
        return new XExpressionImpl(expression.getExpression(), language, expression.getCustomInfo(), expression.getMode());
    }

    public String toString() {
        return this.myExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XExpressionImpl that = (XExpressionImpl)o;
        if (!Objects.equals(this.myCustomInfo, that.myCustomInfo)) {
            return false;
        }
        if (!this.myExpression.equals(that.myExpression)) {
            return false;
        }
        if (!Objects.equals(this.myLanguage, that.myLanguage)) {
            return false;
        }
        return this.myMode == that.myMode;
    }

    public int hashCode() {
        return Objects.hash(this.myExpression, this.myLanguage, this.myCustomInfo, this.myMode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/breakpoints/XExpressionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/breakpoints/XExpressionImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "changeMode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "changeLanguage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

