/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.pinned.items.actions;

import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsCollectorImpl;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.pinned.items.PinToTopMemberValue;
import com.intellij.xdebugger.impl.pinned.items.PinToTopUtilKt;
import com.intellij.xdebugger.impl.pinned.items.XDebuggerPinToTopManager;
import com.intellij.xdebugger.impl.pinned.items.actions.XDebuggerPinToTopActionKt;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeSplitActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import icons.PlatformDebuggerImplIcons;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/xdebugger/impl/pinned/items/actions/XDebuggerPinToTopAction;", "Lcom/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeSplitActionBase;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "perform", "node", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "nodeName", "", "Companion", "intellij.platform.debugger.impl"})
public final class XDebuggerPinToTopAction
extends XDebuggerTreeSplitActionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void update(@NotNull AnActionEvent e) {
        XValueNodeImpl node;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        XValueNodeImpl xValueNodeImpl = node = XDebuggerTreeSplitActionBase.Companion.getSelectedNode(dataContext);
        XValue xValue = xValueNodeImpl != null ? (XValue)xValueNodeImpl.getValueContainer() : null;
        PinToTopMemberValue valueContainer = xValue instanceof PinToTopMemberValue ? (PinToTopMemberValue)xValue : null;
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        Project project = e.getProject();
        if (valueContainer == null || project == null) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        XDebuggerPinToTopManager pinToTopManager = XDebuggerPinToTopManager.Companion.getInstance(project);
        if (!pinToTopManager.isPinToTopSupported(node)) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        presentation2.setVisible(true);
        presentation2.setEnabled(PinToTopUtilKt.canBePinned(node));
        presentation2.setIcon(pinToTopManager.isItemPinned(node) ? PlatformDebuggerImplIcons.PinToTop.UnpinnedItem : PlatformDebuggerImplIcons.PinToTop.PinnedItem);
        presentation2.setText(pinToTopManager.isItemPinned(node) ? XDebuggerBundle.message((String)"xdebugger.unpin.action", (Object[])new Object[0]) : XDebuggerBundle.message((String)"xdebugger.pin.to.top.action", (Object[])new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    @Override
    protected void perform(@NotNull XValueNodeImpl node, @NotNull String nodeName, @NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        XDebuggerPinToTopActionKt.access$performImpl(project2, node);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/xdebugger/impl/pinned/items/actions/XDebuggerPinToTopAction$Companion;", "", "<init>", "()V", "pinToTopField", "", "mouseEvent", "Ljava/awt/event/MouseEvent;", "node", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "intellij.platform.debugger.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void pinToTopField(@Nullable MouseEvent mouseEvent, @NotNull XValueNodeImpl node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            AnActionEvent anActionEvent = AnActionEvent.createFromInputEvent((InputEvent)mouseEvent, (String)XDebuggerPinToTopAction.class.getName(), (Presentation)new Presentation(), (DataContext)SimpleDataContext.builder().add(XDebuggerTree.XDEBUGGER_TREE_KEY, (Object)node.getTree()).add(CommonDataKeys.PROJECT, (Object)node.getTree().getProject()).add(XDebuggerTree.SELECTED_NODES, Collections.singletonList(node)).build());
            Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromInputEvent(...)");
            AnActionEvent event = anActionEvent;
            if (node.getName() != null) {
                Project project = node.getTree().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                XDebuggerPinToTopActionKt.access$performImpl(project, node);
                AnAction action = ActionManager.getInstance().getAction("XDebugger.PinToTop");
                Intrinsics.checkNotNull((Object)action);
                ActionsCollectorImpl.Companion.onAfterActionInvoked(action, event, AnActionResult.PERFORMED);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

