/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.memory.component;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.EventDispatcher;
import com.intellij.xdebugger.memory.component.MemoryViewManagerState;
import com.intellij.xdebugger.memory.event.MemoryViewManagerListener;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;

@State(name="MemoryViewSettings", storages={@Storage(value="memory.view.xml")}, category=SettingsCategory.TOOLS)
public class MemoryViewManager
implements PersistentStateComponent<MemoryViewManagerState> {
    public static final String MEMORY_VIEW_CONTENT = "MemoryView";
    private final EventDispatcher<MemoryViewManagerListener> myDispatcher = EventDispatcher.create(MemoryViewManagerListener.class);
    private MemoryViewManagerState myState = new MemoryViewManagerState();

    public static MemoryViewManager getInstance() {
        return (MemoryViewManager)ApplicationManager.getApplication().getService(MemoryViewManager.class);
    }

    @NotNull
    public MemoryViewManagerState getState() {
        return new MemoryViewManagerState(this.myState);
    }

    public void loadState(@NotNull MemoryViewManagerState state) {
        if (state == null) {
            MemoryViewManager.$$$reportNull$$$0(0);
        }
        this.myState = state;
        this.fireStateChanged();
    }

    public void setShowDiffOnly(boolean value) {
        if (this.myState.isShowWithDiffOnly != value) {
            this.myState.isShowWithDiffOnly = value;
            this.fireStateChanged();
        }
    }

    public void setShowWithInstancesOnly(boolean value) {
        if (this.myState.isShowWithInstancesOnly != value) {
            this.myState.isShowWithInstancesOnly = value;
            this.fireStateChanged();
        }
    }

    public void setShowTrackedOnly(boolean value) {
        if (this.myState.isShowTrackedOnly != value) {
            this.myState.isShowTrackedOnly = value;
            this.fireStateChanged();
        }
    }

    public void setAutoUpdate(boolean value) {
        if (this.myState.isAutoUpdateModeOn != value) {
            this.myState.isAutoUpdateModeOn = value;
            this.fireStateChanged();
        }
    }

    public boolean isNeedShowDiffOnly() {
        return this.myState.isShowWithDiffOnly;
    }

    public boolean isNeedShowInstancesOnly() {
        return this.myState.isShowWithInstancesOnly;
    }

    public boolean isNeedShowTrackedOnly() {
        return this.myState.isShowTrackedOnly;
    }

    public boolean isAutoUpdateModeEnabled() {
        return this.myState.isAutoUpdateModeOn;
    }

    public void addMemoryViewManagerListener(MemoryViewManagerListener listener, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MemoryViewManager.$$$reportNull$$$0(1);
        }
        this.myDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    private void fireStateChanged() {
        ((MemoryViewManagerListener)this.myDispatcher.getMulticaster()).stateChanged(new MemoryViewManagerState(this.myState));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/memory/component/MemoryViewManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addMemoryViewManagerListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

