/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jvm.actions;

import com.intellij.lang.jvm.JvmAnnotation;
import com.intellij.lang.jvm.JvmEnumField;
import com.intellij.lang.jvm.JvmField;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationAttributeValueRequest;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.AnnotationRequestsKt;
import com.intellij.lang.jvm.annotation.JvmAnnotationArrayValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttribute;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttributeValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationClassValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationConstantValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationEnumFieldValue;
import com.intellij.lang.jvm.annotation.JvmNestedAnnotationValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameValuePair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u0016\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0006\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003\u001a\u0016\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003\u001a\u0016\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001c\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u001a\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u001a\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u001b\u00a8\u0006\u001c"}, d2={"stringAttribute", "Lcom/intellij/lang/jvm/actions/AnnotationAttributeRequest;", "name", "", "value", "intAttribute", "", "classAttribute", "classFqn", "constantAttribute", "reference", "Lcom/intellij/lang/jvm/JvmField;", "refText", "nestedAttribute", "annotation", "Lcom/intellij/lang/jvm/actions/AnnotationRequest;", "arrayAttribute", "members", "", "Lcom/intellij/lang/jvm/actions/AnnotationAttributeValueRequest;", "attributeValueRequest", "attribValue", "Lcom/intellij/lang/jvm/annotation/JvmAnnotationAttributeValue;", "attribute", "Lcom/intellij/lang/jvm/annotation/JvmAnnotationAttribute;", "attributeRequest", "attributeRequests", "Lcom/intellij/lang/jvm/JvmAnnotation;", "intellij.java.analysis"})
@SourceDebugExtension(value={"SMAP\nAnnotationAttributeValueRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationAttributeValueRequest.kt\ncom/intellij/lang/jvm/actions/AnnotationAttributeValueRequestKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1642#2,10:77\n1915#2:87\n1916#2:89\n1652#2:90\n1642#2,10:92\n1915#2:102\n1916#2:104\n1652#2:105\n1#3:88\n1#3:91\n1#3:103\n*S KotlinDebug\n*F\n+ 1 AnnotationAttributeValueRequest.kt\ncom/intellij/lang/jvm/actions/AnnotationAttributeValueRequestKt\n*L\n52#1:77,10\n52#1:87\n52#1:89\n52#1:90\n75#1:92,10\n75#1:102\n75#1:104\n75#1:105\n52#1:88\n75#1:103\n*E\n"})
public final class AnnotationAttributeValueRequestKt {
    @NotNull
    public static final AnnotationAttributeRequest stringAttribute(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new AnnotationAttributeRequest(name, new AnnotationAttributeValueRequest.StringValue(value));
    }

    @NotNull
    public static final AnnotationAttributeRequest intAttribute(@NotNull String name, int value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new AnnotationAttributeRequest(name, new AnnotationAttributeValueRequest.PrimitiveValue(value));
    }

    @NotNull
    public static final AnnotationAttributeRequest classAttribute(@NotNull String name, @NotNull String classFqn) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)classFqn, (String)"classFqn");
        return new AnnotationAttributeRequest(name, new AnnotationAttributeValueRequest.ClassValue(classFqn));
    }

    @NotNull
    public static final AnnotationAttributeRequest constantAttribute(@NotNull String name, @NotNull JvmField reference) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        String string = ((PsiElement)reference).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return new AnnotationAttributeRequest(name, new AnnotationAttributeValueRequest.ConstantValue(reference, string));
    }

    @NotNull
    public static final AnnotationAttributeRequest constantAttribute(@NotNull String name, @NotNull String refText) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)refText, (String)"refText");
        return new AnnotationAttributeRequest(name, new AnnotationAttributeValueRequest.ConstantValue(null, refText));
    }

    @NotNull
    public static final AnnotationAttributeRequest nestedAttribute(@NotNull String name, @NotNull AnnotationRequest annotation) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        return new AnnotationAttributeRequest(name, new AnnotationAttributeValueRequest.NestedAnnotation(annotation));
    }

    @NotNull
    public static final AnnotationAttributeRequest arrayAttribute(@NotNull String name, @NotNull List<? extends AnnotationAttributeValueRequest> members) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(members, (String)"members");
        return new AnnotationAttributeRequest(name, new AnnotationAttributeValueRequest.ArrayValue(members));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final AnnotationAttributeValueRequest attributeValueRequest(@NotNull JvmAnnotationAttributeValue attribValue, @Nullable JvmAnnotationAttribute attribute) {
        AnnotationAttributeValueRequest annotationAttributeValueRequest;
        Intrinsics.checkNotNullParameter((Object)attribValue, (String)"attribValue");
        JvmAnnotationAttributeValue jvmAnnotationAttributeValue = attribValue;
        if (jvmAnnotationAttributeValue instanceof JvmAnnotationArrayValue) {
            void $this$mapNotNullTo$iv$iv;
            List list = ((JvmAnnotationArrayValue)attribValue).getValues();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValues(...)");
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                AnnotationAttributeValueRequest it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                JvmAnnotationAttributeValue it = (JvmAnnotationAttributeValue)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (AnnotationAttributeValueRequestKt.attributeValueRequest(it, attribute) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            annotationAttributeValueRequest = new AnnotationAttributeValueRequest.ArrayValue(list2);
        } else if (jvmAnnotationAttributeValue instanceof JvmAnnotationClassValue) {
            AnnotationAttributeValueRequest.ClassValue classValue;
            Object object = ((JvmAnnotationClassValue)attribValue).getClazz();
            if (object != null && (object = object.getQualifiedName()) != null) {
                Object p0 = object;
                boolean bl = false;
                classValue = new AnnotationAttributeValueRequest.ClassValue((String)p0);
            } else {
                classValue = null;
            }
            annotationAttributeValueRequest = classValue;
        } else if (jvmAnnotationAttributeValue instanceof JvmAnnotationConstantValue) {
            Object constantVal = ((JvmAnnotationConstantValue)attribValue).getConstantValue();
            annotationAttributeValueRequest = constantVal instanceof String ? (AnnotationAttributeValueRequest)new AnnotationAttributeValueRequest.StringValue((String)constantVal) : (constantVal != null ? (AnnotationAttributeValueRequest)new AnnotationAttributeValueRequest.PrimitiveValue(constantVal) : null);
        } else if (jvmAnnotationAttributeValue instanceof JvmAnnotationEnumFieldValue) {
            AnnotationAttributeValueRequest.ConstantValue constantValue;
            Object referenceText;
            Object object = attribute instanceof PsiNameValuePair ? (PsiNameValuePair)attribute : null;
            if (object == null || (object = object.getValue()) == null || (object = object.getText()) == null) {
                JvmEnumField jvmEnumField = ((JvmAnnotationEnumFieldValue)attribValue).getField();
                PsiElement psiElement = jvmEnumField instanceof PsiElement ? (PsiElement)jvmEnumField : null;
                object = psiElement != null ? psiElement.getText() : null;
            }
            Object object2 = referenceText = object;
            if (object2 != null) {
                Object it = object2;
                boolean bl = false;
                constantValue = new AnnotationAttributeValueRequest.ConstantValue((JvmField)((JvmAnnotationEnumFieldValue)attribValue).getField(), (String)it);
            } else {
                constantValue = null;
            }
            annotationAttributeValueRequest = constantValue;
        } else if (jvmAnnotationAttributeValue instanceof JvmNestedAnnotationValue) {
            AnnotationAttributeValueRequest.NestedAnnotation nestedAnnotation;
            JvmAnnotation jvmAnnotation = ((JvmNestedAnnotationValue)attribValue).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)jvmAnnotation, (String)"getValue(...)");
            AnnotationRequest annotationRequest = AnnotationRequestsKt.annotationRequest(jvmAnnotation);
            if (annotationRequest != null) {
                AnnotationRequest p0 = annotationRequest;
                boolean bl = false;
                nestedAnnotation = new AnnotationAttributeValueRequest.NestedAnnotation(p0);
            } else {
                nestedAnnotation = null;
            }
            annotationAttributeValueRequest = nestedAnnotation;
        } else {
            annotationAttributeValueRequest = null;
        }
        return annotationAttributeValueRequest;
    }

    public static /* synthetic */ AnnotationAttributeValueRequest attributeValueRequest$default(JvmAnnotationAttributeValue jvmAnnotationAttributeValue, JvmAnnotationAttribute jvmAnnotationAttribute, int n, Object object) {
        if ((n & 2) != 0) {
            jvmAnnotationAttribute = null;
        }
        return AnnotationAttributeValueRequestKt.attributeValueRequest(jvmAnnotationAttributeValue, jvmAnnotationAttribute);
    }

    @Nullable
    public static final AnnotationAttributeRequest attributeRequest(@NotNull JvmAnnotationAttribute attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        JvmAnnotationAttributeValue jvmAnnotationAttributeValue = attribute.getAttributeValue();
        if (jvmAnnotationAttributeValue == null) {
            return null;
        }
        JvmAnnotationAttributeValue attribValue = jvmAnnotationAttributeValue;
        AnnotationAttributeValueRequest annotationAttributeValueRequest = AnnotationAttributeValueRequestKt.attributeValueRequest(attribValue, attribute);
        if (annotationAttributeValueRequest == null) {
            return null;
        }
        AnnotationAttributeValueRequest valueRequest = annotationAttributeValueRequest;
        String string = attribute.getAttributeName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeName(...)");
        return new AnnotationAttributeRequest(string, valueRequest);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<AnnotationAttributeRequest> attributeRequests(@NotNull JvmAnnotation annotation) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        List list = annotation.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAttributes(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            AnnotationAttributeRequest it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            JvmAnnotationAttribute p0 = (JvmAnnotationAttribute)element$iv$iv;
            boolean bl2 = false;
            if (AnnotationAttributeValueRequestKt.attributeRequest(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

