/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.ProblemsView;
import com.intellij.compiler.impl.ProblemsViewPanel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorViewStructure;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.EnumSet;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import javax.swing.JComponent;
import kotlin.Unit;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ProblemsViewImpl
extends ProblemsView {
    private static final String AUTO_BUILD_TOOLWINDOW_ID = "Problems";
    private volatile ProblemsViewPanel myPanel;
    private final ExecutorService myViewUpdater;
    private static final EnumSet<ErrorTreeElementKind> interestingMessageKinds = EnumSet.of(ErrorTreeElementKind.ERROR, ErrorTreeElementKind.WARNING, ErrorTreeElementKind.NOTE);

    ProblemsViewImpl(@NotNull Project project) {
        if (project == null) {
            ProblemsViewImpl.$$$reportNull$$$0(0);
        }
        super(project);
        this.myViewUpdater = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"ProblemsView Pool");
        Disposer.register((Disposable)project, this.myViewUpdater::shutdownNow);
        this.myViewUpdater.execute(() -> ApplicationManager.getApplication().invokeAndWait(() -> {
            if (project.isDisposed()) {
                return;
            }
            ProblemsViewPanel panel = new ProblemsViewPanel(project);
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).registerToolWindow(AUTO_BUILD_TOOLWINDOW_ID, builder -> {
                builder.icon = AllIcons.Toolwindows.ProblemsEmpty;
                builder.stripeTitle = IdeBundle.messagePointer((String)"toolwindow.stripe.Problems", (Object[])new Object[0]);
                builder.canCloseContent = false;
                return Unit.INSTANCE;
            });
            Disposer.register((Disposable)toolWindow.getDisposable(), (Disposable)panel);
            Content content = ContentFactory.getInstance().createContent((JComponent)((Object)panel), "", false);
            content.setHelpId("reference.problems.tool.window");
            toolWindow.getContentManager().addContent(content);
            ProblemsViewImpl.doUpdateIcon(panel, toolWindow, null);
            this.myPanel = panel;
        }, ModalityState.nonModal()));
    }

    @Override
    public void clearOldMessages(@Nullable CompileScope scope, @NotNull UUID currentSessionId) {
        if (currentSessionId == null) {
            ProblemsViewImpl.$$$reportNull$$$0(1);
        }
        this.myViewUpdater.execute(() -> {
            this.cleanupChildrenRecursively(this.myPanel.getErrorViewStructure().getRootElement(), scope, currentSessionId);
            this.updateIcon(null);
            this.myPanel.reload();
        });
    }

    private void cleanupChildrenRecursively(@NotNull Object fromElement, @Nullable CompileScope scope, @NotNull UUID currentSessionId) {
        if (fromElement == null) {
            ProblemsViewImpl.$$$reportNull$$$0(2);
        }
        if (currentSessionId == null) {
            ProblemsViewImpl.$$$reportNull$$$0(3);
        }
        ErrorViewStructure structure = this.myPanel.getErrorViewStructure();
        for (ErrorTreeElement element : structure.getChildElements(fromElement)) {
            if (element instanceof GroupingElement) {
                VirtualFile file;
                if (scope != null && (file = ((GroupingElement)element).getFile()) != null && !((Boolean)ReadAction.compute(() -> scope.belongs(file.getUrl()))).booleanValue()) continue;
                if (!currentSessionId.equals(element.getData())) {
                    structure.removeElement(element);
                    continue;
                }
                this.cleanupChildrenRecursively(element, scope, currentSessionId);
                continue;
            }
            if (currentSessionId.equals(element.getData())) continue;
            structure.removeElement(element);
        }
    }

    @Override
    public void addMessage(int type, String @NotNull [] text, @Nullable String groupName, @Nullable Navigatable navigatable, @Nullable String exportTextPrefix, @Nullable String rendererTextPrefix, @Nullable UUID sessionId) {
        if (text == null) {
            ProblemsViewImpl.$$$reportNull$$$0(4);
        }
        this.myViewUpdater.execute(() -> {
            ErrorViewStructure structure = this.myPanel.getErrorViewStructure();
            GroupingElement group = structure.lookupGroupingElement(groupName);
            if (group != null && sessionId != null && !sessionId.equals(group.getData())) {
                structure.removeElement((ErrorTreeElement)group);
            }
            if (navigatable != null) {
                this.myPanel.addMessage(type, text, groupName, navigatable, exportTextPrefix, rendererTextPrefix, sessionId);
            } else {
                this.myPanel.addMessage(type, text, null, -1, -1, sessionId);
            }
            this.updateIcon(sessionId);
        });
    }

    private void updateIcon(@Nullable UUID currentSessionId) {
        ApplicationManager.getApplication().invokeLater(() -> {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(AUTO_BUILD_TOOLWINDOW_ID);
            if (toolWindow != null) {
                ProblemsViewImpl.doUpdateIcon(this.myPanel, toolWindow, currentSessionId);
            }
        }, this.myProject.getDisposed());
    }

    private static void doUpdateIcon(@NotNull ProblemsViewPanel panel, @NotNull ToolWindow toolWindow, @Nullable UUID currentSessionId) {
        boolean active;
        if (panel == null) {
            ProblemsViewImpl.$$$reportNull$$$0(5);
        }
        if (toolWindow == null) {
            ProblemsViewImpl.$$$reportNull$$$0(6);
        }
        toolWindow.setIcon((active = panel.getErrorViewStructure().hasMessages(interestingMessageKinds, element -> currentSessionId == null || currentSessionId.equals(element.getData()))) ? AllIcons.Toolwindows.Problems : AllIcons.Toolwindows.ProblemsEmpty);
    }

    @Override
    public void buildStarted(@NotNull UUID sessionId) {
        if (sessionId == null) {
            ProblemsViewImpl.$$$reportNull$$$0(7);
        }
        super.buildStarted(sessionId);
        this.updateIcon(sessionId);
    }

    @Override
    public void setProgress(@Nls String text, float fraction) {
        ProblemsViewPanel panel = this.myPanel;
        if (panel == null) {
            this.myViewUpdater.execute(() -> this.myPanel.setProgress(text, fraction));
        } else {
            panel.setProgress(text, fraction);
        }
    }

    @Override
    public void setProgress(@Nls String text) {
        ProblemsViewPanel panel = this.myPanel;
        if (panel == null) {
            this.myViewUpdater.execute(() -> this.myPanel.setProgressText(text));
        } else {
            panel.setProgressText(text);
        }
    }

    @Override
    public void clearProgress() {
        ProblemsViewPanel panel = this.myPanel;
        if (panel != null) {
            panel.clearProgressData();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSessionId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/compiler/impl/ProblemsViewImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "clearOldMessages";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanupChildrenRecursively";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addMessage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "doUpdateIcon";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "buildStarted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

