/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.util.ui.ItemRemovable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

public class ModuleOptionsTableModel
extends AbstractTableModel
implements ItemRemovable {
    private final List<Item> myItems = new ArrayList<Item>();

    @NotNull
    public Map<String, String> getModuleOptions() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Item item : this.myItems) {
            map.put(item.module.getName(), item.option);
        }
        HashMap<String, String> hashMap = map;
        if (hashMap == null) {
            ModuleOptionsTableModel.$$$reportNull$$$0(0);
        }
        return hashMap;
    }

    public void setModuleOptions(@NotNull Project project, @NotNull Map<String, String> moduleOptions) {
        if (project == null) {
            ModuleOptionsTableModel.$$$reportNull$$$0(1);
        }
        if (moduleOptions == null) {
            ModuleOptionsTableModel.$$$reportNull$$$0(2);
        }
        this.myItems.clear();
        if (!moduleOptions.isEmpty()) {
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                String options = moduleOptions.get(module.getName());
                if (options == null) continue;
                this.myItems.add(new Item(module, options));
            }
            this.sortItems();
        }
        this.fireTableDataChanged();
    }

    public int addModulesToModel(@NotNull Project project, @NotNull Component parent) {
        if (project == null) {
            ModuleOptionsTableModel.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            ModuleOptionsTableModel.$$$reportNull$$$0(4);
        }
        HashSet<Module> existing = new HashSet<Module>();
        for (Item item : this.myItems) {
            existing.add(item.module);
        }
        ArrayList<Module> candidates = new ArrayList<Module>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (existing.contains(module)) continue;
            candidates.add(module);
        }
        if (!candidates.isEmpty()) {
            candidates.sort(Comparator.comparing(Module::getName));
            ChooseModulesDialog chooseModulesDialog = new ChooseModulesDialog(parent, candidates, JavaCompilerBundle.message((String)"dialog.title.choose.module", (Object[])new Object[0]));
            chooseModulesDialog.show();
            List chosen = chooseModulesDialog.getChosenElements();
            if (!chosen.isEmpty()) {
                for (Module module : chosen) {
                    this.myItems.add(new Item(module));
                }
                this.sortItems();
                this.fireTableDataChanged();
                for (int i = 0; i < this.myItems.size(); ++i) {
                    if (!this.myItems.get((int)i).module.equals(chosen.get(0))) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    private void sortItems() {
        this.myItems.sort(Comparator.comparing(o -> o.module.getName()));
    }

    @Override
    public int getRowCount() {
        return this.myItems.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Item item = this.myItems.get(rowIndex);
        return columnIndex == 0 ? item.module : item.option;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Item item = this.myItems.get(rowIndex);
        item.option = ((String)aValue).trim();
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public void removeRow(int idx) {
        this.myItems.remove(idx);
        this.fireTableRowsDeleted(idx, idx);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/options/ModuleOptionsTableModel";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleOptions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleOptions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/options/ModuleOptionsTableModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setModuleOptions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addModulesToModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    private static class Item {
        private final Module module;
        private String option;

        Item(Module module) {
            this(module, "");
        }

        private Item(Module module, String option) {
            this.module = module;
            this.option = option;
        }
    }
}

