/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.Validator;
import com.intellij.openapi.compiler.options.ExcludedEntriesConfiguration;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.XmlSerializerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.serialization.java.compiler.JpsValidationSerializer;

@State(name="ValidationConfiguration", storages={@Storage(value="validation.xml")})
public class ValidationConfiguration
implements PersistentStateComponent<JpsValidationSerializer.ValidationConfigurationState> {
    private final JpsValidationSerializer.ValidationConfigurationState myState = new JpsValidationSerializer.ValidationConfigurationState();
    private final Project myProject;

    public ValidationConfiguration(Project project) {
        this.myProject = project;
    }

    public static boolean shouldValidate(Validator validator, Project project) {
        ValidationConfiguration configuration = ValidationConfiguration.getInstance(project);
        return configuration.myState.VALIDATE_ON_BUILD && configuration.isSelected(validator);
    }

    public boolean isSelected(Validator validator) {
        return this.isSelected(validator.getId());
    }

    public boolean isSelected(String validatorId) {
        Boolean selected = (Boolean)this.myState.VALIDATORS.get(validatorId);
        return selected == null || selected != false;
    }

    public boolean isValidateOnBuild() {
        return this.myState.VALIDATE_ON_BUILD;
    }

    public void setValidateOnBuild(boolean value) {
        this.myState.VALIDATE_ON_BUILD = value;
    }

    public void setSelected(Validator validator, boolean selected) {
        this.setSelected(validator.getId(), selected);
    }

    public void deselectAllValidators() {
        for (Validator validator : (Validator[])CompilerManager.getInstance((Project)this.myProject).getCompilers(Validator.class)) {
            this.myState.VALIDATORS.put(validator.getId(), false);
        }
    }

    public void setSelected(String validatorId, boolean selected) {
        this.myState.VALIDATORS.put(validatorId, selected);
    }

    public static ValidationConfiguration getInstance(Project project) {
        return (ValidationConfiguration)project.getService(ValidationConfiguration.class);
    }

    public static ExcludesConfiguration getExcludedEntriesConfiguration(Project project) {
        return (ExcludesConfiguration)project.getService(ExcludedFromValidationConfiguration.class);
    }

    @NotNull
    public JpsValidationSerializer.ValidationConfigurationState getState() {
        JpsValidationSerializer.ValidationConfigurationState validationConfigurationState = this.myState;
        if (validationConfigurationState == null) {
            ValidationConfiguration.$$$reportNull$$$0(0);
        }
        return validationConfigurationState;
    }

    public void loadState(@NotNull JpsValidationSerializer.ValidationConfigurationState state) {
        if (state == null) {
            ValidationConfiguration.$$$reportNull$$$0(1);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myState);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/options/ValidationConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/options/ValidationConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    @State(name="ExcludeFromValidation", storages={@Storage(value="excludeFromValidation.xml")})
    public static class ExcludedFromValidationConfiguration
    extends ExcludedEntriesConfiguration {
        public ExcludedFromValidationConfiguration() {
            super(null);
        }
    }
}

