/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.progress;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import org.jetbrains.annotations.NotNull;

public class ModuleLinkFilter
implements Filter {
    private final Project myProject;
    private static final String TESTS_PREFIX = "tests of ";

    public ModuleLinkFilter(Project project) {
        this.myProject = project;
    }

    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        int start2;
        if (line == null) {
            ModuleLinkFilter.$$$reportNull$$$0(0);
        }
        if ((start2 = line.indexOf("[")) == -1) {
            return null;
        }
        int end = line.indexOf(93, start2 + 1);
        if (end == -1) {
            return null;
        }
        String moduleNameCandidate = line.substring(start2 + 1, end);
        boolean isTests = moduleNameCandidate.startsWith(TESTS_PREFIX);
        final String moduleName = isTests ? moduleNameCandidate.substring(TESTS_PREFIX.length()) : moduleNameCandidate;
        int lineStart = entireLength - line.length();
        return new Filter.Result(lineStart + start2 + 1 + (isTests ? TESTS_PREFIX.length() : 0), lineStart + end, new HyperlinkInfo(){

            public void navigate(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project.isDisposed()) {
                    return;
                }
                Module module = ModuleManager.getInstance((Project)ModuleLinkFilter.this.myProject).findModuleByName(moduleName);
                if (module == null || module.isDisposed()) {
                    return;
                }
                ProjectSettingsService.getInstance((Project)ModuleLinkFilter.this.myProject).openContentEntriesSettings(module);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/progress/ModuleLinkFilter$1", "navigate"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/compiler/progress/ModuleLinkFilter", "applyFilter"));
    }
}

