/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.impl.MessagesContainer;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AutomakeCompileContext
extends UserDataHolderBase
implements CompileContext {
    private final Project myProject;
    private final ProjectCompileScope myScope;
    private final MessagesContainer myMessages;
    private final ProgressIndicator myIndicator;
    private final boolean myAnnotationProcessingEnabled;

    AutomakeCompileContext(@NotNull Project project) {
        if (project == null) {
            AutomakeCompileContext.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myScope = new ProjectCompileScope(project);
        this.myMessages = new MessagesContainer(project);
        this.myIndicator = new EmptyProgressIndicator();
        this.myAnnotationProcessingEnabled = CompilerConfiguration.getInstance((Project)project).isAnnotationProcessorsEnabled();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AutomakeCompileContext.$$$reportNull$$$0(1);
        }
        return project;
    }

    public CompileScope getCompileScope() {
        return this.getProjectCompileScope();
    }

    public CompileScope getProjectCompileScope() {
        return this.myScope;
    }

    public boolean isMake() {
        return true;
    }

    public boolean isAutomake() {
        return true;
    }

    public void addMessage(@NotNull CompilerMessageCategory category, @Nls(capitalization=Nls.Capitalization.Sentence) String message, @Nullable String url, int lineNum, int columnNum, @Nullable Navigatable navigatable, Collection<String> moduleNames) {
        if (category == null) {
            AutomakeCompileContext.$$$reportNull$$$0(2);
        }
        this.createAndAddMessage(category, message, url, lineNum, columnNum, navigatable, moduleNames);
    }

    public CompilerMessage @NotNull [] getMessages(@NotNull CompilerMessageCategory category) {
        if (category == null) {
            AutomakeCompileContext.$$$reportNull$$$0(3);
        }
        CompilerMessage[] compilerMessageArray = this.myMessages.getMessages(category).toArray(CompilerMessage.EMPTY_ARRAY);
        if (compilerMessageArray == null) {
            AutomakeCompileContext.$$$reportNull$$$0(4);
        }
        return compilerMessageArray;
    }

    @Nullable
    CompilerMessage createAndAddMessage(CompilerMessageCategory category, @Nls String message, @Nullable String url, int lineNum, int columnNum, Navigatable navigatable, Collection<String> moduleNames) {
        return this.myMessages.addMessage(category, message, url, lineNum, columnNum, navigatable, moduleNames);
    }

    public int getMessageCount(CompilerMessageCategory category) {
        return this.myMessages.getMessageCount(category);
    }

    @NotNull
    public ProgressIndicator getProgressIndicator() {
        ProgressIndicator progressIndicator = this.myIndicator;
        if (progressIndicator == null) {
            AutomakeCompileContext.$$$reportNull$$$0(5);
        }
        return progressIndicator;
    }

    public Module getModuleByFile(@NotNull VirtualFile file) {
        if (file == null) {
            AutomakeCompileContext.$$$reportNull$$$0(6);
        }
        return ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(file);
    }

    public VirtualFile getModuleOutputDirectory(@NotNull Module module) {
        if (module == null) {
            AutomakeCompileContext.$$$reportNull$$$0(7);
        }
        return CompilerPaths.getModuleOutputDirectory((Module)module, (boolean)false);
    }

    public VirtualFile getModuleOutputDirectoryForTests(Module module) {
        return CompilerPaths.getModuleOutputDirectory((Module)module, (boolean)true);
    }

    public boolean isRebuild() {
        return false;
    }

    public boolean isAnnotationProcessorsEnabled() {
        return this.myAnnotationProcessingEnabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/server/AutomakeCompileContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/server/AutomakeCompileContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessages";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressIndicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addMessage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMessages";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModuleByFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModuleOutputDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5 -> new IllegalStateException(string);
        };
    }
}

