/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.google.protobuf.MessageLite;
import com.intellij.DynamicBundle;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.YourKitProfilerService;
import com.intellij.compiler.cache.CompilerCacheConfigurator;
import com.intellij.compiler.cache.CompilerCacheStartupActivity;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompilerConfiguration;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.compiler.server.AutoMakeMessageHandler;
import com.intellij.compiler.server.BuildCommandLineBuilder;
import com.intellij.compiler.server.BuildManagerListener;
import com.intellij.compiler.server.BuildManagerVersionChecker;
import com.intellij.compiler.server.BuildMessageDispatcher;
import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.compiler.server.BuilderMessageHandler;
import com.intellij.compiler.server.DefaultMessageHandler;
import com.intellij.compiler.server.DelegatingMessageHandler;
import com.intellij.compiler.server.EelBuildCommandLineBuilder;
import com.intellij.compiler.server.InternedPath;
import com.intellij.compiler.server.LocalBuildCommandLineBuilder;
import com.intellij.compiler.server.OptionsDirectoryProcessor;
import com.intellij.compiler.server.PreloadedProcessMessageHandler;
import com.intellij.compiler.server.impl.BuildProcessClasspathManager;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.IdleTracker;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.l10n.LocalizationUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.openapi.util.registry.RegistryManagerKt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.platform.backend.workspace.GlobalWorkspaceModelCache;
import com.intellij.platform.backend.workspace.WorkspaceModelCache;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import com.intellij.platform.workspace.storage.InternalEnvironmentName;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppJavaExecutorUtil;
import com.intellij.util.concurrency.CoroutineDispatcherBackedExecutor;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.net.NetUtils;
import com.intellij.util.system.OS;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import kotlin.Unit;
import kotlinx.coroutines.CoroutineScope;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.BuiltInServerManagerImpl;
import org.jetbrains.io.ChannelRegistrar;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.api.RequestFuture;
import org.jetbrains.jps.api.TaskFuture;
import org.jetbrains.jps.api.TaskFutureAdapter;
import org.jetbrains.jps.cmdline.BuildMain;
import org.jetbrains.jps.cmdline.ClasspathBootstrap;
import org.jetbrains.jps.cmdline.Launcher;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.util.Iterators;
import org.jvnet.winp.WinProcess;

public final class BuildManager
implements Disposable {
    public static final Key<Boolean> ALLOW_AUTOMAKE = Key.create((String)"_allow_automake_when_process_is_active_");
    public static final String SYSTEM_ROOT = "compile-server";
    public static final String TEMP_DIR_NAME = "_temp_";
    private static final Logger LOG = Logger.getInstance(BuildManager.class);
    private static final Key<String> COMPILER_PROCESS_DEBUG_HOST_PORT = Key.create((String)"_compiler_process_debug_host_port_");
    private static final Key<CharSequence> STDERR_OUTPUT = Key.create((String)"_process_launch_errors_");
    private static final DateTimeFormatter USAGE_STAMP_DATE_FORMAT = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private static final String COMPILER_PROCESS_JDK_PROPERTY = "compiler.process.jdk";
    private static final String[] INHERITED_IDE_VM_OPTIONS = new String[]{"user.language", "user.country", "user.region", "idea.paths.selector", "idea.case.sensitive.fs", "java.net.preferIPv4Stack"};
    private static final String IWS_EXTENSION = ".iws";
    private static final int MINIMUM_REQUIRED_JPS_BUILD_JAVA_VERSION = 11;
    private static final String IPR_EXTENSION = ".ipr";
    private static final String IDEA_PROJECT_DIR_PATTERN = ".idea";
    private static final Predicate<InternedPath> PATH_FILTER = SystemInfo.isFileSystemCaseSensitive ? path -> !path.contains(IDEA_PROJECT_DIR_PATTERN::equals) && !path.getName().endsWith(IWS_EXTENSION) && !path.getName().endsWith(IPR_EXTENSION) : path -> !path.contains(elem -> StringUtil.equalsIgnoreCase((CharSequence)elem, (CharSequence)IDEA_PROJECT_DIR_PATTERN)) && !Strings.endsWithIgnoreCase((CharSequence)path.getName(), (String)IWS_EXTENSION) && !Strings.endsWithIgnoreCase((CharSequence)path.getName(), (String)IPR_EXTENSION);
    private static final String JPS_USE_EXPERIMENTAL_STORAGE = "jps.use.experimental.storage";
    private final boolean IS_UNIT_TEST_MODE;
    private final Map<TaskFuture<?>, Project> myAutomakeFutures;
    private final Map<String, RequestFuture<?>> myBuildsInProgress;
    private final Map<String, Future<Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler>>> myPreloadedBuilds;
    private final BuildProcessClasspathManager myClasspathManager;
    private final CoroutineDispatcherBackedExecutor myRequestsProcessor;
    private final List<VFileEvent> myUnprocessedEvents;
    private final CoroutineDispatcherBackedExecutor myAutomakeTrigger;
    private final Map<String, ProjectData> myProjectDataMap;
    private final AtomicInteger mySuspendBackgroundTasksCounter;
    private final BuildManagerPeriodicTask myAutoMakeTask;
    private final BuildManagerPeriodicTask myDocumentSaveTask;
    private final Runnable myGCTask;
    private final BuildMessageDispatcher myMessageDispatcher;
    private final List<ListeningConnection> myListeningConnections;
    @NotNull
    private final Charset mySystemCharset;
    private volatile boolean myBuildProcessDebuggingEnabled;

    public BuildManager(@NotNull CoroutineScope coroutineScope) {
        if (coroutineScope == null) {
            BuildManager.$$$reportNull$$$0(0);
        }
        this.myAutomakeFutures = Collections.synchronizedMap(new HashMap());
        this.myBuildsInProgress = Collections.synchronizedMap(new HashMap());
        this.myPreloadedBuilds = Collections.synchronizedMap(new HashMap());
        this.myClasspathManager = new BuildProcessClasspathManager(this);
        this.myUnprocessedEvents = new ArrayList<VFileEvent>();
        this.myProjectDataMap = Collections.synchronizedMap(new HashMap());
        this.mySuspendBackgroundTasksCounter = new AtomicInteger(0);
        this.myGCTask = () -> {
            int unusedThresholdDays = Registry.intValue((String)"compiler.build.data.unused.threshold", (int)-1);
            if (unusedThresholdDays <= 0) {
                return;
            }
            Path buildSystemDir = LocalBuildCommandLineBuilder.getLocalBuildSystemDirectory();
            LocalDate now = LocalDate.now();
            for (Path buildDataProjectDir : NioFiles.list((Path)buildSystemDir)) {
                if (TEMP_DIR_NAME.equals(buildDataProjectDir.getFileName().toString()) || !Files.isDirectory(buildDataProjectDir, new LinkOption[0])) continue;
                Path usageFile = BuildManager.getUsageFile(buildDataProjectDir);
                if (Files.exists(usageFile, new LinkOption[0])) {
                    Path projectFile;
                    Pair<LocalDate, Path> usageData = BuildManager.readUsageFile(usageFile);
                    if (usageData == null || ((projectFile = (Path)usageData.second) == null || Files.exists(projectFile, new LinkOption[0])) && Duration.between((Temporal)usageData.first, now).toDays() <= (long)unusedThresholdDays) continue;
                    LOG.info("Clearing project build data because the project does not exist or was not opened for more than " + unusedThresholdDays + " days: " + String.valueOf(buildDataProjectDir));
                    try {
                        NioFiles.deleteRecursively((Path)buildDataProjectDir);
                    }
                    catch (IOException e) {
                        LOG.error("Failed to delete the build directory " + String.valueOf(buildDataProjectDir), (Throwable)e);
                    }
                    continue;
                }
                BuildManager.updateUsageFile(null, buildDataProjectDir);
            }
        };
        this.myMessageDispatcher = new BuildMessageDispatcher();
        this.myListeningConnections = new ArrayList<ListeningConnection>();
        this.mySystemCharset = CharsetToolkit.getDefaultSystemCharset();
        this.myRequestsProcessor = AppJavaExecutorUtil.createBoundedTaskExecutor((String)"BuildManager RequestProcessor Pool", (CoroutineScope)coroutineScope);
        this.myAutomakeTrigger = AppJavaExecutorUtil.createBoundedTaskExecutor((String)"BuildManager Auto-Make Trigger", (CoroutineScope)coroutineScope);
        this.myAutoMakeTask = new BuildManagerPeriodicTask(coroutineScope){

            @Override
            protected int getDelay() {
                return Registry.intValue((String)"compiler.automake.trigger.delay");
            }

            @Override
            protected void runTask() {
                BuildManager.this.runAutoMake();
            }

            @Override
            protected boolean shouldPostpone() {
                if (FileDocumentManager.getInstance().getUnsavedDocuments().length > 0) {
                    return true;
                }
                int threshold = Registry.intValue((String)"compiler.automake.postpone.when.idle.less.than", (int)3000);
                long idleSinceLastActivity = ApplicationManager.getApplication().getIdleTime();
                return idleSinceLastActivity < (long)threshold;
            }
        };
        this.myDocumentSaveTask = new BuildManagerPeriodicTask(this, coroutineScope){

            @Override
            protected int getDelay() {
                return Registry.intValue((String)"compiler.document.save.trigger.delay");
            }

            @Override
            public void runTask() {
                if (2.shouldSaveDocuments()) {
                    ApplicationManager.getApplication().invokeAndWait(() -> ((FileDocumentManagerImpl)FileDocumentManager.getInstance()).saveAllDocuments(false));
                }
            }

            private static boolean shouldSaveDocuments() {
                Project contextProject = BuildManager.getCurrentContextProject();
                return contextProject != null && BuildManager.canStartAutoMake(contextProject);
            }
        };
        final Application application = ApplicationManager.getApplication();
        this.IS_UNIT_TEST_MODE = application.isUnitTestMode();
        SimpleMessageBusConnection connection = application.getMessageBus().connect(coroutineScope);
        connection.subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectWatcher());
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!BuildManager.this.IS_UNIT_TEST_MODE) {
                    List<VFileEvent> list = BuildManager.this.myUnprocessedEvents;
                    synchronized (list) {
                        BuildManager.this.myUnprocessedEvents.addAll(events);
                    }
                    BuildManager.this.myAutomakeTrigger.execute(() -> {
                        if (!application.isDisposed()) {
                            ReadAction.run(() -> {
                                ArrayList<VFileEvent> snapshot;
                                if (application.isDisposed()) {
                                    return;
                                }
                                List<VFileEvent> list = BuildManager.this.myUnprocessedEvents;
                                synchronized (list) {
                                    if (BuildManager.this.myUnprocessedEvents.isEmpty()) {
                                        return;
                                    }
                                    snapshot = new ArrayList<VFileEvent>(BuildManager.this.myUnprocessedEvents);
                                    BuildManager.this.myUnprocessedEvents.clear();
                                }
                                if (3.shouldTriggerMake(snapshot)) {
                                    BuildManager.this.scheduleAutoMake();
                                }
                            });
                        } else {
                            List<VFileEvent> list = BuildManager.this.myUnprocessedEvents;
                            synchronized (list) {
                                BuildManager.this.myUnprocessedEvents.clear();
                            }
                        }
                    });
                }
            }

            private static boolean shouldTriggerMake(List<? extends VFileEvent> events) {
                if (PowerSaveMode.isEnabled()) {
                    return false;
                }
                Project project = null;
                ProjectFileIndex fileIndex = null;
                for (VFileEvent vFileEvent : events) {
                    VirtualFile eventFile = vFileEvent.getFile();
                    if (eventFile == null) continue;
                    if (!eventFile.isValid()) {
                        return true;
                    }
                    if (project == null) {
                        project = BuildManager.getCurrentContextProject();
                        if (project == null) {
                            return false;
                        }
                        fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                    }
                    if (!fileIndex.isInContent(eventFile) || ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)eventFile) || GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)eventFile, (Project)project)) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/compiler/server/BuildManager$3", "after"));
            }
        });
        connection.subscribe(BatchFileChangeListener.TOPIC, (Object)new BatchFileChangeListener(){

            public void batchChangeStarted(@NotNull Project project, @Nullable String activityName) {
                if (project == null) {
                    4.$$$reportNull$$$0(0);
                }
                BuildManager.this.postponeBackgroundTasks();
                BuildManager.this.cancelAutoMakeTasks(project);
            }

            public void batchChangeCompleted(@NotNull Project project) {
                if (project == null) {
                    4.$$$reportNull$$$0(1);
                }
                BuildManager.this.allowBackgroundTasks(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/compiler/server/BuildManager$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "batchChangeStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "batchChangeCompleted";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!application.isHeadlessEnvironment()) {
            RegistryManagerKt.useRegistryManagerWhenReadyJavaAdapter((CoroutineScope)coroutineScope, registryManager -> {
                this.configureIdleAutomake((RegistryManager)registryManager);
                return Unit.INSTANCE;
            });
        }
        ShutDownTracker.getInstance().registerShutdownTask(() -> this.stopListening());
        if (!this.IS_UNIT_TEST_MODE) {
            ScheduledFuture<?> future = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> this.runCommand(this.myGCTask), 3L, 180L, TimeUnit.MINUTES);
            Disposer.register((Disposable)this, () -> future.cancel(false));
        }
    }

    private void configureIdleAutomake(@NotNull RegistryManager registryManager) {
        int idleTimeout;
        if (registryManager == null) {
            BuildManager.$$$reportNull$$$0(1);
        }
        int listenerTimeout = (idleTimeout = BuildManager.getAutomakeWhileIdleTimeout(registryManager)) > 0 ? idleTimeout : 60000;
        Ref idleListenerHandle = new Ref();
        idleListenerHandle.set((Object)IdleTracker.getInstance().addIdleListener(listenerTimeout, () -> {
            int currentTimeout = BuildManager.getAutomakeWhileIdleTimeout(registryManager);
            if (idleTimeout != currentTimeout) {
                AccessToken removeListener = (AccessToken)idleListenerHandle.get();
                if (removeListener != null) {
                    removeListener.close();
                }
                this.configureIdleAutomake(registryManager);
            }
            if (currentTimeout > 0 && !this.myAutoMakeTask.myInProgress.get()) {
                boolean hasChanges = false;
                Map<String, ProjectData> map = this.myProjectDataMap;
                synchronized (map) {
                    for (ProjectData data : this.myProjectDataMap.values()) {
                        if (!data.hasChanges()) continue;
                        hasChanges = true;
                        break;
                    }
                }
                if (hasChanges) {
                    this.scheduleAutoMake();
                }
            }
        }));
    }

    public void postponeBackgroundTasks() {
        this.mySuspendBackgroundTasksCounter.incrementAndGet();
    }

    public void allowBackgroundTasks(boolean resetState) {
        if (resetState) {
            this.mySuspendBackgroundTasksCounter.set(0);
        } else if (this.mySuspendBackgroundTasksCounter.decrementAndGet() < 0) {
            this.mySuspendBackgroundTasksCounter.incrementAndGet();
        }
    }

    @NotNull
    private static List<Project> getOpenProjects() {
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        if (projects.length == 0) {
            List<Project> list = List.of();
            if (list == null) {
                BuildManager.$$$reportNull$$$0(2);
            }
            return list;
        }
        SmartList projectList = new SmartList();
        for (Project project : projects) {
            if (!BuildManager.isValidProject(project)) continue;
            projectList.add(project);
        }
        SmartList smartList = projectList;
        if (smartList == null) {
            BuildManager.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    private static boolean isValidProject(@Nullable Project project) {
        return project != null && !project.isDisposed() && !project.isDefault() && project.isInitialized();
    }

    public static BuildManager getInstance() {
        return (BuildManager)ApplicationManager.getApplication().getService(BuildManager.class);
    }

    public void runCommand(@NotNull Runnable command) {
        if (command == null) {
            BuildManager.$$$reportNull$$$0(4);
        }
        this.myRequestsProcessor.execute(command);
    }

    public void notifyChanges(Supplier<? extends Changes> changeProvider) {
        this.runCommand(() -> {
            Map<String, ProjectData> map;
            Iterable<InternedPath> _changed;
            Iterable<InternedPath> _deleted;
            Object patt1$temp = changeProvider.get();
            if (!(patt1$temp instanceof Changes.Paths)) {
                this.clearState();
                return;
            }
            Changes.Paths $b$0 = (Changes.Paths)patt1$temp;
            try {
                Iterable<InternedPath> patt3$temp;
                Iterable<InternedPath> patt2$temp;
                _deleted = patt2$temp = $b$0.deleted();
                _changed = patt3$temp = $b$0.changed();
                map = this.myProjectDataMap;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            synchronized (map) {
                Iterator<Map.Entry<String, ProjectData>> iterator = this.myProjectDataMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    UUID sessionId;
                    Channel channel;
                    String projectPath;
                    RequestFuture<?> future;
                    Map.Entry<String, ProjectData> entry = iterator.next();
                    ProjectData data = entry.getValue();
                    boolean changed = data.addDeleted(Iterators.filter(_deleted, PATH_FILTER::test));
                    if (!(changed |= data.addChanged(Iterators.filter(_changed, PATH_FILTER::test))) || (future = this.myBuildsInProgress.get(projectPath = entry.getKey())) == null || future.isCancelled() || future.isDone() || (channel = this.myMessageDispatcher.getConnectedChannel(sessionId = future.getRequestID())) == null) continue;
                    CmdlineRemoteProto.Message.ControllerMessage.FSEvent event = data.createNextEvent(BuildManager.getPathMapperForProject(projectPath));
                    CmdlineRemoteProto.Message.ControllerMessage message = (CmdlineRemoteProto.Message.ControllerMessage)CmdlineRemoteProto.Message.ControllerMessage.newBuilder().setType(CmdlineRemoteProto.Message.ControllerMessage.Type.FS_EVENT).setFsEvent(event).build();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Sending to running build, ordinal=" + event.getOrdinal());
                    }
                    channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)sessionId, (CmdlineRemoteProto.Message.ControllerMessage)message));
                }
                return;
            }
        });
    }

    @Nullable
    private static Project findProjectByProjectPath(@NotNull String projectPath) {
        if (projectPath == null) {
            BuildManager.$$$reportNull$$$0(5);
        }
        return (Project)ContainerUtil.find((Object[])ProjectManager.getInstance().getOpenProjects(), project -> projectPath.equals(BuildManager.getProjectPath(project)));
    }

    @NotNull
    private static Function<String, String> getPathMapperForProject(@NotNull Project project) {
        if (project == null) {
            BuildManager.$$$reportNull$$$0(6);
        }
        if (!EelPathUtils.isProjectLocal((Project)project)) {
            Function<String, String> function = e -> EelNioBridgeServiceKt.asEelPath((Path)Path.of(e, new String[0])).toString();
            if (function == null) {
                BuildManager.$$$reportNull$$$0(7);
            }
            return function;
        }
        Function<String, String> function = Function.identity();
        if (function == null) {
            BuildManager.$$$reportNull$$$0(8);
        }
        return function;
    }

    @NotNull
    private static Function<String, String> getPathMapperForProject(@NotNull String projectPath) {
        if (projectPath == null) {
            BuildManager.$$$reportNull$$$0(9);
        }
        if (!EelPathUtils.isPathLocal((Path)Path.of(projectPath, new String[0]))) {
            Function<String, String> function = e -> EelNioBridgeServiceKt.asEelPath((Path)Path.of(e, new String[0])).toString();
            if (function == null) {
                BuildManager.$$$reportNull$$$0(10);
            }
            return function;
        }
        Function<String, String> function = Function.identity();
        if (function == null) {
            BuildManager.$$$reportNull$$$0(11);
        }
        return function;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearState(@NotNull Project project) {
        if (project == null) {
            BuildManager.$$$reportNull$$$0(12);
        }
        String projectPath = BuildManager.getProjectPath(project);
        this.cancelPreloadedBuilds(projectPath);
        Map<String, ProjectData> map = this.myProjectDataMap;
        synchronized (map) {
            ProjectData data = this.myProjectDataMap.get(projectPath);
            if (data != null) {
                data.dropChanges();
            }
        }
        this.scheduleAutoMake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearState() {
        boolean cleared;
        Map<String, ProjectData> map = this.myProjectDataMap;
        synchronized (map) {
            cleared = !this.myProjectDataMap.isEmpty();
            for (Map.Entry<String, ProjectData> entry : this.myProjectDataMap.entrySet()) {
                this.cancelPreloadedBuilds(entry.getKey());
                entry.getValue().dropChanges();
            }
        }
        if (cleared) {
            this.scheduleAutoMake();
        }
    }

    public boolean isProjectWatched(@NotNull Project project) {
        if (project == null) {
            BuildManager.$$$reportNull$$$0(13);
        }
        return this.myProjectDataMap.containsKey(BuildManager.getProjectPath(project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<String> getFilesChangedSinceLastCompilation(@NotNull Project project) {
        if (project == null) {
            BuildManager.$$$reportNull$$$0(14);
        }
        String projectPath = BuildManager.getProjectPath(project);
        Map<String, ProjectData> map = this.myProjectDataMap;
        synchronized (map) {
            ProjectData data = this.myProjectDataMap.get(projectPath);
            if (data != null && !data.myNeedRescan) {
                Set<InternedPath> changed = data.myChanged;
                return (List)Iterators.collect((Iterable)Iterators.map(changed, InternedPath::getValue), new ArrayList(changed.size()));
            }
            return null;
        }
    }

    @NotNull
    private static String getProjectPath(@NotNull Project project) {
        if (project == null) {
            BuildManager.$$$reportNull$$$0(15);
        }
        assert (!project.isDefault()) : BuildManager.class.getName() + " methods should not be called for default project";
        String string = VirtualFileManager.extractPath((String)Objects.requireNonNull(project.getPresentableUrl()));
        if (string == null) {
            BuildManager.$$$reportNull$$$0(16);
        }
        return string;
    }

    public void scheduleAutoMake() {
        if (!this.IS_UNIT_TEST_MODE && !PowerSaveMode.isEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Automake scheduled:\n" + BuildManager.getThreadTrace(Thread.currentThread(), 10));
            }
            this.myAutoMakeTask.schedule();
        }
    }

    @NotNull
    private static String getThreadTrace(Thread thread, int depth) {
        StringBuilder buf = new StringBuilder();
        StackTraceElement[] trace = thread.getStackTrace();
        for (int i = 0; i < depth && i < trace.length; ++i) {
            StackTraceElement element = trace[i];
            buf.append("\tat ").append(element).append("\n");
        }
        String string = buf.toString();
        if (string == null) {
            BuildManager.$$$reportNull$$$0(17);
        }
        return string;
    }

    private void scheduleProjectSave() {
        if (!this.IS_UNIT_TEST_MODE && !PowerSaveMode.isEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Automake canceled; reason: project save scheduled");
            }
            this.myAutoMakeTask.cancelPendingExecution();
            this.myDocumentSaveTask.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAutoMake() {
        Collection<Object> projects = List.of();
        int appIdleTimeout = BuildManager.getAutomakeWhileIdleTimeout(RegistryManager.getInstance());
        if (appIdleTimeout > 0 && ApplicationManager.getApplication().getIdleTime() > (long)appIdleTimeout) {
            projects = BuildManager.getOpenProjects();
        } else {
            Project project = BuildManager.getCurrentContextProject();
            if (project != null) {
                projects = Collections.singleton(project);
            }
        }
        if (projects.isEmpty()) {
            return;
        }
        SmartList futures = new SmartList();
        for (Project project : projects) {
            if (!BuildManager.canStartAutoMake(project)) continue;
            List scopes = CmdlineProtoUtil.createAllModulesScopes((boolean)false);
            AutoMakeMessageHandler handler = new AutoMakeMessageHandler(project);
            TaskFuture<?> future = this.scheduleBuild(project, false, true, false, scopes, List.of(), Collections.singletonMap("is_automake", "true"), handler);
            this.myAutomakeFutures.put(future, project);
            futures.add(new Pair(future, (Object)handler));
        }
        boolean needAdditionalBuild = false;
        for (Pair pair : futures) {
            try {
                ((TaskFuture)pair.first).waitFor();
            }
            catch (Throwable throwable) {}
            continue;
            finally {
                this.myAutomakeFutures.remove(pair.first);
                if (!((AutoMakeMessageHandler)pair.second).unprocessedFSChangesDetected()) continue;
                needAdditionalBuild = true;
            }
        }
        if (needAdditionalBuild) {
            this.scheduleAutoMake();
        }
    }

    private static int getAutomakeWhileIdleTimeout(@NotNull RegistryManager registryManager) {
        if (registryManager == null) {
            BuildManager.$$$reportNull$$$0(18);
        }
        return registryManager.intValue("compiler.automake.build.while.idle.timeout", 60000);
    }

    private static boolean canStartAutoMake(@NotNull Project project) {
        if (project == null) {
            BuildManager.$$$reportNull$$$0(19);
        }
        if (project.isDisposed()) {
            return false;
        }
        CompilerWorkspaceConfiguration config = CompilerWorkspaceConfiguration.getInstance((Project)project);
        if (!config.MAKE_PROJECT_ON_SAVE || !TrustedProjects.isProjectTrusted((Project)project)) {
            return false;
        }
        return config.allowAutoMakeWhileRunningApplication() || !BuildManager.hasRunningProcess(project);
    }

    @Nullable
    private static Project getCurrentContextProject() {
        List<Project> openProjects = BuildManager.getOpenProjects();
        if (openProjects.isEmpty()) {
            return null;
        }
        if (openProjects.size() == 1) {
            return openProjects.getFirst();
        }
        Project project = null;
        if (!GraphicsEnvironment.isHeadless()) {
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            if (window == null) {
                window = ComponentUtil.getActiveWindow();
            }
            project = com.intellij.ide.impl.ProjectUtil.getProjectForComponent((Component)window);
        }
        return BuildManager.isValidProject(project) ? project : null;
    }

    private static boolean hasRunningProcess(@NotNull Project project) {
        if (project == null) {
            BuildManager.$$$reportNull$$$0(20);
        }
        for (ProcessHandler handler : ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            if (handler.isProcessTerminated() || ((Boolean)ALLOW_AUTOMAKE.get((UserDataHolder)handler, (Object)Boolean.FALSE)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<TaskFuture<?>> cancelAutoMakeTasks(@NotNull Project project) {
        if (project == null) {
            BuildManager.$$$reportNull$$$0(21);
        }
        SmartList futures = new SmartList();
        Map<TaskFuture<?>, Project> map = this.myAutomakeFutures;
        synchronized (map) {
            for (Map.Entry<TaskFuture<?>, Project> entry : this.myAutomakeFutures.entrySet()) {
                if (!entry.getValue().equals((Object)project)) continue;
                TaskFuture<?> future = entry.getKey();
                future.cancel(false);
                futures.add(future);
            }
        }
        if (LOG.isDebugEnabled() && !futures.isEmpty()) {
            LOG.debug("Automake cancel (all tasks):\n" + BuildManager.getThreadTrace(Thread.currentThread(), 10));
        }
        SmartList smartList = futures;
        if (smartList == null) {
            BuildManager.$$$reportNull$$$0(22);
        }
        return smartList;
    }

    private void cancelAllPreloadedBuilds() {
        String[] paths;
        for (String path : paths = ArrayUtil.toStringArray(this.myPreloadedBuilds.keySet())) {
            this.cancelPreloadedBuilds(path);
        }
    }

    @NotNull
    public TaskFuture<Boolean> cancelPreloadedBuilds(@NotNull Project project) {
        if (project == null) {
            BuildManager.$$$reportNull$$$0(23);
        }
        return this.cancelPreloadedBuilds(BuildManager.getProjectPath(project));
    }

    @NotNull
    private TaskFuture<Boolean> cancelPreloadedBuilds(@NotNull String projectPath) {
        if (projectPath == null) {
            BuildManager.$$$reportNull$$$0(24);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cancel preloaded build for " + projectPath + "\n" + BuildManager.getThreadTrace(Thread.currentThread(), 50));
        }
        CompletableFuture future = new CompletableFuture();
        this.runCommand(() -> {
            Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler> pair = this.takePreloadedProcess(projectPath);
            if (pair != null) {
                this.stopProcess(projectPath, ((RequestFuture)pair.first).getRequestID(), (OSProcessHandler)pair.second, future);
            } else {
                future.complete(Boolean.TRUE);
            }
        });
        return new TaskFutureAdapter(future);
    }

    private void stopProcess(String projectPath, UUID sessionId, OSProcessHandler processHandler, @Nullable CompletableFuture<Boolean> future) {
        this.myMessageDispatcher.cancelSession(sessionId);
        this.getProjectData((String)projectPath).taskQueue.execute(() -> {
            block6: {
                Throwable error = null;
                try {
                    while (!processHandler.waitFor()) {
                        LOG.info("[stop] processHandler.waitFor() returned false for session " + String.valueOf(sessionId) + ", continue waiting");
                    }
                    this.notifySessionTerminationIfNeeded(sessionId, error);
                    if (future == null) break block6;
                    future.complete(error == null ? Boolean.TRUE : Boolean.FALSE);
                }
                catch (Throwable e) {
                    try {
                        error = e;
                        this.notifySessionTerminationIfNeeded(sessionId, error);
                        if (future == null) break block6;
                        future.complete(error == null ? Boolean.TRUE : Boolean.FALSE);
                    }
                    catch (Throwable throwable) {
                        this.notifySessionTerminationIfNeeded(sessionId, error);
                        if (future != null) {
                            future.complete(error == null ? Boolean.TRUE : Boolean.FALSE);
                        }
                        throw throwable;
                    }
                }
            }
        });
    }

    @Nullable
    private Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler> takePreloadedProcess(String projectPath) {
        Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler> result;
        Future<Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler>> preloadProgress = this.myPreloadedBuilds.remove(projectPath);
        try {
            result = preloadProgress != null ? preloadProgress.get() : null;
        }
        catch (Throwable e) {
            LOG.info(e);
            result = null;
        }
        return result != null && !((RequestFuture)result.first).isDone() ? result : null;
    }

    @NotNull
    public TaskFuture<?> scheduleBuild(Project project, boolean isRebuild, boolean isMake, boolean onlyCheckUpToDate, List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes, Collection<String> paths, Map<String, String> userData, DefaultMessageHandler messageHandler) {
        String projectPath = BuildManager.getProjectPath(project);
        boolean isAutomake = messageHandler instanceof AutoMakeMessageHandler;
        EelDescriptor eelDescriptor = EelProviderUtil.getEelDescriptor((Project)project);
        Function<String, String> pathMapperBack = !EelPathUtils.isProjectLocal((Project)project) ? e -> EelNioBridgeServiceKt.asNioPath((EelPath)EelPath.parse((String)e, (EelDescriptor)eelDescriptor)).toString() : Function.identity();
        NotifyingMessageHandler handler = new NotifyingMessageHandler(project, messageHandler, pathMapperBack, isAutomake);
        Function<String, String> pathMapper = BuildManager.getPathMapperForProject(project);
        DelegateFuture _future = new DelegateFuture();
        this.runCommand(() -> {
            UUID sessionId;
            boolean usingPreloadedProcess;
            Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler> preloaded = this.takePreloadedProcess(projectPath);
            RequestFuture preloadedFuture = (RequestFuture)Pair.getFirst(preloaded);
            boolean bl = usingPreloadedProcess = preloadedFuture != null;
            if (usingPreloadedProcess) {
                LOG.info("Using preloaded build process to compile " + projectPath);
                sessionId = preloadedFuture.getRequestID();
                ((PreloadedProcessMessageHandler)preloadedFuture.getMessageHandler()).setDelegateHandler(handler);
            } else {
                sessionId = UUID.randomUUID();
            }
            RequestFuture future = usingPreloadedProcess ? preloadedFuture : new RequestFuture((Object)handler, sessionId, new CancelBuildSessionAction());
            List<RequestFuture> delegatesToWait = Collections.singletonList(future);
            if (!usingPreloadedProcess && (future.isCancelled() || project.isDisposed())) {
                handler.sessionTerminated(sessionId);
                future.setDone();
            } else {
                CmdlineRemoteProto.Message.ControllerMessage params;
                ExecutorService projectTaskQueue;
                boolean needRescan;
                CmdlineRemoteProto.Message.ControllerMessage.FSEvent currentFSChanges;
                String optionsPath = PathManager.getOptionsDir().toString();
                optionsPath = !EelPathUtils.isProjectLocal((Project)project) ? EelNioBridgeServiceKt.asEelPath((Path)OptionsDirectoryProcessor.transferOptionsToRemote(PathManager.getOptionsDir(), project)).toString() : (String)pathMapper.apply(optionsPath);
                CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings globals = (CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings)CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings.newBuilder().setGlobalOptionsPath(optionsPath).build();
                Map<String, ProjectData> map = this.myProjectDataMap;
                synchronized (map) {
                    ProjectData data = this.getProjectData(projectPath);
                    if (isRebuild) {
                        data.dropChanges();
                    }
                    if (this.IS_UNIT_TEST_MODE) {
                        LOG.info("Scheduling build for " + projectPath + "; CHANGED: " + String.valueOf(Iterators.collect((Iterable)Iterators.map(data.myChanged, InternedPath::getValue), new HashSet())) + "; DELETED: " + String.valueOf(Iterators.collect((Iterable)Iterators.map(data.myDeleted, InternedPath::getValue), new HashSet())));
                    }
                    CmdlineRemoteProto.Message.ControllerMessage.FSEvent fSEvent = currentFSChanges = (needRescan = data.getAndResetRescanFlag()) ? null : data.createNextEvent(pathMapper);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Sending to starting build, ordinal=" + (currentFSChanges == null ? null : Long.valueOf(currentFSChanges.getOrdinal())));
                    }
                    projectTaskQueue = data.taskQueue;
                }
                String mappedProjectPath = (String)pathMapper.apply(projectPath);
                List mappedPaths = ContainerUtil.map((Collection)paths, pathMapper::apply);
                if (isRebuild) {
                    params = CmdlineProtoUtil.createBuildRequest((String)mappedProjectPath, (List)scopes, List.of(), (Map)userData, (CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings)globals, null, null);
                } else if (onlyCheckUpToDate) {
                    params = CmdlineProtoUtil.createUpToDateCheckRequest((String)mappedProjectPath, (List)scopes, (Collection)mappedPaths, (Map)userData, (CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings)globals, (CmdlineRemoteProto.Message.ControllerMessage.FSEvent)currentFSChanges);
                } else {
                    List pathsToMake = isMake ? List.of() : mappedPaths;
                    CmdlineRemoteProto.Message.ControllerMessage.CacheDownloadSettings cacheSettings = isMake ? CompilerCacheConfigurator.getCacheDownloadSettings(project) : null;
                    params = CmdlineProtoUtil.createBuildRequest((String)mappedProjectPath, (List)scopes, (Collection)pathsToMake, (Map)userData, (CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings)globals, (CmdlineRemoteProto.Message.ControllerMessage.FSEvent)currentFSChanges, (CmdlineRemoteProto.Message.ControllerMessage.CacheDownloadSettings)cacheSettings);
                }
                if (!usingPreloadedProcess) {
                    this.myMessageDispatcher.registerBuildMessageHandler((RequestFuture<? extends BuilderMessageHandler>)future, params);
                }
                try {
                    CompletableFuture buildFuture = BackgroundTaskUtil.submitTask((Executor)projectTaskQueue, (Disposable)ProjectDisposableService.getInstance(project), () -> {
                        Throwable execFailure = null;
                        try {
                            CharSequence errorsOnLaunch;
                            OSProcessHandler processHandler;
                            if (project.isDisposed()) {
                                if (usingPreloadedProcess) {
                                    future.cancel(false);
                                } else {
                                    return;
                                }
                            }
                            this.myBuildsInProgress.put(projectPath, future);
                            if (usingPreloadedProcess) {
                                boolean paramsSent = this.myMessageDispatcher.sendBuildParameters(future.getRequestID(), params);
                                if (!paramsSent) {
                                    this.myMessageDispatcher.cancelSession(future.getRequestID());
                                }
                                processHandler = (OSProcessHandler)preloaded.second;
                                errorsOnLaunch = (CharSequence)STDERR_OUTPUT.get((UserDataHolder)processHandler);
                            } else {
                                if (isAutomake && needRescan) {
                                    try {
                                        project.save();
                                    }
                                    catch (Throwable e) {
                                        LOG.info(e);
                                    }
                                }
                                processHandler = this.launchBuildProcess(project, sessionId, false, messageHandler.getProgressIndicator());
                                errorsOnLaunch = new StringBuffer();
                                processHandler.addProcessListener((ProcessListener)new StdOutputCollector((Appendable)((Object)errorsOnLaunch)));
                                processHandler.startNotify();
                            }
                            String debugPort = (String)processHandler.getUserData(COMPILER_PROCESS_DEBUG_HOST_PORT);
                            if (debugPort != null) {
                                String text = "Build: waiting for debugger connection on port " + debugPort;
                                messageHandler.handleCompileMessage(sessionId, CmdlineProtoUtil.createCompileProgressMessageResponse((String)text).getCompileMessage());
                                System.out.println("Build: Listening for transport dt_socket at address: " + debugPort);
                            }
                            while (!processHandler.waitFor()) {
                                LOG.info("processHandler.waitFor() returned false for session " + String.valueOf(sessionId) + ", continue waiting");
                            }
                            int exitValue = processHandler.getProcess().exitValue();
                            if (exitValue != 0) {
                                StringBuilder msg = new StringBuilder();
                                msg.append(JavaCompilerBundle.message((String)"abnormal.build.process.termination", (Object[])new Object[0])).append(": ");
                                if (errorsOnLaunch != null && !errorsOnLaunch.isEmpty()) {
                                    msg.append("\n").append(errorsOnLaunch);
                                    if (StringUtil.contains((CharSequence)errorsOnLaunch, (CharSequence)"java.lang.NoSuchMethodError")) {
                                        msg.append("\nThe error may be caused by JARs in Java Extensions directory which conflicts with libraries used by the external build process.").append("\nTry adding -Djava.ext.dirs=\"\" argument to 'Build process VM options' in File | Settings | Build, Execution, Deployment | Compiler to fix the problem.");
                                    }
                                } else {
                                    msg.append(JavaCompilerBundle.message((String)"unknown.build.process.error", (Object[])new Object[0]));
                                }
                                handler.handleFailure(sessionId, CmdlineProtoUtil.createFailure((String)msg.toString(), null));
                            }
                        }
                        catch (Throwable e) {
                            execFailure = e;
                        }
                        finally {
                            this.myBuildsInProgress.remove(projectPath);
                            this.notifySessionTerminationIfNeeded(sessionId, execFailure);
                            if (this.isProcessPreloadingEnabled(project) && !onlyCheckUpToDate) {
                                this.runCommand(() -> {
                                    if (!this.myPreloadedBuilds.containsKey(projectPath)) {
                                        try {
                                            this.myPreloadedBuilds.put(projectPath, this.launchPreloadedBuildProcess(project, projectTaskQueue));
                                        }
                                        catch (Throwable e) {
                                            LOG.info("Error pre-loading build process for project " + projectPath, e);
                                        }
                                    }
                                });
                            }
                        }
                    }).getFuture();
                    delegatesToWait = List.of(future, new TaskFutureAdapter((Future)buildFuture));
                }
                catch (Throwable e) {
                    this.handleProcessExecutionFailure(sessionId, e);
                }
            }
            boolean set = _future.setDelegates(delegatesToWait);
            assert (set);
        });
        DelegateFuture delegateFuture = _future;
        if (delegateFuture == null) {
            BuildManager.$$$reportNull$$$0(25);
        }
        return delegateFuture;
    }

    private boolean isProcessPreloadingEnabled(Project project) {
        if (this.IS_UNIT_TEST_MODE || !Registry.is((String)"compiler.process.preload") || this.myBuildProcessDebuggingEnabled) {
            return false;
        }
        Path projectFilePath = Path.of(BuildManager.getProjectPath(project), new String[0]);
        if (!EelProviderUtil.getEelDescriptor((Path)projectFilePath).equals((Object)LocalEelDescriptor.INSTANCE)) {
            return false;
        }
        if (project.isDisposed()) {
            return true;
        }
        for (BuildProcessParametersProvider provider : BuildProcessParametersProvider.EP_NAME.getExtensions((AreaInstance)project)) {
            if (provider.isProcessPreloadingEnabled()) continue;
            return false;
        }
        return true;
    }

    private void notifySessionTerminationIfNeeded(@NotNull UUID sessionId, @Nullable Throwable execFailure) {
        BuilderMessageHandler unregistered;
        if (sessionId == null) {
            BuildManager.$$$reportNull$$$0(26);
        }
        if (this.myMessageDispatcher.getAssociatedChannel(sessionId) == null && (unregistered = this.myMessageDispatcher.unregisterBuildMessageHandler(sessionId)) != null) {
            if (execFailure != null) {
                unregistered.handleFailure(sessionId, CmdlineProtoUtil.createFailure((String)execFailure.getMessage(), (Throwable)execFailure));
            }
            unregistered.sessionTerminated(sessionId);
        }
    }

    private void handleProcessExecutionFailure(@NotNull UUID sessionId, Throwable e) {
        BuilderMessageHandler unregistered;
        if (sessionId == null) {
            BuildManager.$$$reportNull$$$0(27);
        }
        if ((unregistered = this.myMessageDispatcher.unregisterBuildMessageHandler(sessionId)) != null) {
            unregistered.handleFailure(sessionId, CmdlineProtoUtil.createFailure((String)e.getMessage(), (Throwable)e));
            unregistered.sessionTerminated(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private ProjectData getProjectData(@NotNull String projectPath) {
        if (projectPath == null) {
            BuildManager.$$$reportNull$$$0(28);
        }
        Map<String, ProjectData> map = this.myProjectDataMap;
        // MONITORENTER : map
        ProjectData projectData = this.myProjectDataMap.computeIfAbsent(projectPath, __ -> new ProjectData(SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"BuildManager Pool")));
        // MONITOREXIT : map
        if (projectData != null) return projectData;
        BuildManager.$$$reportNull$$$0(29);
        return projectData;
    }

    private synchronized int ensureListening(InetAddress inetAddress) {
        for (ListeningConnection connection : this.myListeningConnections) {
            if (!connection.myAddress.equals(inetAddress)) continue;
            return connection.myListenPort;
        }
        return this.startListening(inetAddress);
    }

    public void dispose() {
        this.stopListening();
        this.myAutomakeTrigger.cancel();
        this.myRequestsProcessor.cancel();
    }

    @NotNull
    public static @NotNull Pair<@NotNull Sdk, @Nullable JavaSdkVersion> getBuildProcessRuntimeSdk(@NotNull Project project) {
        if (project == null) {
            BuildManager.$$$reportNull$$$0(30);
        }
        return BuildManager.getRuntimeSdk(project, 11, processed -> {
            Predicate<Sdk> sdkFilter = BuildManager.getSdkFilter(project);
            return ((StreamEx)StreamEx.of((Collection)ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)JavaSdk.getInstance())).filter(sdk -> !processed.contains(sdk) && sdkFilter.test((Sdk)sdk))).mapToEntry(sdk -> JavaVersion.tryParse((String)sdk.getVersionString())).filterValues(version -> version != null && version.isAtLeast(11)).min(Map.Entry.comparingByValue()).map(p -> new Pair((Object)((Sdk)p.getKey()), (Object)JavaSdkVersion.fromJavaVersion((JavaVersion)Objects.requireNonNull((JavaVersion)p.getValue())))).filter(p -> p.second != null).orElseGet(() -> BuildManager.getIDERuntimeSdkOrErrorIfRemote(project));
        });
    }

    @NotNull
    private static Predicate<Sdk> getSdkFilter(@NotNull Project project) {
        if (project == null) {
            BuildManager.$$$reportNull$$$0(31);
        }
        Predicate<Sdk> predicate = sdk -> JdkUtil.isCompatible((Sdk)sdk, (Project)project);
        if (predicate == null) {
            BuildManager.$$$reportNull$$$0(32);
        }
        return predicate;
    }

    @NotNull
    public static @NotNull Pair<@NotNull Sdk, @Nullable JavaSdkVersion> getJavacRuntimeSdk(@NotNull Project project) {
        if (project == null) {
            BuildManager.$$$reportNull$$$0(33);
        }
        return BuildManager.getRuntimeSdk(project, 8, processed -> BuildManager.getIDERuntimeSdkOrErrorIfRemote(project));
    }

    @NotNull
    private static Pair<Sdk, JavaSdkVersion> getRuntimeSdk(@NotNull Project project, int oldestPossibleVersion, Function<Set<? extends Sdk>, Pair<Sdk, JavaSdkVersion>> fallbackSdkProvider) {
        List sortedSdks;
        if (project == null) {
            BuildManager.$$$reportNull$$$0(34);
        }
        HashMap candidates = new HashMap();
        Consumer<Sdk> addSdk = sdk -> {
            Integer count;
            if (sdk != null && sdk.getSdkType() instanceof JavaSdkType && (count = candidates.putIfAbsent(sdk, 1)) != null) {
                candidates.put(sdk, count + 1);
            }
        };
        addSdk.accept(ProjectRootManager.getInstance((Project)project).getProjectSdk());
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            addSdk.accept(ModuleRootManager.getInstance((Module)module).getSdk());
        }
        CompilerConfigurationImpl configuration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project);
        if (configuration.getJavacCompiler().equals(configuration.getDefaultCompiler()) && JavacConfiguration.getOptions((Project)project, JavacConfiguration.class).PREFER_TARGET_JDK_COMPILER && !(sortedSdks = ((EntryStream)EntryStream.of(candidates).reverseSorted(Map.Entry.comparingByValue())).keys().mapToEntry(sdk -> JavaVersion.tryParse((String)sdk.getVersionString())).filterValues(version -> version != null && version.isAtLeast(oldestPossibleVersion)).mapValues(version -> JavaSdkVersion.fromJavaVersion((JavaVersion)Objects.requireNonNull(version))).nonNullValues().mapKeyValue(Pair::create).toList()).isEmpty()) {
            Pair sdk9_plus = (Pair)ContainerUtil.find((Iterable)sortedSdks, p -> p.second != null && ((JavaSdkVersion)p.second).isAtLeast(JavaSdkVersion.JDK_1_9));
            Pair pair = sdk9_plus != null ? sdk9_plus : (Pair)sortedSdks.getFirst();
            if (pair == null) {
                BuildManager.$$$reportNull$$$0(35);
            }
            return pair;
        }
        Pair pair = StreamEx.ofKeys(candidates).mapToEntry(sdk -> JavaVersion.tryParse((String)sdk.getVersionString())).filterValues(version -> version != null && version.isAtLeast(oldestPossibleVersion)).max(Map.Entry.comparingByValue()).map(p -> new Pair((Object)((Sdk)p.getKey()), (Object)JavaSdkVersion.fromJavaVersion((JavaVersion)Objects.requireNonNull((JavaVersion)p.getValue())))).filter(p -> p.second != null).orElseGet(() -> (Pair)fallbackSdkProvider.apply(candidates.keySet()));
        if (pair == null) {
            BuildManager.$$$reportNull$$$0(36);
        }
        return pair;
    }

    @Nullable
    private static Pair<Sdk, JavaSdkVersion> getForkedJavacFallbackSdk(Project project) {
        return ((StreamEx)StreamEx.of((Collection)ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)JavaSdk.getInstance())).filter(BuildManager.getSdkFilter(project))).mapToEntry(sdk -> JavaVersion.tryParse((String)sdk.getVersionString())).filterValues(version -> version != null && version.isAtLeast(8)).min(Map.Entry.comparingByValue()).map(p -> new Pair((Object)((Sdk)p.getKey()), (Object)JavaSdkVersion.fromJavaVersion((JavaVersion)Objects.requireNonNull((JavaVersion)p.getValue())))).filter(p -> p.second != null).orElse(null);
    }

    @NotNull
    private static Pair<Sdk, JavaSdkVersion> getIDERuntimeSdkOrErrorIfRemote(@NotNull Project project) {
        if (project == null) {
            BuildManager.$$$reportNull$$$0(37);
        }
        if (!EelPathUtils.isProjectLocal((Project)project)) {
            throw new IllegalStateException(JavaCompilerBundle.message((String)"build.manager.launch.build.process.failed.to.find.compatible.jdk", (Object[])new Object[0]));
        }
        Sdk sdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
        return new Pair((Object)sdk, (Object)JavaSdk.getInstance().getVersion(sdk));
    }

    private Future<Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler>> launchPreloadedBuildProcess(Project project, ExecutorService projectTaskQueue) {
        return BackgroundTaskUtil.submitTask((Executor)projectTaskQueue, (Disposable)ProjectDisposableService.getInstance(project), () -> {
            if (project.isDisposed()) {
                return null;
            }
            RequestFuture future = new RequestFuture((Object)new PreloadedProcessMessageHandler(), UUID.randomUUID(), new CancelBuildSessionAction());
            try {
                this.myMessageDispatcher.registerBuildMessageHandler((RequestFuture<? extends BuilderMessageHandler>)future, null);
                ProgressIndicator indicator = Objects.requireNonNull(ProgressIndicatorProvider.getGlobalProgressIndicator());
                OSProcessHandler processHandler = this.launchBuildProcess(project, future.getRequestID(), true, indicator);
                StringBuffer errors = new StringBuffer();
                processHandler.addProcessListener((ProcessListener)new StdOutputCollector(errors));
                STDERR_OUTPUT.set((UserDataHolder)processHandler, (Object)errors);
                processHandler.startNotify();
                return new Pair((Object)future, (Object)processHandler);
            }
            catch (Throwable e) {
                this.handleProcessExecutionFailure(future.getRequestID(), e);
                ExceptionUtil.rethrowUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }).getFuture();
    }

    /*
     * WARNING - void declaration
     */
    private OSProcessHandler launchBuildProcess(@NotNull Project project, @NotNull UUID sessionId, boolean requestProjectPreload, @Nullable ProgressIndicator progressIndicator) throws com.intellij.execution.ExecutionException, IOException {
        void var37_62;
        String path;
        String fallbackSdkVersion;
        int localHeapSize;
        String additionalOptions;
        BuildCommandLineBuilder cmdLine;
        String vmExecutablePath;
        if (project == null) {
            BuildManager.$$$reportNull$$$0(38);
        }
        if (sessionId == null) {
            BuildManager.$$$reportNull$$$0(39);
        }
        String compilerPath = null;
        JavaSdkVersion sdkVersion = null;
        String forcedCompiledJdkHome = Registry.stringValue((String)COMPILER_PROCESS_JDK_PROPERTY);
        if (Strings.isEmptyOrSpaces((CharSequence)forcedCompiledJdkHome)) {
            Pair<Sdk, JavaSdkVersion> pair = BuildManager.getBuildProcessRuntimeSdk(project);
            Sdk projectJdk = (Sdk)pair.first;
            sdkName = projectJdk.getName();
            sdkVersion = (JavaSdkVersion)pair.second;
            JavaSdkType projectJdkType = (JavaSdkType)projectJdk.getSdkType();
            if (!JavaSdkUtil.isJdkAtLeast((Sdk)projectJdk, (JavaSdkVersion)JavaSdkVersion.JDK_1_9)) {
                Sdk internalJdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
                if (FileUtil.pathsEqual((String)projectJdk.getHomePath(), (String)internalJdk.getHomePath())) {
                    JavaCompiler systemCompiler = ToolProvider.getSystemJavaCompiler();
                    if (systemCompiler == null) {
                        try {
                            compilerPath = ClasspathBootstrap.getResourcePath(Class.forName("com.sun.tools.javac.api.JavacTool", false, BuildManager.class.getClassLoader()));
                        }
                        catch (Throwable t) {
                            LOG.info(t);
                        }
                        if (compilerPath == null) {
                            throw new com.intellij.execution.ExecutionException(JavaCompilerBundle.message((String)"build.process.no.javac.found", (Object[])new Object[0]));
                        }
                    } else {
                        compilerPath = ClasspathBootstrap.getResourcePath(systemCompiler.getClass());
                    }
                } else {
                    compilerPath = projectJdkType.getToolsPath(projectJdk);
                    if (compilerPath == null) {
                        throw new com.intellij.execution.ExecutionException(JavaCompilerBundle.message((String)"build.process.no.javac.path.found", (Object[])new Object[]{sdkName, projectJdk.getHomePath()}));
                    }
                }
            }
            vmExecutablePath = projectJdkType.getVMExecutablePath(projectJdk);
            ((BuildManagerVersionChecker)project.getService(BuildManagerVersionChecker.class)).checkArch(projectJdk.getHomePath());
        } else {
            sdkName = forcedCompiledJdkHome;
            compilerPath = Path.of(forcedCompiledJdkHome, "lib/tools.jar").toAbsolutePath().toString();
            vmExecutablePath = Path.of(forcedCompiledJdkHome, "bin/java").toAbsolutePath().toString();
            ((BuildManagerVersionChecker)project.getService(BuildManagerVersionChecker.class)).checkArch(forcedCompiledJdkHome);
        }
        CompilerConfiguration projectConfig = CompilerConfiguration.getInstance((Project)project);
        CompilerWorkspaceConfiguration config = CompilerWorkspaceConfiguration.getInstance((Project)project);
        InetAddress listenAddress = InetAddress.getLoopbackAddress();
        InetSocketAddress listenSocketAddress = new InetSocketAddress(listenAddress, this.ensureListening(listenAddress));
        String buildProcessConnectHost = listenAddress.getHostAddress();
        int buildProcessConnectPort = listenSocketAddress.getPort();
        boolean localProject = EelPathUtils.isProjectLocal((Project)project);
        if (!localProject) {
            EelBuildCommandLineBuilder eelBuilder = new EelBuildCommandLineBuilder(project, Path.of(vmExecutablePath, new String[0]));
            cmdLine = eelBuilder;
            cmdLine.addParameter("-Dide.jps.remote.path.prefixes=" + eelBuilder.pathPrefixes().stream().map(e -> e.replace('\\', '/')).collect(Collectors.joining(";")));
            buildProcessConnectHost = "127.0.0.1";
            int listenPort = listenSocketAddress.getPort();
            buildProcessConnectPort = eelBuilder.maybeRunReverseTunnel(listenPort, project);
        } else {
            cmdLine = new LocalBuildCommandLineBuilder(vmExecutablePath);
        }
        boolean profileWithYourKit = false;
        boolean isAgentpathSet = false;
        String userDefinedHeapSize = null;
        SmartList userAdditionalOptionsList = new SmartList();
        String userAdditionalVMOptions = config.COMPILER_PROCESS_ADDITIONAL_VM_OPTIONS;
        boolean userLocalOptionsActive = !StringUtil.isEmptyOrSpaces((String)userAdditionalVMOptions);
        String string = additionalOptions = userLocalOptionsActive ? userAdditionalVMOptions : projectConfig.getBuildProcessVMOptions();
        if (!StringUtil.isEmptyOrSpaces((String)additionalOptions)) {
            StringTokenizer tokenizer = new StringTokenizer(additionalOptions, " ", false);
            while (tokenizer.hasMoreTokens()) {
                String option = tokenizer.nextToken();
                if (StringUtil.startsWithIgnoreCase((String)option, (String)"-Xmx")) {
                    if (!userLocalOptionsActive) continue;
                    userDefinedHeapSize = option;
                    continue;
                }
                if (option.startsWith("-Dprofiling.mode=") && !option.equals("-Dprofiling.mode=false")) {
                    profileWithYourKit = true;
                }
                if (option.startsWith("-agentpath:")) {
                    isAgentpathSet = true;
                }
                userAdditionalOptionsList.add(option);
            }
        }
        if ((localHeapSize = config.COMPILER_PROCESS_HEAP_SIZE) > 0) {
            cmdLine.addParameter("-Xmx" + localHeapSize + "m");
        } else if (userDefinedHeapSize != null) {
            cmdLine.addParameter(userDefinedHeapSize);
        } else {
            int heapSize = projectConfig.getBuildProcessHeapSize(JavacConfiguration.getOptions((Project)project, JavacConfiguration.class).MAXIMUM_HEAP_SIZE);
            cmdLine.addParameter("-Xmx" + heapSize + "m");
        }
        cmdLine.addParameter("-Djava.awt.headless=true");
        if (Boolean.getBoolean(JPS_USE_EXPERIMENTAL_STORAGE)) {
            cmdLine.addParameter("-Djps.use.experimental.storage=true");
        }
        BuildManager.attachJnaBootLibraryIfNeeded(project, cmdLine);
        if (Registry.is((String)"jps.build.use.workspace.model")) {
            String globalCacheId = "Local";
            cmdLine.addParameter("-Dintellij.jps.use.workspace.model=true");
            WorkspaceModelCache cache = WorkspaceModelCache.getInstance((Project)project);
            GlobalWorkspaceModelCache globalCache = GlobalWorkspaceModelCache.Companion.getInstance();
            if (cache != null && globalCache != null) {
                cmdLine.addParameter("-Djps.workspace.storage.project.cache.path=" + String.valueOf(cache.getCacheFile()));
                cmdLine.addParameter("-Djps.workspace.storage.global.cache.path=" + String.valueOf(globalCache.cacheFile(InternalEnvironmentName.of((String)globalCacheId))));
                cmdLine.addParameter("-Djps.workspace.storage.relative.paths.in.cache=" + Registry.is((String)"ide.workspace.model.store.relative.paths.in.cache", (boolean)false));
            } else {
                LOG.info("Workspace model caches aren't available and won't be used in the build process");
            }
            cmdLine.addParameter("--add-opens=java.base/java.util=ALL-UNNAMED");
        }
        if (sdkVersion != null) {
            if (sdkVersion.compareTo((Enum)JavaSdkVersion.JDK_1_9) < 0) {
                cmdLine.addParameter("-Djava.endorsed.dirs=\"\"");
            }
            if (sdkVersion.isAtLeast(JavaSdkVersion.JDK_11)) {
                ClasspathBootstrap.configureReflectionOpenPackages(cmdLine::addParameter);
            }
        }
        if (this.IS_UNIT_TEST_MODE) {
            cmdLine.addParameter("-Dtest.mode=true");
        }
        if (requestProjectPreload) {
            cmdLine.addPathParameter("-Dpreload.project.path=", FileUtil.toCanonicalPath((String)BuildManager.getProjectPath(project)));
            cmdLine.addPathParameter("-Dpreload.config.path=", FileUtil.toCanonicalPath((String)PathManager.getOptionsPath()));
        }
        if (ProjectUtilCore.isExternalStorageEnabled((Project)project)) {
            Path externalProjectConfig = ProjectUtil.getExternalConfigurationDir((Project)project);
            if (!localProject) {
                try {
                    cmdLine.addPathParameter("-Dexternal.project.config=", cmdLine.syncProjectSpecificPathWithTarget(project, externalProjectConfig));
                }
                catch (NoSuchFileException cache) {
                }
                catch (FileSystemException err) {
                    throw new com.intellij.execution.ExecutionException(JavaCompilerBundle.message((String)"build.manager.launch.build.process.failed.to.copy.external.project.configuration", (Object[])new Object[0]), (Throwable)err);
                }
            } else {
                String pathToExternalStorage = externalProjectConfig.toString();
                cmdLine.addPathParameter("-Dexternal.project.config=", pathToExternalStorage);
            }
        }
        cmdLine.addParameter("-Dcompile.parallel=" + projectConfig.isParallelCompilationEnabled());
        if (projectConfig.isParallelCompilationEnabled() && !Registry.is((String)"compiler.automake.allow.parallel", (boolean)true)) {
            cmdLine.addParameter("-Dallow.parallel.automake=false");
        }
        cmdLine.addParameter("-Drebuild.on.dependency.change=" + config.REBUILD_ON_DEPENDENCY_CHANGE);
        cmdLine.addParameter("-Didea.IntToIntBtree.page.size=32768");
        if (Registry.is((String)"compiler.build.report.statistics")) {
            cmdLine.addParameter("-Djps.report.build.statistics=true");
        }
        if (Registry.is((String)"compiler.natural.int.multimap.impl")) {
            cmdLine.addParameter("-Djps.mappings.natural.int.multimap.impl=true");
        }
        cmdLine.addParameter("-Djdt.compiler.useSingleThread=true");
        cmdLine.addParameter("-Daether.connector.resumeDownloads=false");
        for (String option : userAdditionalOptionsList) {
            cmdLine.addParameter(option);
        }
        cmdLine.setupAdditionalVMOptions();
        Path hostWorkingDirectory = cmdLine.getHostWorkingDirectory();
        try {
            Files.createDirectories(hostWorkingDirectory, new FileAttribute[0]);
        }
        catch (IOException e2) {
            LOG.warn("Failed to create build working directory " + String.valueOf(hostWorkingDirectory), (Throwable)e2);
        }
        if (profileWithYourKit) {
            YourKitProfilerService service = (YourKitProfilerService)ApplicationManager.getApplication().getService(YourKitProfilerService.class);
            if (service != null) {
                try {
                    service.copyYKLibraries(hostWorkingDirectory);
                }
                catch (IOException e3) {
                    LOG.warn("Failed to copy YK libraries", (Throwable)e3);
                }
                StringBuilder parameters = new StringBuilder().append("-agentpath:").append(cmdLine.getYjpAgentPath(service)).append("=disablealloc,delay=10000,sessionname=ExternalBuild");
                String buildSnapshotPath = System.getProperty("build.snapshots.path");
                if (buildSnapshotPath != null) {
                    parameters.append(",dir=").append(buildSnapshotPath);
                }
                cmdLine.addParameter(parameters.toString());
                BuildManager.showSnapshotNotificationAfterFinish(project);
            } else {
                LOG.warn("Performance Plugin is missing or disabled; skipping YJP agent configuration");
                if (isAgentpathSet) {
                    BuildManager.showSnapshotNotificationAfterFinish(project);
                }
            }
        }
        String debugPort = null;
        if (this.myBuildProcessDebuggingEnabled) {
            debugPort = StringUtil.nullize((String)Registry.stringValue((String)"compiler.process.debug.port"));
            if (debugPort == null) {
                try {
                    debugPort = String.valueOf(NetUtils.findAvailableSocketPort());
                }
                catch (IOException e4) {
                    throw new com.intellij.execution.ExecutionException(JavaCompilerBundle.message((String)"build.process.no.free.debug.port", (Object[])new Object[0]), (Throwable)e4);
                }
            }
            cmdLine.addParameter("-XX:+HeapDumpOnOutOfMemoryError");
            cmdLine.addParameter("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=" + debugPort);
        }
        if (RegistryManager.getInstance().is("compiler.process.use.portable.caches") && CompilerCacheConfigurator.isServerUrlConfigured(project) && CompilerCacheStartupActivity.isLineEndingsConfiguredCorrectly()) {
            cmdLine.addParameter("-Dorg.jetbrains.jps.portable.caches=true");
        }
        if (AdvancedSettings.getBoolean((String)"compiler.unified.ic.implementation")) {
            cmdLine.addParameter("-Djps.use.dependency.graph=true");
        }
        if (Boolean.parseBoolean(System.getProperty("jps.track.library.dependencies", "false"))) {
            cmdLine.addParameter("-Djps.track.library.dependencies=true");
        }
        cmdLine.setCharset(this.mySystemCharset);
        cmdLine.addParameter("-Dfile.encoding=" + this.mySystemCharset.name());
        for (String name : INHERITED_IDE_VM_OPTIONS) {
            String value = System.getProperty(name);
            if (value == null) continue;
            cmdLine.addParameter("-D" + name + "=" + value);
        }
        for (String name : Set.of("intellij.test.jars.location", "intellij.test.jars.mapping.file")) {
            String value = System.getProperty(name);
            if (value == null) continue;
            cmdLine.addPathParameter("-D" + name + "=", value);
        }
        DynamicBundle.LanguageBundleEP languageBundle = LocalizationUtil.INSTANCE.findLanguageBundle();
        if (languageBundle != null) {
            String bundlePath;
            PluginDescriptor pluginDescriptor = languageBundle.pluginDescriptor;
            ClassLoader loader = pluginDescriptor == null ? null : pluginDescriptor.getClassLoader();
            String string2 = bundlePath = loader == null ? null : PathManager.getResourceRoot((ClassLoader)loader, (String)"META-INF/plugin.xml");
            if (bundlePath != null) {
                cmdLine.addParameter("-Djps.language.bundle=" + FileUtil.toSystemIndependentName((String)bundlePath));
            }
        }
        if (localProject) {
            cmdLine.addPathParameter("-Didea.home.path=", FileUtil.toSystemIndependentName((String)PathManager.getHomePath()));
            cmdLine.addPathParameter("-Didea.config.path=", FileUtil.toSystemIndependentName((String)PathManager.getConfigPath()));
            cmdLine.addPathParameter("-Didea.plugins.path=", FileUtil.toSystemIndependentName((String)PathManager.getPluginsPath()));
        }
        Path logPath = localProject ? BuildManager.getBuildLogDirectory().toAbsolutePath() : EelPathUtils.getSystemFolder((Project)project).resolve("logs");
        cmdLine.addPathParameter("-Djps.log.dir=", logPath);
        if (AdvancedSettings.getBoolean((String)"compiler.inMemoryLogger")) {
            cmdLine.addParameter("-Djps.use.in.memory.failed.build.logger=true");
        }
        if (Registry.is((String)"jps.report.registered.unexistent.output", (boolean)false)) {
            cmdLine.addParameter("-Djps.report.registered.unexistent.output=true");
        }
        String fallbackSdkHome = localProject ? System.getProperty("jps.fallback.jdk.home", null) : null;
        String string3 = fallbackSdkVersion = localProject ? System.getProperty("jps.fallback.jdk.version", null) : null;
        if (fallbackSdkHome == null || fallbackSdkVersion == null) {
            Object javaSdk;
            SdkTypeId sdkTypeId;
            Sdk sdk;
            Pair<Sdk, JavaSdkVersion> fallback = BuildManager.getForkedJavacFallbackSdk(project);
            Sdk sdk2 = sdk = fallback != null ? (Sdk)fallback.first : null;
            if (sdk != null && (sdkTypeId = sdk.getSdkType()) instanceof JavaSdkType && !FileUtil.pathsEqual((String)vmExecutablePath, (String)(javaSdk = (JavaSdkType)sdkTypeId).getVMExecutablePath(sdk))) {
                fallbackSdkHome = sdk.getHomePath();
                fallbackSdkVersion = ((JavaSdkVersion)fallback.second).getMaxLanguageLevel().getShortText();
            }
        }
        if (fallbackSdkHome != null && fallbackSdkVersion != null) {
            cmdLine.addPathParameter("-Djps.fallback.jdk.home=", fallbackSdkHome);
            cmdLine.addParameter("-Djps.fallback.jdk.version=" + fallbackSdkVersion);
        }
        cmdLine.addParameter("-Dio.netty.noUnsafe=true");
        Path projectSystemRoot = EelPathUtils.getSystemFolder((Project)project);
        Path projectTempDir = projectSystemRoot.resolve(TEMP_DIR_NAME);
        Files.createDirectories(projectTempDir, new FileAttribute[0]);
        cmdLine.addPathParameter("-Djava.io.tmpdir=", projectSystemRoot);
        for (BuildProcessParametersProvider provider : BuildProcessParametersProvider.EP_NAME.getExtensions((AreaInstance)project)) {
            for (String string4 : provider.getVMArguments()) {
                cmdLine.addParameter(string4);
            }
            for (Pair pair : provider.getPathParameters()) {
                try {
                    cmdLine.addPathParameter((String)pair.getFirst(), cmdLine.copyProjectSpecificPathToTargetIfRequired(project, (Path)pair.getSecond()));
                }
                catch (FileSystemException err) {
                    throw new com.intellij.execution.ExecutionException(JavaCompilerBundle.message((String)"build.manager.launch.build.process.failed.to.copy.parameter", (Object[])new Object[]{pair.getFirst()}), (Throwable)err);
                }
            }
        }
        cmdLine.addParameter("-Dide.propagate.context=false");
        cmdLine.addParameter("-Dintellij.platform.log.sync=true");
        Class<Launcher> launcherClass = Launcher.class;
        ArrayList<String> launcherCp = new ArrayList<String>();
        launcherCp.add(ClasspathBootstrap.getResourcePath(launcherClass));
        launcherCp.addAll(BuildProcessClasspathManager.getLauncherClasspath(project));
        if (compilerPath != null) {
            launcherCp.add(compilerPath);
        }
        boolean includeBundledEcj = BuildManager.shouldIncludeEclipseCompiler(projectConfig);
        Path path2 = null;
        if (includeBundledEcj && (path = EclipseCompilerConfiguration.getOptions((Project)project, EclipseCompilerConfiguration.class).ECJ_TOOL_PATH) != null && !path.isBlank()) {
            Path path3 = Path.of(path, new String[0]);
            if (Files.exists(path3, new LinkOption[0])) {
                includeBundledEcj = false;
            } else {
                throw new com.intellij.execution.ExecutionException(JavaCompilerBundle.message((String)"build.process.ecj.path.does.not.exist", (Object[])new Object[]{path3.toAbsolutePath()}));
            }
        }
        ClasspathBootstrap.appendJavaCompilerClasspath(launcherCp, (boolean)includeBundledEcj);
        if (var37_62 != null) {
            launcherCp.add(var37_62.toAbsolutePath().toString());
        }
        cmdLine.addParameter("-classpath");
        cmdLine.addClasspathParameter(launcherCp, List.of());
        cmdLine.addParameter(launcherClass.getName());
        List<String> cp = this.myClasspathManager.getBuildProcessClasspath(project);
        if (profileWithYourKit) {
            String yjpControllerFileName = "yjp-controller-api-redist.jar";
            Path yjpControllerPath = Path.of(cmdLine.getWorkingDirectory(), yjpControllerFileName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("JPS process profiling with YourKit is enabled, adding '" + (String)yjpControllerFileName + "' to classpath, full path '" + String.valueOf(yjpControllerPath) + "'");
            }
            if (!Files.exists(yjpControllerPath, new LinkOption[0])) {
                LOG.warn("JPS process profiling is enabled, but '" + String.valueOf(yjpControllerPath) + "' is missing");
            }
            cmdLine.addClasspathParameter(cp, Collections.singletonList(yjpControllerFileName));
        } else {
            cmdLine.addClasspathParameter(cp, List.of());
        }
        for (BuildProcessParametersProvider buildProcessParametersProvider : BuildProcessParametersProvider.EP_NAME.getExtensions((AreaInstance)project)) {
            for (String path22 : buildProcessParametersProvider.getAdditionalPluginPaths()) {
                try {
                    cmdLine.copyProjectSpecificPathToTargetIfRequired(project, Path.of(path22, new String[0]));
                }
                catch (FileSystemException err) {
                    throw new com.intellij.execution.ExecutionException(JavaCompilerBundle.message((String)"build.manager.launch.build.process.failed.to.copy.additional.plugin", (Object[])new Object[0]), (Throwable)err);
                }
            }
        }
        cmdLine.addParameter(BuildMain.class.getName());
        cmdLine.addParameter(buildProcessConnectHost);
        cmdLine.addParameter(Integer.toString(buildProcessConnectPort));
        cmdLine.addParameter(sessionId.toString());
        cmdLine.addParameter(cmdLine.getWorkingDirectory());
        boolean lowPriority = AdvancedSettings.getBoolean((String)"compiler.lower.process.priority");
        if (localProject && OS.CURRENT != OS.Windows && lowPriority) {
            cmdLine.setUnixProcessPriority(10);
        }
        if (localProject && OS.CURRENT == OS.Linux && Registry.is((String)"compiler.process.new.session", (boolean)true)) {
            cmdLine.setStartNewSession();
        }
        try {
            ((BuildManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BuildManagerListener.TOPIC)).beforeBuildProcessStarted(project, sessionId);
        }
        catch (Throwable e5) {
            LOG.error(e5);
        }
        OSProcessHandler processHandler = new OSProcessHandler(cmdLine.buildCommandLine()){

            protected boolean shouldDestroyProcessRecursively() {
                return true;
            }

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = BaseOutputReader.Options.BLOCKING;
                if (options == null) {
                    5.$$$reportNull$$$0(0);
                }
                return options;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/server/BuildManager$5", "readerOptions"));
            }
        };
        processHandler.addProcessListener(new ProcessListener(this){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String text;
                if (event == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (!StringUtil.isEmptyOrSpaces((String)(text = event.getText()))) {
                    if (ProcessOutputTypes.SYSTEM.equals((Object)outputType)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("BUILDER_PROCESS [" + String.valueOf(outputType) + "]: " + text.trim());
                        }
                    } else {
                        LOG.info("BUILDER_PROCESS [" + String.valueOf(outputType) + "]: " + text.trim());
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/compiler/server/BuildManager$6";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (debugPort != null) {
            processHandler.putUserData(COMPILER_PROCESS_DEBUG_HOST_PORT, (Object)debugPort);
        }
        if (localProject && SystemInfo.isWindows && lowPriority) {
            try {
                WinProcess winProcess = new WinProcess((int)processHandler.getProcess().pid());
                winProcess.setPriority(64);
            }
            catch (UnsupportedOperationException winProcess) {
            }
            catch (Throwable e6) {
                LOG.error("Cannot set priority", e6);
            }
        }
        return processHandler;
    }

    private static void attachJnaBootLibraryIfNeeded(@NotNull Project project, @NotNull BuildCommandLineBuilder cmdLine) {
        if (project == null) {
            BuildManager.$$$reportNull$$$0(40);
        }
        if (cmdLine == null) {
            BuildManager.$$$reportNull$$$0(41);
        }
        if (!(EelProviderUtil.getEelDescriptor((Project)project) instanceof LocalEelDescriptor)) {
            return;
        }
        String jnaBootLibraryPath = System.getProperty("jna.boot.library.path");
        if (jnaBootLibraryPath != null) {
            cmdLine.addPathParameter("-Djna.boot.library.path=", jnaBootLibraryPath);
            cmdLine.addParameter("-Djna.nosys=true");
            cmdLine.addParameter("-Djna.noclasspath=true");
        }
    }

    private static void showSnapshotNotificationAfterFinish(@NotNull Project project) {
        if (project == null) {
            BuildManager.$$$reportNull$$$0(42);
        }
        final MessageBusConnection busConnection = project.getMessageBus().connect();
        busConnection.subscribe(BuildManagerListener.TOPIC, (Object)new BuildManagerListener(){

            @Override
            public void buildFinished(@NotNull Project project, @NotNull UUID sessionId, boolean isAutomake) {
                if (project == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (sessionId == null) {
                    7.$$$reportNull$$$0(1);
                }
                busConnection.disconnect();
                final Notification notification = new Notification("Build Profiler", JavaCompilerBundle.message((String)"notification.title.cpu.snapshot.build.has.been.captured", (Object[])new Object[0]), NotificationType.INFORMATION);
                notification.addAction((AnAction)new DumbAwareAction(this, JavaCompilerBundle.message((String)"action.show.snapshot.location.text", (Object[])new Object[0])){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        RevealFileAction.openDirectory((Path)Path.of(SystemProperties.getUserHome(), "Snapshots"));
                        notification.expire();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/compiler/server/BuildManager$7$1", "actionPerformed"));
                    }
                });
                Notifications.Bus.notify((Notification)notification, (Project)project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "sessionId";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/compiler/server/BuildManager$7";
                objectArray[2] = "buildFinished";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean shouldIncludeEclipseCompiler(CompilerConfiguration config) {
        if (config instanceof CompilerConfigurationImpl) {
            BackendCompiler javaCompiler = ((CompilerConfigurationImpl)config).getDefaultCompiler();
            String compilerId = javaCompiler != null ? javaCompiler.getId() : null;
            return "Eclipse".equals(compilerId) || "EclipseEmbedded".equals(compilerId);
        }
        return true;
    }

    @NotNull
    public Path getBuildSystemDirectory(Project project) {
        if (!EelPathUtils.isProjectLocal((Project)project)) {
            Path path = EelPathUtils.getSystemFolder((Project)project).resolve(SYSTEM_ROOT);
            if (path == null) {
                BuildManager.$$$reportNull$$$0(43);
            }
            return path;
        }
        Path path = LocalBuildCommandLineBuilder.getLocalBuildSystemDirectory();
        if (path == null) {
            BuildManager.$$$reportNull$$$0(44);
        }
        return path;
    }

    @NotNull
    public static Path getBuildLogDirectory() {
        Path path = PathManager.getLogDir().resolve("build-log");
        if (path == null) {
            BuildManager.$$$reportNull$$$0(45);
        }
        return path;
    }

    @NotNull
    public Path getProjectSystemDir(@NotNull Project project) {
        if (project == null) {
            BuildManager.$$$reportNull$$$0(46);
        }
        Path path = this.getProjectSystemDirectory(project).toPath();
        if (path == null) {
            BuildManager.$$$reportNull$$$0(47);
        }
        return path;
    }

    @ApiStatus.Obsolete
    @NotNull
    public File getProjectSystemDirectory(@NotNull Project project) {
        Function<String, Integer> hashFunction;
        if (project == null) {
            BuildManager.$$$reportNull$$$0(48);
        }
        String projectPath = BuildManager.getProjectPath(project);
        if (!EelPathUtils.isProjectLocal((Project)project)) {
            EelDescriptor descriptor = EelProviderUtil.getEelDescriptor((Project)project);
            hashFunction = s -> {
                try {
                    return EelNioBridgeServiceKt.asEelPath((Path)Path.of(s, new String[0]), (EelDescriptor)descriptor).toString().hashCode();
                }
                catch (Throwable e) {
                    return s.hashCode();
                }
            };
        } else {
            hashFunction = String::hashCode;
        }
        File file = Utils.getDataStorageRoot((File)this.getBuildSystemDirectory(project).toFile(), (String)projectPath, hashFunction);
        if (file == null) {
            BuildManager.$$$reportNull$$$0(49);
        }
        return file;
    }

    private static Path getUsageFile(Path projectSystemDir) {
        return projectSystemDir.resolve("ustamp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateUsageFile(@Nullable Project project, Path projectSystemDir) {
        Path usageFile = BuildManager.getUsageFile(projectSystemDir);
        StringBuilder content = new StringBuilder();
        try {
            String projectFilePath;
            DateTimeFormatter dateTimeFormatter = USAGE_STAMP_DATE_FORMAT;
            synchronized (dateTimeFormatter) {
                content.append(USAGE_STAMP_DATE_FORMAT.format(LocalDate.now()));
            }
            if (project != null && !project.isDisposed() && (projectFilePath = project.getProjectFilePath()) != null && !projectFilePath.isBlank()) {
                content.append("\n").append(FileUtil.toCanonicalPath((String)projectFilePath));
            }
            NioFiles.createParentDirectories((Path)usageFile);
            Files.writeString(usageFile, (CharSequence)content.toString(), new OpenOption[0]);
        }
        catch (Throwable e) {
            LOG.info(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Pair<LocalDate, Path> readUsageFile(Path usageFile) {
        block5: {
            try {
                LocalDate date;
                List<String> lines = Files.readAllLines(usageFile);
                if (lines.isEmpty()) break block5;
                String dateString = lines.getFirst();
                DateTimeFormatter dateTimeFormatter = USAGE_STAMP_DATE_FORMAT;
                synchronized (dateTimeFormatter) {
                    date = LocalDate.from(USAGE_STAMP_DATE_FORMAT.parse(dateString));
                }
                Path projectFile = lines.size() > 1 ? Path.of(lines.get(1), new String[0]) : null;
                return new Pair((Object)date, (Object)projectFile);
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
        return null;
    }

    private synchronized void stopListening() {
        for (ListeningConnection connection : this.myListeningConnections) {
            connection.myChannelRegistrar.close();
        }
        this.myListeningConnections.clear();
    }

    private int startListening(InetAddress address) {
        int port;
        final ListeningConnection listeningConnection = new ListeningConnection(address);
        BuiltInServerManager builtInServerManager = BuiltInServerManager.getInstance();
        builtInServerManager.waitForStart();
        ServerBootstrap bootstrap = ((BuiltInServerManagerImpl)builtInServerManager).createServerBootstrap();
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(@NotNull Channel channel) {
                if (channel == null) {
                    8.$$$reportNull$$$0(0);
                }
                channel.pipeline().addLast(new ChannelHandler[]{listeningConnection.myChannelRegistrar, new ProtobufVarint32FrameDecoder(), new ProtobufDecoder((MessageLite)CmdlineRemoteProto.Message.getDefaultInstance()), new ProtobufVarint32LengthFieldPrepender(), new ProtobufEncoder(), BuildManager.this.myMessageDispatcher});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "com/intellij/compiler/server/BuildManager$8", "initChannel"));
            }
        });
        Channel serverChannel = bootstrap.bind(address, 0).syncUninterruptibly().channel();
        listeningConnection.myChannelRegistrar.setServerChannel(serverChannel, false);
        listeningConnection.myListenPort = port = ((InetSocketAddress)serverChannel.localAddress()).getPort();
        this.myListeningConnections.add(listeningConnection);
        return port;
    }

    public boolean isBuildProcessDebuggingEnabled() {
        return this.myBuildProcessDebuggingEnabled;
    }

    public void setBuildProcessDebuggingEnabled(boolean buildProcessDebuggingEnabled) {
        this.myBuildProcessDebuggingEnabled = buildProcessDebuggingEnabled;
        if (this.myBuildProcessDebuggingEnabled) {
            this.cancelAllPreloadedBuilds();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 7, 8, 10, 11, 16, 17, 22, 25, 29, 32, 35, 36, 43, 44, 45, 47, 49 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 1: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registryManager";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 22: 
            case 25: 
            case 29: 
            case 32: 
            case 35: 
            case 36: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/server/BuildManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 5: 
            case 9: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 26: 
            case 27: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/server/BuildManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenProjects";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMapperForProject";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectPath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadTrace";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "cancelAutoMakeTasks";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleBuild";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectData";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkFilter";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeSdk";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildSystemDirectory";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildLogDirectory";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSystemDir";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSystemDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "configureIdleAutomake";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 22: 
            case 25: 
            case 29: 
            case 32: 
            case 35: 
            case 36: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runCommand";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findProjectByProjectPath";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPathMapperForProject";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "clearState";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isProjectWatched";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFilesChangedSinceLastCompilation";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getProjectPath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAutomakeWhileIdleTimeout";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "canStartAutoMake";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "hasRunningProcess";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "cancelAutoMakeTasks";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "cancelPreloadedBuilds";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "notifySessionTerminationIfNeeded";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "handleProcessExecutionFailure";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getProjectData";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getBuildProcessRuntimeSdk";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getSdkFilter";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getJavacRuntimeSdk";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getRuntimeSdk";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getIDERuntimeSdkOrErrorIfRemote";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "launchBuildProcess";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "attachJnaBootLibraryIfNeeded";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "showSnapshotNotificationAfterFinish";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getProjectSystemDir";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getProjectSystemDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 7, 8, 10, 11, 16, 17, 22, 25, 29, 32, 35, 36, 43, 44, 45, 47, 49 -> new IllegalStateException(string);
        };
    }

    private abstract class BuildManagerPeriodicTask
    implements Runnable {
        private final Alarm myAlarm;
        private final AtomicBoolean myInProgress;
        private final Runnable myTaskRunnable;
        private final CoroutineScope myCoroutineScope;

        BuildManagerPeriodicTask(CoroutineScope coroutineScope) {
            if (coroutineScope == null) {
                BuildManagerPeriodicTask.$$$reportNull$$$0(0);
            }
            this.myInProgress = new AtomicBoolean(false);
            this.myTaskRunnable = () -> {
                try {
                    this.runTask();
                }
                finally {
                    this.myInProgress.set(false);
                }
            };
            this.myCoroutineScope = coroutineScope;
            this.myAlarm = new Alarm(coroutineScope, Alarm.ThreadToUse.POOLED_THREAD);
        }

        final void schedule() {
            this.schedule(false);
        }

        private void schedule(boolean increasedDelay) {
            this.cancelPendingExecution();
            this.myAlarm.addRequest((Runnable)this, Math.max(100, increasedDelay ? 10 * this.getDelay() : this.getDelay()));
        }

        void cancelPendingExecution() {
            this.myAlarm.cancelAllRequests();
        }

        protected boolean shouldPostpone() {
            return false;
        }

        protected abstract int getDelay();

        protected abstract void runTask();

        @Override
        public final void run() {
            boolean shouldPostponeAllTasks;
            boolean bl = shouldPostponeAllTasks = HeavyProcessLatch.INSTANCE.isRunning() || BuildManager.this.mySuspendBackgroundTasksCounter.get() > 0;
            if (!(shouldPostponeAllTasks || this.shouldPostpone() || this.myInProgress.getAndSet(true))) {
                try {
                    AppJavaExecutorUtil.executeOnPooledIoThread((CoroutineScope)this.myCoroutineScope, (Runnable)this.myTaskRunnable);
                }
                catch (CancellationException ignored) {
                    this.myInProgress.set(false);
                }
                catch (Throwable e) {
                    this.myInProgress.set(false);
                    throw new RuntimeException(e);
                }
            } else {
                this.schedule(shouldPostponeAllTasks);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coroutineScope", "com/intellij/compiler/server/BuildManager$BuildManagerPeriodicTask", "<init>"));
        }
    }

    private final class ProjectWatcher
    implements ProjectCloseListener {
        private ProjectWatcher() {
        }

        public void projectClosingBeforeSave(@NotNull Project project) {
            if (project == null) {
                ProjectWatcher.$$$reportNull$$$0(0);
            }
            BuildManager.this.myAutoMakeTask.cancelPendingExecution();
            BuildManager.this.cancelAutoMakeTasks(project);
        }

        public void projectClosing(final @NotNull Project project) {
            if (project == null) {
                ProjectWatcher.$$$reportNull$$$0(1);
            }
            final String projectPath = BuildManager.getProjectPath(project);
            ProgressManager.getInstance().run((Task)new Task.Modal(project, JavaCompilerBundle.message((String)"progress.title.cancelling.running.builds", (Object[])new Object[0]), false){

                public void run(@NotNull ProgressIndicator indicator) {
                    TaskFuture currentBuild;
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((currentBuild = (TaskFuture)BuildManager.this.myBuildsInProgress.get(projectPath)) != null) {
                        currentBuild.cancel(false);
                    }
                    BuildManager.this.myAutoMakeTask.cancelPendingExecution();
                    BuildManager.this.cancelPreloadedBuilds(projectPath);
                    for (TaskFuture<?> future : BuildManager.this.cancelAutoMakeTasks(project)) {
                        future.waitFor(500L, TimeUnit.MILLISECONDS);
                    }
                    if (currentBuild != null) {
                        currentBuild.waitFor(15L, TimeUnit.SECONDS);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/compiler/server/BuildManager$ProjectWatcher$1", "run"));
                }
            });
        }

        public void projectClosed(@NotNull Project project) {
            if (project == null) {
                ProjectWatcher.$$$reportNull$$$0(2);
            }
            if (BuildManager.this.myProjectDataMap.remove(BuildManager.getProjectPath(project)) != null && BuildManager.this.myProjectDataMap.isEmpty()) {
                InternedPath.clearCache();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/intellij/compiler/server/BuildManager$ProjectWatcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectClosingBeforeSave";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectClosing";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectClosed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ProjectData {
        @NotNull
        final ExecutorService taskQueue;
        private final Set<InternedPath> myChanged;
        private final Set<InternedPath> myDeleted;
        private long myNextEventOrdinal;
        private boolean myNeedRescan;

        private ProjectData(@NotNull ExecutorService taskQueue) {
            if (taskQueue == null) {
                ProjectData.$$$reportNull$$$0(0);
            }
            this.myChanged = new HashSet<InternedPath>();
            this.myDeleted = new HashSet<InternedPath>();
            this.myNeedRescan = true;
            this.taskQueue = taskQueue;
        }

        boolean hasChanges() {
            return this.myNeedRescan || !this.myChanged.isEmpty() || !this.myDeleted.isEmpty();
        }

        boolean addChanged(Iterable<InternedPath> paths) {
            boolean changes = false;
            if (!this.myNeedRescan) {
                for (InternedPath path : paths) {
                    changes |= this.myDeleted.remove(path);
                    changes |= this.myChanged.add(path);
                }
            }
            return changes;
        }

        boolean addDeleted(Iterable<InternedPath> paths) {
            boolean changes = false;
            if (!this.myNeedRescan) {
                for (InternedPath path : paths) {
                    changes |= this.myChanged.remove(path);
                    changes |= this.myDeleted.add(path);
                }
            }
            return changes;
        }

        CmdlineRemoteProto.Message.ControllerMessage.FSEvent createNextEvent(Function<String, String> pathMapper) {
            CmdlineRemoteProto.Message.ControllerMessage.FSEvent.Builder builder = CmdlineRemoteProto.Message.ControllerMessage.FSEvent.newBuilder();
            builder.setOrdinal(++this.myNextEventOrdinal);
            for (InternedPath path : this.myChanged) {
                builder.addChangedPaths(pathMapper.apply(path.getValue()));
            }
            this.myChanged.clear();
            for (InternedPath path : this.myDeleted) {
                builder.addDeletedPaths(pathMapper.apply(path.getValue()));
            }
            this.myDeleted.clear();
            return (CmdlineRemoteProto.Message.ControllerMessage.FSEvent)builder.build();
        }

        boolean getAndResetRescanFlag() {
            boolean rescan = this.myNeedRescan;
            this.myNeedRescan = false;
            return rescan;
        }

        void dropChanges() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Project build state cleared: " + BuildManager.getThreadTrace(Thread.currentThread(), 20));
            }
            this.myNeedRescan = true;
            this.myNextEventOrdinal = 0L;
            this.myChanged.clear();
            this.myDeleted.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskQueue", "com/intellij/compiler/server/BuildManager$ProjectData", "<init>"));
        }
    }

    private static final class NotifyingMessageHandler
    extends DelegatingMessageHandler {
        private final Project myProject;
        private final BuilderMessageHandler myDelegateHandler;
        @Nullable
        private final Function<String, String> myPathMapper;
        private final boolean myIsAutomake;

        NotifyingMessageHandler(@NotNull Project project, @NotNull BuilderMessageHandler delegateHandler, @Nullable Function<String, String> pathMapper, boolean isAutomake) {
            if (project == null) {
                NotifyingMessageHandler.$$$reportNull$$$0(0);
            }
            if (delegateHandler == null) {
                NotifyingMessageHandler.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myDelegateHandler = delegateHandler;
            this.myPathMapper = pathMapper;
            this.myIsAutomake = isAutomake;
        }

        @Override
        protected BuilderMessageHandler getDelegateHandler() {
            return this.myDelegateHandler;
        }

        @Override
        public void buildStarted(@NotNull UUID sessionId) {
            if (sessionId == null) {
                NotifyingMessageHandler.$$$reportNull$$$0(2);
            }
            super.buildStarted(sessionId);
            try {
                ((BuildManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BuildManagerListener.TOPIC)).buildStarted(this.myProject, sessionId, this.myIsAutomake);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        @Override
        public void sessionTerminated(@NotNull UUID sessionId) {
            if (sessionId == null) {
                NotifyingMessageHandler.$$$reportNull$$$0(3);
            }
            try {
                super.sessionTerminated(sessionId);
            }
            finally {
                try {
                    ((BuildManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BuildManagerListener.TOPIC)).buildFinished(this.myProject, sessionId, this.myIsAutomake);
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }

        @Override
        public void handleBuildMessage(Channel channel, UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage msg) {
            CmdlineRemoteProto.Message.BuilderMessage _message = msg;
            if (this.myPathMapper != null) {
                CmdlineRemoteProto.Message.BuilderMessage.BuildEvent buildEvent;
                int filesCount;
                CmdlineRemoteProto.Message.BuilderMessage.CompileMessage compileMessage;
                if (_message.hasCompileMessage() && (compileMessage = _message.getCompileMessage()).hasSourceFilePath()) {
                    CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Builder builder = CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.newBuilder((CmdlineRemoteProto.Message.BuilderMessage.CompileMessage)compileMessage);
                    builder.setSourceFilePath(this.myPathMapper.apply(compileMessage.getSourceFilePath()));
                    _message = (CmdlineRemoteProto.Message.BuilderMessage)CmdlineRemoteProto.Message.BuilderMessage.newBuilder((CmdlineRemoteProto.Message.BuilderMessage)_message).setCompileMessage(builder).build();
                }
                if (_message.hasBuildEvent() && (filesCount = (buildEvent = _message.getBuildEvent()).getGeneratedFilesCount()) > 0) {
                    CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Builder builder = CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.newBuilder((CmdlineRemoteProto.Message.BuilderMessage.BuildEvent)buildEvent);
                    for (int idx = 0; idx < filesCount; ++idx) {
                        CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.GeneratedFile file = buildEvent.getGeneratedFiles(idx);
                        builder.setGeneratedFiles(idx, CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.GeneratedFile.newBuilder((CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.GeneratedFile)file).setOutputRoot(this.myPathMapper.apply(file.getOutputRoot())));
                    }
                    _message = (CmdlineRemoteProto.Message.BuilderMessage)CmdlineRemoteProto.Message.BuilderMessage.newBuilder((CmdlineRemoteProto.Message.BuilderMessage)_message).setBuildEvent(builder).build();
                }
            }
            super.handleBuildMessage(channel, sessionId, _message);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegateHandler";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sessionId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/compiler/server/BuildManager$NotifyingMessageHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildStarted";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sessionTerminated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class DelegateFuture
    implements TaskFuture<Void> {
        private List<TaskFuture<?>> myDelegates;
        private Boolean myRequestedCancelState;

        private DelegateFuture() {
        }

        @NotNull
        private synchronized List<TaskFuture<?>> getDelegates() {
            List<TaskFuture<?>> delegates = this.myDelegates;
            while (delegates == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                delegates = this.myDelegates;
            }
            List<TaskFuture<?>> list = delegates;
            if (list == null) {
                DelegateFuture.$$$reportNull$$$0(0);
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean setDelegates(@NotNull List<TaskFuture<?>> delegates) {
            if (delegates == null) {
                DelegateFuture.$$$reportNull$$$0(1);
            }
            if (this.myDelegates == null) {
                try {
                    this.myDelegates = delegates;
                    if (this.myRequestedCancelState != null) {
                        for (TaskFuture<?> delegate : delegates) {
                            delegate.cancel(this.myRequestedCancelState.booleanValue());
                        }
                    }
                }
                finally {
                    this.notifyAll();
                }
                return true;
            }
            return false;
        }

        public synchronized boolean cancel(boolean mayInterruptIfRunning) {
            List<TaskFuture<?>> delegates = this.myDelegates;
            if (delegates == null) {
                this.myRequestedCancelState = mayInterruptIfRunning;
                return true;
            }
            boolean cancelled = false;
            for (TaskFuture<?> delegate : delegates) {
                cancelled |= delegate.cancel(mayInterruptIfRunning);
            }
            return cancelled;
        }

        public void waitFor() {
            for (TaskFuture<?> delegate : this.getDelegates()) {
                delegate.waitFor();
            }
        }

        public boolean waitFor(long timeout, TimeUnit unit) {
            for (TaskFuture<?> delegate : this.getDelegates()) {
                delegate.waitFor(timeout, unit);
            }
            return this.isDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCancelled() {
            List<TaskFuture<?>> delegates;
            DelegateFuture delegateFuture = this;
            synchronized (delegateFuture) {
                delegates = this.myDelegates;
                if (delegates == null) {
                    return this.myRequestedCancelState != null;
                }
            }
            for (TaskFuture taskFuture : delegates) {
                if (!taskFuture.isCancelled()) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDone() {
            List<TaskFuture<?>> delegates;
            DelegateFuture delegateFuture = this;
            synchronized (delegateFuture) {
                delegates = this.myDelegates;
                if (delegates == null) {
                    return false;
                }
            }
            for (TaskFuture taskFuture : delegates) {
                if (taskFuture.isDone()) continue;
                return false;
            }
            return true;
        }

        public Void get() throws InterruptedException, ExecutionException {
            for (Future future : this.getDelegates()) {
                future.get();
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public Void get(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            void unit;
            if (timeUnit == null) {
                DelegateFuture.$$$reportNull$$$0(2);
            }
            ConcurrencyUtil.getAll((long)timeout, (TimeUnit)unit, this.getDelegates());
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/compiler/server/BuildManager$DelegateFuture";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegates";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegates";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/compiler/server/BuildManager$DelegateFuture";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setDelegates";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class ListeningConnection {
        private final InetAddress myAddress;
        private final ChannelRegistrar myChannelRegistrar = new ChannelRegistrar();
        private volatile int myListenPort = -1;

        private ListeningConnection(InetAddress address) {
            this.myAddress = address;
        }
    }

    @Service(value={Service.Level.PROJECT})
    private static final class ProjectDisposableService
    implements Disposable {
        private ProjectDisposableService() {
        }

        @NotNull
        static ProjectDisposableService getInstance(@NotNull Project project) {
            if (project == null) {
                ProjectDisposableService.$$$reportNull$$$0(0);
            }
            ProjectDisposableService projectDisposableService = (ProjectDisposableService)project.getService(ProjectDisposableService.class);
            if (projectDisposableService == null) {
                ProjectDisposableService.$$$reportNull$$$0(1);
            }
            return projectDisposableService;
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/compiler/server/BuildManager$ProjectDisposableService";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/compiler/server/BuildManager$ProjectDisposableService";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getInstance";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private class CancelBuildSessionAction<T extends BuilderMessageHandler>
    implements RequestFuture.CancelAction<T> {
        private CancelBuildSessionAction() {
        }

        public void cancel(RequestFuture<T> future) {
            BuildManager.this.myMessageDispatcher.cancelSession(future.getRequestID());
            BuildManager.this.notifySessionTerminationIfNeeded(future.getRequestID(), null);
        }
    }

    private static final class StdOutputCollector
    implements ProcessListener {
        private final Appendable myOutput;
        private int myStoredLength;

        StdOutputCollector(@NotNull Appendable outputSink) {
            if (outputSink == null) {
                StdOutputCollector.$$$reportNull$$$0(0);
            }
            this.myOutput = outputSink;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            String text;
            if (event == null) {
                StdOutputCollector.$$$reportNull$$$0(1);
            }
            if (outputType == null) {
                StdOutputCollector.$$$reportNull$$$0(2);
            }
            StdOutputCollector stdOutputCollector = this;
            synchronized (stdOutputCollector) {
                if (this.myStoredLength > 16384) {
                    return;
                }
                text = event.getText();
                if (StringUtil.isEmptyOrSpaces((String)text)) {
                    return;
                }
                this.myStoredLength += text.length();
            }
            try {
                this.myOutput.append(text);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputSink";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/compiler/server/BuildManager$StdOutputCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTextAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static sealed interface Changes {
        public static Changes createIncomplete() {
            return Incomplete.instance;
        }

        public static final class Incomplete
        implements Changes {
            public static final Incomplete instance = new Incomplete();
        }

        public record Paths(Iterable<InternedPath> deleted, Iterable<InternedPath> changed) implements Changes
        {
        }
    }

    static final class MyDocumentListener
    implements DocumentListener {
        MyDocumentListener() {
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                MyDocumentListener.$$$reportNull$$$0(0);
            }
            if (ApplicationManager.getApplication().isUnitTestMode() || !Registry.is((String)"compiler.document.save.enabled", (boolean)false)) {
                return;
            }
            Document document = e.getDocument();
            if (!FileDocumentManager.getInstance().isDocumentUnsaved(document)) {
                return;
            }
            VirtualFile file = FileDocumentManager.getInstance().getFile(document);
            if (file != null && file.isInLocalFileSystem()) {
                BuildManager.getInstance().scheduleProjectSave();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/compiler/server/BuildManager$MyDocumentListener", "documentChanged"));
        }
    }

    static final class BuildManagerStartupActivity
    implements StartupActivity,
    DumbAware {
        BuildManagerStartupActivity() {
            if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                throw ExtensionNotApplicableException.create();
            }
        }

        public void runActivity(final @NotNull Project project) {
            if (project == null) {
                BuildManagerStartupActivity.$$$reportNull$$$0(0);
            }
            MessageBusConnection connection = project.getMessageBus().connect();
            connection.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(this){

                public void processStarting(@NotNull String executorId, @NotNull ExecutionEnvironment env) {
                    if (executorId == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (env == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    BuildManager.getInstance().cancelAutoMakeTasks(env.getProject());
                }

                public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
                    if (executorId == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (env == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (handler == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    BuildManager.getInstance().cancelAutoMakeTasks(env.getProject());
                }

                public void processNotStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env) {
                    if (executorId == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    if (env == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    BuildManager.getInstance().scheduleAutoMake();
                }

                public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler, int exitCode) {
                    if (executorId == null) {
                        1.$$$reportNull$$$0(7);
                    }
                    if (env == null) {
                        1.$$$reportNull$$$0(8);
                    }
                    if (handler == null) {
                        1.$$$reportNull$$$0(9);
                    }
                    BuildManager.getInstance().scheduleAutoMake();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "executorId";
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 6: 
                        case 8: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "env";
                            break;
                        }
                        case 4: 
                        case 9: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "handler";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/compiler/server/BuildManager$BuildManagerStartupActivity$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processStarting";
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processStarted";
                            break;
                        }
                        case 5: 
                        case 6: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processNotStarted";
                            break;
                        }
                        case 7: 
                        case 8: 
                        case 9: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            connection.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new CompilationStatusListener(){
                private final Set<String> myRootsToRefresh = CollectionFactory.createFilePathSet();

                public void automakeCompilationFinished(int errors, int warnings, @NotNull CompileContext compileContext) {
                    if (compileContext == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (!compileContext.getProgressIndicator().isCanceled()) {
                        this.refreshSources(compileContext);
                    }
                }

                public void compilationFinished(boolean aborted, int errors, int warnings, @NotNull CompileContext compileContext) {
                    if (compileContext == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    this.refreshSources(compileContext);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void refreshSources(CompileContext compileContext) {
                    if (project.isDisposed()) {
                        return;
                    }
                    Set candidates = CollectionFactory.createFilePathSet();
                    Set<String> set = this.myRootsToRefresh;
                    synchronized (set) {
                        candidates.addAll(this.myRootsToRefresh);
                        this.myRootsToRefresh.clear();
                    }
                    if (candidates.isEmpty() && !compileContext.isAnnotationProcessorsEnabled()) {
                        return;
                    }
                    BackgroundTaskUtil.submitTask((Disposable)ProjectDisposableService.getInstance(project), () -> {
                        if (project.isDisposed()) {
                            return;
                        }
                        if (compileContext.isAnnotationProcessorsEnabled()) {
                            CompilerConfiguration config = CompilerConfiguration.getInstance((Project)project);
                            try {
                                for (Module module : (Module[])ReadAction.nonBlocking(() -> compileContext.getCompileScope().getAffectedModules()).executeSynchronously()) {
                                    String testsPath;
                                    if (project.isDisposed()) {
                                        return;
                                    }
                                    if (module.isDisposed() || !config.getAnnotationProcessingConfiguration(module).isEnabled()) continue;
                                    String productionPath = CompilerPaths.getAnnotationProcessorsGenerationPath((Module)module, (boolean)false);
                                    if (productionPath != null) {
                                        candidates.add(productionPath);
                                    }
                                    if ((testsPath = CompilerPaths.getAnnotationProcessorsGenerationPath((Module)module, (boolean)true)) == null) continue;
                                    candidates.add(testsPath);
                                }
                            }
                            catch (ProcessCanceledException processCanceledException) {
                            }
                            catch (Throwable e) {
                                LOG.info(e);
                            }
                        }
                        if (candidates.isEmpty()) {
                            return;
                        }
                        CompilerUtil.refreshOutputRoots(candidates);
                        LocalFileSystem lfs = LocalFileSystem.getInstance();
                        try {
                            Collection toRefresh = (Collection)ReadAction.nonBlocking(() -> {
                                if (project.isDisposed()) {
                                    return Collections.emptySet();
                                }
                                ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                                return candidates.stream().map(arg_0 -> ((LocalFileSystem)lfs).findFileByPath(arg_0)).filter(root -> root != null && fileIndex.isInSourceContent(root)).collect(Collectors.toSet());
                            }).executeSynchronously();
                            if (!toRefresh.isEmpty()) {
                                lfs.refreshFiles((Iterable)toRefresh, true, true, null);
                            }
                        }
                        catch (ProcessCanceledException toRefresh) {
                        }
                        catch (Throwable e) {
                            LOG.info(e);
                        }
                    });
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fileGenerated(@NotNull String outputRoot, @NotNull String relativePath) {
                    if (outputRoot == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (relativePath == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    Set<String> set = this.myRootsToRefresh;
                    synchronized (set) {
                        this.myRootsToRefresh.add(outputRoot);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "compileContext";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputRoot";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "relativePath";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/compiler/server/BuildManager$BuildManagerStartupActivity$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "automakeCompilationFinished";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "compilationFinished";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "fileGenerated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            String projectPath = BuildManager.getProjectPath(project);
            Disposer.register((Disposable)ProjectDisposableService.getInstance(project), () -> {
                BuildManager buildManager = BuildManager.getInstance();
                buildManager.cancelPreloadedBuilds(projectPath);
                buildManager.myProjectDataMap.remove(projectPath);
            });
            BuildProcessParametersProvider.EP_NAME.addChangeListener((AreaInstance)project, () -> BuildManager.getInstance().cancelAllPreloadedBuilds(), null);
            BuildManager.getInstance().runCommand(() -> {
                try {
                    BackgroundTaskUtil.submitTask((Disposable)ProjectDisposableService.getInstance(project), () -> BuildManager.updateUsageFile(project, BuildManager.getInstance().getProjectSystemDir(project))).awaitCompletion();
                }
                catch (ExecutionException e) {
                    ExceptionUtil.rethrowAllAsUnchecked((Throwable)e.getCause());
                }
            });
            BuildManager.getInstance().scheduleAutoMake();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/server/BuildManager$BuildManagerStartupActivity", "runActivity"));
        }
    }
}

