/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ArtifactPointer;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ArtifactPointerImpl
implements ArtifactPointer {
    @NotNull
    private final Project myProject;
    @NotNull
    private volatile String myName;
    private volatile AtomicReference<Artifact> myArtifact;

    ArtifactPointerImpl(@NotNull String name, @NotNull Project project) {
        if (name == null) {
            ArtifactPointerImpl.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ArtifactPointerImpl.$$$reportNull$$$0(1);
        }
        this.myName = name;
        this.myProject = project;
    }

    @NotNull
    public String getArtifactName() {
        String string = this.myName;
        if (string == null) {
            ArtifactPointerImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public Artifact getArtifact() {
        AtomicReference<Artifact> artifact = this.myArtifact;
        if (artifact == null) {
            this.myArtifact = artifact = new AtomicReference<Artifact>(ArtifactManager.getInstance((Project)this.myProject).findArtifact(this.myName));
        }
        return artifact.get();
    }

    public Artifact getArtifactNoResolve() {
        AtomicReference<Artifact> artifact = this.myArtifact;
        return artifact == null ? null : artifact.get();
    }

    @NotNull
    public String getArtifactName(@NotNull ArtifactModel artifactModel) {
        Artifact artifact;
        if (artifactModel == null) {
            ArtifactPointerImpl.$$$reportNull$$$0(3);
        }
        if ((artifact = this.getArtifactNoResolve()) != null) {
            String string = artifactModel.getArtifactByOriginal(artifact).getName();
            if (string == null) {
                ArtifactPointerImpl.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = this.myName;
        if (string == null) {
            ArtifactPointerImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    public Artifact findArtifact(@NotNull ArtifactModel artifactModel) {
        Artifact artifact;
        if (artifactModel == null) {
            ArtifactPointerImpl.$$$reportNull$$$0(6);
        }
        if ((artifact = this.getArtifactNoResolve()) != null) {
            return artifactModel.getArtifactByOriginal(artifact);
        }
        return artifactModel.findArtifact(this.myName);
    }

    void setArtifact(@NotNull Artifact artifact) {
        if (artifact == null) {
            ArtifactPointerImpl.$$$reportNull$$$0(7);
        }
        this.myArtifact = new AtomicReference<Artifact>(artifact);
    }

    void invalidateArtifact() {
        this.myArtifact = null;
    }

    void setName(@NotNull String name) {
        if (name == null) {
            ArtifactPointerImpl.$$$reportNull$$$0(8);
        }
        this.myName = name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/artifacts/ArtifactPointerImpl";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/artifacts/ArtifactPointerImpl";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findArtifact";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setArtifact";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }
}

