/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.java.workspace.entities.ArchivePackagingElementEntity;
import com.intellij.java.workspace.entities.PackagingElementEntity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingExternalMapping;
import com.intellij.packaging.impl.elements.CompositeElementWithManifest;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.ui.ArchiveElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kotlin.Unit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ArchivePackagingElement
extends CompositeElementWithManifest<ArchivePackagingElement> {
    @NonNls
    public static final String NAME_ATTRIBUTE = "name";
    private String myArchiveFileName;

    public ArchivePackagingElement() {
        super(PackagingElementFactoryImpl.ARCHIVE_ELEMENT_TYPE);
    }

    public ArchivePackagingElement(@NotNull String archiveFileName) {
        if (archiveFileName == null) {
            ArchivePackagingElement.$$$reportNull$$$0(0);
        }
        super(PackagingElementFactoryImpl.ARCHIVE_ELEMENT_TYPE);
        this.myArchiveFileName = archiveFileName;
    }

    @NotNull
    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            ArchivePackagingElement.$$$reportNull$$$0(1);
        }
        return new ArchiveElementPresentation(this);
    }

    @Attribute(value="name")
    @NlsSafe
    public String getArchiveFileName() {
        return this.getMyArchiveName();
    }

    @NonNls
    public String toString() {
        return "archive:" + this.getMyArchiveName();
    }

    public ArchivePackagingElement getState() {
        return this;
    }

    public void setArchiveFileName(String archiveFileName) {
        this.renameArchive(archiveFileName);
    }

    public String getName() {
        return this.getMyArchiveName();
    }

    public void rename(@NotNull String newName) {
        if (newName == null) {
            ArchivePackagingElement.$$$reportNull$$$0(2);
        }
        this.renameArchive(newName);
    }

    private void renameArchive(String archiveFileName) {
        this.update(() -> {
            this.myArchiveFileName = archiveFileName;
        }, (builder, entity) -> builder.modifyEntity(ArchivePackagingElementEntity.Builder.class, (WorkspaceEntity)entity, ent -> {
            ent.setFileName(archiveFileName);
            return Unit.INSTANCE;
        }));
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            ArchivePackagingElement.$$$reportNull$$$0(3);
        }
        return element instanceof ArchivePackagingElement && ((ArchivePackagingElement)element).getArchiveFileName().equals(this.getMyArchiveName());
    }

    public void loadState(@NotNull ArchivePackagingElement state) {
        if (state == null) {
            ArchivePackagingElement.$$$reportNull$$$0(4);
        }
        XmlSerializerUtil.copyBean((Object)((Object)state), (Object)((Object)this));
    }

    public PackagingElementEntity.Builder<? extends PackagingElementEntity> getOrAddEntityBuilder(@NotNull MutableEntityStorage diff, @NotNull EntitySource source, @NotNull Project project) {
        PackagingElementEntity existingEntity;
        if (diff == null) {
            ArchivePackagingElement.$$$reportNull$$$0(5);
        }
        if (source == null) {
            ArchivePackagingElement.$$$reportNull$$$0(6);
        }
        if (project == null) {
            ArchivePackagingElement.$$$reportNull$$$0(7);
        }
        if ((existingEntity = (PackagingElementEntity)this.getExistingEntity(diff)) != null) {
            return this.getBuilder(diff, existingEntity);
        }
        List children = ContainerUtil.map((Collection)this.getChildren(), o -> o.getOrAddEntityBuilder(diff, source, project));
        Objects.requireNonNull(this.myArchiveFileName, "archiveFileName is not specified");
        ArchivePackagingElementEntity entity = (ArchivePackagingElementEntity)diff.addEntity((WorkspaceEntity.Builder)ArchivePackagingElementEntity.create((String)this.myArchiveFileName, (EntitySource)source, entityBuilder -> {
            entityBuilder.setChildren(children);
            return Unit.INSTANCE;
        }));
        diff.getMutableExternalMapping(PackagingExternalMapping.key).addMapping((WorkspaceEntity)entity, (Object)this);
        return this.getBuilder(diff, (PackagingElementEntity)entity);
    }

    private String getMyArchiveName() {
        if (this.myStorage == null) {
            return this.myArchiveFileName;
        }
        ArchivePackagingElementEntity entity = (ArchivePackagingElementEntity)this.getThisEntity();
        String fileName = entity.getFileName();
        if (!Objects.equals(fileName, this.myArchiveFileName)) {
            this.myArchiveFileName = fileName;
        }
        return fileName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveFileName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diff";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/packaging/impl/elements/ArchivePackagingElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createPresentation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "rename";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEqualTo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrAddEntityBuilder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

