/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.InferredAnnotationProvider;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.bytecodeAnalysis.ProjectBytecodeAnalysis;
import com.intellij.codeInspection.dataFlow.HardcodedContracts;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.inference.JavaSourceInference;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultInferredAnnotationProvider
implements InferredAnnotationProvider {
    private static final Set<String> JB_INFERRED_ANNOTATIONS = Set.of(JavaMethodContractUtil.ORG_JETBRAINS_ANNOTATIONS_CONTRACT, Mutability.UNMODIFIABLE_ANNOTATION, Mutability.UNMODIFIABLE_VIEW_ANNOTATION);
    private static final Set<String> EXPERIMENTAL_INFERRED_ANNOTATIONS = Collections.emptySet();
    private final Project myProject;
    private final NullableNotNullManager myNullabilityManager;

    public DefaultInferredAnnotationProvider(Project project) {
        this.myProject = project;
        this.myNullabilityManager = NullableNotNullManager.getInstance((Project)project);
    }

    @Nullable
    public PsiAnnotation findInferredAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        PsiAnnotation fromBytecode;
        PsiAnnotation anno;
        if (listOwner == null) {
            DefaultInferredAnnotationProvider.$$$reportNull$$$0(0);
        }
        if (annotationFQN == null) {
            DefaultInferredAnnotationProvider.$$$reportNull$$$0(1);
        }
        if (!JB_INFERRED_ANNOTATIONS.contains(annotationFQN) && !this.isDefaultNullabilityAnnotation(annotationFQN)) {
            return null;
        }
        listOwner = PsiUtil.preferCompiledElement((PsiModifierListOwner)listOwner);
        if (JavaMethodContractUtil.ORG_JETBRAINS_ANNOTATIONS_CONTRACT.equals(annotationFQN) && listOwner instanceof PsiMethod && (anno = this.getHardcodedContractAnnotation((PsiMethod)listOwner)) != null) {
            return anno;
        }
        if (this.ignoreInference(listOwner, annotationFQN)) {
            return null;
        }
        if (DefaultInferredAnnotationProvider.canInferFromByteCode(listOwner) && (fromBytecode = ProjectBytecodeAnalysis.getInstance(this.myProject).findInferredAnnotation(listOwner, annotationFQN)) != null) {
            return fromBytecode;
        }
        if (this.isDefaultNullabilityAnnotation(annotationFQN)) {
            PsiModifierListOwner psiModifierListOwner = listOwner;
            Objects.requireNonNull(psiModifierListOwner);
            PsiModifierListOwner psiModifierListOwner2 = psiModifierListOwner;
            int n = 0;
            anno = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PsiMethodImpl.class, PsiParameter.class}, (Object)psiModifierListOwner2, n)) {
                case 0 -> {
                    PsiMethodImpl method = (PsiMethodImpl)psiModifierListOwner2;
                    yield this.getInferredNullabilityAnnotation(method);
                }
                case 1 -> {
                    PsiParameter parameter = (PsiParameter)psiModifierListOwner2;
                    yield this.getInferredNullabilityAnnotation(parameter);
                }
                default -> null;
            };
            return anno != null && anno.hasQualifiedName(annotationFQN) ? anno : null;
        }
        if (Mutability.UNMODIFIABLE_ANNOTATION.equals(annotationFQN) || Mutability.UNMODIFIABLE_VIEW_ANNOTATION.equals(annotationFQN)) {
            return this.getInferredMutabilityAnnotation(listOwner);
        }
        if (listOwner instanceof PsiMethodImpl && JavaMethodContractUtil.ORG_JETBRAINS_ANNOTATIONS_CONTRACT.equals(annotationFQN)) {
            return this.getInferredContractAnnotation((PsiMethodImpl)listOwner);
        }
        return null;
    }

    private boolean isDefaultNullabilityAnnotation(String annotationFQN) {
        return annotationFQN.equals(this.myNullabilityManager.getDefaultNullable()) || annotationFQN.equals(this.myNullabilityManager.getDefaultNotNull());
    }

    @Nullable
    private PsiAnnotation getHardcodedContractAnnotation(PsiMethod method) {
        String name;
        PsiClass aClass = method.getContainingClass();
        if (aClass != null && (name = aClass.getQualifiedName()) != null && name.startsWith("org.assertj.core.api.") && !name.equals("org.assertj.core.api.AbstractThrowableAssert")) {
            return this.createContractAnnotation(Collections.emptyList(), MutationSignature.pure());
        }
        List<MethodContract> contracts = HardcodedContracts.getHardcodedContracts(method, null);
        return contracts.isEmpty() ? null : this.createContractAnnotation(contracts, HardcodedContracts.getHardcodedMutation(method));
    }

    private boolean ignoreInference(@NotNull PsiModifierListOwner owner, @Nullable String annotationFQN) {
        PsiMethodImpl methodImpl;
        PsiMethod method;
        if (owner == null) {
            DefaultInferredAnnotationProvider.$$$reportNull$$$0(2);
        }
        if (annotationFQN == null) {
            return true;
        }
        if (owner instanceof PsiMethod && PsiUtil.canBeOverridden((PsiMethod)(method = (PsiMethod)owner)) && (!(owner instanceof PsiMethodImpl) || !JavaSourceInference.canInferFromSource(methodImpl = (PsiMethodImpl)owner))) {
            return true;
        }
        if (JavaMethodContractUtil.ORG_JETBRAINS_ANNOTATIONS_CONTRACT.equals(annotationFQN) && HardcodedContracts.hasHardcodedContracts((PsiElement)owner)) {
            return true;
        }
        if (annotationFQN.equals(this.myNullabilityManager.getDefaultNotNull()) && owner instanceof PsiParameter && owner.getParent() != null) {
            List annotations = NullableNotNullManager.getInstance((Project)owner.getProject()).getNullables();
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, (Collection)annotations, (int)10)) {
                return true;
            }
            return HardcodedContracts.hasHardcodedContracts((PsiElement)owner);
        }
        return false;
    }

    @Nullable
    private PsiAnnotation getInferredMutabilityAnnotation(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            DefaultInferredAnnotationProvider.$$$reportNull$$$0(3);
        }
        if (!(owner instanceof PsiMethodImpl)) {
            return null;
        }
        PsiMethodImpl method = (PsiMethodImpl)owner;
        if (StreamEx.of((Object[])new PsiAnnotationOwner[]{method.getModifierList(), method.getReturnType()}).nonNull().anyMatch(m -> m.hasAnnotation(Mutability.UNMODIFIABLE_ANNOTATION) || m.hasAnnotation(Mutability.UNMODIFIABLE_VIEW_ANNOTATION))) {
            return null;
        }
        return JavaSourceInference.inferMutability(method).asAnnotation(this.myProject);
    }

    @Nullable
    private PsiAnnotation getInferredContractAnnotation(PsiMethodImpl method) {
        if (method.getModifierList().hasAnnotation(JavaMethodContractUtil.ORG_JETBRAINS_ANNOTATIONS_CONTRACT)) {
            return null;
        }
        return this.createContractAnnotation(JavaSourceInference.inferContracts(method), JavaSourceInference.inferMutationSignature(method));
    }

    @Nullable
    private PsiAnnotation getInferredNullabilityAnnotation(PsiMethodImpl method) {
        PsiType returnType = method.getReturnType();
        if (returnType == null || returnType instanceof PsiPrimitiveType) {
            return null;
        }
        if (this.hasExplicitNullability((PsiModifierListOwner)method)) {
            return null;
        }
        Nullability nullability = JavaSourceInference.inferNullability(method);
        if (nullability == Nullability.NOT_NULL) {
            return ProjectBytecodeAnalysis.getInstance(this.myProject).getNotNullAnnotation();
        }
        if (nullability == Nullability.NULLABLE) {
            return ProjectBytecodeAnalysis.getInstance(this.myProject).getNullableAnnotation();
        }
        return null;
    }

    private boolean hasExplicitNullability(PsiModifierListOwner owner) {
        return NullableNotNullManager.getInstance((Project)this.myProject).findExplicitNullability(owner) != null;
    }

    @Nullable
    private PsiAnnotation getInferredNullabilityAnnotation(PsiParameter parameter) {
        String className;
        PsiClass containingClass;
        PsiMethod method;
        if (this.hasExplicitNullability((PsiModifierListOwner)parameter)) {
            return null;
        }
        PsiElement parent = parameter.getParent();
        if (!(parent instanceof PsiParameterList)) {
            return null;
        }
        PsiElement scope = parent.getParent();
        if (scope instanceof PsiMethod && (method = (PsiMethod)scope).getName().equals("of") && (containingClass = method.getContainingClass()) != null && ("java.util.List".equals(className = containingClass.getQualifiedName()) || "java.util.Set".equals(className) || "java.util.Map".equals(className) || "java.util.EnumSet".equals(className))) {
            return ProjectBytecodeAnalysis.getInstance(this.myProject).getNotNullAnnotation();
        }
        Nullability nullability = JavaSourceInference.inferNullability(parameter);
        return nullability == Nullability.NOT_NULL ? ProjectBytecodeAnalysis.getInstance(this.myProject).getNotNullAnnotation() : null;
    }

    @Nullable
    private PsiAnnotation createContractAnnotation(List<? extends MethodContract> contracts, MutationSignature signature) {
        return DefaultInferredAnnotationProvider.createContractAnnotation(this.myProject, signature.isPure(), StreamEx.of(contracts).select(StandardMethodContract.class).joining((CharSequence)"; "), signature.isPure() || signature == MutationSignature.unknown() ? "" : signature.toString());
    }

    @Nullable
    public static PsiAnnotation createContractAnnotation(Project project, boolean pure, String contracts, String mutates) {
        String attributes = JavaMethodContractUtil.createAttributesText(contracts, pure, mutates);
        if (attributes.isEmpty()) {
            return null;
        }
        return ProjectBytecodeAnalysis.getInstance(project).createContractAnnotation(attributes);
    }

    @NotNull
    public List<PsiAnnotation> findInferredAnnotations(@NotNull PsiModifierListOwner listOwner) {
        if (listOwner == null) {
            DefaultInferredAnnotationProvider.$$$reportNull$$$0(4);
        }
        listOwner = PsiUtil.preferCompiledElement((PsiModifierListOwner)listOwner);
        ArrayList<PsiAnnotation> result = new ArrayList<PsiAnnotation>();
        if (DefaultInferredAnnotationProvider.canInferFromByteCode(listOwner)) {
            PsiAnnotation[] fromBytecode;
            for (PsiAnnotation annotation : fromBytecode = ProjectBytecodeAnalysis.getInstance(this.myProject).findInferredAnnotations(listOwner)) {
                if (this.ignoreInference(listOwner, annotation.getQualifiedName()) || DefaultInferredAnnotationProvider.ignoreByteCodeAnnotation(listOwner, annotation.getQualifiedName())) continue;
                result.add(annotation);
            }
        }
        if (listOwner instanceof PsiMethod) {
            PsiAnnotation hardcoded = this.getHardcodedContractAnnotation((PsiMethod)listOwner);
            ContainerUtil.addIfNotNull(result, (Object)hardcoded);
            if (listOwner instanceof PsiMethodImpl) {
                PsiAnnotation annotation;
                if (hardcoded == null && !this.ignoreInference(listOwner, JavaMethodContractUtil.ORG_JETBRAINS_ANNOTATIONS_CONTRACT)) {
                    ContainerUtil.addIfNotNull(result, (Object)this.getInferredContractAnnotation((PsiMethodImpl)listOwner));
                }
                if (!(this.ignoreInference(listOwner, this.myNullabilityManager.getDefaultNotNull()) && this.ignoreInference(listOwner, this.myNullabilityManager.getDefaultNullable()) || (annotation = this.getInferredNullabilityAnnotation((PsiMethodImpl)listOwner)) == null || this.ignoreInference(listOwner, annotation.getQualifiedName()))) {
                    result.add(annotation);
                }
            }
        }
        if (listOwner instanceof PsiParameter && !this.ignoreInference(listOwner, this.myNullabilityManager.getDefaultNotNull())) {
            ContainerUtil.addIfNotNull(result, (Object)this.getInferredNullabilityAnnotation((PsiParameter)listOwner));
        }
        ContainerUtil.addIfNotNull(result, (Object)this.getInferredMutabilityAnnotation(listOwner));
        ArrayList<PsiAnnotation> arrayList = result;
        if (arrayList == null) {
            DefaultInferredAnnotationProvider.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static boolean ignoreByteCodeAnnotation(PsiModifierListOwner owner, String name) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)owner.getProject());
        if (name.equals(manager.getDefaultNotNull()) || name.equals(manager.getDefaultNullable())) {
            return ContainerUtil.exists((Object[])owner.getAnnotations(), NullableNotNullManager::isNullabilityAnnotation);
        }
        return false;
    }

    private static boolean canInferFromByteCode(PsiModifierListOwner owner) {
        if (!(owner instanceof PsiCompiledElement)) {
            return false;
        }
        PsiModifierListOwner psiModifierListOwner = owner;
        Objects.requireNonNull(psiModifierListOwner);
        PsiModifierListOwner psiModifierListOwner2 = psiModifierListOwner;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PsiField.class, PsiMethod.class, PsiParameter.class}, (Object)psiModifierListOwner2, n)) {
            case 0 -> {
                PsiField ignored = (PsiField)psiModifierListOwner2;
                yield true;
            }
            case 1 -> {
                PsiMethod method = (PsiMethod)psiModifierListOwner2;
                if (!PsiUtil.canBeOverridden((PsiMethod)method)) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                PsiMethod method;
                PsiParameter parameter = (PsiParameter)psiModifierListOwner2;
                PsiElement var7_6 = parameter.getDeclarationScope();
                if (var7_6 instanceof PsiMethod && !PsiUtil.canBeOverridden((PsiMethod)(method = (PsiMethod)var7_6))) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static boolean isExperimentalInferredAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            DefaultInferredAnnotationProvider.$$$reportNull$$$0(6);
        }
        return EXPERIMENTAL_INFERRED_ANNOTATIONS.contains(annotation.getQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/DefaultInferredAnnotationProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/DefaultInferredAnnotationProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findInferredAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findInferredAnnotation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "ignoreInference";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInferredMutabilityAnnotation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findInferredAnnotations";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isExperimentalInferredAnnotation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

