/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.application.options.colors.ScopeAttributesUtil;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.JavaHighlightInfoTypes;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.JavaNamesHighlightVisitor;
import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.DependencyValidationManagerImpl;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.light.LightRecordField;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.javadoc.PsiDocFragmentName;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HighlightNamesUtil {
    private static final Logger LOG = Logger.getInstance(HighlightNamesUtil.class);

    public static void highlightElement(@NotNull PsiElement psiElement, @NotNull HighlightInfoHolder holder) {
        PsiFile containingFile;
        if (psiElement == null) {
            HighlightNamesUtil.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            HighlightNamesUtil.$$$reportNull$$$0(1);
        }
        if ((containingFile = psiElement.getContainingFile()) == null) {
            return;
        }
        HighlightNamesUtil.highlight(containingFile, holder, visitor2 -> psiElement.accept((PsiElementVisitor)visitor2));
    }

    public static void highlight(@NotNull PsiFile psiFile, @NotNull HighlightInfoHolder holder, @NotNull @NotNull Consumer<? super @NotNull JavaElementVisitor> consumer) {
        JavaNamesHighlightVisitor visitor2;
        if (psiFile == null) {
            HighlightNamesUtil.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            HighlightNamesUtil.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            HighlightNamesUtil.$$$reportNull$$$0(4);
        }
        if (!(visitor2 = new JavaNamesHighlightVisitor()).suitableForFile(psiFile)) {
            return;
        }
        visitor2.analyze(psiFile, false, holder, () -> consumer.accept(visitor2));
    }

    @Nullable
    static HighlightInfo highlightMethodName(@NotNull PsiMember methodOrClass, @NotNull PsiElement elementToHighlight, boolean isDeclaration, @NotNull TextAttributesScheme colorsScheme) {
        HighlightInfoType type;
        if (methodOrClass == null) {
            HighlightNamesUtil.$$$reportNull$$$0(5);
        }
        if (elementToHighlight == null) {
            HighlightNamesUtil.$$$reportNull$$$0(6);
        }
        if (colorsScheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(7);
        }
        boolean isInherited = false;
        boolean isStaticallyImported = false;
        if (!isDeclaration) {
            try {
                isStaticallyImported = HighlightNamesUtil.isStaticallyImported(elementToHighlight);
                if (HighlightNamesUtil.isCalledOnThis(elementToHighlight)) {
                    PsiClass enclosingClass;
                    PsiClass containingClass = methodOrClass instanceof PsiMethod ? methodOrClass.getContainingClass() : null;
                    PsiClass psiClass = enclosingClass = containingClass == null ? null : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)elementToHighlight, PsiClass.class);
                    while (enclosingClass != null && !(isInherited = enclosingClass.isInheritor(containingClass, true))) {
                        enclosingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)enclosingClass, PsiClass.class, (boolean)true);
                    }
                }
            }
            catch (IndexNotReadyException containingClass) {
                // empty catch block
            }
        }
        LOG.assertTrue(methodOrClass instanceof PsiMethod || !isDeclaration);
        if (methodOrClass instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)methodOrClass;
            v1 = HighlightNamesUtil.getMethodNameHighlightType(psiMethod, isDeclaration, isInherited, isStaticallyImported);
        } else {
            v1 = type = JavaHighlightInfoTypes.CONSTRUCTOR_CALL;
        }
        if (type != null) {
            TextAttributes attributes = HighlightNamesUtil.mergeWithScopeAttributes((PsiElement)methodOrClass, type, colorsScheme);
            if (!isDeclaration) {
                attributes = HighlightNamesUtil.mergeWithVisibilityAttributes((PsiModifierListOwner)methodOrClass, attributes, colorsScheme);
            }
            HighlightInfo.Builder builder = HighlightNamesUtil.nameBuilder(type).range(elementToHighlight);
            if (attributes != null) {
                builder.textAttributes(attributes);
            }
            return builder.createUnconditionally();
        }
        return null;
    }

    @NotNull
    private static HighlightInfo.Builder nameBuilder(@NotNull HighlightInfoType type) {
        if (type == null) {
            HighlightNamesUtil.$$$reportNull$$$0(8);
        }
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)type);
        if (builder == null) {
            HighlightNamesUtil.$$$reportNull$$$0(9);
        }
        return builder;
    }

    private static boolean isCalledOnThis(@NotNull PsiElement elementToHighlight) {
        PsiMethodCallExpression methodCallExpression;
        if (elementToHighlight == null) {
            HighlightNamesUtil.$$$reportNull$$$0(10);
        }
        if ((methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)elementToHighlight, PsiMethodCallExpression.class)) != null) {
            PsiElement qualifier = methodCallExpression.getMethodExpression().getQualifier();
            return qualifier == null || qualifier instanceof PsiThisExpression;
        }
        return false;
    }

    public static boolean isStaticallyImported(@NotNull PsiElement elementToHighlight) {
        PsiReferenceExpression referenceExpression;
        if (elementToHighlight == null) {
            HighlightNamesUtil.$$$reportNull$$$0(11);
        }
        if ((referenceExpression = (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)elementToHighlight, PsiReferenceExpression.class)) != null) {
            JavaResolveResult result = referenceExpression.advancedResolve(false);
            return result.getCurrentFileResolveScope() instanceof PsiImportStaticStatement;
        }
        return false;
    }

    private static TextAttributes mergeWithScopeAttributes(@Nullable PsiElement element, @NotNull HighlightInfoType type, @NotNull TextAttributesScheme colorsScheme) {
        if (type == null) {
            HighlightNamesUtil.$$$reportNull$$$0(12);
        }
        if (colorsScheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(13);
        }
        TextAttributes regularAttributes = HighlightInfo.getAttributesByType((PsiElement)element, (HighlightInfoType)type, (TextAttributesScheme)colorsScheme);
        if (element == null) {
            return regularAttributes;
        }
        TextAttributes scopeAttributes = HighlightNamesUtil.getScopeAttributes(element, colorsScheme);
        return TextAttributes.merge((TextAttributes)scopeAttributes, (TextAttributes)regularAttributes);
    }

    private static TextAttributes mergeWithVisibilityAttributes(@NotNull PsiModifierListOwner listOwner, TextAttributes basedAttributes, @NotNull TextAttributesScheme colorsScheme) {
        TextAttributes visibilityAttributes;
        if (listOwner == null) {
            HighlightNamesUtil.$$$reportNull$$$0(14);
        }
        if (colorsScheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(15);
        }
        TextAttributesKey attributesKey = null;
        if (listOwner.hasModifierProperty("public")) {
            attributesKey = JavaHighlightingColors.PUBLIC_REFERENCE_ATTRIBUTES;
        } else if (listOwner.hasModifierProperty("protected")) {
            attributesKey = JavaHighlightingColors.PROTECTED_REFERENCE_ATTRIBUTES;
        } else if (listOwner.hasModifierProperty("packageLocal")) {
            attributesKey = JavaHighlightingColors.PACKAGE_PRIVATE_REFERENCE_ATTRIBUTES;
        } else if (listOwner.hasModifierProperty("private")) {
            attributesKey = JavaHighlightingColors.PRIVATE_REFERENCE_ATTRIBUTES;
        }
        if (attributesKey != null && (visibilityAttributes = colorsScheme.getAttributes(attributesKey)) != null && !visibilityAttributes.isEmpty()) {
            return TextAttributes.merge((TextAttributes)basedAttributes, (TextAttributes)visibilityAttributes);
        }
        return basedAttributes;
    }

    @NotNull
    static HighlightInfo highlightClassName(@Nullable PsiClass aClass, @NotNull PsiElement elementToHighlight, @NotNull TextAttributesScheme colorsScheme) {
        PsiElement parent;
        PsiJavaCodeReferenceElement referenceElement;
        PsiElement identifier;
        if (elementToHighlight == null) {
            HighlightNamesUtil.$$$reportNull$$$0(16);
        }
        if (colorsScheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(17);
        }
        TextRange range = elementToHighlight.getTextRange();
        if (elementToHighlight instanceof PsiJavaCodeReferenceElement && (identifier = (referenceElement = (PsiJavaCodeReferenceElement)elementToHighlight).getReferenceNameElement()) != null) {
            range = identifier.getTextRange();
        }
        if ((parent = elementToHighlight.getParent()) instanceof PsiAnnotation) {
            PsiAnnotation psiAnnotation = (PsiAnnotation)parent;
            range = new TextRange(psiAnnotation.getTextRange().getStartOffset(), range.getEndOffset());
        }
        HighlightInfoType type = HighlightNamesUtil.getClassNameHighlightType(aClass, elementToHighlight);
        TextAttributes attributes = HighlightNamesUtil.mergeWithScopeAttributes((PsiElement)aClass, type, colorsScheme);
        if (aClass != null && elementToHighlight instanceof PsiJavaCodeReferenceElement) {
            attributes = HighlightNamesUtil.mergeWithVisibilityAttributes((PsiModifierListOwner)aClass, attributes, colorsScheme);
        }
        HighlightInfo.Builder builder = HighlightNamesUtil.nameBuilder(type).range(range);
        if (attributes != null) {
            builder.textAttributes(attributes);
        }
        HighlightInfo highlightInfo = builder.createUnconditionally();
        if (highlightInfo == null) {
            HighlightNamesUtil.$$$reportNull$$$0(18);
        }
        return highlightInfo;
    }

    @Nullable
    static HighlightInfo highlightVariableName(@NotNull PsiVariable variable, @NotNull PsiElement elementToHighlight, @NotNull TextAttributesScheme colorsScheme) {
        HighlightInfoType varType;
        if (variable == null) {
            HighlightNamesUtil.$$$reportNull$$$0(19);
        }
        if (elementToHighlight == null) {
            HighlightNamesUtil.$$$reportNull$$$0(20);
        }
        if (colorsScheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(21);
        }
        if ((varType = HighlightNamesUtil.getVariableNameHighlightType(variable, elementToHighlight)) == null) {
            return null;
        }
        if (variable instanceof PsiField) {
            TextAttributes attributes = HighlightNamesUtil.mergeWithScopeAttributes((PsiElement)variable, varType, colorsScheme);
            if (elementToHighlight.getParent() instanceof PsiReferenceExpression) {
                attributes = HighlightNamesUtil.mergeWithVisibilityAttributes((PsiModifierListOwner)variable, attributes, colorsScheme);
            }
            HighlightInfo.Builder builder = HighlightNamesUtil.nameBuilder(varType).range(elementToHighlight);
            if (attributes != null) {
                builder.textAttributes(attributes);
            }
            return builder.createUnconditionally();
        }
        HighlightInfo.Builder builder = HighlightNamesUtil.nameBuilder(varType).range(elementToHighlight);
        return RainbowHighlighter.isRainbowEnabledWithInheritance((TextAttributesScheme)colorsScheme, (Language)JavaLanguage.INSTANCE) ? builder.createUnconditionally() : builder.create();
    }

    private static HighlightInfoType getMethodNameHighlightType(@NotNull PsiMethod method, boolean isDeclaration, boolean isInheritedMethod, boolean isStaticallyImported) {
        if (method == null) {
            HighlightNamesUtil.$$$reportNull$$$0(22);
        }
        if (method.isConstructor()) {
            return isDeclaration ? JavaHighlightInfoTypes.CONSTRUCTOR_DECLARATION : JavaHighlightInfoTypes.CONSTRUCTOR_CALL;
        }
        if (isDeclaration) {
            return JavaHighlightInfoTypes.METHOD_DECLARATION;
        }
        if (method.hasModifierProperty("static")) {
            return isStaticallyImported ? JavaHighlightInfoTypes.STATIC_METHOD_CALL_IMPORTED : JavaHighlightInfoTypes.STATIC_METHOD;
        }
        if (isInheritedMethod) {
            return JavaHighlightInfoTypes.INHERITED_METHOD;
        }
        if (method.hasModifierProperty("abstract")) {
            return JavaHighlightInfoTypes.ABSTRACT_METHOD;
        }
        return JavaHighlightInfoTypes.METHOD_CALL;
    }

    @Nullable
    private static HighlightInfoType getVariableNameHighlightType(@NotNull PsiVariable var, @NotNull PsiElement elementToHighlight) {
        PsiParameter parameter;
        if (var == null) {
            HighlightNamesUtil.$$$reportNull$$$0(23);
        }
        if (elementToHighlight == null) {
            HighlightNamesUtil.$$$reportNull$$$0(24);
        }
        if (var instanceof PsiLocalVariable || var instanceof PsiParameter && (parameter = (PsiParameter)var).getDeclarationScope() instanceof PsiForeachStatement) {
            return JavaHighlightInfoTypes.LOCAL_VARIABLE;
        }
        if (var instanceof PsiRecordComponent || var instanceof LightRecordField) {
            return JavaHighlightInfoTypes.RECORD_COMPONENT;
        }
        if (var instanceof PsiField) {
            if (var.hasModifierProperty("static")) {
                boolean staticallyImported = HighlightNamesUtil.isStaticallyImported(elementToHighlight);
                if (var.hasModifierProperty("final")) {
                    return staticallyImported ? JavaHighlightInfoTypes.STATIC_FINAL_FIELD_IMPORTED : JavaHighlightInfoTypes.STATIC_FINAL_FIELD;
                }
                return staticallyImported ? JavaHighlightInfoTypes.STATIC_FIELD_IMPORTED : JavaHighlightInfoTypes.STATIC_FIELD;
            }
            return var.hasModifierProperty("final") ? JavaHighlightInfoTypes.INSTANCE_FINAL_FIELD : JavaHighlightInfoTypes.INSTANCE_FIELD;
        }
        if (var instanceof PsiParameter) {
            parameter = (PsiParameter)var;
            return parameter.getDeclarationScope() instanceof PsiLambdaExpression ? JavaHighlightInfoTypes.LAMBDA_PARAMETER : JavaHighlightInfoTypes.PARAMETER;
        }
        return null;
    }

    @NotNull
    private static HighlightInfoType getClassNameHighlightType(@Nullable PsiClass aClass, @NotNull PsiElement element) {
        if (element == null) {
            HighlightNamesUtil.$$$reportNull$$$0(25);
        }
        if (element instanceof PsiJavaCodeReferenceElement && element.getParent() instanceof PsiAnonymousClass) {
            HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.ANONYMOUS_CLASS_NAME;
            if (highlightInfoType == null) {
                HighlightNamesUtil.$$$reportNull$$$0(26);
            }
            return highlightInfoType;
        }
        if (aClass != null) {
            if (aClass.isAnnotationType()) {
                HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.ANNOTATION_NAME;
                if (highlightInfoType == null) {
                    HighlightNamesUtil.$$$reportNull$$$0(27);
                }
                return highlightInfoType;
            }
            if (aClass.isInterface()) {
                HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.INTERFACE_NAME;
                if (highlightInfoType == null) {
                    HighlightNamesUtil.$$$reportNull$$$0(28);
                }
                return highlightInfoType;
            }
            if (aClass.isEnum()) {
                HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.ENUM_NAME;
                if (highlightInfoType == null) {
                    HighlightNamesUtil.$$$reportNull$$$0(29);
                }
                return highlightInfoType;
            }
            if (aClass.isRecord()) {
                HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.RECORD_NAME;
                if (highlightInfoType == null) {
                    HighlightNamesUtil.$$$reportNull$$$0(30);
                }
                return highlightInfoType;
            }
            if (aClass instanceof PsiTypeParameter) {
                HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.TYPE_PARAMETER_NAME;
                if (highlightInfoType == null) {
                    HighlightNamesUtil.$$$reportNull$$$0(31);
                }
                return highlightInfoType;
            }
            PsiModifierList modList = aClass.getModifierList();
            if (modList != null && modList.hasModifierProperty("abstract")) {
                HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.ABSTRACT_CLASS_NAME;
                if (highlightInfoType == null) {
                    HighlightNamesUtil.$$$reportNull$$$0(32);
                }
                return highlightInfoType;
            }
        }
        if (aClass == null && element.getParent() instanceof PsiAnnotation) {
            HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.ANNOTATION_NAME;
            if (highlightInfoType == null) {
                HighlightNamesUtil.$$$reportNull$$$0(33);
            }
            return highlightInfoType;
        }
        HighlightInfoType highlightInfoType = JavaHighlightInfoTypes.CLASS_NAME;
        if (highlightInfoType == null) {
            HighlightNamesUtil.$$$reportNull$$$0(34);
        }
        return highlightInfoType;
    }

    private static TextAttributes getScopeAttributes(@NotNull PsiElement element, @NotNull TextAttributesScheme colorsScheme) {
        PsiFile psiFile;
        if (element == null) {
            HighlightNamesUtil.$$$reportNull$$$0(35);
        }
        if (colorsScheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(36);
        }
        if ((psiFile = element.getContainingFile()) == null) {
            return null;
        }
        TextAttributes result = null;
        DependencyValidationManagerImpl validationManager = (DependencyValidationManagerImpl)DependencyValidationManager.getInstance((Project)psiFile.getProject());
        List scopes = validationManager.getScopeBasedHighlightingCachedScopes();
        for (Pair scope : scopes) {
            PackageSet packageSet;
            NamedScope namedScope = (NamedScope)scope.getFirst();
            TextAttributesKey scopeKey = ScopeAttributesUtil.getScopeTextAttributeKey((String)namedScope.getScopeId());
            TextAttributes attributes = colorsScheme.getAttributes(scopeKey);
            if (attributes == null || attributes.isEmpty() || (packageSet = namedScope.getValue()) == null || !packageSet.contains(psiFile, (NamedScopesHolder)scope.getSecond())) continue;
            result = TextAttributes.merge((TextAttributes)attributes, result);
        }
        return result;
    }

    @NotNull
    public static TextRange getMethodDeclarationTextRange(@NotNull PsiMethod method) {
        if (method == null) {
            HighlightNamesUtil.$$$reportNull$$$0(37);
        }
        if (method instanceof SyntheticElement) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                HighlightNamesUtil.$$$reportNull$$$0(38);
            }
            return textRange;
        }
        int start = HighlightNamesUtil.stripAnnotationsFromModifierList((PsiElement)method.getModifierList());
        TextRange throwsRange = method.getThrowsList().getTextRange();
        LOG.assertTrue(throwsRange != null, (Object)method);
        int end = throwsRange.getEndOffset();
        return new TextRange(start, end);
    }

    @NotNull
    public static TextRange getFieldDeclarationTextRange(@NotNull PsiField field) {
        if (field == null) {
            HighlightNamesUtil.$$$reportNull$$$0(39);
        }
        int start = HighlightNamesUtil.stripAnnotationsFromModifierList((PsiElement)field.getModifierList());
        int end = field.getNameIdentifier().getTextRange().getEndOffset();
        return new TextRange(start, end);
    }

    @NotNull
    public static TextRange getClassDeclarationTextRange(@NotNull PsiClass aClass) {
        PsiReferenceList endElement;
        PsiJavaCodeReferenceElement psiElement;
        if (aClass == null) {
            HighlightNamesUtil.$$$reportNull$$$0(40);
        }
        if (aClass instanceof PsiEnumConstantInitializer) {
            PsiEnumConstantInitializer initializer = (PsiEnumConstantInitializer)aClass;
            TextRange textRange = initializer.getEnumConstant().getNameIdentifier().getTextRange();
            if (textRange == null) {
                HighlightNamesUtil.$$$reportNull$$$0(41);
            }
            return textRange;
        }
        if (aClass instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymousClass = (PsiAnonymousClass)aClass;
            v1 = anonymousClass.getBaseClassReference();
        } else {
            v1 = psiElement = aClass.getModifierList() == null ? aClass.getNameIdentifier() : aClass.getModifierList();
        }
        if (psiElement == null) {
            return new TextRange(aClass.getTextRange().getStartOffset(), aClass.getTextRange().getStartOffset());
        }
        int start = HighlightNamesUtil.stripAnnotationsFromModifierList((PsiElement)psiElement);
        if (aClass instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymousClass = (PsiAnonymousClass)aClass;
            v2 = anonymousClass.getBaseClassReference();
        } else {
            v2 = endElement = aClass.getImplementsList();
        }
        if (endElement == null) {
            endElement = aClass.getNameIdentifier();
        }
        TextRange endTextRange = endElement == null ? null : endElement.getTextRange();
        int end = endTextRange == null ? start : endTextRange.getEndOffset();
        return new TextRange(start, end);
    }

    private static int stripAnnotationsFromModifierList(@NotNull PsiElement element) {
        TextRange textRange;
        if (element == null) {
            HighlightNamesUtil.$$$reportNull$$$0(42);
        }
        if ((textRange = element.getTextRange()) == null) {
            return 0;
        }
        PsiAnnotation lastAnnotation = null;
        for (PsiElement child = element.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (!(child instanceof PsiAnnotation)) continue;
            lastAnnotation = (PsiAnnotation)child;
            break;
        }
        if (lastAnnotation == null) {
            return textRange.getStartOffset();
        }
        ASTNode node = lastAnnotation.getNode();
        if (node != null) {
            while ((node = TreeUtil.nextLeaf((ASTNode)node)) != null && ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(node.getElementType())) {
            }
        }
        if (node != null) {
            return node.getTextRange().getStartOffset();
        }
        return textRange.getStartOffset();
    }

    @NotNull
    static HighlightInfo highlightPackage(@Nullable PsiElement resolved, @NotNull PsiJavaCodeReferenceElement elementToHighlight, @NotNull TextAttributesScheme scheme) {
        TextRange range;
        PsiElement referenceNameElement;
        if (elementToHighlight == null) {
            HighlightNamesUtil.$$$reportNull$$$0(43);
        }
        if (scheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(44);
        }
        if ((referenceNameElement = elementToHighlight.getReferenceNameElement()) == null) {
            range = elementToHighlight.getTextRange();
        } else {
            PsiElement nextSibling = PsiTreeUtil.nextLeaf((PsiElement)referenceNameElement);
            if (nextSibling != null && nextSibling.getTextRange().isEmpty()) {
                nextSibling = PsiTreeUtil.nextLeaf((PsiElement)nextSibling);
            }
            range = PsiUtil.isJavaToken((PsiElement)nextSibling, (IElementType)JavaTokenType.DOT) ? new TextRange(referenceNameElement.getTextRange().getStartOffset(), nextSibling.getTextRange().getEndOffset()) : referenceNameElement.getTextRange();
        }
        return HighlightNamesUtil.generateClassNameHighlight(resolved, scheme, range);
    }

    @NotNull
    static HighlightInfo highlightModule(@Nullable PsiElement resolved, @NotNull PsiReference elementToHighlight, @NotNull TextAttributesScheme scheme) {
        if (elementToHighlight == null) {
            HighlightNamesUtil.$$$reportNull$$$0(45);
        }
        if (scheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(46);
        }
        TextRange range = elementToHighlight.getElement().getTextRange();
        return HighlightNamesUtil.generateClassNameHighlight(resolved, scheme, range);
    }

    @NotNull
    private static HighlightInfo generateClassNameHighlight(@Nullable PsiElement resolved, @NotNull TextAttributesScheme scheme, TextRange range) {
        if (scheme == null) {
            HighlightNamesUtil.$$$reportNull$$$0(47);
        }
        HighlightInfoType type = JavaHighlightInfoTypes.CLASS_NAME;
        TextAttributes attributes = HighlightNamesUtil.mergeWithScopeAttributes(resolved, type, scheme);
        HighlightInfo.Builder builder = HighlightNamesUtil.nameBuilder(type).range(range);
        if (attributes != null) {
            builder.textAttributes(attributes);
        }
        HighlightInfo highlightInfo = builder.createUnconditionally();
        if (highlightInfo == null) {
            HighlightNamesUtil.$$$reportNull$$$0(48);
        }
        return highlightInfo;
    }

    static HighlightInfo highlightImplicitAnonymousClassParameter(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            HighlightNamesUtil.$$$reportNull$$$0(49);
        }
        return HighlightNamesUtil.nameBuilder(JavaHighlightInfoTypes.IMPLICIT_ANONYMOUS_CLASS_PARAMETER).range((PsiElement)ref).create();
    }

    static HighlightInfo highlightAnnotationAttributeName(@NotNull PsiIdentifier nameId) {
        if (nameId == null) {
            HighlightNamesUtil.$$$reportNull$$$0(50);
        }
        return HighlightNamesUtil.nameBuilder(JavaHighlightInfoTypes.ANNOTATION_ATTRIBUTE_NAME).range((PsiElement)nameId).create();
    }

    static HighlightInfo highlightKeyword(@NotNull PsiKeyword keyword) {
        if (keyword == null) {
            HighlightNamesUtil.$$$reportNull$$$0(51);
        }
        return HighlightNamesUtil.nameBuilder(JavaHighlightInfoTypes.JAVA_KEYWORD).range((PsiElement)keyword).create();
    }

    static HighlightInfo highlightClassKeyword(@NotNull PsiKeyword keyword) {
        if (keyword == null) {
            HighlightNamesUtil.$$$reportNull$$$0(52);
        }
        return HighlightNamesUtil.nameBuilder(JavaHighlightInfoTypes.JAVA_KEYWORD_CLASS_FILE).range((PsiElement)keyword).create();
    }

    static HighlightInfo highlightFragmentReference(@NotNull PsiDocFragmentName fragmentName) {
        if (fragmentName == null) {
            HighlightNamesUtil.$$$reportNull$$$0(53);
        }
        return HighlightNamesUtil.nameBuilder(JavaHighlightInfoTypes.LOCAL_VARIABLE).range((PsiElement)fragmentName).create();
    }

    @NotNull
    @NlsSafe
    public static String formatClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            HighlightNamesUtil.$$$reportNull$$$0(54);
        }
        return HighlightNamesUtil.formatClass(aClass, true);
    }

    @NotNull
    public static String formatClass(@NotNull PsiClass aClass, boolean fqn) {
        if (aClass == null) {
            HighlightNamesUtil.$$$reportNull$$$0(55);
        }
        String string = PsiFormatUtil.formatClass((PsiClass)aClass, (int)(0x8001 | (fqn ? 2048 : 0)));
        if (string == null) {
            HighlightNamesUtil.$$$reportNull$$$0(56);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 18, 26, 27, 28, 29, 30, 31, 32, 33, 34, 38, 41, 48, 56 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodOrClass";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 16: 
            case 20: 
            case 24: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToHighlight";
                break;
            }
            case 7: 
            case 13: 
            case 15: 
            case 17: 
            case 21: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsScheme";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 41: 
            case 48: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 22: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 25: 
            case 35: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 40: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 44: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameId";
                break;
            }
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragmentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightNamesUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "nameBuilder";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "highlightClassName";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNameHighlightType";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodDeclarationTextRange";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDeclarationTextRange";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "generateClassNameHighlight";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "formatClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "highlightElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "highlightMethodName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "nameBuilder";
                break;
            }
            case 9: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 41: 
            case 48: 
            case 56: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isCalledOnThis";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isStaticallyImported";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "mergeWithScopeAttributes";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "mergeWithVisibilityAttributes";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "highlightClassName";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "highlightVariableName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getMethodNameHighlightType";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getVariableNameHighlightType";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getClassNameHighlightType";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getScopeAttributes";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getMethodDeclarationTextRange";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getFieldDeclarationTextRange";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getClassDeclarationTextRange";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "stripAnnotationsFromModifierList";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "highlightPackage";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "highlightModule";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "generateClassNameHighlight";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "highlightImplicitAnonymousClassParameter";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "highlightAnnotationAttributeName";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "highlightKeyword";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "highlightClassKeyword";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "highlightFragmentReference";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "formatClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 18, 26, 27, 28, 29, 30, 31, 32, 33, 34, 38, 41, 48, 56 -> new IllegalStateException(string);
        };
    }
}

