/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaHighlightUtil {
    public static boolean isSerializable(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaHighlightUtil.$$$reportNull$$$0(0);
        }
        return JavaHighlightUtil.isSerializable(aClass, "java.io.Serializable");
    }

    public static boolean isSerializable(@NotNull PsiClass aClass, @NotNull String serializableClassName) {
        Project project;
        PsiClass serializableClass;
        if (aClass == null) {
            JavaHighlightUtil.$$$reportNull$$$0(1);
        }
        if (serializableClassName == null) {
            JavaHighlightUtil.$$$reportNull$$$0(2);
        }
        return (serializableClass = JavaPsiFacade.getInstance((Project)(project = aClass.getManager().getProject())).findClass(serializableClassName, aClass.getResolveScope())) != null && aClass.isInheritor(serializableClass, true);
    }

    public static boolean isSerializationRelatedMethod(@NotNull PsiMethod method, @Nullable PsiClass containingClass) {
        if (method == null) {
            JavaHighlightUtil.$$$reportNull$$$0(3);
        }
        if (containingClass == null) {
            return false;
        }
        if (method.isConstructor()) {
            return JavaHighlightUtil.isSerializable(containingClass, "java.io.Externalizable") && method.getParameterList().isEmpty() && method.hasModifierProperty("public");
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        @NonNls String name = method.getName();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if ("readObjectNoData".equals(name)) {
            PsiType returnType = method.getReturnType();
            return parameters.length == 0 && TypeConversionUtil.isVoidType((PsiType)returnType) && JavaHighlightUtil.isSerializable(containingClass);
        }
        if ("readObject".equals(name)) {
            PsiType returnType = method.getReturnType();
            return parameters.length == 1 && parameters[0].getType().equalsToText("java.io.ObjectInputStream") && TypeConversionUtil.isVoidType((PsiType)returnType) && method.hasModifierProperty("private") && JavaHighlightUtil.isSerializable(containingClass);
        }
        if ("readResolve".equals(name)) {
            PsiType returnType = method.getReturnType();
            return parameters.length == 0 && returnType != null && returnType.equalsToText("java.lang.Object") && (containingClass.hasModifierProperty("abstract") || JavaHighlightUtil.isSerializable(containingClass));
        }
        if ("writeReplace".equals(name)) {
            PsiType returnType = method.getReturnType();
            return parameters.length == 0 && returnType != null && returnType.equalsToText("java.lang.Object") && (containingClass.hasModifierProperty("abstract") || JavaHighlightUtil.isSerializable(containingClass));
        }
        if ("writeObject".equals(name)) {
            PsiType returnType = method.getReturnType();
            return parameters.length == 1 && TypeConversionUtil.isVoidType((PsiType)returnType) && parameters[0].getType().equalsToText("java.io.ObjectOutputStream") && method.hasModifierProperty("private") && JavaHighlightUtil.isSerializable(containingClass);
        }
        return false;
    }

    @NotNull
    public static String formatType(@Nullable PsiType type) {
        String string = type == null ? "null" : PsiTypesUtil.removeExternalAnnotations((PsiType)type).getInternalCanonicalText();
        if (string == null) {
            JavaHighlightUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private static PsiType getArrayInitializerType(@NotNull PsiArrayInitializerExpression element) {
        PsiType typeCheckResult;
        if (element == null) {
            JavaHighlightUtil.$$$reportNull$$$0(5);
        }
        return (typeCheckResult = JavaHighlightUtil.sameType(element.getInitializers())) != null ? typeCheckResult.createArrayType() : null;
    }

    @Nullable
    public static PsiType sameType(PsiExpression @NotNull [] expressions) {
        if (expressions == null) {
            JavaHighlightUtil.$$$reportNull$$$0(6);
        }
        PsiType type = null;
        for (PsiExpression expression : expressions) {
            PsiType currentType;
            if (expression instanceof PsiArrayInitializerExpression) {
                PsiArrayInitializerExpression initializerExpression = (PsiArrayInitializerExpression)expression;
                currentType = JavaHighlightUtil.getArrayInitializerType(initializerExpression);
            } else {
                currentType = expression.getType();
            }
            if (type == null) {
                type = currentType;
                continue;
            }
            if (type.equals(currentType)) continue;
            return null;
        }
        return type;
    }

    @NotNull
    @NlsSafe
    public static String formatMethod(@NotNull PsiMethod method) {
        if (method == null) {
            JavaHighlightUtil.$$$reportNull$$$0(7);
        }
        String string = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
        if (string == null) {
            JavaHighlightUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    public static boolean isSuperOrThisCall(@NotNull PsiStatement statement, boolean testForSuper, boolean testForThis) {
        if (statement == null) {
            JavaHighlightUtil.$$$reportNull$$$0(9);
        }
        if (!(statement instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
        PsiExpression expression = expressionStatement.getExpression();
        if (!(expression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression callExpression = (PsiMethodCallExpression)expression;
        PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
        if (testForSuper && "super".equals(methodExpression.getText())) {
            return true;
        }
        return testForThis && "this".equals(methodExpression.getText());
    }

    @Deprecated
    @NotNull
    public static List<PsiMethod> getChainedConstructors(@NotNull PsiMethod constructor) {
        if (constructor == null) {
            JavaHighlightUtil.$$$reportNull$$$0(10);
        }
        List list = JavaPsiConstructorUtil.getChainedConstructors((PsiMethod)constructor);
        if (list == null) {
            JavaHighlightUtil.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Nullable
    @Nls
    public static String checkPsiTypeUseInContext(@NotNull PsiType type, @NotNull PsiElement context) {
        if (type == null) {
            JavaHighlightUtil.$$$reportNull$$$0(12);
        }
        if (context == null) {
            JavaHighlightUtil.$$$reportNull$$$0(13);
        }
        if (type instanceof PsiPrimitiveType) {
            return null;
        }
        if (type instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)type;
            return JavaHighlightUtil.checkPsiTypeUseInContext(arrayType.getComponentType(), context);
        }
        if (PsiUtil.resolveClassInType((PsiType)type) != null) {
            return null;
        }
        if (type instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            return JavaHighlightUtil.checkClassType(classType, context);
        }
        return JavaHighlightUtil.invalidJavaTypeMessage();
    }

    @NotNull
    @Nls
    public static String invalidJavaTypeMessage() {
        String string = JavaAnalysisBundle.message((String)"error.message.invalid.java.type", (Object[])new Object[0]);
        if (string == null) {
            JavaHighlightUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String checkClassType(@NotNull PsiClassType type, @NotNull PsiElement context) {
        String className;
        if (type == null) {
            JavaHighlightUtil.$$$reportNull$$$0(15);
        }
        if (context == null) {
            JavaHighlightUtil.$$$reportNull$$$0(16);
        }
        if (JavaHighlightUtil.classExists(context, className = PsiNameHelper.getQualifiedClassName((String)type.getCanonicalText(false), (boolean)true))) {
            return JavaHighlightUtil.getClassInaccessibleMessage(context, className);
        }
        return JavaHighlightUtil.invalidJavaTypeMessage();
    }

    private static boolean classExists(@NotNull PsiElement context, @NotNull String className) {
        if (context == null) {
            JavaHighlightUtil.$$$reportNull$$$0(17);
        }
        if (className == null) {
            JavaHighlightUtil.$$$reportNull$$$0(18);
        }
        return JavaPsiFacade.getInstance((Project)context.getProject()).findClass(className, GlobalSearchScope.allScope((Project)context.getProject())) != null;
    }

    @NotNull
    @Nls
    private static String getClassInaccessibleMessage(@NotNull PsiElement context, @NotNull String className) {
        Module module;
        if (context == null) {
            JavaHighlightUtil.$$$reportNull$$$0(19);
        }
        if (className == null) {
            JavaHighlightUtil.$$$reportNull$$$0(20);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context)) == null) {
            String string = JavaAnalysisBundle.message((String)"message.class.inaccessible", (Object[])new Object[]{className});
            if (string == null) {
                JavaHighlightUtil.$$$reportNull$$$0(21);
            }
            return string;
        }
        String string = JavaAnalysisBundle.message((String)"message.class.inaccessible.from.module", (Object[])new Object[]{className, module.getName()});
        if (string == null) {
            JavaHighlightUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8, 11, 14, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializableClassName";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/JavaHighlightUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/JavaHighlightUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "formatType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "formatMethod";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChainedConstructors";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "invalidJavaTypeMessage";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassInaccessibleMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSerializable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSerializationRelatedMethod";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 21: 
            case 22: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getArrayInitializerType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sameType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "formatMethod";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSuperOrThisCall";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getChainedConstructors";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkPsiTypeUseInContext";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkClassType";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "classExists";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getClassInaccessibleMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 8, 11, 14, 21, 22 -> new IllegalStateException(string);
        };
    }
}

