/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.UnusedImportProvider;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.JavaHighlightInfoTypes;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.daemon.impl.analysis.ImportsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.LocalRefUseInfo;
import com.intellij.codeInsight.daemon.impl.analysis.OptimizeImportRestarter;
import com.intellij.codeInsight.daemon.impl.analysis.RemoveAllUnusedImportsFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.CodeInsightContextUtil;
import com.intellij.codeInspection.ExternalSourceProblemGroup;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportModuleStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ImportUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class UnusedImportsVisitor
extends JavaElementVisitor {
    @NotNull
    private final Document myDocument;
    @NotNull
    private final CodeInsightContext myContext;
    @NotNull
    private final State myState;
    @NotNull
    private final PsiFile myPsiFile;
    @NotNull
    private final Project myProject;

    UnusedImportsVisitor(@NotNull PsiFile psiFile, @NotNull Document document) throws ProcessCanceledException {
        if (psiFile == null) {
            UnusedImportsVisitor.$$$reportNull$$$0(0);
        }
        if (document == null) {
            UnusedImportsVisitor.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.myPsiFile = psiFile;
        this.myProject = psiFile.getProject();
        this.myState = new State(psiFile);
        this.myDocument = document;
        this.myContext = CodeInsightContextUtil.getCodeInsightContext((PsiFile)psiFile);
    }

    void collectHighlights(@NotNull HighlightInfoHolder holder) {
        PsiImportList importList;
        if (holder == null) {
            UnusedImportsVisitor.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        HighlightDisplayKey unusedImportKey = HighlightDisplayKey.find((String)"UNUSED_IMPORT");
        PsiJavaFile javaFile = (PsiJavaFile)ObjectUtils.tryCast((Object)this.myPsiFile, PsiJavaFile.class);
        PsiImportList psiImportList = importList = javaFile == null ? null : javaFile.getImportList();
        if (unusedImportKey != null && this.isUnusedImportEnabled(unusedImportKey) && importList != null) {
            this.processImports(javaFile, importList, unusedImportKey);
        }
        boolean errorFound = false;
        for (HighlightInfo.Builder builder : this.myState.builderList) {
            errorFound |= UnusedImportsVisitor.addInfo(builder, holder);
        }
        if (errorFound) {
            DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx((Project)this.myProject);
            FileStatusMap fileStatusMap = daemonCodeAnalyzer.getFileStatusMap();
            fileStatusMap.setErrorFoundFlag(this.myDocument, this.myContext, true);
        }
        if (this.myState.requiresFix) {
            ModCommandAction fix = QuickFixFactory.getInstance().createOptimizeImportsFix(true, this.myPsiFile);
            OptimizeImportRestarter.getInstance(this.myProject).scheduleOnDaemonFinish(this.myPsiFile, fix);
        }
    }

    private boolean isUnusedImportEnabled(@NotNull HighlightDisplayKey unusedImportKey) {
        if (unusedImportKey == null) {
            UnusedImportsVisitor.$$$reportNull$$$0(3);
        }
        if (this.isToolEnabled(unusedImportKey)) {
            return true;
        }
        for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
            UnusedImportProvider uip;
            if (!(provider instanceof UnusedImportProvider) || !(uip = (UnusedImportProvider)provider).isUnusedImportEnabled((PsiElement)this.myPsiFile)) continue;
            return true;
        }
        return false;
    }

    private boolean isToolEnabled(@NotNull HighlightDisplayKey displayKey) {
        if (displayKey == null) {
            UnusedImportsVisitor.$$$reportNull$$$0(4);
        }
        if (!(this.myPsiFile instanceof PsiJavaFile)) {
            return false;
        }
        InspectionProfile profile = UnusedImportsVisitor.getCurrentProfile(this.myPsiFile);
        return profile.isToolEnabled(displayKey, (PsiElement)this.myPsiFile) && HighlightingLevelManager.getInstance((Project)this.myProject).shouldInspect((PsiElement)this.myPsiFile) && !HighlightingLevelManager.getInstance((Project)this.myProject).runEssentialHighlightingOnly((PsiElement)this.myPsiFile);
    }

    @NotNull
    private static InspectionProfile getCurrentProfile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            UnusedImportsVisitor.$$$reportNull$$$0(5);
        }
        Function custom = InspectionProfileWrapper.getCustomInspectionProfileWrapper((PsiFile)psiFile);
        InspectionProfileImpl currentProfile = InspectionProjectProfileManager.getInstance((Project)psiFile.getProject()).getCurrentProfile();
        Object object = custom != null ? ((InspectionProfileWrapper)custom.apply(currentProfile)).getInspectionProfile() : currentProfile;
        if (object == null) {
            UnusedImportsVisitor.$$$reportNull$$$0(6);
        }
        return object;
    }

    private static boolean isRedundantImport(@NotNull PsiJavaFile javaFile, @NotNull PsiImportStatementBase importStatement, @NotNull LocalRefUseInfo refCountHolder) {
        List<PsiImportModuleStatement> moduleStatements;
        PsiImportModuleStatement moduleStatement;
        boolean isRedundant;
        if (javaFile == null) {
            UnusedImportsVisitor.$$$reportNull$$$0(7);
        }
        if (importStatement == null) {
            UnusedImportsVisitor.$$$reportNull$$$0(8);
        }
        if (refCountHolder == null) {
            UnusedImportsVisitor.$$$reportNull$$$0(9);
        }
        if (!(isRedundant = refCountHolder.isRedundant(importStatement)) && !(importStatement instanceof PsiImportStaticStatement)) {
            PsiElement resolved;
            String packageName = javaFile.getPackageName();
            PsiJavaCodeReferenceElement reference = importStatement.getImportReference();
            PsiElement psiElement = resolved = reference == null ? null : reference.resolve();
            if (resolved instanceof PsiPackage) {
                PsiPackage psiPackage = (PsiPackage)resolved;
                isRedundant = packageName.equals(psiPackage.getQualifiedName());
            } else if (resolved instanceof PsiClass) {
                String qName;
                PsiClass psiClass = (PsiClass)resolved;
                if (!importStatement.isOnDemand() && (qName = psiClass.getQualifiedName()) != null) {
                    String name = psiClass.getName();
                    isRedundant = qName.equals(packageName + "." + name);
                }
            }
        }
        if (isRedundant && importStatement instanceof PsiImportModuleStatement) {
            moduleStatement = (PsiImportModuleStatement)importStatement;
            if (!JavaCodeStyleSettings.getInstance((PsiFile)javaFile).isDeleteUnusedModuleImports() && (moduleStatements = ImportUtils.optimizeModuleImports(javaFile)).contains(moduleStatement)) {
                return false;
            }
        }
        if (importStatement instanceof PsiImportModuleStatement) {
            moduleStatement = (PsiImportModuleStatement)importStatement;
            moduleStatements = ImportUtils.optimizeModuleImports(javaFile);
            if (!moduleStatements.contains(moduleStatement)) {
                return true;
            }
        }
        return isRedundant;
    }

    private void processImports(@NotNull PsiJavaFile javaFile, @NotNull PsiImportList importList, @NotNull HighlightDisplayKey unusedImportKey) {
        if (javaFile == null) {
            UnusedImportsVisitor.$$$reportNull$$$0(10);
        }
        if (importList == null) {
            UnusedImportsVisitor.$$$reportNull$$$0(11);
        }
        if (unusedImportKey == null) {
            UnusedImportsVisitor.$$$reportNull$$$0(12);
        }
        List<PsiImportStatementBase> imports = UnusedImportsVisitor.getRedundantImports(this.myState, javaFile, importList, statement -> ProgressManager.checkCanceled());
        this.registerRedundantImports(imports, unusedImportKey);
        HighlightDisplayKey missortedKey = HighlightDisplayKey.find((String)"MISSORTED_IMPORTS");
        if (missortedKey != null && this.isToolEnabled(missortedKey) && this.myState.requiresFix) {
            this.myState.builderList.add(HighlightInfo.newHighlightInfo((HighlightInfoType)JavaHighlightInfoTypes.MISSORTED_IMPORTS).range((PsiElement)importList).registerFix(QuickFixFactory.getInstance().createOptimizeImportsFix(false, this.myPsiFile), null, HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)missortedKey), null, missortedKey));
        }
    }

    @Nullable
    public static ImportProblems getImportProblems(@NotNull PsiJavaFile javaFile) {
        PsiImportList importList;
        if (javaFile == null) {
            UnusedImportsVisitor.$$$reportNull$$$0(13);
        }
        if ((importList = javaFile.getImportList()) == null) {
            return null;
        }
        State state = new State((PsiFile)javaFile);
        ArrayList<RedundantImportInfo> redundantImportInfoList = new ArrayList<RedundantImportInfo>();
        List<PsiImportStatementBase> redundantImportList = UnusedImportsVisitor.getRedundantImports(state, javaFile, importList, null);
        for (PsiImportStatementBase importStatement : redundantImportList) {
            List<ModCommandAction> fixes = UnusedImportsVisitor.getRedundantImportFixes(redundantImportList);
            redundantImportInfoList.add(new RedundantImportInfo(importStatement, HighlightSeverity.WARNING, "UNUSED_IMPORT", JavaAnalysisBundle.message((String)"unused.import.statement", (Object[])new Object[0]), fixes));
        }
        return new ImportProblems(redundantImportInfoList, !redundantImportList.isEmpty() || state.requiresFix);
    }

    @NotNull
    private static List<PsiImportStatementBase> getRedundantImports(@NotNull State state, @NotNull PsiJavaFile javaFile, @NotNull PsiImportList list, @Nullable Consumer<PsiImportStatementBase> statementPreProcessor) {
        if (state == null) {
            UnusedImportsVisitor.$$$reportNull$$$0(14);
        }
        if (javaFile == null) {
            UnusedImportsVisitor.$$$reportNull$$$0(15);
        }
        if (list == null) {
            UnusedImportsVisitor.$$$reportNull$$$0(16);
        }
        ArrayList<PsiImportStatementBase> redundantImports = new ArrayList<PsiImportStatementBase>();
        for (PsiImportStatementBase importStatement : list.getAllImportStatements()) {
            if (statementPreProcessor != null) {
                statementPreProcessor.accept(importStatement);
            }
            if (importStatement.isForeignFileImport() || PsiUtilCore.hasErrorElementChild((PsiElement)importStatement)) continue;
            if (UnusedImportsVisitor.isRedundantImport(javaFile, importStatement, state.refCountHolder)) {
                redundantImports.add(importStatement);
                continue;
            }
            int entryIndex = JavaCodeStyleManager.getInstance((Project)javaFile.getProject()).findEntryIndex(importStatement);
            if (entryIndex < state.currentEntryIndex && !state.requiresFix) {
                state.requiresFix = true;
            }
            state.currentEntryIndex = entryIndex;
        }
        ArrayList<PsiImportStatementBase> arrayList = redundantImports;
        if (arrayList == null) {
            UnusedImportsVisitor.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    private static boolean addInfo(@NotNull HighlightInfo.Builder builder, @NotNull HighlightInfoHolder holder) {
        if (builder == null) {
            UnusedImportsVisitor.$$$reportNull$$$0(18);
        }
        if (holder == null) {
            UnusedImportsVisitor.$$$reportNull$$$0(19);
        }
        HighlightInfo info = builder.create();
        boolean errorFound = false;
        if (info != null && info.getSeverity() == HighlightSeverity.ERROR) {
            errorFound = true;
        }
        holder.add(info);
        return errorFound;
    }

    private void registerRedundantImports(@NotNull List<PsiImportStatementBase> redundantImportList, @NotNull HighlightDisplayKey unusedImportKey) {
        if (redundantImportList == null) {
            UnusedImportsVisitor.$$$reportNull$$$0(20);
        }
        if (unusedImportKey == null) {
            UnusedImportsVisitor.$$$reportNull$$$0(21);
        }
        for (PsiImportStatementBase importStatement : redundantImportList) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)this.myPsiFile);
            Set imports = virtualFile != null ? (Set)virtualFile.getCopyableUserData(ImportsHighlightUtil.IMPORTS_FROM_TEMPLATE) : null;
            boolean predefinedImport = imports != null && imports.contains(importStatement.getText());
            String description = !predefinedImport ? JavaAnalysisBundle.message((String)"unused.import.statement", (Object[])new Object[0]) : JavaAnalysisBundle.message((String)"text.unused.import.in.template", (Object[])new Object[0]);
            InspectionProfile profile = UnusedImportsVisitor.getCurrentProfile(this.myPsiFile);
            TextAttributesKey key = (TextAttributesKey)ObjectUtils.notNull((Object)profile.getEditorAttributes(unusedImportKey.getShortName(), (PsiElement)this.myPsiFile), (Object)JavaHighlightInfoTypes.UNUSED_IMPORT.getAttributesKey());
            HighlightInfoType.HighlightInfoTypeImpl configHighlightType = new HighlightInfoType.HighlightInfoTypeImpl(profile.getErrorLevel(unusedImportKey, (PsiElement)this.myPsiFile).getSeverity(), key);
            ExternalSourceProblemGroup problemGroup = new ExternalSourceProblemGroup(this){

                public String getExternalCheckName() {
                    return "UNUSED_IMPORT";
                }

                @Nullable
                public String getProblemName() {
                    return null;
                }
            };
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)configHighlightType).range((PsiElement)importStatement).descriptionAndTooltip(description).problemGroup((ProblemGroup)problemGroup);
            List<ModCommandAction> fixes = UnusedImportsVisitor.getRedundantImportFixes(redundantImportList);
            for (ModCommandAction fix : fixes) {
                builder.registerFix(fix, null, HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)unusedImportKey), null, unusedImportKey);
            }
            this.myState.builderList.add(builder);
            if (predefinedImport || this.myState.requiresFix) continue;
            this.myState.requiresFix = true;
        }
    }

    @NotNull
    private static List<ModCommandAction> getRedundantImportFixes(List<PsiImportStatementBase> redundantImportList) {
        IntentionAction switchFix = QuickFixFactory.getInstance().createEnableOptimizeImportsOnTheFlyFix();
        List<ModCommandAction> list = List.of(new RemoveAllUnusedImportsFix(redundantImportList), Objects.requireNonNull(switchFix.asModCommandAction()));
        if (list == null) {
            UnusedImportsVisitor.$$$reportNull$$$0(22);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 17, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unusedImportKey";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayKey";
                break;
            }
            case 6: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/UnusedImportsVisitor";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refCountHolder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importList";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "redundantImportList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/UnusedImportsVisitor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentProfile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRedundantImports";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRedundantImportFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectHighlights";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUnusedImportEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isToolEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentProfile";
                break;
            }
            case 6: 
            case 17: 
            case 22: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isRedundantImport";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processImports";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getImportProblems";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRedundantImports";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addInfo";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "registerRedundantImports";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 17, 22 -> new IllegalStateException(string);
        };
    }

    private static class State {
        private boolean requiresFix;
        private int currentEntryIndex;
        @NotNull
        private final LocalRefUseInfo refCountHolder;
        @NotNull
        private final List<HighlightInfo.Builder> builderList;

        State(@NotNull PsiFile psiFile) {
            if (psiFile == null) {
                State.$$$reportNull$$$0(0);
            }
            this.requiresFix = false;
            this.currentEntryIndex = -1;
            this.builderList = new ArrayList<HighlightInfo.Builder>();
            this.refCountHolder = LocalRefUseInfo.forFile(psiFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/analysis/UnusedImportsVisitor$State", "<init>"));
        }
    }

    public record RedundantImportInfo(@NotNull PsiImportStatementBase context, @NotNull HighlightSeverity severity, @NotNull String shortName, @NotNull String description, @NotNull List<ModCommandAction> fixes) {
        @NotNull
        private final PsiImportStatementBase context;
        @NotNull
        private final HighlightSeverity severity;
        @NotNull
        private final String shortName;
        @NotNull
        private final String description;
        @NotNull
        private final List<ModCommandAction> fixes;

        public RedundantImportInfo(@NotNull PsiImportStatementBase context, @NotNull HighlightSeverity severity, @NotNull String shortName, @NotNull String description, @NotNull List<ModCommandAction> fixes) {
            if (context == null) {
                RedundantImportInfo.$$$reportNull$$$0(0);
            }
            if (severity == null) {
                RedundantImportInfo.$$$reportNull$$$0(1);
            }
            if (shortName == null) {
                RedundantImportInfo.$$$reportNull$$$0(2);
            }
            if (description == null) {
                RedundantImportInfo.$$$reportNull$$$0(3);
            }
            if (fixes == null) {
                RedundantImportInfo.$$$reportNull$$$0(4);
            }
        }

        @NotNull
        public PsiImportStatementBase context() {
            PsiImportStatementBase psiImportStatementBase = this.context;
            if (psiImportStatementBase == null) {
                RedundantImportInfo.$$$reportNull$$$0(5);
            }
            return psiImportStatementBase;
        }

        @NotNull
        public HighlightSeverity severity() {
            HighlightSeverity highlightSeverity = this.severity;
            if (highlightSeverity == null) {
                RedundantImportInfo.$$$reportNull$$$0(6);
            }
            return highlightSeverity;
        }

        @NotNull
        public String shortName() {
            String string = this.shortName;
            if (string == null) {
                RedundantImportInfo.$$$reportNull$$$0(7);
            }
            return string;
        }

        @NotNull
        public String description() {
            String string = this.description;
            if (string == null) {
                RedundantImportInfo.$$$reportNull$$$0(8);
            }
            return string;
        }

        @NotNull
        public List<ModCommandAction> fixes() {
            List<ModCommandAction> list = this.fixes;
            if (list == null) {
                RedundantImportInfo.$$$reportNull$$$0(9);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7, 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "severity";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shortName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/UnusedImportsVisitor$RedundantImportInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/UnusedImportsVisitor$RedundantImportInfo";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "context";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "severity";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "shortName";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "description";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fixes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 7, 8, 9 -> new IllegalStateException(string);
            };
        }
    }

    public record ImportProblems(@NotNull List<RedundantImportInfo> redundantImportInfoList, boolean shouldOrganizeImports) {
        @NotNull
        private final List<RedundantImportInfo> redundantImportInfoList;

        public ImportProblems(@NotNull List<RedundantImportInfo> redundantImportInfoList, boolean shouldOrganizeImports) {
            if (redundantImportInfoList == null) {
                ImportProblems.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public List<RedundantImportInfo> redundantImportInfoList() {
            List<RedundantImportInfo> list = this.redundantImportInfoList;
            if (list == null) {
                ImportProblems.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "redundantImportInfoList";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/UnusedImportsVisitor$ImportProblems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/UnusedImportsVisitor$ImportProblems";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "redundantImportInfoList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

