/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeCastFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.Presentation;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CastMethodArgumentFix
extends MethodArgumentFix {
    public static final ArgumentFixerActionFactory REGISTRAR = new MyFixerActionFactory();

    private CastMethodArgumentFix(PsiExpressionList list, int i, PsiType toType, ArgumentFixerActionFactory factory) {
        super(list, i, toType, factory);
    }

    @Override
    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiExpressionList list) {
        Presentation presentation;
        if (context == null) {
            CastMethodArgumentFix.$$$reportNull$$$0(0);
        }
        if (list == null) {
            CastMethodArgumentFix.$$$reportNull$$$0(1);
        }
        return (presentation = super.getPresentation(context, list)) != null ? presentation.withPriority(PriorityAction.Priority.HIGH) : null;
    }

    @Override
    @NotNull
    String getText(@NotNull PsiExpressionList list) {
        if (list == null) {
            CastMethodArgumentFix.$$$reportNull$$$0(2);
        }
        String role = list.getExpressionCount() == 1 ? QuickFixBundle.message("fix.expression.role.argument", new Object[0]) : QuickFixBundle.message("fix.expression.role.nth.argument", this.myIndex + 1);
        boolean literal = AddTypeCastFix.createCastExpression(list.getExpressions()[this.myIndex], this.myToType) instanceof PsiLiteralExpression;
        String string = QuickFixBundle.message(literal ? "add.typecast.convert.text" : "add.typecast.cast.text", this.myToType.getPresentableText(), role);
        if (string == null) {
            CastMethodArgumentFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CastMethodArgumentFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CastMethodArgumentFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static class MyFixerActionFactory
    extends ArgumentFixerActionFactory {
        private MyFixerActionFactory() {
        }

        @Override
        public IntentionAction createFix(PsiExpressionList list, int i, PsiType toType) {
            return new CastMethodArgumentFix(list, i, toType, this).asIntention();
        }

        @Override
        protected PsiExpression getModifiedArgument(PsiExpression expression, PsiType toType) throws IncorrectOperationException {
            PsiType exprType = expression.getType();
            if (exprType instanceof PsiClassType && toType instanceof PsiPrimitiveType) {
                PsiPrimitiveType primitiveType = (PsiPrimitiveType)toType;
                PsiClassType boxed = primitiveType.getBoxedType((PsiElement)expression);
                assert (boxed != null) : String.valueOf(toType) + ":" + String.valueOf(PsiUtil.getLanguageLevel((PsiElement)expression));
                toType = boxed;
            }
            return AddTypeCastFix.createCastExpression(expression, toType);
        }

        @Override
        public boolean areTypesConvertible(@NotNull PsiType exprType, @NotNull PsiType parameterType, @NotNull PsiElement context) {
            PsiEllipsisType ellipsisType;
            PsiPrimitiveType primitiveType;
            if (exprType == null) {
                MyFixerActionFactory.$$$reportNull$$$0(0);
            }
            if (parameterType == null) {
                MyFixerActionFactory.$$$reportNull$$$0(1);
            }
            if (context == null) {
                MyFixerActionFactory.$$$reportNull$$$0(2);
            }
            if (exprType instanceof PsiClassType && parameterType instanceof PsiPrimitiveType && (parameterType = (primitiveType = (PsiPrimitiveType)parameterType).getBoxedType(context)) == null) {
                return false;
            }
            if (exprType instanceof PsiPrimitiveType && parameterType instanceof PsiClassType) {
                if (PsiTypes.nullType().equals(exprType)) {
                    return true;
                }
                if ((parameterType = PsiPrimitiveType.getUnboxedType((PsiType)parameterType)) == null) {
                    return false;
                }
            }
            if (parameterType.isConvertibleFrom(exprType)) {
                return true;
            }
            return parameterType instanceof PsiEllipsisType && this.areTypesConvertible(exprType, (ellipsisType = (PsiEllipsisType)parameterType).getComponentType(), context);
        }

        @Override
        protected boolean doesFixCauseOtherCompilationErrors(@NotNull PsiExpression expression, @NotNull PsiType parameterType) {
            PsiClassType[] declaredExceptions;
            if (expression == null) {
                MyFixerActionFactory.$$$reportNull$$$0(3);
            }
            if (parameterType == null) {
                MyFixerActionFactory.$$$reportNull$$$0(4);
            }
            if ((declaredExceptions = MyFixerActionFactory.declaredExceptionsOfFunctionalInterface(parameterType)) == null) {
                return false;
            }
            Collection<PsiClassType> unhandledExceptions = MyFixerActionFactory.exceptionsThrownByFunctionalExpression(PsiUtil.skipParenthesizedExprDown((PsiExpression)expression));
            return ContainerUtil.exists(unhandledExceptions, unhandled -> !ExceptionUtil.isHandledBy((PsiClassType)unhandled, (PsiClassType[])declaredExceptions));
        }

        @NotNull
        private static @NotNull Collection<@NotNull PsiClassType> exceptionsThrownByFunctionalExpression(PsiExpression expression) {
            PsiMethodReferenceExpression methodReferenceExpression;
            PsiElement target;
            if (expression instanceof PsiLambdaExpression) {
                PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)expression;
                PsiElement body = lambdaExpression.getBody();
                if (body != null) {
                    Collection collection = ExceptionUtil.collectUnhandledExceptions((PsiElement)body, (PsiElement)body);
                    if (collection == null) {
                        MyFixerActionFactory.$$$reportNull$$$0(5);
                    }
                    return collection;
                }
            } else if (expression instanceof PsiMethodReferenceExpression && (target = (methodReferenceExpression = (PsiMethodReferenceExpression)expression).resolve()) instanceof PsiMethod) {
                PsiMethod psiMethod = (PsiMethod)target;
                List<PsiClassType> list = Arrays.asList(psiMethod.getThrowsList().getReferencedTypes());
                if (list == null) {
                    MyFixerActionFactory.$$$reportNull$$$0(6);
                }
                return list;
            }
            List<PsiClassType> list = List.of();
            if (list == null) {
                MyFixerActionFactory.$$$reportNull$$$0(7);
            }
            return list;
        }

        private static @NotNull PsiClassType @Nullable [] declaredExceptionsOfFunctionalInterface(@NotNull PsiType parameterType) {
            if (parameterType == null) {
                MyFixerActionFactory.$$$reportNull$$$0(8);
            }
            if (!(parameterType instanceof PsiClassType)) {
                return null;
            }
            PsiClassType classType = (PsiClassType)parameterType;
            PsiSubstitutor psiSubstitutor = classType.resolveGenerics().getSubstitutor();
            PsiMethod psiMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)parameterType);
            if (psiMethod == null) {
                return null;
            }
            Object[] throwListTypes = psiMethod.getThrowsList().getReferencedTypes();
            return (PsiClassType[])ContainerUtil.map((Object[])throwListTypes, type -> (PsiClassType)psiSubstitutor.substitute((PsiType)type)).toArray(PsiClassType[]::new);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exprType";
                    break;
                }
                case 1: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CastMethodArgumentFix$MyFixerActionFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CastMethodArgumentFix$MyFixerActionFactory";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "exceptionsThrownByFunctionalExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "areTypesConvertible";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "doesFixCauseOtherCompilationErrors";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "declaredExceptionsOfFunctionalInterface";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

