/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveAnnotationToPackageInfoFileFix
extends PsiUpdateModCommandAction<PsiPackageStatement> {
    public MoveAnnotationToPackageInfoFileFix(@NotNull PsiPackageStatement pkgStatement) {
        if (pkgStatement == null) {
            MoveAnnotationToPackageInfoFileFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)pkgStatement);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiPackageStatement packageStatement) {
        PsiPackage aPackage;
        if (context == null) {
            MoveAnnotationToPackageInfoFileFix.$$$reportNull$$$0(1);
        }
        if (packageStatement == null) {
            MoveAnnotationToPackageInfoFileFix.$$$reportNull$$$0(2);
        }
        if ((aPackage = MoveAnnotationToPackageInfoFileFix.getPackage(packageStatement)) == null) {
            return null;
        }
        PsiFile packageInfoFile = MoveAnnotationToPackageInfoFileFix.getPackageInfoFile(aPackage);
        if (packageInfoFile == null) {
            return Presentation.of((String)this.getFamilyName());
        }
        if (!"package-info.java".equals(packageInfoFile.getName())) {
            return null;
        }
        PsiPackageStatement packageStatementInPackageInfoFile = (PsiPackageStatement)PsiTreeUtil.findChildOfType((PsiElement)packageInfoFile, PsiPackageStatement.class);
        if (packageStatementInPackageInfoFile == null) {
            return null;
        }
        PsiModifierList missingAnnotations = MoveAnnotationToPackageInfoFileFix.findMissingAnnotations(packageStatement, packageStatementInPackageInfoFile);
        if (missingAnnotations == null || !missingAnnotations.hasAnnotations()) {
            return null;
        }
        return Presentation.of((String)this.getFamilyName());
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiPackageStatement packageStatement, @NotNull ModPsiUpdater updater) {
        PsiFile modifiedPackageInfoFile;
        PsiPackage aPackage;
        if (context == null) {
            MoveAnnotationToPackageInfoFileFix.$$$reportNull$$$0(3);
        }
        if (packageStatement == null) {
            MoveAnnotationToPackageInfoFileFix.$$$reportNull$$$0(4);
        }
        if (updater == null) {
            MoveAnnotationToPackageInfoFileFix.$$$reportNull$$$0(5);
        }
        if ((aPackage = MoveAnnotationToPackageInfoFileFix.getPackage(packageStatement)) == null) {
            return;
        }
        PsiFile packageInfoFile = MoveAnnotationToPackageInfoFileFix.getPackageInfoFile(aPackage);
        if (packageInfoFile == null) {
            packageInfoFile = ((PsiDirectory)updater.getWritable((PsiElement)context.file().getContainingDirectory())).createFile("package-info.java");
        }
        if ("package-info.java".equals(packageInfoFile.getName()) && (modifiedPackageInfoFile = MoveAnnotationToPackageInfoFileFix.moveAnnotationsAndGetFile(packageStatement, (PsiFile)updater.getWritable((PsiElement)packageInfoFile))) != null) {
            updater.moveCaretTo((PsiElement)modifiedPackageInfoFile);
        }
        MoveAnnotationToPackageInfoFileFix.deleteAnnotations(packageStatement);
    }

    private static void deleteAnnotations(@NotNull PsiPackageStatement packageStatement) {
        if (packageStatement == null) {
            MoveAnnotationToPackageInfoFileFix.$$$reportNull$$$0(6);
        }
        for (PsiAnnotation annotation : packageStatement.getAnnotationList().getAnnotations()) {
            annotation.delete();
        }
    }

    @Nullable
    private static PsiPackage getPackage(@NotNull PsiPackageStatement packageStatement) {
        if (packageStatement == null) {
            MoveAnnotationToPackageInfoFileFix.$$$reportNull$$$0(7);
        }
        PsiJavaCodeReferenceElement packageReference = packageStatement.getPackageReference();
        return (PsiPackage)ObjectUtils.tryCast((Object)packageReference.resolve(), PsiPackage.class);
    }

    @Nullable
    private static PsiFile moveAnnotationsAndGetFile(@NotNull PsiPackageStatement packageStatement, @NotNull PsiFile packageInfoFile) {
        PsiModifierList missingAnnotations;
        PsiPackageStatement packageStatementInPackageInfoFile;
        if (packageStatement == null) {
            MoveAnnotationToPackageInfoFileFix.$$$reportNull$$$0(8);
        }
        if (packageInfoFile == null) {
            MoveAnnotationToPackageInfoFileFix.$$$reportNull$$$0(9);
        }
        if ((packageStatementInPackageInfoFile = (PsiPackageStatement)PsiTreeUtil.findChildOfType((PsiElement)packageInfoFile, PsiPackageStatement.class)) == null) {
            PsiPackageStatement copy = (PsiPackageStatement)packageStatement.copy();
            MoveAnnotationToPackageInfoFileFix.deleteAnnotations(copy);
            packageStatementInPackageInfoFile = (PsiPackageStatement)packageInfoFile.addBefore((PsiElement)copy, packageInfoFile.getFirstChild());
        }
        if ((missingAnnotations = MoveAnnotationToPackageInfoFileFix.findMissingAnnotations(packageStatement, packageStatementInPackageInfoFile)) == null) {
            return null;
        }
        PsiModifierList annotationList = packageStatementInPackageInfoFile.getAnnotationList();
        if (annotationList != null) {
            StreamEx.of((Object[])missingAnnotations.getAnnotations()).forEach(arg_0 -> ((PsiModifierList)annotationList).add(arg_0));
        } else {
            packageStatementInPackageInfoFile.addBefore((PsiElement)missingAnnotations, packageStatementInPackageInfoFile.getFirstChild());
        }
        CodeStyleManager.getInstance((Project)packageInfoFile.getProject()).reformat((PsiElement)packageInfoFile);
        return packageInfoFile;
    }

    @Nullable
    private static PsiModifierList findMissingAnnotations(@NotNull PsiPackageStatement packageStatement, @NotNull PsiPackageStatement packageStatementInPackageInfoFile) {
        PsiModifierList annotationList;
        if (packageStatement == null) {
            MoveAnnotationToPackageInfoFileFix.$$$reportNull$$$0(10);
        }
        if (packageStatementInPackageInfoFile == null) {
            MoveAnnotationToPackageInfoFileFix.$$$reportNull$$$0(11);
        }
        if ((annotationList = packageStatementInPackageInfoFile.getAnnotationList()) == null) {
            return packageStatement.getAnnotationList();
        }
        PsiPackageStatement copy = (PsiPackageStatement)packageStatement.copy();
        ((StreamEx)StreamEx.of((Object[])copy.getAnnotationList().getChildren()).select(PsiAnnotation.class).filter(annotation -> {
            String qualifiedName = annotation.getQualifiedName();
            return qualifiedName != null && annotationList.hasAnnotation(qualifiedName);
        })).forEach(PsiElement::delete);
        return copy.getAnnotationList();
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaAnalysisBundle.message((String)"move.annotations.to.package.info.file.family.name", (Object[])new Object[0]);
        if (string == null) {
            MoveAnnotationToPackageInfoFileFix.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    public static PsiFile getPackageInfoFile(@NotNull PsiPackage aPackage) {
        PsiDirectory[] directories;
        if (aPackage == null) {
            MoveAnnotationToPackageInfoFileFix.$$$reportNull$$$0(13);
        }
        for (PsiDirectory directory : directories = aPackage.getDirectories()) {
            PsiFile packageInfoJava = directory.findFile("package-info.java");
            if (packageInfoJava != null) {
                return packageInfoJava;
            }
            PsiFile packageHtml = directory.findFile("package.html");
            if (packageHtml == null) continue;
            return packageHtml;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkgStatement";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageStatement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageInfoFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageStatementInPackageInfoFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/MoveAnnotationToPackageInfoFileFix";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MoveAnnotationToPackageInfoFileFix";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deleteAnnotations";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPackage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "moveAnnotationsAndGetFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findMissingAnnotations";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPackageInfoFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12 -> new IllegalStateException(string);
        };
    }
}

