/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoveRedundantArgumentsFix
extends PsiUpdateModCommandAction<PsiExpressionList> {
    private final PsiMethod myTargetMethod;
    private final PsiSubstitutor mySubstitutor;

    private RemoveRedundantArgumentsFix(@NotNull PsiMethod targetMethod, @NotNull PsiExpressionList arguments, @NotNull PsiSubstitutor substitutor) {
        if (targetMethod == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(0);
        }
        if (arguments == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(1);
        }
        if (substitutor == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(2);
        }
        super((PsiElement)arguments);
        this.myTargetMethod = targetMethod;
        this.mySubstitutor = substitutor;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("remove.redundant.arguments.family", new Object[0]);
        if (string == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiExpressionList args) {
        if (context == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(4);
        }
        if (args == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(5);
        }
        if (!this.myTargetMethod.isValid() || this.myTargetMethod.getContainingClass() == null) {
            return null;
        }
        if (!this.mySubstitutor.isValid()) {
            return null;
        }
        PsiExpression[] redundant = RemoveRedundantArgumentsFix.findRedundantArgument(args.getExpressions(), this.myTargetMethod.getParameterList().getParameters(), this.mySubstitutor);
        if (redundant == null) {
            return null;
        }
        return Presentation.of((String)QuickFixBundle.message("remove.redundant.arguments.text", JavaHighlightUtil.formatMethod(this.myTargetMethod), redundant.length));
    }

    private static PsiExpression @Nullable [] findRedundantArgument(PsiExpression @NotNull [] arguments, PsiParameter @NotNull [] parameters, @NotNull PsiSubstitutor substitutor) {
        PsiType parameterType;
        if (substitutor == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(6);
        }
        if (arguments == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(7);
        }
        if (parameters == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(8);
        }
        ArrayList<PsiExpression> reduntantArguments = new ArrayList<PsiExpression>();
        int argumentCount = arguments.length;
        PsiType varargsComponentType = RemoveRedundantArgumentsFix.varargsComponentType(parameters);
        int parameterCount = parameters.length - (varargsComponentType == null ? 0 : 1);
        if (argumentCount <= parameterCount) {
            return null;
        }
        int argumentIndex = 0;
        int parameterIndex = 0;
        while (argumentIndex < argumentCount && parameterIndex < parameterCount) {
            PsiExpression argument = arguments[argumentIndex];
            PsiType argumentType = argument.getType();
            if (argumentType == null) {
                return null;
            }
            parameterType = substitutor.substitute(parameters[parameterIndex].getType());
            if (TypeConversionUtil.isAssignable((PsiType)parameterType, (PsiType)argumentType)) {
                ++argumentIndex;
                ++parameterIndex;
                continue;
            }
            reduntantArguments.add(argument);
            ++argumentIndex;
        }
        if (varargsComponentType != null) {
            boolean matchedVarargsElement = false;
            boolean matchedVarargsArray = false;
            parameterType = substitutor.substitute(varargsComponentType);
            while (argumentIndex < argumentCount) {
                PsiExpression argument = arguments[argumentIndex];
                PsiType argumentType = argument.getType();
                if (argumentType == null) {
                    return null;
                }
                if (matchedVarargsArray) {
                    reduntantArguments.add(argument);
                } else if (!matchedVarargsElement && RemoveRedundantArgumentsFix.isArgumentTypeAssignableToVarargsArrayType(parameters, substitutor, argumentType)) {
                    matchedVarargsArray = true;
                } else if (!TypeConversionUtil.isAssignable((PsiType)parameterType, (PsiType)argumentType)) {
                    reduntantArguments.add(argument);
                } else {
                    matchedVarargsElement = true;
                }
                ++argumentIndex;
            }
        }
        if (parameterIndex < parameterCount) {
            return null;
        }
        while (argumentIndex < argumentCount) {
            reduntantArguments.add(arguments[argumentIndex++]);
        }
        return reduntantArguments.toArray(PsiExpression.EMPTY_ARRAY);
    }

    private static boolean isArgumentTypeAssignableToVarargsArrayType(PsiParameter @NotNull [] parameters, @NotNull PsiSubstitutor substitutor, PsiType argumentType) {
        PsiType varargsArrayType;
        if (substitutor == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(9);
        }
        if (parameters == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(10);
        }
        return (varargsArrayType = substitutor.substitute(RemoveRedundantArgumentsFix.varargsArrayType(parameters))) != null && TypeConversionUtil.isAssignable((PsiType)varargsArrayType, (PsiType)argumentType);
    }

    @Nullable
    private static PsiType varargsComponentType(PsiParameter @NotNull [] parameters) {
        int length;
        if (parameters == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(11);
        }
        if ((length = parameters.length) == 0) {
            return null;
        }
        PsiType type = parameters[length - 1].getType();
        if (type instanceof PsiEllipsisType) {
            PsiEllipsisType ellipsisType = (PsiEllipsisType)type;
            return ellipsisType.getComponentType();
        }
        return null;
    }

    @Nullable
    private static PsiType varargsArrayType(PsiParameter @NotNull [] parameters) {
        int length;
        if (parameters == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(12);
        }
        if ((length = parameters.length) == 0) {
            return null;
        }
        PsiType type = parameters[length - 1].getType();
        if (type instanceof PsiEllipsisType) {
            PsiEllipsisType ellipsisType = (PsiEllipsisType)type;
            return ellipsisType.toArrayType();
        }
        return null;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiExpressionList args, @NotNull ModPsiUpdater updater) {
        PsiExpression[] redundantArguments;
        if (context == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(13);
        }
        if (args == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(14);
        }
        if (updater == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(15);
        }
        if ((redundantArguments = RemoveRedundantArgumentsFix.findRedundantArgument(args.getExpressions(), this.myTargetMethod.getParameterList().getParameters(), this.mySubstitutor)) != null) {
            for (PsiExpression argument : redundantArguments) {
                argument.delete();
            }
        }
    }

    public static void registerIntentions(JavaResolveResult @NotNull [] candidates, @NotNull PsiExpressionList arguments, @NotNull Consumer<? super CommonIntentionAction> info) {
        if (arguments == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(16);
        }
        if (info == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(17);
        }
        if (candidates == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(18);
        }
        for (JavaResolveResult candidate : candidates) {
            RemoveRedundantArgumentsFix.registerIntention(arguments, info, candidate);
        }
    }

    private static void registerIntention(@NotNull PsiExpressionList arguments, @NotNull Consumer<? super CommonIntentionAction> info, @NotNull JavaResolveResult candidate) {
        if (arguments == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(19);
        }
        if (info == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(20);
        }
        if (candidate == null) {
            RemoveRedundantArgumentsFix.$$$reportNull$$$0(21);
        }
        if (!candidate.isStaticsScopeCorrect()) {
            return;
        }
        PsiMethod method = (PsiMethod)candidate.getElement();
        PsiSubstitutor substitutor = candidate.getSubstitutor();
        if (method == null || !BaseIntentionAction.canModify((PsiElement)arguments)) {
            return;
        }
        if (method.isConstructor() && arguments.getParent() instanceof PsiMethodCallExpression && ((PsiMethodCallExpression)arguments.getParent()).getMethodExpression().textMatches((CharSequence)"this") && PsiTreeUtil.isAncestor((PsiElement)method, (PsiElement)arguments, (boolean)true)) {
            return;
        }
        info.accept((CommonIntentionAction)new RemoveRedundantArgumentsFix(method, arguments, substitutor));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetMethod";
                break;
            }
            case 1: 
            case 7: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantArgumentsFix";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantArgumentsFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findRedundantArgument";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isArgumentTypeAssignableToVarargsArrayType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "varargsComponentType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "varargsArrayType";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "registerIntentions";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "registerIntention";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

