/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Predicates;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WrapWithAdapterMethodCallFix
extends PsiUpdateModCommandAction<PsiExpression> {
    private static final AbstractWrapper[] WRAPPERS = new AbstractWrapper[]{new InstanceMethodFixer(), new Wrapper("new java.io.File({0})", inType -> inType.equalsToText("java.lang.String"), outType -> outType.equalsToText("java.io.File")), new Wrapper("new java.lang.StringBuilder({0})", inType -> inType.equalsToText("java.lang.String"), outType -> outType.equalsToText("java.lang.StringBuilder")), new Wrapper("java.nio.file.Path.of({0})", inType -> inType.equalsToText("java.lang.String"), outType -> outType.equalsToText("java.nio.file.Path") && WrapWithAdapterMethodCallFix.isAppropriateLanguageLevel(outType, level -> level.isAtLeast(LanguageLevel.JDK_11))), new Wrapper("java.nio.file.Paths.get({0})", inType -> inType.equalsToText("java.lang.String"), outType -> outType.equalsToText("java.nio.file.Path") && WrapWithAdapterMethodCallFix.isAppropriateLanguageLevel(outType, level -> level.isLessThan(LanguageLevel.JDK_11))), new Wrapper("java.util.Arrays.asList({0})", inType -> inType instanceof PsiArrayType && ((PsiArrayType)inType).getComponentType() instanceof PsiClassType, outType -> InheritanceUtil.isInheritor((PsiType)outType, (String)"java.lang.Iterable") && WrapWithAdapterMethodCallFix.isAppropriateLanguageLevel(outType, l -> l.isLessThan(LanguageLevel.JDK_1_9))), new Wrapper("java.util.List.of({0})", inType -> inType instanceof PsiArrayType && ((PsiArrayType)inType).getComponentType() instanceof PsiClassType, outType -> {
        if (!InheritanceUtil.isInheritor((PsiType)outType, (String)"java.lang.Iterable")) return false;
        if (!WrapWithAdapterMethodCallFix.isAppropriateLanguageLevel(outType, arg_0 -> ((JavaFeature)JavaFeature.COLLECTION_FACTORIES).isSufficient(arg_0))) return false;
        return true;
    }), new Wrapper("java.lang.Math.toIntExact({0})", inType -> PsiTypes.longType().equals(inType) || inType.equalsToText("java.lang.Long"), outType -> PsiTypes.intType().equals(outType) || outType.equalsToText("java.lang.Integer")), new Wrapper("java.util.Collections.singleton({0})", Predicates.alwaysTrue(), outType -> InheritanceUtil.isInheritor((PsiType)outType, (String)"java.lang.Iterable")), new Wrapper("java.util.Collections.singletonList({0})", Predicates.alwaysTrue(), outType -> PsiTypesUtil.classNameEquals((PsiType)outType, (String)"java.util.List")), new Wrapper("java.util.Arrays.stream({0})", inType -> inType instanceof PsiArrayType, outType -> InheritanceUtil.isInheritor((PsiType)outType, (String)"java.util.stream.BaseStream"))};
    @Nullable
    private final PsiType myType;
    @Nullable
    private final AbstractWrapper myWrapper;
    @Nullable
    private final String myRole;

    private static boolean isAppropriateLanguageLevel(@NotNull PsiType psiType, @NotNull Predicate<? super LanguageLevel> level) {
        if (psiType == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(0);
        }
        if (level == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(1);
        }
        if (!(psiType instanceof PsiClassType)) {
            return true;
        }
        return level.test((LanguageLevel)((PsiClassType)psiType).getLanguageLevel());
    }

    public WrapWithAdapterMethodCallFix(@Nullable PsiType type, @NotNull PsiExpression expression, @Nullable String role) {
        if (expression == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(2);
        }
        this(type, expression, (AbstractWrapper)ContainerUtil.find((Object[])WRAPPERS, w -> w.isApplicable((PsiElement)expression, expression.getType(), type)), role);
    }

    private WrapWithAdapterMethodCallFix(@Nullable PsiType type, @NotNull PsiExpression expression, @Nullable AbstractWrapper wrapper, @Nullable String role) {
        if (expression == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(3);
        }
        super((PsiElement)expression);
        this.myType = type;
        this.myWrapper = wrapper;
        this.myRole = role;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiExpression expression) {
        if (context == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(4);
        }
        if (expression == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(5);
        }
        if (this.myType == null || this.myWrapper == null || !this.myType.isValid() || this.getModifiedExpression(expression) == null) {
            return null;
        }
        String wrapperText = this.myWrapper.getText(expression, this.myType);
        String text = wrapperText == null ? this.getFamilyName() : (this.myRole == null ? QuickFixBundle.message("wrap.with.adapter.text", wrapperText) : QuickFixBundle.message("wrap.with.adapter.text.role", wrapperText, this.myRole));
        return Presentation.of((String)text).withPriority(PriorityAction.Priority.HIGH);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("wrap.with.adapter.call.family.name", new Object[0]);
        if (string == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiExpression expression, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(7);
        }
        if (expression == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(8);
        }
        if (updater == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(9);
        }
        JavaCodeStyleManager.getInstance((Project)context.project()).shortenClassReferences(expression.replace((PsiElement)this.getModifiedExpression(expression)));
    }

    private PsiExpression getModifiedExpression(@NotNull PsiExpression expression) {
        if (expression == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(10);
        }
        assert (this.myWrapper != null);
        return this.myWrapper.getModifiedArgument(expression, this.myType);
    }

    public static void registerCastActions(CandidateInfo @NotNull [] candidates, @NotNull PsiCall call, @NotNull Consumer<? super CommonIntentionAction> info) {
        if (call == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(11);
        }
        if (info == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(12);
        }
        if (candidates == null) {
            WrapWithAdapterMethodCallFix.$$$reportNull$$$0(13);
        }
        for (AbstractWrapper wrapper : WRAPPERS) {
            wrapper.registerCastActions(candidates, call, info);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/WrapWithAdapterMethodCallFix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/WrapWithAdapterMethodCallFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAppropriateLanguageLevel";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getModifiedExpression";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerCastActions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    static abstract class AbstractWrapper
    extends ArgumentFixerActionFactory {
        AbstractWrapper() {
        }

        abstract boolean isApplicable(PsiElement var1, PsiType var2, PsiType var3);

        @Override
        public boolean areTypesConvertible(@NotNull PsiType exprType, @NotNull PsiType parameterType, @NotNull PsiElement context) {
            if (exprType == null) {
                AbstractWrapper.$$$reportNull$$$0(0);
            }
            if (parameterType == null) {
                AbstractWrapper.$$$reportNull$$$0(1);
            }
            if (context == null) {
                AbstractWrapper.$$$reportNull$$$0(2);
            }
            return parameterType.isConvertibleFrom(exprType) || this.isApplicable(context, exprType, parameterType);
        }

        @Override
        public IntentionAction createFix(PsiExpressionList list, int i, PsiType toType) {
            return new MyMethodArgumentFix(list, i, toType, this).asIntention();
        }

        abstract String getText(PsiExpression var1, PsiType var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "exprType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameterType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/quickfix/WrapWithAdapterMethodCallFix$AbstractWrapper";
            objectArray[2] = "areTypesConvertible";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class InstanceMethodFixer
    extends AbstractWrapper {
        InstanceMethodFixer() {
        }

        @Override
        @Nullable
        protected PsiExpression getModifiedArgument(PsiExpression expression, PsiType toType) throws IncorrectOperationException {
            PsiMethod targetMethod = InstanceMethodFixer.findOnlyMethod(expression.getType(), toType);
            if (targetMethod == null) {
                return null;
            }
            PsiMethodCallExpression replacement = (PsiMethodCallExpression)JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText("x." + targetMethod.getName() + "()", (PsiElement)expression);
            Objects.requireNonNull(replacement.getMethodExpression().getQualifierExpression()).replace((PsiElement)expression);
            return replacement;
        }

        @Nullable
        private static PsiMethod findOnlyMethod(@Nullable PsiType inType, @NotNull PsiType outType) {
            if (outType == null) {
                InstanceMethodFixer.$$$reportNull$$$0(0);
            }
            if (!(inType instanceof PsiClassType)) {
                return null;
            }
            PsiClassType.ClassResolveResult result = ((PsiClassType)inType).resolveGenerics();
            PsiClass psiClass = result.getElement();
            if (psiClass == null || psiClass instanceof PsiTypeParameter) {
                return null;
            }
            return ((Optional)StreamEx.of((Object[])psiClass.getAllMethods()).collect(MoreCollectors.onlyOne(method -> {
                if (method.hasModifierProperty("static") || !method.hasModifierProperty("public")) {
                    return false;
                }
                if (method.isConstructor()) {
                    return false;
                }
                if (method.getName().equals("hashCode")) {
                    return false;
                }
                if (!method.getParameterList().isEmpty()) {
                    return false;
                }
                PsiType type = method.getReturnType();
                if (type == null || PsiTypes.voidType().equals((Object)type)) {
                    return false;
                }
                if (type instanceof PsiClassType) {
                    PsiClass containingClass = method.getContainingClass();
                    if (containingClass == null) {
                        return false;
                    }
                    PsiSubstitutor substitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)psiClass, (PsiSubstitutor)result.getSubstitutor());
                    if (substitutor != null) {
                        type = substitutor.substitute(type);
                    }
                }
                return outType.isAssignableFrom(type);
            }))).orElse(null);
        }

        @Override
        boolean isApplicable(PsiElement context, PsiType inType, PsiType outType) {
            return InstanceMethodFixer.findOnlyMethod(inType, outType) != null;
        }

        @Override
        @Nullable
        String getText(PsiExpression expression, PsiType type) {
            PsiMethod method = InstanceMethodFixer.findOnlyMethod(expression.getType(), type);
            if (method != null) {
                return method.getName() + "()";
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outType", "com/intellij/codeInsight/daemon/impl/quickfix/WrapWithAdapterMethodCallFix$InstanceMethodFixer", "findOnlyMethod"));
        }
    }

    static class Wrapper
    extends AbstractWrapper {
        final Predicate<? super PsiType> myInTypeFilter;
        final Predicate<? super PsiType> myOutTypeFilter;
        final String myTemplate;

        Wrapper(@NonNls String template, Predicate<? super PsiType> inTypeFilter, Predicate<? super PsiType> outTypeFilter) {
            this.myInTypeFilter = inTypeFilter;
            this.myOutTypeFilter = outTypeFilter;
            this.myTemplate = template;
        }

        @Override
        boolean isApplicable(PsiElement context, PsiType inType, PsiType outType) {
            PsiExpression replacement;
            String typeText;
            if (inType == null || outType == null || inType.equals(PsiTypes.nullType()) || !this.myInTypeFilter.test((PsiType)inType) || !this.myOutTypeFilter.test((PsiType)outType)) {
                return false;
            }
            PsiType variableType = GenericsUtil.getVariableTypeByExpressionType((PsiType)inType);
            if (LambdaUtil.notInferredType((PsiType)variableType)) {
                return false;
            }
            if (variableType instanceof PsiDisjunctionType) {
                variableType = ((PsiDisjunctionType)variableType).getLeastUpperBound();
            }
            if ((typeText = variableType.getCanonicalText()).isEmpty()) {
                return false;
            }
            if (variableType instanceof PsiClassType) {
                PsiClassType clsType = (PsiClassType)variableType;
                if (!PsiNameHelper.getInstance((Project)context.getProject()).isQualifiedName(clsType.rawType().getCanonicalText())) {
                    return false;
                }
            }
            try {
                replacement = this.createReplacement(context, "((" + typeText + ")null)");
            }
            catch (IncorrectOperationException ioe) {
                PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)variableType);
                throw new IncorrectOperationException(Wrapper.getExceptionMessage(variableType, aClass), (Throwable)ioe);
            }
            PsiDeclarationStatement declaration = JavaPsiFacade.getElementFactory((Project)context.getProject()).createVariableDeclarationStatement("x", outType, replacement, context);
            PsiVariable var = (PsiVariable)ObjectUtils.tryCast((Object)ArrayUtil.getFirstElement((Object[])declaration.getDeclaredElements()), PsiVariable.class);
            if (var == null) {
                return false;
            }
            PsiExpression initializer = var.getInitializer();
            if (initializer == null) {
                return false;
            }
            PsiType resultType = initializer.getType();
            return resultType != null && outType.isAssignableFrom(resultType);
        }

        @NotNull
        private static String getExceptionMessage(PsiType variableType, PsiClass aClass) {
            String message = "Cannot create expression for type " + String.valueOf(variableType.getClass()) + "\nCanonical text: " + variableType.getCanonicalText() + "\nInternal text: " + variableType.getInternalCanonicalText() + "\n";
            if (aClass != null) {
                message = message + "Class: " + String.valueOf(aClass.getClass()) + "|" + aClass.getQualifiedName() + "\nFile: " + String.valueOf(aClass.getContainingFile()) + "\n";
            }
            if (variableType instanceof PsiClassReferenceType) {
                PsiJavaCodeReferenceElement reference = ((PsiClassReferenceType)variableType).getReference();
                message = message + "Reference: " + reference.getCanonicalText() + "\nReference class: " + String.valueOf(reference.getClass()) + "\nReference name: " + reference.getReferenceName() + "\nReference qualifier: " + (reference.getQualifier() == null ? "(null)" : reference.getQualifier().getText()) + "\nReference file: " + String.valueOf(reference.getContainingFile());
            }
            String string = message;
            if (string == null) {
                Wrapper.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        String getText(PsiExpression element, PsiType type) {
            return this.toString();
        }

        @NotNull
        private PsiExpression createReplacement(PsiElement context, @NonNls String replacement) {
            PsiExpression psiExpression = JavaPsiFacade.getElementFactory((Project)context.getProject()).createExpressionFromText(this.myTemplate.replace("{0}", replacement), context);
            if (psiExpression == null) {
                Wrapper.$$$reportNull$$$0(1);
            }
            return psiExpression;
        }

        @Override
        @Nullable
        protected PsiExpression getModifiedArgument(PsiExpression expression, PsiType toType) throws IncorrectOperationException {
            if (this.isApplicable((PsiElement)expression, expression.getType(), toType)) {
                return (PsiExpression)JavaCodeStyleManager.getInstance((Project)expression.getProject()).shortenClassReferences((PsiElement)this.createReplacement((PsiElement)expression, expression.getText()));
            }
            return null;
        }

        public String toString() {
            return this.myTemplate.replace("{0}", "").replaceAll("\\b[a-z.]+\\.", "");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/daemon/impl/quickfix/WrapWithAdapterMethodCallFix$Wrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExceptionMessage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createReplacement";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class MyMethodArgumentFix
    extends MethodArgumentFix {
        MyMethodArgumentFix(@NotNull PsiExpressionList list, int i, @NotNull PsiType toType, @NotNull AbstractWrapper fixerActionFactory) {
            if (list == null) {
                MyMethodArgumentFix.$$$reportNull$$$0(0);
            }
            if (toType == null) {
                MyMethodArgumentFix.$$$reportNull$$$0(1);
            }
            if (fixerActionFactory == null) {
                MyMethodArgumentFix.$$$reportNull$$$0(2);
            }
            super(list, i, toType, fixerActionFactory);
        }

        @Override
        @Nullable
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiExpressionList list) {
            Presentation presentation;
            if (context == null) {
                MyMethodArgumentFix.$$$reportNull$$$0(3);
            }
            if (list == null) {
                MyMethodArgumentFix.$$$reportNull$$$0(4);
            }
            return (presentation = super.getPresentation(context, list)) != null ? presentation.withPriority(PriorityAction.Priority.HIGH) : null;
        }

        @Override
        @Nls
        @NotNull
        public String getText(@NotNull PsiExpressionList list) {
            AbstractWrapper wrapper;
            String wrapperText;
            if (list == null) {
                MyMethodArgumentFix.$$$reportNull$$$0(5);
            }
            if ((wrapperText = (wrapper = (AbstractWrapper)this.myArgumentFixerActionFactory).getText(list.getExpressions()[this.myIndex], this.myToType)) == null) {
                String string = this.getFamilyName();
                if (string == null) {
                    MyMethodArgumentFix.$$$reportNull$$$0(6);
                }
                return string;
            }
            if (list.getExpressionCount() == 1) {
                String string = QuickFixBundle.message("wrap.with.adapter.parameter.single.text", wrapperText);
                if (string == null) {
                    MyMethodArgumentFix.$$$reportNull$$$0(7);
                }
                return string;
            }
            String string = QuickFixBundle.message("wrap.with.adapter.parameter.multiple.text", this.myIndex + 1, wrapperText);
            if (string == null) {
                MyMethodArgumentFix.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixerActionFactory";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/WrapWithAdapterMethodCallFix$MyMethodArgumentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/WrapWithAdapterMethodCallFix$MyMethodArgumentFix";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7, 8 -> new IllegalStateException(string);
            };
        }
    }
}

