/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.guess.impl;

import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.guess.impl.AssignmentFilteringMemoryState;
import com.intellij.codeInsight.guess.impl.ExpressionVariableDescriptor;
import com.intellij.codeInsight.guess.impl.MethodPattern;
import com.intellij.codeInsight.guess.impl.MethodPatternMap;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.interpreter.RunnerResult;
import com.intellij.codeInspection.dataFlow.interpreter.StandardDataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.java.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.java.JavaDfaListener;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaExpressionAnchor;
import com.intellij.codeInspection.dataFlow.java.inst.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.DfaListener;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.DumbModeAccessType;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class GuessManagerImpl
extends GuessManager {
    private final MethodPatternMap myMethodPatternMap = new MethodPatternMap();
    private final Project myProject;
    private static final int CHECK_USAGE = 1;
    private static final int CHECK_UP = 2;
    private static final int CHECK_DOWN = 4;

    private void initMethodPatterns() {
        this.myMethodPatternMap.addPattern(new MethodPattern("add", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("contains", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("remove", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("add", 2, 1));
        this.myMethodPatternMap.addPattern(new MethodPattern("addElement", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("elementAt", 1, -1));
        this.myMethodPatternMap.addPattern(new MethodPattern("firstElement", 0, -1));
        this.myMethodPatternMap.addPattern(new MethodPattern("lastElement", 0, -1));
        this.myMethodPatternMap.addPattern(new MethodPattern("get", 1, -1));
        this.myMethodPatternMap.addPattern(new MethodPattern("indexOf", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("indexOf", 2, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("lastIndexOf", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("lastIndexOf", 2, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("insertElementAt", 2, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("removeElement", 1, 0));
        this.myMethodPatternMap.addPattern(new MethodPattern("set", 2, 1));
        this.myMethodPatternMap.addPattern(new MethodPattern("setElementAt", 2, 0));
    }

    public GuessManagerImpl(Project project) {
        this.initMethodPatterns();
        this.myProject = project;
    }

    @Override
    public PsiType @NotNull [] guessContainerElementType(PsiExpression containerExpr, TextRange rangeToIgnore) {
        PsiElement refElement;
        HashSet typesSet = new HashSet();
        PsiType type = containerExpr.getType();
        PsiType elemType = GuessManagerImpl.getGenericElementType(type);
        if (elemType != null) {
            PsiType[] psiTypeArray = new PsiType[]{elemType};
            if (psiTypeArray == null) {
                GuessManagerImpl.$$$reportNull$$$0(0);
            }
            return psiTypeArray;
        }
        if (containerExpr instanceof PsiReferenceExpression && (refElement = ((PsiReferenceExpression)containerExpr).resolve()) instanceof PsiVariable) {
            PsiFile file = refElement.getContainingFile();
            if (file == null) {
                file = containerExpr.getContainingFile();
            }
            HashSet checkedVariables = new HashSet();
            this.addTypesByVariable(typesSet, (PsiVariable)refElement, file, checkedVariables, 5, rangeToIgnore);
            checkedVariables.clear();
            this.addTypesByVariable(typesSet, (PsiVariable)refElement, file, checkedVariables, 2, rangeToIgnore);
        }
        PsiType[] psiTypeArray = typesSet.toArray(PsiType.createArray((int)typesSet.size()));
        if (psiTypeArray == null) {
            GuessManagerImpl.$$$reportNull$$$0(1);
        }
        return psiTypeArray;
    }

    @Nullable
    private static PsiType getGenericElementType(PsiType collectionType) {
        PsiClassType classType;
        PsiType[] parameters;
        if (collectionType instanceof PsiClassType && (parameters = (classType = (PsiClassType)collectionType).getParameters()).length == 1) {
            return parameters[0];
        }
        return null;
    }

    @Override
    public PsiType @NotNull [] guessTypeToCast(PsiExpression expr) {
        LinkedHashSet<PsiType> types = new LinkedHashSet<PsiType>(this.getControlFlowExpressionTypeConjuncts(expr));
        this.addExprTypesWhenContainerElement(types, expr);
        this.addExprTypesByDerivedClasses(types, expr);
        PsiType[] psiTypeArray = types.toArray(PsiType.createArray((int)types.size()));
        if (psiTypeArray == null) {
            GuessManagerImpl.$$$reportNull$$$0(2);
        }
        return psiTypeArray;
    }

    @Override
    @NotNull
    public MultiMap<PsiExpression, PsiType> getControlFlowExpressionTypes(@NotNull PsiExpression forPlace, boolean honorAssignments) {
        ExpressionTypeListener interceptor;
        GuessManagerRunner runner;
        RunnerResult result;
        PsiElement scope;
        if (forPlace == null) {
            GuessManagerImpl.$$$reportNull$$$0(3);
        }
        if ((scope = DfaPsiUtil.getTopmostBlockInSameClass((PsiElement)forPlace)) == null) {
            PsiFile file = forPlace.getContainingFile();
            if (!(file instanceof PsiCodeFragment)) {
                MultiMap multiMap = MultiMap.empty();
                if (multiMap == null) {
                    GuessManagerImpl.$$$reportNull$$$0(4);
                }
                return multiMap;
            }
            scope = file;
        }
        if ((result = (runner = new GuessManagerRunner(scope.getProject(), honorAssignments, null)).analyzeMethodWithInlining(scope, interceptor = new ExpressionTypeListener(runner, (PsiElement)forPlace))) == RunnerResult.OK || result == RunnerResult.CANCELLED) {
            MultiMap<PsiExpression, PsiType> multiMap = interceptor.getResult();
            if (multiMap == null) {
                GuessManagerImpl.$$$reportNull$$$0(5);
            }
            return multiMap;
        }
        MultiMap multiMap = MultiMap.empty();
        if (multiMap == null) {
            GuessManagerImpl.$$$reportNull$$$0(6);
        }
        return multiMap;
    }

    @Nullable
    private static PsiType getTypeFromDataflow(final PsiExpression forPlace, boolean honorAssignments) {
        MyListener interceptor;
        GuessManagerRunner runner;
        RunnerResult result;
        PsiType type = forPlace.getType();
        TypeConstraint initial = type == null ? TypeConstraints.TOP : TypeConstraints.instanceOf(type);
        PsiElement scope = DfaPsiUtil.getTopmostBlockInSameClass((PsiElement)forPlace);
        if (scope == null) {
            PsiFile file = forPlace.getContainingFile();
            if (!(file instanceof PsiCodeFragment)) {
                return null;
            }
            scope = file;
        }
        class MyListener
        implements JavaDfaListener {
            TypeConstraint constraint = TypeConstraints.BOTTOM;

            MyListener() {
            }

            @Override
            public void beforeExpressionPush(@NotNull DfaValue value, @NotNull PsiExpression expression, @NotNull DfaMemoryState state) {
                if (value == null) {
                    MyListener.$$$reportNull$$$0(0);
                }
                if (expression == null) {
                    MyListener.$$$reportNull$$$0(1);
                }
                if (state == null) {
                    MyListener.$$$reportNull$$$0(2);
                }
                if (expression == forPlace) {
                    if (!(value instanceof DfaVariableValue) || ((DfaVariableValue)value).isFlushableByCalls()) {
                        value = value.getFactory().getVarFactory().createVariableValue((VariableDescriptor)new ExpressionVariableDescriptor(expression));
                    }
                    this.constraint = this.constraint.join(TypeConstraint.fromDfType(state.getDfType(value)));
                    runner.placeVisited();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/guess/impl/GuessManagerImpl$1MyListener";
                objectArray[2] = "beforeExpressionPush";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        if ((result = (runner = new GuessManagerRunner(scope.getProject(), honorAssignments, forPlace)).analyzeMethodWithInlining(scope, interceptor = new MyListener())) == RunnerResult.OK || result == RunnerResult.CANCELLED) {
            return interceptor.constraint.meet(initial).getPsiType(scope.getProject());
        }
        return null;
    }

    private static PsiElement getTopmostBlock(PsiElement scope) {
        PsiFile file;
        PsiCodeBlock lastCodeBlock;
        assert (scope.isValid());
        PsiElement lastScope = scope;
        while ((lastCodeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)lastScope, PsiCodeBlock.class, (boolean)true)) != null) {
            lastScope = lastCodeBlock;
        }
        if (lastScope == scope && (file = scope.getContainingFile()) instanceof PsiCodeFragment) {
            return file;
        }
        return lastScope;
    }

    private void addExprTypesByDerivedClasses(LinkedHashSet<? super PsiType> set, PsiExpression expr) {
        PsiType type = expr.getType();
        if (!(type instanceof PsiClassType)) {
            return;
        }
        PsiClass refClass = PsiUtil.resolveClassInType((PsiType)type);
        if (refClass == null) {
            return;
        }
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        PsiElementProcessor.CollectElementsWithLimit processor = new PsiElementProcessor.CollectElementsWithLimit(5);
        DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> ClassInheritorsSearch.search((PsiClass)refClass).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)processor)));
        if (processor.isOverflow()) {
            return;
        }
        for (PsiClass derivedClass : processor.getCollection()) {
            if (derivedClass instanceof PsiAnonymousClass) continue;
            PsiClassType derivedType = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createType(derivedClass);
            set.add((PsiType)derivedType);
        }
    }

    private void addExprTypesWhenContainerElement(LinkedHashSet<? super PsiType> set, PsiExpression expr) {
        PsiExpression qualifier;
        PsiMethodCallExpression callExpr;
        PsiReferenceExpression methodExpr;
        String methodName;
        MethodPattern pattern;
        if (expr instanceof PsiMethodCallExpression && (pattern = this.myMethodPatternMap.findPattern(methodName = (methodExpr = (callExpr = (PsiMethodCallExpression)expr).getMethodExpression()).getReferenceName(), callExpr.getArgumentList().getExpressionCount())) != null && pattern.parameterIndex() < 0 && (qualifier = methodExpr.getQualifierExpression()) != null) {
            PsiType[] types;
            for (PsiType type : types = this.guessContainerElementType(qualifier, null)) {
                if (type instanceof PsiClassType && ((PsiClassType)type).resolve() instanceof PsiAnonymousClass) continue;
                set.add((PsiType)type);
            }
        }
    }

    private void addTypesByVariable(HashSet<? super PsiType> typesSet, PsiVariable var, PsiFile scopeFile, HashSet<? super PsiVariable> checkedVariables, int flags, TextRange rangeToIgnore) {
        PsiParameter[] parameters;
        PsiElement ref;
        if (!checkedVariables.add((PsiVariable)var)) {
            return;
        }
        LocalSearchScope searchScope = new LocalSearchScope((PsiElement)scopeFile);
        if (BitUtil.isSet((int)flags, (int)1) || BitUtil.isSet((int)flags, (int)4)) {
            for (PsiReference varRef : ReferencesSearch.search((PsiElement)var, (SearchScope)searchScope, (boolean)false).asIterable()) {
                Object object;
                PsiType type;
                ref = varRef.getElement();
                if (BitUtil.isSet((int)flags, (int)1) && (type = GuessManagerImpl.guessElementTypeFromReference(this.myMethodPatternMap, ref, rangeToIgnore)) != null && !(type instanceof PsiPrimitiveType)) {
                    typesSet.add((PsiType)type);
                }
                if (!BitUtil.isSet((int)flags, (int)4) || !((object = ref.getParent()) instanceof PsiExpressionList)) continue;
                PsiExpressionList list = (PsiExpressionList)object;
                if (!(ref.getParent().getParent() instanceof PsiMethodCallExpression)) continue;
                int argIndex = ArrayUtil.indexOf((Object[])list.getExpressions(), (Object)ref);
                PsiMethodCallExpression methodCall = (PsiMethodCallExpression)list.getParent();
                PsiMethod method = (PsiMethod)methodCall.getMethodExpression().resolve();
                if (method == null || argIndex >= (parameters = method.getParameterList().getParameters()).length) continue;
                this.addTypesByVariable(typesSet, (PsiVariable)parameters[argIndex], method.getContainingFile(), checkedVariables, flags | 1, rangeToIgnore);
            }
        }
        if (BitUtil.isSet((int)flags, (int)2) && var instanceof PsiParameter && (ref = var.getParent()) instanceof PsiParameterList) {
            PsiParameterList list = (PsiParameterList)ref;
            ref = var.getParent().getParent();
            if (ref instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)ref;
                Object[] parameters2 = list.getParameters();
                int argIndex = ArrayUtil.indexOf((Object[])parameters2, (Object)var);
                for (PsiReference methodRef : ReferencesSearch.search((PsiElement)method, (SearchScope)searchScope, (boolean)false).asIterable()) {
                    PsiReferenceExpression ref2;
                    PsiElement psiElement;
                    PsiExpression arg;
                    PsiMethodCallExpression methodCall;
                    PsiExpression[] args;
                    parameters = methodRef.getElement().getParent();
                    if (!(parameters instanceof PsiMethodCallExpression) || (args = (methodCall = (PsiMethodCallExpression)parameters).getArgumentList().getExpressions()).length <= argIndex || !((arg = args[argIndex]) instanceof PsiReferenceExpression) || !((psiElement = (ref2 = (PsiReferenceExpression)arg).resolve()) instanceof PsiVariable)) continue;
                    PsiVariable variable = (PsiVariable)psiElement;
                    this.addTypesByVariable(typesSet, variable, scopeFile, checkedVariables, flags | 1, rangeToIgnore);
                }
            }
        }
    }

    @Nullable
    private static PsiType guessElementTypeFromReference(MethodPatternMap methodPatternMap, PsiElement ref, TextRange rangeToIgnore) {
        PsiElement psiElement;
        PsiReferenceExpression parentExpr;
        PsiElement refParent = ref.getParent();
        if (refParent instanceof PsiReferenceExpression && ref.equals((Object)(parentExpr = (PsiReferenceExpression)refParent).getQualifierExpression()) && (psiElement = parentExpr.getParent()) instanceof PsiMethodCallExpression) {
            PsiExpression[] args;
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)psiElement;
            String methodName = parentExpr.getReferenceName();
            MethodPattern pattern = methodPatternMap.findPattern(methodName, (args = methodCall.getArgumentList().getExpressions()).length);
            if (pattern != null) {
                if (pattern.parameterIndex() < 0) {
                    PsiElement psiElement2 = methodCall.getParent();
                    if (psiElement2 instanceof PsiTypeCastExpression) {
                        PsiTypeCastExpression cast = (PsiTypeCastExpression)psiElement2;
                        if (rangeToIgnore == null || !rangeToIgnore.contains(methodCall.getTextRange())) {
                            return cast.getType();
                        }
                    }
                } else {
                    return args[pattern.parameterIndex()].getType();
                }
            }
        }
        return null;
    }

    @Override
    @NotNull
    public List<PsiType> getControlFlowExpressionTypeConjuncts(@NotNull PsiExpression expr, boolean honorAssignments) {
        if (expr == null) {
            GuessManagerImpl.$$$reportNull$$$0(7);
        }
        if (expr.getType() instanceof PsiPrimitiveType) {
            List<PsiType> list = Collections.emptyList();
            if (list == null) {
                GuessManagerImpl.$$$reportNull$$$0(8);
            }
            return list;
        }
        PsiExpression place = PsiUtil.skipParenthesizedExprDown((PsiExpression)expr);
        if (place == null) {
            List<PsiType> list = Collections.emptyList();
            if (list == null) {
                GuessManagerImpl.$$$reportNull$$$0(9);
            }
            return list;
        }
        DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        PsiType type = (PsiType)dumbService.computeWithAlternativeResolveEnabled(() -> {
            GuessTypeVisitor visitor2;
            if (!ControlFlowAnalyzer.inlinerMayInferPreciseType(place) && !(visitor2 = GuessManagerImpl.tryGuessingTypeWithoutDfa(place, honorAssignments)).isDfaNeeded()) {
                return visitor2.mySpecificType;
            }
            return GuessManagerImpl.getTypeFromDataflow(expr, honorAssignments);
        });
        List list = (List)dumbService.computeWithAlternativeResolveEnabled(() -> GuessManagerImpl.postFilter(expr, type));
        if (list == null) {
            GuessManagerImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private static @Unmodifiable List<PsiType> flattenAndGenerify(@NotNull PsiExpression expr, PsiType psiType) {
        if (expr == null) {
            GuessManagerImpl.$$$reportNull$$$0(11);
        }
        if (psiType instanceof PsiIntersectionType) {
            PsiIntersectionType intersection = (PsiIntersectionType)psiType;
            List list = ContainerUtil.mapNotNull((Object[])intersection.getConjuncts(), type -> DfaPsiUtil.tryGenerify(expr, type));
            if (list == null) {
                GuessManagerImpl.$$$reportNull$$$0(12);
            }
            return list;
        }
        if (psiType != null) {
            List<PsiType> list = Collections.singletonList(DfaPsiUtil.tryGenerify(expr, psiType));
            if (list == null) {
                GuessManagerImpl.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<PsiType> list = Collections.emptyList();
        if (list == null) {
            GuessManagerImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    private static List<PsiType> postFilter(@NotNull PsiExpression expr, PsiType type) {
        List result;
        if (expr == null) {
            GuessManagerImpl.$$$reportNull$$$0(15);
        }
        if ((result = ContainerUtil.filter(GuessManagerImpl.flattenAndGenerify(expr, type), t -> {
            PsiClass typeClass = PsiUtil.resolveClassInType((PsiType)t);
            return typeClass == null || PsiUtil.isAccessible((PsiMember)typeClass, (PsiElement)expr, null);
        })).equals(Collections.singletonList(TypeConversionUtil.erasure((PsiType)expr.getType())))) {
            List<PsiType> list = Collections.emptyList();
            if (list == null) {
                GuessManagerImpl.$$$reportNull$$$0(16);
            }
            return list;
        }
        List list = result;
        if (list == null) {
            GuessManagerImpl.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    private static GuessTypeVisitor tryGuessingTypeWithoutDfa(PsiExpression place, boolean honorAssignments) {
        List<PsiElement> exprsAndVars = GuessManagerImpl.getPotentiallyAffectingElements(place);
        GuessTypeVisitor visitor2 = new GuessTypeVisitor(place, honorAssignments);
        for (PsiElement e : exprsAndVars) {
            e.accept((PsiElementVisitor)visitor2);
            if (e != place && !visitor2.isDfaNeeded()) continue;
            break;
        }
        GuessTypeVisitor guessTypeVisitor = visitor2;
        if (guessTypeVisitor == null) {
            GuessManagerImpl.$$$reportNull$$$0(18);
        }
        return guessTypeVisitor;
    }

    private static List<PsiElement> getPotentiallyAffectingElements(PsiExpression place) {
        PsiElement topmostBlock = GuessManagerImpl.getTopmostBlock((PsiElement)place);
        return (List)CachedValuesManager.getCachedValue((PsiElement)topmostBlock, () -> {
            List list = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)topmostBlock).filter(e -> e instanceof PsiExpression || e instanceof PsiLocalVariable)).toList();
            return new CachedValueProvider.Result((Object)list, new Object[]{topmostBlock});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 7, 11, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/guess/impl/GuessManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forPlace";
                break;
            }
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "guessContainerElementType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "guessTypeToCast";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/guess/impl/GuessManagerImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlowExpressionTypes";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlowExpressionTypeConjuncts";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenAndGenerify";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "postFilter";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "tryGuessingTypeWithoutDfa";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlowExpressionTypes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlowExpressionTypeConjuncts";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "flattenAndGenerify";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "postFilter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 7, 11, 15 -> new IllegalArgumentException(string);
        };
    }

    private static class GuessManagerRunner
    extends StandardDataFlowRunner {
        private final boolean myAssignments;
        private final PsiExpression myPlace;
        private boolean myPlaceVisited;

        GuessManagerRunner(@NotNull Project project, boolean honorAssignments, @Nullable PsiExpression place) {
            if (project == null) {
                GuessManagerRunner.$$$reportNull$$$0(0);
            }
            super(project);
            this.myAssignments = honorAssignments;
            this.myPlace = place;
        }

        @Override
        @NotNull
        protected StandardDataFlowInterpreter createInterpreter(@NotNull DfaListener listener, final @NotNull ControlFlow flow) {
            if (listener == null) {
                GuessManagerRunner.$$$reportNull$$$0(1);
            }
            if (flow == null) {
                GuessManagerRunner.$$$reportNull$$$0(2);
            }
            return new StandardDataFlowInterpreter(flow, listener){

                public int getComplexityLimit() {
                    return 100;
                }

                protected void afterInstruction(Instruction instruction) {
                    super.afterInstruction(instruction);
                    if (myPlaceVisited && flow.getLoopNumbers()[instruction.getIndex()] == 0) {
                        this.cancel();
                    }
                }

                protected DfaInstructionState @NotNull [] acceptInstruction(@NotNull DfaInstructionState instructionState) {
                    if (instructionState == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Instruction instruction = instructionState.getInstruction();
                    DfaMemoryState memState = instructionState.getMemoryState();
                    if (instruction instanceof TypeCastInstruction) {
                        TypeCastInstruction typeCast = (TypeCastInstruction)instruction;
                        DfaValue value = memState.pop();
                        memState.push(this.adjustValue(value, typeCast.getCasted()));
                    } else if (instruction instanceof InstanceofInstruction) {
                        InstanceofInstruction instanceOf = (InstanceofInstruction)instruction;
                        DfaValue dfaRight = memState.pop();
                        DfaValue dfaLeft = memState.pop();
                        memState.push(this.adjustValue(dfaLeft, 1.getInstanceOfOperand(instanceOf)));
                        memState.push(dfaRight);
                    }
                    DfaInstructionState[] dfaInstructionStateArray = super.acceptInstruction(instructionState);
                    if (dfaInstructionStateArray == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return dfaInstructionStateArray;
                }

                @Nullable
                private static PsiExpression getInstanceOfOperand(InstanceofInstruction instruction) {
                    JavaExpressionAnchor anchor;
                    DfaAnchor dfaAnchor = instruction.getDfaAnchor();
                    if (dfaAnchor instanceof JavaExpressionAnchor && (dfaAnchor = (anchor = (JavaExpressionAnchor)dfaAnchor).getExpression()) instanceof PsiInstanceOfExpression) {
                        PsiInstanceOfExpression instanceOf = (PsiInstanceOfExpression)dfaAnchor;
                        return instanceOf.getOperand();
                    }
                    return null;
                }

                private DfaValue adjustValue(@NotNull DfaValue value, @Nullable PsiExpression expression) {
                    if (value == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (expression != null && this.isInteresting(value, expression)) {
                        return this.getFactory().getVarFactory().createVariableValue((VariableDescriptor)new ExpressionVariableDescriptor(expression));
                    }
                    return value;
                }

                private boolean isInteresting(@NotNull DfaValue value, @NotNull PsiExpression expression) {
                    DfaVariableValue var;
                    if (value == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (expression == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    if (myPlace == null) {
                        return true;
                    }
                    return (!(value instanceof DfaVariableValue) || (var = (DfaVariableValue)value).isFlushableByCalls()) && ExpressionVariableDescriptor.EXPRESSION_HASHING_STRATEGY.equals((Object)expression, (Object)myPlace);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "instructionState";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/codeInsight/guess/impl/GuessManagerImpl$GuessManagerRunner$1";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "value";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "expression";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/codeInsight/guess/impl/GuessManagerImpl$GuessManagerRunner$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "acceptInstruction";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "acceptInstruction";
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "adjustValue";
                            break;
                        }
                        case 3: 
                        case 4: {
                            objectArray = objectArray;
                            objectArray[2] = "isInteresting";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            };
        }

        void placeVisited() {
            this.myPlaceVisited = true;
        }

        @Override
        @NotNull
        protected DfaMemoryState createMemoryState() {
            return this.myAssignments ? super.createMemoryState() : new AssignmentFilteringMemoryState(this.getFactory());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flow";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/guess/impl/GuessManagerImpl$GuessManagerRunner";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createInterpreter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ExpressionTypeListener
    implements JavaDfaListener {
        private final Map<DfaVariableValue, TypeConstraint> myResult;
        private final GuessManagerRunner myRunner;
        private final PsiElement myForPlace;

        private ExpressionTypeListener(GuessManagerRunner runner, @NotNull PsiElement forPlace) {
            if (forPlace == null) {
                ExpressionTypeListener.$$$reportNull$$$0(0);
            }
            this.myResult = new HashMap<DfaVariableValue, TypeConstraint>();
            this.myRunner = runner;
            this.myForPlace = PsiUtil.skipParenthesizedExprUp((PsiElement)forPlace);
        }

        MultiMap<PsiExpression, PsiType> getResult() {
            MultiMap result = MultiMap.createSet((Map)CollectionFactory.createCustomHashingStrategyMap(ExpressionVariableDescriptor.EXPRESSION_HASHING_STRATEGY));
            Project project = this.myForPlace.getProject();
            this.myResult.forEach((value, constraint) -> {
                if (value.getDescriptor() instanceof ExpressionVariableDescriptor) {
                    PsiExpression expression = ((ExpressionVariableDescriptor)value.getDescriptor()).getExpression();
                    PsiType type = constraint.getPsiType(project);
                    if (type instanceof PsiIntersectionType) {
                        result.putValues((Object)expression, Arrays.asList(((PsiIntersectionType)type).getConjuncts()));
                    } else if (type != null) {
                        result.putValue((Object)expression, (Object)type);
                    }
                }
            });
            return result;
        }

        @Override
        public void beforeExpressionPush(@NotNull DfaValue value, @NotNull PsiExpression expression, @NotNull DfaMemoryState state) {
            if (value == null) {
                ExpressionTypeListener.$$$reportNull$$$0(1);
            }
            if (expression == null) {
                ExpressionTypeListener.$$$reportNull$$$0(2);
            }
            if (state == null) {
                ExpressionTypeListener.$$$reportNull$$$0(3);
            }
            if (this.myForPlace == expression) {
                ((DfaMemoryStateImpl)state).forRecordedVariableTypes((var, dfType) -> this.myResult.merge((DfaVariableValue)var, TypeConstraint.fromDfType(dfType), TypeConstraint::join));
                this.myRunner.placeVisited();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forPlace";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/guess/impl/GuessManagerImpl$ExpressionTypeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeExpressionPush";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GuessTypeVisitor
    extends JavaElementVisitor {
        private static final CallMatcher OBJECT_GET_CLASS = CallMatcher.exactInstanceCall("java.lang.Object", "getClass").parameterCount(0);
        @NotNull
        private final PsiExpression myPlace;
        PsiType mySpecificType;
        private boolean myNeedDfa;
        private boolean myDeclared;
        private final boolean myHonorAssignments;

        GuessTypeVisitor(@NotNull PsiExpression place, boolean honorAssignments) {
            if (place == null) {
                GuessTypeVisitor.$$$reportNull$$$0(0);
            }
            this.myPlace = place;
            this.myHonorAssignments = honorAssignments;
        }

        protected void handleAssignment(@Nullable PsiExpression expression) {
            PsiType rawType;
            if (!this.myHonorAssignments || expression == null) {
                return;
            }
            PsiType type = expression.getType();
            if (type instanceof PsiPrimitiveType) {
                type = ((PsiPrimitiveType)type).getBoxedType((PsiElement)expression);
            }
            Object object = rawType = type instanceof PsiClassType ? ((PsiClassType)type).rawType() : type;
            if (rawType == null || rawType.equals(PsiTypes.nullType())) {
                return;
            }
            if (this.mySpecificType == null) {
                this.mySpecificType = rawType;
            } else if (!this.mySpecificType.equals(rawType)) {
                this.myNeedDfa = true;
            }
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                GuessTypeVisitor.$$$reportNull$$$0(1);
            }
            if (ExpressionVariableDescriptor.EXPRESSION_HASHING_STRATEGY.equals((Object)expression.getLExpression(), (Object)this.myPlace)) {
                this.handleAssignment(expression.getRExpression());
            }
            super.visitAssignmentExpression(expression);
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                GuessTypeVisitor.$$$reportNull$$$0(2);
            }
            if (ExpressionUtils.isReferenceTo(this.myPlace, (PsiVariable)variable)) {
                this.myDeclared = true;
                this.handleAssignment(variable.getInitializer());
            }
            super.visitLocalVariable(variable);
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            PsiExpression operand;
            if (expression == null) {
                GuessTypeVisitor.$$$reportNull$$$0(3);
            }
            if ((operand = expression.getOperand()) != null && ExpressionVariableDescriptor.EXPRESSION_HASHING_STRATEGY.equals((Object)operand, (Object)this.myPlace)) {
                this.myNeedDfa = true;
            }
            super.visitTypeCastExpression(expression);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            PsiExpression qualifier;
            if (call == null) {
                GuessTypeVisitor.$$$reportNull$$$0(4);
            }
            if (OBJECT_GET_CLASS.test(call) && (qualifier = ExpressionUtils.getEffectiveQualifier(call.getMethodExpression())) != null && ExpressionVariableDescriptor.EXPRESSION_HASHING_STRATEGY.equals((Object)qualifier, (Object)this.myPlace)) {
                this.myNeedDfa = true;
            }
            super.visitMethodCallExpression(call);
        }

        public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression) {
            if (expression == null) {
                GuessTypeVisitor.$$$reportNull$$$0(5);
            }
            if (ExpressionVariableDescriptor.EXPRESSION_HASHING_STRATEGY.equals((Object)expression.getOperand(), (Object)this.myPlace)) {
                this.myNeedDfa = true;
            }
            super.visitInstanceOfExpression(expression);
        }

        public boolean isDfaNeeded() {
            if (this.myNeedDfa) {
                return true;
            }
            if (this.myDeclared || this.mySpecificType == null) {
                return false;
            }
            PsiType type = this.myPlace.getType();
            PsiType rawType = type instanceof PsiClassType ? ((PsiClassType)type).rawType() : type;
            return !this.mySpecificType.equals(rawType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/guess/impl/GuessManagerImpl$GuessTypeVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLocalVariable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeCastExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitInstanceOfExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

