/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class AnnotateMethodFix
extends ModCommandQuickFix {
    private static final Logger LOG = Logger.getInstance(AnnotateMethodFix.class);
    protected final String myAnnotation;
    private final boolean myAnnotateOverriddenMethods;
    private final boolean myAnnotateSelf;
    private final String[] myAnnotationsToRemove;

    public AnnotateMethodFix(@NotNull String fqn, String ... annotationsToRemove) {
        if (fqn == null) {
            AnnotateMethodFix.$$$reportNull$$$0(0);
        }
        if (annotationsToRemove == null) {
            AnnotateMethodFix.$$$reportNull$$$0(1);
        }
        this(fqn, false, true, annotationsToRemove);
    }

    public AnnotateMethodFix(@NotNull String fqn, boolean annotateOverriddenMethods, boolean annotateSelf, String ... annotationsToRemove) {
        if (fqn == null) {
            AnnotateMethodFix.$$$reportNull$$$0(2);
        }
        if (annotationsToRemove == null) {
            AnnotateMethodFix.$$$reportNull$$$0(3);
        }
        this.myAnnotation = fqn;
        this.myAnnotateOverriddenMethods = annotateOverriddenMethods;
        this.myAnnotateSelf = annotateSelf;
        this.myAnnotationsToRemove = annotationsToRemove.length == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : annotationsToRemove;
        LOG.assertTrue(this.myAnnotateSelf || this.myAnnotateOverriddenMethods, (Object)"annotate method quick fix should not do nothing");
    }

    @NotNull
    public String getName() {
        if (this.myAnnotateSelf) {
            if (this.myAnnotateOverriddenMethods) {
                String string = JavaAnalysisBundle.message((String)"inspection.annotate.overridden.method.and.self.quickfix.name", (Object[])new Object[]{ClassUtil.extractClassName((String)this.myAnnotation)});
                if (string == null) {
                    AnnotateMethodFix.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = JavaAnalysisBundle.message((String)"inspection.annotate.method.quickfix.name", (Object[])new Object[]{ClassUtil.extractClassName((String)this.myAnnotation)});
            if (string == null) {
                AnnotateMethodFix.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = JavaAnalysisBundle.message((String)"inspection.annotate.overridden.method.quickfix.name", (Object[])new Object[]{ClassUtil.extractClassName((String)this.myAnnotation)});
        if (string == null) {
            AnnotateMethodFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if (this.myAnnotateSelf) {
            if (this.myAnnotateOverriddenMethods) {
                String string = JavaAnalysisBundle.message((String)"inspection.annotate.overridden.method.and.self.quickfix.family.name", (Object[])new Object[0]);
                if (string == null) {
                    AnnotateMethodFix.$$$reportNull$$$0(7);
                }
                return string;
            }
            String string = JavaAnalysisBundle.message((String)"inspection.annotate.method.quickfix.family.name", (Object[])new Object[0]);
            if (string == null) {
                AnnotateMethodFix.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = JavaAnalysisBundle.message((String)"inspection.annotate.overridden.method.quickfix.family.name", (Object[])new Object[0]);
        if (string == null) {
            AnnotateMethodFix.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement psiElement;
        PsiMethod method;
        if (project == null) {
            AnnotateMethodFix.$$$reportNull$$$0(10);
        }
        if (descriptor == null) {
            AnnotateMethodFix.$$$reportNull$$$0(11);
        }
        if ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)(psiElement = descriptor.getPsiElement()), PsiMethod.class)) == null) {
            ModCommand modCommand = ModCommand.nop();
            if (modCommand == null) {
                AnnotateMethodFix.$$$reportNull$$$0(12);
            }
            return modCommand;
        }
        ArrayList<PsiMethod> toAnnotate = new ArrayList<PsiMethod>();
        if (this.myAnnotateSelf) {
            toAnnotate.add(method);
        }
        if (this.myAnnotateOverriddenMethods) {
            for (PsiMethod inheritor : OverridingMethodsSearch.search((PsiMethod)method).asIterable()) {
                if (!AnnotationUtil.isAnnotatingApplicable((PsiElement)inheritor, (String)this.myAnnotation) || AnnotationUtil.isAnnotated((PsiModifierListOwner)inheritor, (String)this.myAnnotation, (int)10)) continue;
                toAnnotate.add(inheritor);
            }
        }
        ModCommand modCommand = ModCommand.psiUpdate((ActionContext)ActionContext.from((ProblemDescriptor)descriptor), updater -> {
            for (PsiMethod psiMethod : ContainerUtil.map((Collection)toAnnotate, arg_0 -> ((ModPsiUpdater)updater).getWritable(arg_0))) {
                this.annotateMethod(psiMethod);
            }
        });
        if (modCommand == null) {
            AnnotateMethodFix.$$$reportNull$$$0(13);
        }
        return modCommand;
    }

    private void annotateMethod(@NotNull PsiMethod method) {
        if (method == null) {
            AnnotateMethodFix.$$$reportNull$$$0(14);
        }
        PsiModifierList list = method.getModifierList();
        if (this.myAnnotationsToRemove.length > 0) {
            for (PsiAnnotation annotation : list.getAnnotations()) {
                for (String fqn : this.myAnnotationsToRemove) {
                    if (!annotation.hasQualifiedName(fqn)) continue;
                    annotation.delete();
                }
            }
        }
        list.addAnnotation(this.myAnnotation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationsToRemove";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/AnnotateMethodFix";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/AnnotateMethodFix";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "annotateMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 12, 13 -> new IllegalStateException(string);
        };
    }
}

