/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public final class BlockMarkerCommentsInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final PsiJavaElementPattern.Capture<PsiElement> ANONYMOUS_CLASS_MARKER_PATTERN = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement((Class[])new Class[]{PsiDeclarationStatement.class, PsiExpressionStatement.class}))).afterSiblingSkipping(PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiWhiteSpace.class), PsiJavaPatterns.psiElement(PsiJavaToken.class).with((PatternCondition)new PatternCondition<PsiJavaToken>(null){

        public boolean accepts(@NotNull PsiJavaToken psiJavaToken, ProcessingContext context) {
            if (psiJavaToken == null) {
                1.$$$reportNull$$$0(0);
            }
            return psiJavaToken.getTokenType().equals(JavaTokenType.SEMICOLON);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiJavaToken", "com/intellij/codeInspection/BlockMarkerCommentsInspection$1", "accepts"));
        }
    })}), (ElementPattern)PsiJavaPatterns.psiElement((Class[])new Class[]{PsiLocalVariable.class, PsiAssignmentExpression.class}).withChild((ElementPattern)PsiJavaPatterns.psiElement(PsiNewExpression.class).withChild((ElementPattern)PsiJavaPatterns.psiElement(PsiAnonymousClass.class))));
    private static final PsiJavaElementPattern.Capture<PsiElement> CLASS_MARKER_PATTERN = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent(PsiClass.class)).afterSiblingSkipping((ElementPattern)PsiJavaPatterns.psiElement(PsiWhiteSpace.class), (ElementPattern)PsiJavaPatterns.psiElement(PsiJavaToken.class).with((PatternCondition)new PatternCondition<PsiJavaToken>(null){

        public boolean accepts(@NotNull PsiJavaToken token, ProcessingContext context) {
            if (token == null) {
                2.$$$reportNull$$$0(0);
            }
            return JavaTokenType.RBRACE.equals(token.getTokenType());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/codeInspection/BlockMarkerCommentsInspection$2", "accepts"));
        }
    }));
    private static final PsiJavaElementPattern.Capture<PsiElement> TRY_CATCH_MARKER_PATTERN = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent(PsiTryStatement.class)).afterSiblingSkipping((ElementPattern)PsiJavaPatterns.psiElement(PsiWhiteSpace.class), (ElementPattern)PsiJavaPatterns.psiElement((Class[])new Class[]{PsiCodeBlock.class, PsiCatchSection.class}));
    private static final PsiJavaElementPattern.Capture<PsiElement> LOOP_OR_IF_MARKER = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterSiblingSkipping((ElementPattern)PsiJavaPatterns.psiElement(PsiWhiteSpace.class), (ElementPattern)PsiJavaPatterns.psiElement(PsiCodeBlock.class))).withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiBlockStatement.class).withParent((ElementPattern)PsiJavaPatterns.psiElement((Class[])new Class[]{PsiLoopStatement.class, PsiIfStatement.class})));
    private static final PsiJavaElementPattern.Capture<PsiElement> METHOD_MARKER_PATTERN = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent(PsiMethod.class)).afterSiblingSkipping((ElementPattern)PsiJavaPatterns.psiElement(PsiWhiteSpace.class), (ElementPattern)PsiJavaPatterns.psiElement(PsiCodeBlock.class));
    private static final ElementPattern<PsiElement> MARKER_PATTERN = PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{ANONYMOUS_CLASS_MARKER_PATTERN, CLASS_MARKER_PATTERN, TRY_CATCH_MARKER_PATTERN, LOOP_OR_IF_MARKER, METHOD_MARKER_PATTERN});
    private static final String END_WORD = "end";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            BlockMarkerCommentsInspection.$$$reportNull$$$0(0);
        }
        return new PsiElementVisitor(this){

            public void visitComment(@NotNull PsiComment element) {
                String commentText;
                IElementType tokenType;
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!(tokenType = element.getTokenType()).equals(JavaTokenType.END_OF_LINE_COMMENT)) {
                    return;
                }
                Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(element.getLanguage());
                String rawCommentText = element.getText();
                String prefix = commenter.getLineCommentPrefix();
                if (prefix != null && rawCommentText.startsWith(prefix)) {
                    rawCommentText = rawCommentText.substring(prefix.length());
                }
                if (!(commentText = StringUtil.toLowerCase((String)rawCommentText.trim())).startsWith(BlockMarkerCommentsInspection.END_WORD) || StringUtil.split((String)commentText, (String)" ").size() > 3) {
                    return;
                }
                if (MARKER_PATTERN.accepts((Object)element)) {
                    holder.registerProblem((PsiElement)element, JavaAnalysisBundle.message((String)"redundant.block.marker", (Object[])new Object[0]), new LocalQuickFix[]{new DeleteBlockMarkerCommentFix()});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/BlockMarkerCommentsInspection$3", "visitComment"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/BlockMarkerCommentsInspection", "buildVisitor"));
    }

    private static class DeleteBlockMarkerCommentFix
    extends PsiUpdateModCommandQuickFix {
        private DeleteBlockMarkerCommentFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"remove.block.marker.comments", (Object[])new Object[0]);
            if (string == null) {
                DeleteBlockMarkerCommentFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                DeleteBlockMarkerCommentFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                DeleteBlockMarkerCommentFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                DeleteBlockMarkerCommentFix.$$$reportNull$$$0(3);
            }
            element.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/BlockMarkerCommentsInspection$DeleteBlockMarkerCommentFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/BlockMarkerCommentsInspection$DeleteBlockMarkerCommentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

