/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class ExplicitTypeCanBeDiamondInspection
extends AbstractBaseJavaLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance(ExplicitTypeCanBeDiamondInspection.class);

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.language.level.specific.issues.and.migration.aids", (Object[])new Object[0]);
        if (string == null) {
            ExplicitTypeCanBeDiamondInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        return "Convert2Diamond";
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.DIAMOND_TYPES);
        if (set == null) {
            ExplicitTypeCanBeDiamondInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ExplicitTypeCanBeDiamondInspection.$$$reportNull$$$0(2);
        }
        return new JavaElementVisitor(this){

            public void visitNewExpression(@NotNull PsiNewExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PsiDiamondTypeUtil.canCollapseToDiamond((PsiNewExpression)expression, (PsiNewExpression)expression, null)) {
                    PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
                    LOG.assertTrue(classReference != null);
                    PsiReferenceParameterList parameterList = classReference.getParameterList();
                    LOG.assertTrue(parameterList != null);
                    if (PsiTreeUtil.findChildOfType((PsiElement)parameterList, PsiAnnotation.class) != null) {
                        return;
                    }
                    PsiElement firstChild = parameterList.getFirstChild();
                    PsiElement lastChild = parameterList.getLastChild();
                    TextRange range = new TextRange(firstChild != null && firstChild.getNode().getElementType() == JavaTokenType.LT ? 1 : 0, parameterList.getTextLength() - (lastChild != null && lastChild.getNode().getElementType() == JavaTokenType.GT ? 1 : 0));
                    holder.registerProblem((PsiElement)parameterList, range, JavaAnalysisBundle.message((String)"explicit.type.argument.ref.loc.can.be.replaced.with", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceWithDiamondFix()});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/ExplicitTypeCanBeDiamondInspection$1", "visitNewExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ExplicitTypeCanBeDiamondInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ExplicitTypeCanBeDiamondInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private static class ReplaceWithDiamondFix
    extends PsiUpdateModCommandQuickFix
    implements HighPriorityAction {
        private ReplaceWithDiamondFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"quickfix.family.replace.with.diamond", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithDiamondFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiNewExpression newExpression;
            if (project == null) {
                ReplaceWithDiamondFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithDiamondFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithDiamondFix.$$$reportNull$$$0(3);
            }
            if ((newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)RemoveRedundantTypeArgumentsUtil.replaceExplicitWithDiamond(element), PsiNewExpression.class)) != null) {
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)newExpression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ExplicitTypeCanBeDiamondInspection$ReplaceWithDiamondFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ExplicitTypeCanBeDiamondInspection$ReplaceWithDiamondFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

