/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.CommentTracker;

public final class RemoveRedundantTypeArgumentsUtil {
    public static PsiElement replaceExplicitWithDiamond(PsiElement psiElement) {
        PsiElement replacement = PsiDiamondTypeUtil.createExplicitReplacement((PsiElement)psiElement);
        return replacement == null ? psiElement : psiElement.replace(replacement);
    }

    public static void removeRedundantTypeArguments(PsiElement element) {
        for (PsiNewExpression newExpression : PsiTreeUtil.collectElementsOfType((PsiElement)element, (Class[])new Class[]{PsiNewExpression.class})) {
            PsiJavaCodeReferenceElement classReference = newExpression.getClassOrAnonymousClassReference();
            if (classReference == null || !PsiDiamondTypeUtil.canCollapseToDiamond((PsiNewExpression)newExpression, (PsiNewExpression)newExpression, null)) continue;
            RemoveRedundantTypeArgumentsUtil.replaceExplicitWithDiamond((PsiElement)classReference.getParameterList());
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        for (PsiMethodCallExpression call : PsiTreeUtil.collectElementsOfType((PsiElement)element, (Class[])new Class[]{PsiMethodCallExpression.class})) {
            PsiTypeParameter[] parameters;
            PsiMethod method;
            PsiType[] arguments = call.getTypeArguments();
            if (arguments.length == 0 || (method = call.resolveMethod()) == null || arguments.length != (parameters = method.getTypeParameters()).length || !PsiDiamondTypeUtil.areTypeArgumentsRedundant((PsiType[])arguments, (PsiExpression)call, (boolean)false, (PsiMethod)method, (PsiTypeParameter[])parameters)) continue;
            PsiMethodCallExpression expr = (PsiMethodCallExpression)factory.createExpressionFromText("foo()", null);
            new CommentTracker().replaceAndRestoreComments((PsiElement)call.getTypeArgumentList(), (PsiElement)expr.getTypeArgumentList());
        }
    }
}

