/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public final class SuspiciousReturnByteInputStreamInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher READ_INPUT_STREAM = CallMatcher.anyOf(CallMatcher.instanceCall("java.io.InputStream", "read").parameterCount(0));

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SuspiciousReturnByteInputStreamInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
                PsiExpression returnValue;
                if (statement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((returnValue = statement.getReturnValue()) == null) {
                    return;
                }
                PsiType type = returnValue.getType();
                if (type == null) {
                    return;
                }
                if (!type.equalsToText("byte") && !type.equalsToText("java.lang.Byte")) {
                    return;
                }
                this.process(returnValue);
            }

            private void process(PsiExpression expression) {
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class);
                if (method == null) {
                    return;
                }
                if (!READ_INPUT_STREAM.methodMatches(method)) {
                    return;
                }
                this.registerProblem(expression);
            }

            private void registerProblem(PsiExpression expression) {
                holder.registerProblem((PsiElement)expression, JavaBundle.message((String)"inspection.suspicious.return.byte.input.stream.name", (Object[])new Object[0]), new LocalQuickFix[]{new ConvertToUnsignedByteFix()});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInspection/SuspiciousReturnByteInputStreamInspection$1", "visitReturnStatement"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/SuspiciousReturnByteInputStreamInspection", "buildVisitor"));
    }

    private static class ConvertToUnsignedByteFix
    extends PsiUpdateModCommandQuickFix {
        private ConvertToUnsignedByteFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.suspicious.return.byte.input.stream.convert.to.unsigned", (Object[])new Object[0]);
            if (string == null) {
                ConvertToUnsignedByteFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ConvertToUnsignedByteFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ConvertToUnsignedByteFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ConvertToUnsignedByteFix.$$$reportNull$$$0(3);
            }
            if (!(element instanceof PsiExpression)) {
                return;
            }
            PsiExpression expression = (PsiExpression)element;
            CommentTracker tracker = new CommentTracker();
            String text = tracker.text(expression, 10);
            tracker.replace((PsiElement)expression, text + "& 0xFF");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SuspiciousReturnByteInputStreamInspection$ConvertToUnsignedByteFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SuspiciousReturnByteInputStreamInspection$ConvertToUnsignedByteFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

