/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.quickfix.ReplaceVarWithExplicitTypeFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class VariableTypeCanBeExplicitInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.LVTI);
        if (set == null) {
            VariableTypeCanBeExplicitInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            VariableTypeCanBeExplicitInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                ArrayList<PsiTypeElement> typeElements = new ArrayList<PsiTypeElement>();
                for (PsiParameter parameter : expression.getParameterList().getParameters()) {
                    PsiTypeElement typeElement = VariableTypeCanBeExplicitInspection.getTypeElementToExpand((PsiVariable)parameter);
                    if (typeElement == null) {
                        return;
                    }
                    typeElements.add(typeElement);
                }
                for (PsiTypeElement typeElement : typeElements) {
                    this.registerTypeElementProblem(typeElement);
                }
            }

            public void visitVariable(@NotNull PsiVariable variable) {
                if (variable == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (variable instanceof PsiParameter && ((PsiParameter)variable).getDeclarationScope() instanceof PsiLambdaExpression) {
                    return;
                }
                PsiTypeElement typeElement = VariableTypeCanBeExplicitInspection.getTypeElementToExpand(variable);
                if (typeElement != null) {
                    this.registerTypeElementProblem(typeElement);
                }
            }

            private void registerTypeElementProblem(@NotNull PsiTypeElement typeElement) {
                if (typeElement == null) {
                    1.$$$reportNull$$$0(2);
                }
                holder.problem((PsiElement)typeElement, JavaAnalysisBundle.message((String)"var.can.be.replaced.with.explicit.type", (Object[])new Object[0])).fix((ModCommandAction)new ReplaceVarWithExplicitTypeFix(typeElement)).register();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variable";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeElement";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/VariableTypeCanBeExplicitInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLambdaExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitVariable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerTypeElementProblem";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public static PsiTypeElement getTypeElementToExpand(PsiVariable variable) {
        PsiType type;
        PsiTypeElement typeElement = variable.getTypeElement();
        if (typeElement != null && typeElement.isInferredType() && PsiTypesUtil.isDenotableType((PsiType)(type = variable.getType()), (PsiElement)variable)) {
            return typeElement;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/VariableTypeCanBeExplicitInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/VariableTypeCanBeExplicitInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

