/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.compiler;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsFix;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.PsiReplacementUtil;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavacQuirksInspectionVisitor
extends JavaElementVisitor {
    private static final ElementPattern<PsiElement> QUALIFIER_REFERENCE = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent(PsiJavaCodeReferenceElement.class)).withSuperParent(2, PsiJavaCodeReferenceElement.class);
    private final ProblemsHolder myHolder;
    private final LanguageLevel myLanguageLevel;

    public JavacQuirksInspectionVisitor(ProblemsHolder holder) {
        this.myHolder = holder;
        this.myLanguageLevel = PsiUtil.getLanguageLevel((PsiElement)this.myHolder.getFile());
    }

    public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression methodRef) {
        PsiMethod method;
        PsiClass targetClass;
        if (methodRef == null) {
            JavacQuirksInspectionVisitor.$$$reportNull$$$0(0);
        }
        if ((targetClass = JavacQuirksInspectionVisitor.getInaccessibleMethodReferenceClass((PsiElement)methodRef, method = (PsiMethod)ObjectUtils.tryCast((Object)methodRef.resolve(), PsiMethod.class))) == null) {
            return;
        }
        String className = PsiFormatUtil.formatClass((PsiClass)targetClass, (int)2049);
        this.myHolder.registerProblem((PsiElement)methodRef, JavaAnalysisBundle.message((String)"inspection.quirk.method.reference.return.type.message", (Object[])new Object[]{className}), new LocalQuickFix[0]);
    }

    @Nullable
    public static PsiClass getInaccessibleMethodReferenceClass(@NotNull PsiElement context, @Nullable PsiMethod method) {
        if (context == null) {
            JavacQuirksInspectionVisitor.$$$reportNull$$$0(1);
        }
        if (method == null) {
            return null;
        }
        PsiClass targetClass = PsiUtil.resolveClassInType((PsiType)TypeConversionUtil.erasure((PsiType)method.getReturnType()));
        if (targetClass == null) {
            return null;
        }
        if (!targetClass.hasModifierProperty("packageLocal") && !targetClass.hasModifierProperty("private")) {
            return null;
        }
        if (JavaResolveUtil.isAccessible((PsiMember)targetClass, (PsiClass)targetClass.getContainingClass(), (PsiModifierList)targetClass.getModifierList(), (PsiElement)context, null, null)) {
            return null;
        }
        return targetClass;
    }

    public void visitAnnotationArrayInitializer(@NotNull PsiArrayInitializerMemberValue initializer) {
        if (initializer == null) {
            JavacQuirksInspectionVisitor.$$$reportNull$$$0(2);
        }
        if (PsiUtil.isLanguageLevel7OrHigher((PsiElement)initializer)) {
            return;
        }
        PsiElement lastElement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)initializer.getLastChild());
        if (PsiUtil.isJavaToken((PsiElement)lastElement, (IElementType)JavaTokenType.COMMA)) {
            String message = JavaAnalysisBundle.message((String)"inspection.compiler.javac.quirks.anno.array.comma.problem", (Object[])new Object[0]);
            String fixName = JavaAnalysisBundle.message((String)"inspection.compiler.javac.quirks.anno.array.comma.fix", (Object[])new Object[0]);
            this.myHolder.registerProblem(lastElement, message, new LocalQuickFix[]{QuickFixFactory.getInstance().createDeleteFix(lastElement, fixName)});
        }
    }

    public void visitTypeParameterList(@NotNull PsiTypeParameterList list) {
        if (list == null) {
            JavacQuirksInspectionVisitor.$$$reportNull$$$0(3);
        }
        if (PsiUtil.isLanguageLevel7OrHigher((PsiElement)list)) {
            return;
        }
        Object[] parameters = list.getTypeParameters();
        for (int i = 0; i < parameters.length; ++i) {
            PsiTypeParameter typeParameter = parameters[i];
            for (PsiJavaCodeReferenceElement referenceElement : typeParameter.getExtendsList().getReferenceElements()) {
                PsiElement resolve = referenceElement.resolve();
                if (!(resolve instanceof PsiTypeParameter) || ArrayUtilRt.find((Object[])parameters, (Object)resolve) <= i) continue;
                this.myHolder.registerProblem((PsiElement)referenceElement, JavaAnalysisBundle.message((String)"inspection.compiler.javac.quirks.illegal.forward.reference", (Object[])new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
        if (expression == null) {
            JavacQuirksInspectionVisitor.$$$reportNull$$$0(4);
        }
        if (PsiUtil.isLanguageLevel7OrHigher((PsiElement)expression)) {
            return;
        }
        PsiTypeElement type = expression.getCastType();
        if (type != null) {
            type.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceParameterList(@NotNull PsiReferenceParameterList list) {
                    if (list == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitReferenceParameterList(list);
                    if (list.getFirstChild() != null && QUALIFIER_REFERENCE.accepts((Object)list)) {
                        String message = JavaAnalysisBundle.message((String)"inspection.compiler.javac.quirks.qualifier.type.args.problem", (Object[])new Object[0]);
                        String fixName = JavaAnalysisBundle.message((String)"inspection.compiler.javac.quirks.qualifier.type.args.fix", (Object[])new Object[0]);
                        JavacQuirksInspectionVisitor.this.myHolder.registerProblem((PsiElement)list, message, new LocalQuickFix[]{QuickFixFactory.getInstance().createDeleteFix((PsiElement)list, fixName)});
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInspection/compiler/JavacQuirksInspectionVisitor$1", "visitReferenceParameterList"));
                }
            });
        }
    }

    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
        if (assignment == null) {
            JavacQuirksInspectionVisitor.$$$reportNull$$$0(5);
        }
        super.visitAssignmentExpression(assignment);
        PsiType lType = assignment.getLExpression().getType();
        if (lType == null) {
            return;
        }
        PsiExpression rExpression = assignment.getRExpression();
        if (rExpression == null) {
            return;
        }
        PsiJavaToken operationSign = assignment.getOperationSign();
        IElementType eqOpSign = operationSign.getTokenType();
        IElementType opSign = TypeConversionUtil.convertEQtoOperation((IElementType)eqOpSign);
        if (opSign == null) {
            return;
        }
        if (JavaSdkVersion.JDK_1_6.equals((Object)JavaVersionService.getInstance().getJavaSdkVersion((PsiElement)assignment)) && PsiType.getJavaLangObject((PsiManager)assignment.getManager(), (GlobalSearchScope)assignment.getResolveScope()).equals((Object)lType)) {
            String operatorText = operationSign.getText().substring(0, operationSign.getText().length() - 1);
            String message = JavaErrorBundle.message("binary.operator.not.applicable", operatorText, JavaHighlightUtil.formatType(lType), JavaHighlightUtil.formatType(rExpression.getType()));
            this.myHolder.registerProblem((PsiElement)assignment, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceAssignmentOperatorWithAssignmentFix(operationSign.getText())});
        }
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            JavacQuirksInspectionVisitor.$$$reportNull$$$0(6);
        }
        super.visitMethodCallExpression(expression);
        if (expression.getTypeArguments().length == 0) {
            PsiExpression[] args = expression.getArgumentList().getExpressions();
            JavaResolveResult resolveResult = expression.resolveMethodGenerics();
            if (resolveResult instanceof MethodCandidateInfo) {
                PsiMethod method = ((MethodCandidateInfo)resolveResult).getElement();
                PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                if (PsiUtil.isLanguageLevel8OrHigher((PsiElement)expression) && method.isVarArgs() && method.hasTypeParameters() && args.length > method.getParameterList().getParametersCount() + 50) {
                    for (PsiTypeParameter typeParameter : method.getTypeParameters()) {
                        if (PsiTypesUtil.isDenotableType((PsiType)substitutor.substitute(typeParameter), (PsiElement)expression)) continue;
                        return;
                    }
                    if (JavacQuirksInspectionVisitor.isSuspicious(args, method)) {
                        this.myHolder.registerProblem((PsiElement)expression.getMethodExpression(), JavaAnalysisBundle.message((String)"vararg.method.call.with.50.poly.arguments", (Object[])new Object[0]), new LocalQuickFix[]{new MyAddExplicitTypeArgumentsFix()});
                    }
                }
                if (resolveResult.isValidResult()) {
                    for (PsiType value : substitutor.getSubstitutionMap().values()) {
                        PsiClass aClass;
                        if (!(value instanceof PsiIntersectionType) || (aClass = (PsiClass)Arrays.stream(((PsiIntersectionType)value).getConjuncts()).map(PsiUtil::resolveClassInClassTypeOnly).filter(_aClass -> _aClass != null && _aClass.hasModifierProperty("final")).findFirst().orElse(null)) == null || !aClass.hasModifierProperty("final")) continue;
                        for (PsiType conjunct : ((PsiIntersectionType)value).getConjuncts()) {
                            PsiClass currentClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)conjunct);
                            if (currentClass == null || aClass.equals((Object)currentClass) || aClass.isInheritor(currentClass, true)) continue;
                            String descriptionTemplate = JavaAnalysisBundle.message((String)"inspection.message.javac.quick.intersection.type.problem", (Object[])new Object[]{value.getPresentableText(), ObjectUtils.notNull((Object)aClass.getQualifiedName(), (Object)Objects.requireNonNull(aClass.getName()))});
                            this.myHolder.registerProblem((PsiElement)expression.getMethodExpression(), descriptionTemplate, new LocalQuickFix[0]);
                        }
                    }
                }
            }
        }
    }

    public static boolean isSuspicious(PsiExpression[] args, PsiMethod method) {
        int count = 0;
        for (int i = method.getParameterList().getParametersCount(); i < args.length; ++i) {
            if (!PsiPolyExpressionUtil.isPolyExpression((PsiExpression)args[i]) || ++count <= 50) continue;
            return true;
        }
        return false;
    }

    public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
        if (expression == null) {
            JavacQuirksInspectionVisitor.$$$reportNull$$$0(7);
        }
        super.visitBinaryExpression(expression);
        if (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_7) && !this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
            PsiType ltype = expression.getLOperand().getType();
            PsiExpression rOperand = expression.getROperand();
            if (rOperand != null) {
                PsiType rtype = rOperand.getType();
                if (ltype != null && rtype != null && ltype.equalsToText("java.lang.Object") ^ rtype.equalsToText("java.lang.Object") && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)ltype) ^ TypeConversionUtil.isPrimitiveAndNotNull((PsiType)rtype) && TypeConversionUtil.isBinaryOperatorApplicable((IElementType)expression.getOperationTokenType(), (PsiType)ltype, (PsiType)rtype, (boolean)false) && TypeConversionUtil.areTypesConvertible((PsiType)rtype, (PsiType)ltype)) {
                    this.myHolder.registerProblem((PsiElement)expression.getOperationSign(), JavaAnalysisBundle.message((String)"comparision.between.object.and.primitive", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }
        }
    }

    public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            JavacQuirksInspectionVisitor.$$$reportNull$$$0(8);
        }
        if (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_9)) {
            return;
        }
        if (ref.getParent() instanceof PsiTypeElement) {
            PsiElement qualifier;
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiClass.class);
            if (psiClass == null) {
                return;
            }
            if ((PsiTreeUtil.isAncestor((PsiElement)psiClass.getExtendsList(), (PsiElement)ref, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)psiClass.getImplementsList(), (PsiElement)ref, (boolean)false)) && (qualifier = ref.getQualifier()) instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)qualifier).resolve() == psiClass) {
                PsiClass hiddenClass;
                PsiClass containingClass;
                PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiJavaCodeReferenceElement.class);
                if (referenceElement == null) {
                    return;
                }
                PsiElement typeClass = referenceElement.resolve();
                if (!(typeClass instanceof PsiClass)) {
                    return;
                }
                PsiElement resolve = ref.resolve();
                PsiClass psiClass2 = containingClass = resolve != null ? ((PsiClass)resolve).getContainingClass() : null;
                if (containingClass == null) {
                    return;
                }
                if (psiClass.isInheritor(containingClass, true)) {
                    hiddenClass = (PsiClass)resolve;
                } else {
                    hiddenClass = JavacQuirksInspectionVisitor.unqualifiedNestedClassReferenceAccessedViaContainingClassInheritance((PsiClass)typeClass, ((PsiClass)resolve).getExtendsList());
                    if (hiddenClass == null) {
                        hiddenClass = JavacQuirksInspectionVisitor.unqualifiedNestedClassReferenceAccessedViaContainingClassInheritance((PsiClass)typeClass, ((PsiClass)resolve).getImplementsList());
                    }
                }
                if (hiddenClass != null) {
                    this.myHolder.registerProblem((PsiElement)ref, JavaErrorBundle.message("text.class.is.not.accessible", hiddenClass.getName()), new LocalQuickFix[0]);
                }
            }
        }
    }

    private static PsiClass unqualifiedNestedClassReferenceAccessedViaContainingClassInheritance(@NotNull PsiClass containingClass, @Nullable PsiReferenceList referenceList) {
        if (containingClass == null) {
            JavacQuirksInspectionVisitor.$$$reportNull$$$0(9);
        }
        if (referenceList != null) {
            for (PsiJavaCodeReferenceElement referenceElement : referenceList.getReferenceElements()) {
                PsiClass superContainingClass;
                PsiElement superClass;
                if (referenceElement.isQualified() || !((superClass = referenceElement.resolve()) instanceof PsiClass) || (superContainingClass = ((PsiClass)superClass).getContainingClass()) == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)superContainingClass, (boolean)true) || PsiTreeUtil.isAncestor((PsiElement)superContainingClass, (PsiElement)containingClass, (boolean)true)) continue;
                return (PsiClass)superClass;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodRef";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/compiler/JavacQuirksInspectionVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethodReferenceExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInaccessibleMethodReferenceClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAnnotationArrayInitializer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeParameterList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeCastExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAssignmentExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethodCallExpression";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBinaryExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "unqualifiedNestedClassReferenceAccessedViaContainingClassInheritance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ReplaceAssignmentOperatorWithAssignmentFix
    extends PsiUpdateModCommandQuickFix {
        private final String myOperationSign;

        ReplaceAssignmentOperatorWithAssignmentFix(String operationSign) {
            this.myOperationSign = operationSign;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = JavaAnalysisBundle.message((String)"replace.0.with", (Object[])new Object[]{this.myOperationSign});
            if (string == null) {
                ReplaceAssignmentOperatorWithAssignmentFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"replace.operator.assignment.with.assignment", (Object[])new Object[0]);
            if (string == null) {
                ReplaceAssignmentOperatorWithAssignmentFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ReplaceAssignmentOperatorWithAssignmentFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ReplaceAssignmentOperatorWithAssignmentFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ReplaceAssignmentOperatorWithAssignmentFix.$$$reportNull$$$0(4);
            }
            if (element instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)element;
                PsiReplacementUtil.replaceOperatorAssignmentWithAssignmentExpression(assignment);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/compiler/JavacQuirksInspectionVisitor$ReplaceAssignmentOperatorWithAssignmentFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/compiler/JavacQuirksInspectionVisitor$ReplaceAssignmentOperatorWithAssignmentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class MyAddExplicitTypeArgumentsFix
    extends PsiUpdateModCommandQuickFix {
        private MyAddExplicitTypeArgumentsFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message("add.type.arguments.single.argument.text", new Object[0]);
            if (string == null) {
                MyAddExplicitTypeArgumentsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (project == null) {
                MyAddExplicitTypeArgumentsFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                MyAddExplicitTypeArgumentsFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                MyAddExplicitTypeArgumentsFix.$$$reportNull$$$0(3);
            }
            if (element instanceof PsiReferenceExpression && (parent = element.getParent()) instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)parent;
                PsiExpression withArgs = AddTypeArgumentsFix.addTypeArguments((PsiExpression)call, null);
                if (withArgs == null) {
                    return;
                }
                parent.replace((PsiElement)withArgs);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/compiler/JavacQuirksInspectionVisitor$MyAddExplicitTypeArgumentsFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/compiler/JavacQuirksInspectionVisitor$MyAddExplicitTypeArgumentsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

