/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class MethodContract {
    private final ContractReturnValue myReturnValue;

    MethodContract(ContractReturnValue returnValue) {
        this.myReturnValue = returnValue;
    }

    public ContractReturnValue getReturnValue() {
        return this.myReturnValue;
    }

    public boolean isTrivial() {
        return this.getConditions().isEmpty();
    }

    abstract String getArgumentsPresentation();

    public abstract List<ContractValue> getConditions();

    public String toString() {
        return this.getArgumentsPresentation() + " -> " + String.valueOf(this.getReturnValue());
    }

    public static MethodContract trivialContract(ContractReturnValue value) {
        return new MethodContract(value){

            @Override
            String getArgumentsPresentation() {
                return "()";
            }

            @Override
            public List<ContractValue> getConditions() {
                return Collections.emptyList();
            }
        };
    }

    @NotNull
    public static MethodContract singleConditionContract(ContractValue left, RelationType relationType, ContractValue right, ContractReturnValue returnValue) {
        return MethodContract.singleConditionContract(ContractValue.condition(left, relationType, right), returnValue);
    }

    @NotNull
    private static MethodContract singleConditionContract(final ContractValue condition, ContractReturnValue returnValue) {
        return new MethodContract(returnValue){

            @Override
            String getArgumentsPresentation() {
                return "(" + condition.toString() + ")";
            }

            @Override
            public List<ContractValue> getConditions() {
                return Collections.singletonList(condition);
            }
        };
    }

    public static List<? extends MethodContract> toNonIntersectingContracts(List<? extends MethodContract> contracts) {
        if (contracts.size() == 1) {
            return contracts;
        }
        if (contracts.stream().allMatch(StandardMethodContract.class::isInstance)) {
            List<? extends MethodContract> standardContracts = contracts;
            return StandardMethodContract.toNonIntersectingStandardContracts(standardContracts);
        }
        if (contracts.size() == 2 && contracts.get(1).isTrivial()) {
            ArrayList<MethodContract> result = new ArrayList<MethodContract>();
            result.add(contracts.get(0));
            List<ContractValue> conditions = contracts.get(0).getConditions();
            for (ContractValue condition : conditions) {
                ContractValue inverted = condition.invert();
                if (inverted == null) {
                    return null;
                }
                result.add(MethodContract.singleConditionContract(inverted, contracts.get(1).getReturnValue()));
            }
            return result;
        }
        return null;
    }
}

